/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.JetContainerNode;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionImpl;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetVisitor;

public class JetArrayAccessExpression
extends JetExpressionImpl
implements JetReferenceExpression {
    public JetArrayAccessExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetArrayAccessExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetArrayAccessExpression", "accept"));
        }
        return visitor2.visitArrayAccessExpression(this, data2);
    }

    @IfNotParsed
    @Nullable
    public JetExpression getArrayExpression() {
        return (JetExpression)this.findChildByClass(JetExpression.class);
    }

    @NotNull
    public List<JetExpression> getIndexExpressions() {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this.getIndicesNode(), JetExpression.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetArrayAccessExpression", "getIndexExpressions"));
        }
        return list;
    }

    @NotNull
    public JetContainerNode getIndicesNode() {
        JetContainerNode indicesNode = (JetContainerNode)this.findChildByType(JetNodeTypes.INDICES);
        assert (indicesNode != null) : "Can't be null because of parser";
        JetContainerNode jetContainerNode = indicesNode;
        if (jetContainerNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetArrayAccessExpression", "getIndicesNode"));
        }
        return jetContainerNode;
    }

    @NotNull
    public List<TextRange> getBracketRanges() {
        PsiElement lBracket = this.getLeftBracket();
        PsiElement rBracket = this.getRightBracket();
        if (lBracket == null || rBracket == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetArrayAccessExpression", "getBracketRanges"));
            }
            return list;
        }
        ArrayList arrayList = Lists.newArrayList((Object[])new TextRange[]{lBracket.getTextRange(), rBracket.getTextRange()});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetArrayAccessExpression", "getBracketRanges"));
        }
        return arrayList;
    }

    @Nullable
    public PsiElement getLeftBracket() {
        return this.getIndicesNode().findChildByType(JetTokens.LBRACKET);
    }

    @Nullable
    public PsiElement getRightBracket() {
        return this.getIndicesNode().findChildByType(JetTokens.RBRACKET);
    }
}

