/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionImpl;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitor;

public class JetBinaryExpressionWithTypeRHS
extends JetExpressionImpl
implements JetOperationExpression {
    public JetBinaryExpressionWithTypeRHS(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetBinaryExpressionWithTypeRHS", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetBinaryExpressionWithTypeRHS", "accept"));
        }
        return visitor2.visitBinaryWithTypeRHSExpression(this, data2);
    }

    @NotNull
    public JetExpression getLeft() {
        JetExpression left = (JetExpression)this.findChildByClass(JetExpression.class);
        assert (left != null);
        JetExpression jetExpression = left;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetBinaryExpressionWithTypeRHS", "getLeft"));
        }
        return jetExpression;
    }

    @IfNotParsed
    @Nullable
    public JetTypeReference getRight() {
        for (ASTNode node = this.getOperationReference().getNode(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof JetTypeReference)) continue;
            return (JetTypeReference)psi;
        }
        return null;
    }

    @Override
    @NotNull
    public JetSimpleNameExpression getOperationReference() {
        JetSimpleNameExpression jetSimpleNameExpression = (JetSimpleNameExpression)this.findChildByType(JetNodeTypes.OPERATION_REFERENCE);
        if (jetSimpleNameExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetBinaryExpressionWithTypeRHS", "getOperationReference"));
        }
        return jetSimpleNameExpression;
    }
}

