/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.JetElementImpl;
import org.jetbrains.kotlin.psi.JetFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetTypeArgumentList;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.ValueArgument;

public class JetConstructorDelegationCall
extends JetElementImpl
implements JetCallElement {
    public JetConstructorDelegationCall(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetConstructorDelegationCall", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public JetValueArgumentList getValueArgumentList() {
        return (JetValueArgumentList)this.findChildByType(JetNodeTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<? extends ValueArgument> getValueArguments() {
        JetValueArgumentList list = this.getValueArgumentList();
        List<Object> list2 = list != null ? list.getArguments() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetConstructorDelegationCall", "getValueArguments"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<JetFunctionLiteralArgument> getFunctionLiteralArguments() {
        List<JetFunctionLiteralArgument> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetConstructorDelegationCall", "getFunctionLiteralArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetTypeProjection> getTypeArguments() {
        List<JetTypeProjection> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetConstructorDelegationCall", "getTypeArguments"));
        }
        return list;
    }

    @Override
    public JetTypeArgumentList getTypeArgumentList() {
        return null;
    }

    @Override
    @Nullable
    public JetConstructorDelegationReferenceExpression getCalleeExpression() {
        return (JetConstructorDelegationReferenceExpression)this.findChildByClass(JetConstructorDelegationReferenceExpression.class);
    }

    public boolean isImplicit() {
        JetConstructorDelegationReferenceExpression callee = this.getCalleeExpression();
        return callee != null && callee.getFirstChild() == null;
    }

    public boolean isCallToThis() {
        JetConstructorDelegationReferenceExpression callee = this.getCalleeExpression();
        return callee != null && callee.isThis();
    }
}

