/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetNamedDeclarationStub;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeParameterStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.kotlin.types.Variance;

public class JetTypeParameter
extends JetNamedDeclarationStub<KotlinTypeParameterStub> {
    public JetTypeParameter(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetTypeParameter", "<init>"));
        }
        super(node);
    }

    public JetTypeParameter(@NotNull KotlinTypeParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetTypeParameter", "<init>"));
        }
        super(stub, JetStubElementTypes.TYPE_PARAMETER);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetTypeParameter", "accept"));
        }
        return visitor2.visitTypeParameter(this, data2);
    }

    @NotNull
    public Variance getVariance() {
        KotlinTypeParameterStub stub = (KotlinTypeParameterStub)this.getStub();
        if (stub != null) {
            if (stub.isOutVariance()) {
                Variance variance = Variance.OUT_VARIANCE;
                if (variance == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetTypeParameter", "getVariance"));
                }
                return variance;
            }
            if (stub.isInVariance()) {
                Variance variance = Variance.IN_VARIANCE;
                if (variance == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetTypeParameter", "getVariance"));
                }
                return variance;
            }
            Variance variance = Variance.INVARIANT;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetTypeParameter", "getVariance"));
            }
            return variance;
        }
        JetModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            Variance variance = Variance.INVARIANT;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetTypeParameter", "getVariance"));
            }
            return variance;
        }
        if (modifierList.hasModifier(JetTokens.OUT_KEYWORD)) {
            Variance variance = Variance.OUT_VARIANCE;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetTypeParameter", "getVariance"));
            }
            return variance;
        }
        if (modifierList.hasModifier(JetTokens.IN_KEYWORD)) {
            Variance variance = Variance.IN_VARIANCE;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetTypeParameter", "getVariance"));
            }
            return variance;
        }
        Variance variance = Variance.INVARIANT;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetTypeParameter", "getVariance"));
        }
        return variance;
    }

    @Nullable
    public JetTypeReference setExtendsBound(@Nullable JetTypeReference typeReference) {
        JetTypeReference currentExtendsBound = this.getExtendsBound();
        if (currentExtendsBound != null) {
            if (typeReference == null) {
                PsiElement colon = this.findChildByType(JetTokens.COLON);
                if (colon != null) {
                    colon.delete();
                }
                currentExtendsBound.delete();
                return null;
            }
            return (JetTypeReference)currentExtendsBound.replace((PsiElement)typeReference);
        }
        if (typeReference != null) {
            PsiElement colon = this.addAfter(new JetPsiFactory(this.getProject()).createColon(), this.getNameIdentifier());
            return (JetTypeReference)this.addAfter((PsiElement)typeReference, colon);
        }
        return null;
    }

    @Nullable
    public JetTypeReference getExtendsBound() {
        return (JetTypeReference)this.getStubOrPsiChild(JetStubElementTypes.TYPE_REFERENCE);
    }
}

