/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.SlicedMapImpl;
import org.jetbrains.kotlin.util.slicedMap.TrackingSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BindingTraceContext
implements BindingTrace {
    static final boolean TRACK_REWRITES = false;
    static final boolean TRACK_WITH_STACK_TRACES = true;
    private final MutableSlicedMap map;
    private final MutableDiagnosticsWithSuppression mutableDiagnostics;
    private final BindingContext bindingContext;

    public BindingTraceContext() {
        this(SlicedMapImpl.create());
    }

    private BindingTraceContext(@NotNull MutableSlicedMap map2) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/resolve/BindingTraceContext", "<init>"));
        }
        this.bindingContext = new BindingContext(){

            @Override
            @NotNull
            public Diagnostics getDiagnostics() {
                MutableDiagnosticsWithSuppression mutableDiagnosticsWithSuppression = BindingTraceContext.this.mutableDiagnostics;
                if (mutableDiagnosticsWithSuppression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getDiagnostics"));
                }
                return mutableDiagnosticsWithSuppression;
            }

            @Override
            public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
                return BindingTraceContext.this.get(slice, key);
            }

            @Override
            @NotNull
            public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
                Collection<K> collection = BindingTraceContext.this.getKeys(slice);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getKeys"));
                }
                return collection;
            }

            @Override
            @NotNull
            public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
                if (slice == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getSliceContents"));
                }
                ImmutableMap<K, V> immutableMap = BindingTraceContext.this.map.getSliceContents(slice);
                if (immutableMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getSliceContents"));
                }
                return immutableMap;
            }

            @Override
            @Nullable
            public JetType getType(@NotNull JetExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getType"));
                }
                return BindingTraceContext.this.getType(expression2);
            }

            @Override
            public void addOwnDataTo(@NotNull BindingTrace trace, boolean commitDiagnostics) {
                if (trace == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "addOwnDataTo"));
                }
                BindingContextUtils.addOwnDataTo(trace, null, commitDiagnostics, BindingTraceContext.this.map, BindingTraceContext.this.mutableDiagnostics);
            }
        };
        this.map = map2;
        this.mutableDiagnostics = new MutableDiagnosticsWithSuppression(this.bindingContext, Diagnostics.EMPTY);
    }

    public static BindingTraceContext createTraceableBindingTrace() {
        return new BindingTraceContext(new TrackingSlicedMap(true));
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/BindingTraceContext", "report"));
        }
        this.mutableDiagnostics.report(diagnostic);
    }

    public void clearDiagnostics() {
        this.mutableDiagnostics.clear();
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext2 = this.bindingContext;
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext", "getBindingContext"));
        }
        return bindingContext2;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value2) {
        this.map.put(slice, key, value2);
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return this.map.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        Collection<K> collection = this.map.getKeys(slice);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext", "getKeys"));
        }
        return collection;
    }

    @Override
    @Nullable
    public JetType getType(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingTraceContext", "getType"));
        }
        JetTypeInfo typeInfo = this.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        return typeInfo != null ? typeInfo.getType() : null;
    }

    @Override
    public void recordType(@NotNull JetExpression expression2, @Nullable JetType type2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingTraceContext", "recordType"));
        }
        JetTypeInfo typeInfo = this.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        typeInfo = typeInfo != null ? typeInfo.replaceType(type2) : TypeInfoFactoryPackage.createTypeInfo(type2);
        this.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, typeInfo);
    }
}

