/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetAnnotatedExpression;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"M\u0010)i1)\u00197m\u0007>l\u0007\u000f\\3uKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\u0015\u0019\u0017\r\u001c7t\u0015\r\te.\u001f\u0006\u0007y%t\u0017\u000e\u001e \u000b)\u0005\u0014x-^7f]R$\u0016\u0010]3SKN|GN^3s\u0015Q\t%oZ;nK:$H+\u001f9f%\u0016\u001cx\u000e\u001c<fe*\t2-\u00198eS\u0012\fG/\u001a*fg>dg/\u001a:\u000b#\r\u000bg\u000eZ5eCR,'+Z:pYZ,'O\u0003\u000bts6\u0014w\u000e\\+tC\u001e,g+\u00197jI\u0006$xN\u001d\u0006\u0015'fl'm\u001c7Vg\u0006<WMV1mS\u0012\fGo\u001c:\u000b\u0015Y\fG.\u001b3bi&|gN\u0003\teCR\fg\t\\8x\u0003:\fG.\u001f>fe*\u0001B)\u0019;b\r2|w/\u00118bYfTXM\u001d\u0006\u0006if\u0004Xm\u001d\u0006\fKb\u0004(/Z:tS>t7O\u0003\u0007dC2d7\t[3dW\u0016\u00148O\u0003\u0005Ji\u0016\u0014\u0018M\u00197f\u0015-\u0019\u0015\r\u001c7DQ\u0016\u001c7.\u001a:\u000b\u0011\rDWmY6feNT\u0001BY;jYRLen\u001d\u0006\u000f\u0017>$H.\u001b8Ck&dG/\u00138t\u0015!\u0011W/\u001b7uS:\u001c(\u0002\u00026bm\u0006TA\u0001\\1oO*\tAI\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTQcY8na2,G/Z!mY\u000e\u000bg\u000eZ5eCR,7OC\u0004d_:$X\r\u001f;\u000b5\t\u000b7/[2DC2d'+Z:pYV$\u0018n\u001c8D_:$X\r\u001f;\u000b\u000fI,7/\u001e7ug*irJ^3sY>\fGMU3t_2,H/[8o%\u0016\u001cX\u000f\u001c;t\u00136\u0004HN\u0003\u0003V]&$(\"E2p[BdW\r^3Be\u001e,X.\u001a8ug*a1m\\7qY\u0016$XmQ1mY*9AO]1dS:<'b\u0004+sC\u000eLgnZ*ue\u0006$XmZ=\u000b\u000bQ\f7o[:\u000b/\r|W\u000e\u001d7fi\u0016\u001c\u0015\r\u001c7G_J\f%oZ;nK:$(BC3yaJ,7o]5p]*i!*\u001a;FqB\u0014Xm]:j_:T1\u0001]:j\u0015M\u0019w.\u001c9mKR,wJ\\3Be\u001e,X.\u001a8u\u001551\u0018\r\\;f\u0003J<W/\\3oi*ia+\u00197vK\u0006\u0013x-^7f]RT\u0001eY8na2,G/\u001a*fg>dg/\u001a3DC2d\u0017I\u001c3Be\u001e,X.\u001a8ug*a!/Z:pYZ,GmQ1mY*\u0019R*\u001e;bE2,'+Z:pYZ,GmQ1mY*)Qn\u001c3fY*!\u0002.Y:OK\u000e,7o]1ssN\u000bg-Z\"bY2TQ\u0001\u001e:bG\u0016TABQ5oI&tw\r\u0016:bG\u0016TqAQ8pY\u0016\fgNC\u000fva\u0012\fG/\u001a*fG>\u0014H-\u001a3UsB,gi\u001c:Be\u001e,X.\u001a8u\u0015-)\b\u000fZ1uK\u0012$\u0016\u0010]3\u000b\u000f)+G\u000fV=qK*a!/Z2pe\u0012,G\rV=qK*\u0011\u0012M]4v[\u0016tG/\u0012=qe\u0016\u001c8/[8o\u0015a\u0019w.\u001c9mKR,7i\u001c8tiJ\f\u0017N\u001c;TsN$X-\u001c\u0006\rKb\u0004Xm\u0019;fIRK\b/\u001a\u0006+kB$\u0017\r^3SKN|G.\u001e;j_:\u001cF/\u0019;vg\u001a\u0013x.\\\"p]N$(/Y5oiNK8\u000f^3nA\fQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)1\u0001\u0002\u0002\t\n1\u0001Qa\u0001\u0003\u0003\u0011\u0017a\u0001!\u0002\u0002\u0005\u0004!9Qa\u0001\u0003\u0006\u0011\u001ba\u0001!\u0002\u0002\u0005\u0003!EQA\u0001\u0003\u0007\u0011%)1\u0001\"\u0004\t\u00111\u0001Qa\u0001\u0003\u0004\u0011)a\u0001!\u0002\u0002\u0005\u0005!YQa\u0001\u0003\t\u0011+a\u0001!\u0002\u0002\u0005\u0003!eQa\u0001\u0003\n\u00111a\u0001!\u0002\u0002\u0005\u0005!%QA\u0001\u0003\u0003\u0011\u0017)!\u0001B\u0003\t\u000e\u0015\u0011AQ\u0002\u0005\t\u000b\u0005AQ\"\u0002\u0002\u0005\u0019!mQA\u0001C\r\u0011))!\u0001B\u0005\t\u0019\u0015\u0011A!\u0001\u0005\u0010\u000b\r!a\u0002#\b\r\u0001\u0015\u0011AA\u0001\u0005\u0011\u000b\r!q\u0002#\t\r\u0001\u0015\u0011AA\u0001\u0005\u0012\u000b\r!\u0001\u0003c\t\r\u0001\u0015\u0019Aa\u0001\u0005\u0013\u0019\u0001)!\u0001B\b\t\"\u0015\u0011A\u0001\u0005E\u0012\u000b\t!!\u0001#\u000b\u0006\u0007\u0011\u0015\u0002\u0002\u0006\u0007\u0001\u000b\t!)\u0003\u0003\u000b\u0006\u0005\u0011\t\u0001RF\u0003\u0004\tQAa\u0003\u0004\u0001\u0006\u0005\u0011!\u0002BF\u0003\u0004\tQA\u0001\u0004\u0004\u0001\u0006\u0005\u0011!\u0002\u0002G\u0003\u0003\t\tA!$B\u0002\u0005.!MB\u0002A\u0003\u0003\t[A\u0019$B\u0002\u0005\u0004!]B\u0002A\u0003\u0004\t\rAA\u0004\u0004\u0001\u0006\u0005\u0011\r\u0001rG\u0003\u0004\t\u0019AY\u0004\u0004\u0001\u0006\u0005\u00111\u00012\b\u0003\u0004\u0019\u000bI2!B\u0001\t\ba\u001dQ\u0006\u0004\u0003b\ta!\u0011eA\u0003\u0002\u0011\u0011AB!V\u0002\u0005\u000b\r!A!C\u0001\t\u00155bA!\u0019\u0003\u0019\u0018\u0005\u001aQ!\u0001E\n1')6\u0001B\u0003\u0004\t/I\u0011\u0001c\u0007.#\u0011\tG\u0001g\u0005\"\u0011\u0015\t\u0001rB\u0005\u0005\u0013\r)\u0011\u0001#\u0005\u0019\u0012a=Qk\u0001\u0003\u0006\u0007\u0011M\u0011\"\u0001\u0005\u000e[1!\u0011\r\u0002\r\u0006C\r)\u0011\u0001#\u0003\u0019\nU\u001bA!B\u0002\u0005\u000b%\t\u0001RC\u0017\r\t\u0005$\u0001tB\u0011\u0004\u000b\u0005Aq\u0001G\u0004V\u0007\u0011)1\u0001b\u0004\n\u0003!]Q\u0006\u0004\u0003b\ta1\u0011eA\u0003\u0002\u0011\u0017AZ!V\u0002\u0005\u000b\r!a!C\u0001\t\u00175fC!A\t\u0007\t\u0001Aa\"F\u0002\u0006\u0003!u\u0001T\u0004M\u0010;\u001f!\u0001\u0001\u0003\t\u000e\u0007\u0015\t\u0001r\u0004M\u0010!\u000e\u0001Q4\u0004\u0003\u0001\u0011Ei\u0011\"B\u0001\t\"%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\"A\u001b\t!I\u0002\u0006\u0003!\t\u0002$E)\u0004\u000f\u0011}\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0019#D\u0001\t%5fC!A\t\u0007\t\u0001Aa\"F\u0002\u0006\u0003!u\u0001T\u0004M\u0013;\u001f!\u0001\u0001\u0003\t\u000e\u0007\u0015\t\u0001r\u0004M\u0010!\u000e\u0001Q4\u0004\u0003\u0001\u0011Ei\u0011\"B\u0001\t\"%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\"A\u001b\t!I\u0002\u0006\u0003!\t\u0002$E)\u0004\u000f\u0011\u0015\u0012\"\u0001\u0003\u0001\u001b\u0005A\u0019#D\u0001\t%5jDaA\t\u0007\t\u0001Aa\"F\u0002\u0006\u0003!u\u0001T\u0004\r\u0014;\u001f!\u0001\u0001\u0003\t\u000e\u0007\u0015\t\u0001r\u0004M\u0010!\u000e\u0001Q4\u0004\u0003\u0001\u0011Ei\u0011\"B\u0001\t\"%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\"A\u001b\t!h\u0004\u0005\u0001!\u001dRbA\u0003\u0002\u0011MA2\u0003U\u0002\u0002C%)\u0011\u0001#\t\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002\u0001'\tR\u0007%!1#C\u0001\t%5\t\u00012E\u0007\u0002\u0011Ii\u0011\u0001c\n.F\u0011\t\u0001$FO\b\t\u0001AY#D\u0002\u0006\u0003!%\u0002\u0014\u0006)\u0004\u0001u=A\u0001\u0001\u0005\u0011\u001b\r)\u0011\u0001c\b\u0019 A\u001b\t!\t\u0004\u0006\u0003!\u0005\u0012\"\u0001C\u0002\u0019\u0003A\n#U\u0002\b\tUI\u0011\u0001\u0003\n\u000e\u0003!)R\"\u0001E\u0012[\u007f!\u0011\u0001G\f\u001e\u0010\u0011\u0001\u0001rF\u0007\u0004\u000b\u0005AY\u0003g\u000bQ\u0007\u0001iz\u0001\u0002\u0001\t!5\u0019Q!\u0001E\u00101?\u00016\u0011A\u0011\u0004\u000b\u0005A\u0011\u0003G\tR\u0007\u001d!q#C\u0001\u0005\u00015\t\u0001BF\u0007\u0002\u0011Gi\u000b\u001a\u0001\u0003\u0002#\u0019!\u0001\u0001\u0003\b\u0016\u0007\u0015\t\u0001R\u0004M\u000f1cij\u0002\u0002\u0001\t35QQ!\u0001\u0005\u0018\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001G\u00011]\u00016\u0001AO\u000e\t\u0001A\u0011#D\u0005\u0006\u0003!\u0005\u0012\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001a\u0005\u0002k!\u0001\u001e\u0010\u0011\u0001\u0001\u0002E\u0007\u0004\u000b\u0005Ay\u0002g\bQ\u0007\u0005iz\u0001\u0002\u0001\t(5\u0019Q!\u0001\u0005\u00141M\u000161A\u0011\u0004\u000b\u0005A\u0011\u0003G\tR\u0007-!\t$C\u0001\u0005\u00015\t\u0001rF\u0007\u0002\u0011Ii\u0011\u0001c\t\u000e\u0003!\u001dRv\b\u0003\u00021kiz\u0001\u0002\u0001\t,5\u0019Q!\u0001E\u00151S\u00016\u0001AO\b\t\u0001A1$D\u0002\u0006\u0003!A\u0002\u0004\u0007)\u0004\u0002\u0005\u001aQ!\u0001E\u00191c\t6a\u0002C\u001b\u0013\u0005!\t!D\u0001\t+5\t\u0001\"GW8\t\u0005AJ$(\u0005\u0005\u0001!iR\u0002B\u0003\u0002\u0011ga\t\u0001g\rQ\u0007\u0001i\n\u0002\u0002\u0001\t=5!Q!\u0001E\u001a\u0019\u0003A\u001a\u0004UB\u0001;\u001f!\u0001\u0001#\u0010\u000e\u0007\u0015\t\u0001\u0012\u0006M\u0015!\u000e\tQt\u0002\u0003\u0001\u0011mi1!B\u0001\t1aA\u0002ka\u0001\"\t\u0015\t\u00012\u0007G\u00011g\t6a\u0003C\u001d\u0013\u0005A!$D\u0001\t55\t\u0001BG\u0007\u0002\u0011Ui\u0011\u0001C\r.f\u0011\t\u0011C\u0002\u0003\u0001\u00119)2!B\u0001\t\u001eauQ#C\u0003\u0002\u0011]IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011]Ar$h\u0004\u0005\u0001!}RbA\u0003\u0002\u0011gA\u001a\u0004UB\u0001;\u001f!\u0001\u0001C\u000e\u000e\u0007\u0015\t\u0001\u0002\u0007\r\u0019!\u000e\t\u0011eA\u0003\u0002\u0011EA\u0012#U\u0002\n\t}I\u0011\u0001\u0002\u0001\u000e\u0003!=R\"\u0001\u0005\u001b\u001b\u0005A\u0011$,\u001a\u0005\u0003E1A\u0001\u0001\u0005\u000f+\r)\u0011\u0001#\b\u0019\u001eUIQ!\u0001\u0005\u0018\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001\r\u00181\u0001jz\u0001\u0002\u0001\t!5\u0019Q!\u0001E\u00101?\u00016\u0011AO\b\t\u0001A9#D\u0002\u0006\u0003!\u0019\u0002d\u0005)\u0004\u0003\u0005\u001aQ!\u0001\u0005\u00121E\t6!\u0003\u0003!\u0013\u0005!\u0001!D\u0001\t05\t\u00012E\u0007\u0002\u0011O)\f\u001bA\u0003P\u0002\u0011\u0019\u000f\u0001g\u0002\u001e\u0010\u0011\u0001\u0001\u0002B\u0007\u0004\u000b\u0005AA\u0001\u0007\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\u000b5\u0019Q!\u0001E\u00051\u0013\u00016\u0011AO\b\t\u0001Aa!D\u0002\u0006\u0003!-\u00014\u0002)\u0004\u0003u=A\u0001\u0001E\b\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\u0019!(\u0007\u0005\u0001!MQ\u0002C\u0003\u0002\u0011\u001fIA!C\u0002\u0006\u0003!E\u0001\u0014\u0003M\b!\u000e\u0011Qt\u0002\u0003\u0001\u0011/i1!B\u0001\t\u0014aM\u0001k!\u0002\"\u0007\u0015\t\u0001R\u0001M\u0003#\u000eyAqA\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0006\u000e\u0003!UQ\"\u0001\u0005\f\u001b\u0005A9\"D\u0001\t\u001b5\t\u00012\u0004"})
public final class CallCompleter {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ArgumentTypeResolver argumentTypeResolver;
    private final CandidateResolver candidateResolver;
    private final SymbolUsageValidator symbolUsageValidator;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final Iterable<? extends CallChecker> callCheckers;
    private final KotlinBuiltIns builtIns;

    static {
        $kotlinClass = Reflection.createKotlinClass(CallCompleter.class);
    }

    @NotNull
    public final <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeCall(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results2, @NotNull TracingStrategy tracing) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(results2, (String)"results");
        Intrinsics.checkParameterIsNotNull((Object)tracing, (String)"tracing");
        ResolvedCall resolvedCall = results2.isSingleResult() ? results2.getResultingCall() : (MutableResolvedCall)null;
        Call call = context.call;
        Intrinsics.checkExpressionValueIsNotNull((Object)call, (String)"context.call");
        if (!CallResolverUtilKt.isInvokeCallOnVariable(call)) {
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "Trace to complete a resulting call");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)context.replaceBindingTrace(temporaryBindingTrace);
            Intrinsics.checkExpressionValueIsNotNull((Object)basicCallResolutionContext, (String)"context.replaceBindingTrace(temporaryTrace)");
            this.completeResolvedCallAndArguments((MutableResolvedCall<D>)resolvedCall, results2, basicCallResolutionContext, tracing);
            this.completeAllCandidates(context, results2);
            temporaryBindingTrace.commit();
        }
        if (resolvedCall != null) {
            context.performContextDependentCallChecks(resolvedCall);
            for (CallChecker callChecker : this.callCheckers) {
                callChecker.check(resolvedCall, context);
            }
            JetExpression jetExpression = resolvedCall instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall().getCall().getCalleeExpression() : resolvedCall.getCall().getCalleeExpression();
            Object d = resolvedCall.getResultingDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"resolvedCall.getResultingDescriptor()");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            JetExpression jetExpression2 = jetExpression;
            if (jetExpression2 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement2 = (PsiElement)jetExpression2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element!!");
            this.symbolUsageValidator.validateCall((CallableDescriptor)d, bindingTrace, psiElement2);
        }
        if (results2.isSingleResult() && results2.getResultingCall().getStatus().isSuccess()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results2.changeStatusToSuccess();
            Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResultsImpl, (String)"results.changeStatusToSuccess()");
            return overloadResolutionResultsImpl;
        }
        return results2;
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> void completeAllCandidates(BasicCallResolutionContext context, OverloadResolutionResultsImpl<D> results2) {
        void destination;
        void $receiver;
        Iterable $receiver2;
        Collection<ResolvedCall<D>> collection;
        if (context.collectAllCandidates) {
            Collection<ResolvedCall<D>> collection2 = results2.getAllCandidates();
            if (collection2 == null) {
                Intrinsics.throwNpe();
            }
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"results.getAllCandidates()!!");
        } else {
            Collection<MutableResolvedCall<D>> collection3 = results2.getResultingCalls();
            collection = collection3;
            Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"results.getResultingCalls()");
        }
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Collection<org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall<D>>");
        }
        Collection<ResolvedCall<D>> candidates = collection;
        Iterable iterable = candidates;
        Iterator iterator2 = $receiver2;
        Collection collection4 = new ArrayList();
        for (Object element2 : $receiver) {
            MutableResolvedCall resolvedCall = (MutableResolvedCall)element2;
            if (!(!resolvedCall.isCompleted())) continue;
            destination.add(element2);
        }
        $receiver2 = (List)destination;
        for (Object element3 : $receiver2) {
            MutableResolvedCall resolvedCall = (MutableResolvedCall)element3;
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "Trace to complete a candidate that is not a resulting call");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)context.replaceBindingTrace(temporaryBindingTrace);
            Intrinsics.checkExpressionValueIsNotNull((Object)basicCallResolutionContext, (String)"context.replaceBindingTrace(temporaryBindingTrace)");
            TracingStrategy tracingStrategy = TracingStrategy.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)tracingStrategy, (String)"TracingStrategy.EMPTY");
            this.completeResolvedCallAndArguments(resolvedCall, results2, basicCallResolutionContext, tracingStrategy);
        }
    }

    private final <D extends CallableDescriptor> void completeResolvedCallAndArguments(MutableResolvedCall<D> resolvedCall, OverloadResolutionResultsImpl<D> results2, BasicCallResolutionContext context, TracingStrategy tracing) {
        if (resolvedCall == null || resolvedCall.isCompleted() || resolvedCall.getConstraintSystem() == null) {
            Unit unit;
            this.completeArguments(context, results2);
            MutableResolvedCall<D> mutableResolvedCall = resolvedCall;
            if (mutableResolvedCall != null) {
                mutableResolvedCall.markCallAsCompleted();
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
            return;
        }
        JetType jetType = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"context.expectedType");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        this.completeConstraintSystem(resolvedCall, jetType, bindingTrace);
        this.completeArguments(context, results2);
        this.updateResolutionStatusFromConstraintSystem(resolvedCall, context, tracing);
        resolvedCall.markCallAsCompleted();
    }

    private final <D extends CallableDescriptor> void completeConstraintSystem(MutableResolvedCall<D> $receiver, JetType expectedType, BindingTrace trace) {
        ConstraintSystemCompleter constraintSystemCompleter;
        Function1<Function1<? super ConstraintSystemImpl, ? extends Boolean>, Unit> updateSystemIfSuccessful$ = new Function1<Function1<? super ConstraintSystemImpl, ? extends Boolean>, Unit>($receiver){
            final /* synthetic */ MutableResolvedCall receiver$0;

            public final void invoke(@NotNull Function1<? super ConstraintSystemImpl, ? extends Boolean> update) {
                Intrinsics.checkParameterIsNotNull(update, (String)"update");
                ConstraintSystem constraintSystem = this.receiver$0.getConstraintSystem();
                if (constraintSystem == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
                }
                ConstraintSystem constraintSystem2 = ((ConstraintSystemImpl)constraintSystem).copy();
                if (constraintSystem2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
                }
                ConstraintSystemImpl copy2 = (ConstraintSystemImpl)constraintSystem2;
                if (((Boolean)update.invoke((Object)copy2)).booleanValue()) {
                    this.receiver$0.setConstraintSystem(copy2);
                }
            }
            {
                this.receiver$0 = mutableResolvedCall;
                super(1);
            }
        };
        JetType returnType2 = $receiver.getCandidateDescriptor().getReturnType();
        if (returnType2 != null) {
            ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
            if (constraintSystem == null) {
                Intrinsics.throwNpe();
            }
            constraintSystem.addSupertypeConstraint(expectedType, returnType2, ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
        }
        if ((constraintSystemCompleter = (ConstraintSystemCompleter)trace.get(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, $receiver.getCall().getCalleeExpression())) != null) {
            updateSystemIfSuccessful$.invoke((Function1<? super ConstraintSystemImpl, ? extends Boolean>)((Function1)new Function1<ConstraintSystemImpl, Boolean>($receiver, constraintSystemCompleter){
                final /* synthetic */ MutableResolvedCall receiver$0;
                final /* synthetic */ ConstraintSystemCompleter $constraintSystemCompleter;

                public final boolean invoke(@NotNull ConstraintSystemImpl system) {
                    Intrinsics.checkParameterIsNotNull((Object)system, (String)"system");
                    this.$constraintSystemCompleter.completeConstraintSystem(system, this.receiver$0);
                    return !system.filterConstraintsOut(ConstraintPositionKind.TYPE_BOUND_POSITION).getStatus().hasOnlyErrorsDerivedFrom(ConstraintPositionKind.FROM_COMPLETER);
                }
                {
                    this.receiver$0 = mutableResolvedCall;
                    this.$constraintSystemCompleter = constraintSystemCompleter;
                    super(1);
                }
            }));
        }
        if (returnType2 != null && expectedType == TypeUtils.UNIT_EXPECTED_TYPE) {
            updateSystemIfSuccessful$.invoke((Function1<? super ConstraintSystemImpl, ? extends Boolean>)((Function1)new Function1<ConstraintSystemImpl, Boolean>(this, returnType2){
                final /* synthetic */ CallCompleter this$0;
                final /* synthetic */ JetType $returnType;

                public final boolean invoke(@NotNull ConstraintSystemImpl system) {
                    Intrinsics.checkParameterIsNotNull((Object)system, (String)"system");
                    system.addSupertypeConstraint(CallCompleter.access$getBuiltIns$1(this.this$0).getUnitType(), this.$returnType, ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                    return system.getStatus().isSuccessful();
                }
                {
                    this.this$0 = callCompleter;
                    this.$returnType = jetType;
                    super(1);
                }
            }));
        }
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
        }
        ConstraintSystemImpl constraintSystem2 = (ConstraintSystemImpl)constraintSystem;
        constraintSystem2.fixVariables();
        ConstraintSystem constraintSystem3 = $receiver.getConstraintSystem();
        if (constraintSystem3 == null) {
            Intrinsics.throwNpe();
        }
        $receiver.setResultingSubstitutor(constraintSystem3.getResultingSubstitutor());
    }

    private final <D extends CallableDescriptor> void updateResolutionStatusFromConstraintSystem(MutableResolvedCall<D> $receiver, BasicCallResolutionContext context, TracingStrategy tracing) {
        CallCandidateResolutionContext<D> contextWithResolvedCall;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = contextWithResolvedCall = CallCandidateResolutionContext.createForCallBeingAnalyzed($receiver, context, tracing);
        Intrinsics.checkExpressionValueIsNotNull(callCandidateResolutionContext, (String)"contextWithResolvedCall");
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.candidateResolver.checkAllValueArguments(callCandidateResolutionContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        ResolutionStatus status = $receiver.getStatus();
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            Intrinsics.throwNpe();
        }
        if (constraintSystem.getStatus().isSuccessful()) {
            if (Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ResolutionStatus.UNKNOWN_STATUS)) || Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ResolutionStatus.INCOMPLETE_TYPE_INFERENCE))) {
                $receiver.setStatusToSuccess();
            }
            return;
        }
        JetType receiverType = $receiver.getExtensionReceiver().exists() ? $receiver.getExtensionReceiver().getType() : (JetType)null;
        Object d = $receiver.getCandidateDescriptor();
        ConstraintSystem constraintSystem2 = $receiver.getConstraintSystem();
        if (constraintSystem2 == null) {
            Intrinsics.throwNpe();
        }
        InferenceErrorData errorData = InferenceErrorData.create(d, constraintSystem2, valueArgumentsCheckingResult.getArgumentTypes(), receiverType, context.expectedType);
        tracing.typeInferenceFailed(context.trace, errorData);
        $receiver.addStatus(ResolutionStatus.OTHER_ERROR);
    }

    private final <D extends CallableDescriptor> void completeArguments(BasicCallResolutionContext context, OverloadResolutionResultsImpl<D> results2) {
        Function1 getDataFlowInfoForArgument;
        Function1 getArgumentMapping;
        if (Intrinsics.areEqual((Object)((Object)context.checkArguments), (Object)((Object)CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS)) ^ true) {
            return;
        }
        if (results2.isSingleResult()) {
            ResolvedCall resolvedCall = results2.getResultingCall();
            getArgumentMapping = (Function1)new Function1<ValueArgument, ArgumentMapping>((MutableResolvedCall)resolvedCall){
                final /* synthetic */ MutableResolvedCall $resolvedCall;

                @NotNull
                public final ArgumentMapping invoke(@NotNull ValueArgument argument) {
                    Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
                    ArgumentMapping argumentMapping = this.$resolvedCall.getArgumentMapping(argument);
                    Intrinsics.checkExpressionValueIsNotNull((Object)argumentMapping, (String)"resolvedCall.getArgumentMapping(argument)");
                    return argumentMapping;
                }
                {
                    this.$resolvedCall = mutableResolvedCall;
                    super(1);
                }
            };
            getDataFlowInfoForArgument = (Function1)new Function1<ValueArgument, DataFlowInfo>((MutableResolvedCall)resolvedCall){
                final /* synthetic */ MutableResolvedCall $resolvedCall;

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument argument) {
                    Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
                    DataFlowInfo dataFlowInfo = this.$resolvedCall.getDataFlowInfoForArguments().getInfo(argument);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"resolvedCall.getDataFlow\u2026ments().getInfo(argument)");
                    return dataFlowInfo;
                }
                {
                    this.$resolvedCall = mutableResolvedCall;
                    super(1);
                }
            };
        } else {
            getArgumentMapping = completeArguments.3.INSTANCE$;
            getDataFlowInfoForArgument = (Function1)new Function1<ValueArgument, DataFlowInfo>(context){
                final /* synthetic */ BasicCallResolutionContext $context;

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    DataFlowInfo dataFlowInfo = this.$context.dataFlowInfo;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
                    return dataFlowInfo;
                }
                {
                    this.$context = basicCallResolutionContext;
                    super(1);
                }
            };
        }
        Iterator<? extends ValueArgument> iterator2 = context.call.getValueArguments().iterator();
        while (iterator2.hasNext()) {
            BasicCallResolutionContext newContext;
            ArgumentMapping argumentMapping;
            ArgumentMapping argumentMapping2;
            ValueArgument valueArgument;
            ValueArgument valueArgument2 = valueArgument = iterator2.next();
            if (valueArgument2 == null) {
                Intrinsics.throwNpe();
            }
            JetType expectedType = (argumentMapping2 = (argumentMapping = (ArgumentMapping)getArgumentMapping.invoke((Object)valueArgument2))) instanceof ArgumentMatch ? CallResolverUtilKt.getEffectiveExpectedType(((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument) : TypeUtils.NO_EXPECTED_TYPE;
            BasicCallResolutionContext basicCallResolutionContext = newContext = (BasicCallResolutionContext)((BasicCallResolutionContext)context.replaceDataFlowInfo((DataFlowInfo)getDataFlowInfoForArgument.invoke((Object)valueArgument))).replaceExpectedType(expectedType);
            Intrinsics.checkExpressionValueIsNotNull((Object)basicCallResolutionContext, (String)"newContext");
            this.completeOneArgument(valueArgument, basicCallResolutionContext);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void completeOneArgument(ValueArgument valueArgument, BasicCallResolutionContext context) {
        JetTypeInfo jetTypeInfo;
        JetTypeInfo jetTypeInfo2;
        JetCallableReferenceExpression $receiver;
        Object resolvedCall;
        JetType recordedType;
        void $receiver2;
        if (valueArgument.isExternal()) {
            return;
        }
        JetExpression jetExpression = valueArgument.getArgumentExpression();
        if (jetExpression == null) {
            return;
        }
        JetExpression expression2 = jetExpression;
        JetExpression jetExpression2 = JetPsiUtil.getLastElementDeparenthesized(expression2, context.statementFilter);
        if (jetExpression2 == null) {
            return;
        }
        JetExpression deparenthesized = jetExpression2;
        JetExpression jetExpression3 = expression2;
        JetExpression it = (JetExpression)$receiver2;
        JetType updatedType = recordedType = context.trace.getType(it);
        JetExpression jetExpression4 = deparenthesized;
        Intrinsics.checkExpressionValueIsNotNull((Object)jetExpression4, (String)"deparenthesized");
        OverloadResolutionResultsImpl<?> results2 = this.completeCallForArgument(jetExpression4, context);
        if (results2 != null && results2.isSingleResult()) {
            JetType jetType;
            resolvedCall = results2.getResultingCall();
            if (resolvedCall.hasInferredReturnType()) {
                Object d = resolvedCall.getResultingDescriptor();
                jetType = d != null ? d.getReturnType() : null;
            } else {
                jetType = updatedType = (JetType)null;
            }
        }
        if (recordedType != null && !recordedType.getConstructor().isDenotable()) {
            updatedType = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context, expression2);
        }
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        updatedType = this.updateRecordedTypeForArgument(updatedType, recordedType, expression2, bindingTrace);
        JetFunction jetFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context);
        if (jetFunction != null) {
            resolvedCall = jetFunction;
            JetFunction functionLiteralArgument = (JetFunction)((Object)$receiver);
            jetTypeInfo2 = this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression2, functionLiteralArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        } else {
            jetTypeInfo2 = null;
        }
        JetCallableReferenceExpression jetCallableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context);
        if (jetCallableReferenceExpression != null) {
            $receiver = jetCallableReferenceExpression;
            JetCallableReferenceExpression callableReferenceArgument = $receiver;
            jetTypeInfo = this.argumentTypeResolver.getCallableReferenceTypeInfo(expression2, callableReferenceArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        } else {
            jetTypeInfo = null;
        }
        this.dataFlowAnalyzer.checkType(updatedType, deparenthesized, (ResolutionContext)context);
    }

    /*
     * WARNING - void declaration
     */
    private final OverloadResolutionResultsImpl<?> completeCallForArgument(JetExpression expression2, BasicCallResolutionContext context) {
        void tracing;
        void cachedContext;
        BasicCallResolutionContext contextForArgument;
        void cachedResolutionResults;
        ResolutionResultsCache.CachedData cachedData;
        ResolutionResultsCache.CachedData cachedData2 = GenericCandidateResolverKt.getResolutionResultsCachedData(expression2, context);
        if (cachedData2 == null) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedData3 = cachedData = cachedData2;
        OverloadResolutionResultsImpl<?> overloadResolutionResultsImpl = cachedData3.component1();
        BasicCallResolutionContext basicCallResolutionContext = cachedData3.component2();
        TracingStrategy tracingStrategy = cachedData3.component3();
        cachedData3 = null;
        void v1 = cachedResolutionResults;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl<org.jetbrains.kotlin.descriptors.CallableDescriptor>");
        }
        OverloadResolutionResultsImpl cachedResults = (OverloadResolutionResultsImpl)v1;
        BasicCallResolutionContext basicCallResolutionContext2 = contextForArgument = (BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)cachedContext.replaceBindingTrace(context.trace)).replaceExpectedType(context.expectedType)).replaceCollectAllCandidates(false);
        Intrinsics.checkExpressionValueIsNotNull((Object)basicCallResolutionContext2, (String)"contextForArgument");
        return this.completeCall(basicCallResolutionContext2, cachedResults, (TracingStrategy)tracing);
    }

    /*
     * WARNING - void declaration
     */
    private final JetType updateRecordedTypeForArgument(JetType updatedType, JetType recordedType, JetExpression argumentExpression, BindingTrace trace) {
        void $receiver;
        if (!ErrorUtils.containsErrorType(recordedType) && Intrinsics.areEqual((Object)recordedType, (Object)updatedType) || updatedType == null) {
            return updatedType;
        }
        updateRecordedTypeForArgument.1 deparenthesizeOrGetSelector$ = updateRecordedTypeForArgument.1.INSTANCE$;
        ArrayList<JetExpression> expressions = new ArrayList<JetExpression>();
        JetExpression expression2 = argumentExpression;
        while (expression2 != null) {
            expressions.add(expression2);
            expression2 = deparenthesizeOrGetSelector$.invoke(expression2);
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Iterable iterable = CollectionsKt.reverse((Iterable)expressions);
        for (Object element2 : $receiver) {
            void shouldBeMadeNullable;
            JetExpression expression3 = (JetExpression)element2;
            if (!(expression3 instanceof JetParenthesizedExpression || expression3 instanceof JetLabeledExpression || expression3 instanceof JetAnnotatedExpression)) {
                shouldBeMadeNullable.element = this.hasNecessarySafeCall(expression3, trace);
            }
            BindingContextUtils.updateRecordedType(updatedType, expression3, trace, shouldBeMadeNullable.element);
        }
        return trace.getType(argumentExpression);
    }

    private final boolean hasNecessarySafeCall(JetExpression expression2, BindingTrace trace) {
        if (!(expression2 instanceof JetSafeQualifiedExpression)) {
            return false;
        }
        JetType expressionType = trace.getType(((JetSafeQualifiedExpression)expression2).getReceiverExpression());
        return expressionType != null && TypeUtils.isNullableType(expressionType);
    }

    public CallCompleter(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull CandidateResolver candidateResolver, @NotNull SymbolUsageValidator symbolUsageValidator, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull Iterable<? extends CallChecker> callCheckers, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull((Object)candidateResolver, (String)"candidateResolver");
        Intrinsics.checkParameterIsNotNull((Object)symbolUsageValidator, (String)"symbolUsageValidator");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowAnalyzer, (String)"dataFlowAnalyzer");
        Intrinsics.checkParameterIsNotNull(callCheckers, (String)"callCheckers");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        this.argumentTypeResolver = argumentTypeResolver;
        this.candidateResolver = candidateResolver;
        this.symbolUsageValidator = symbolUsageValidator;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.callCheckers = callCheckers;
        this.builtIns = builtIns;
    }

    @NotNull
    public static final /* synthetic */ KotlinBuiltIns access$getBuiltIns$1(CallCompleter $this) {
        return $this.builtIns;
    }
}

