/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;

public class DataFlowInfoForArgumentsImpl
implements MutableDataFlowInfoForArguments {
    @NotNull
    private final Call call;
    @Nullable
    private Map<ValueArgument, DataFlowInfo> infoMap;
    @Nullable
    private Map<ValueArgument, ValueArgument> nextArgument;
    @Nullable
    private DataFlowInfo initialInfo;
    @Nullable
    private DataFlowInfo resultInfo;

    public DataFlowInfoForArgumentsImpl(@NotNull Call call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "<init>"));
        }
        this.infoMap = null;
        this.nextArgument = null;
        this.call = call;
        this.initNextArgMap(call.getValueArguments());
    }

    private void initNextArgMap(@NotNull List<? extends ValueArgument> valueArguments2) {
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "initNextArgMap"));
        }
        Iterator<? extends ValueArgument> iterator2 = valueArguments2.iterator();
        ValueArgument prev2 = null;
        while (iterator2.hasNext()) {
            ValueArgument argument = iterator2.next();
            if (prev2 != null) {
                if (this.nextArgument == null) {
                    this.nextArgument = new HashMap<ValueArgument, ValueArgument>();
                }
                this.nextArgument.put(prev2, argument);
            }
            prev2 = argument;
        }
    }

    @Override
    public void setInitialDataFlowInfo(@NotNull DataFlowInfo dataFlowInfo) {
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "setInitialDataFlowInfo"));
        }
        this.initialInfo = dataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo getInfo(@NotNull ValueArgument valueArgument) {
        DataFlowInfo infoForArgument;
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getInfo"));
        }
        assert (this.initialInfo != null) : "Initial data flow info was not set for call: " + this.call;
        DataFlowInfo dataFlowInfo = infoForArgument = this.infoMap == null ? null : this.infoMap.get(valueArgument);
        if (infoForArgument == null) {
            DataFlowInfo dataFlowInfo2 = this.initialInfo;
            if (dataFlowInfo2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getInfo"));
            }
            return dataFlowInfo2;
        }
        DataFlowInfo dataFlowInfo3 = this.initialInfo.and(infoForArgument);
        if (dataFlowInfo3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getInfo"));
        }
        return dataFlowInfo3;
    }

    @Override
    public void updateInfo(@NotNull ValueArgument valueArgument, @NotNull DataFlowInfo dataFlowInfo) {
        ValueArgument next2;
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "updateInfo"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "updateInfo"));
        }
        ValueArgument valueArgument2 = next2 = this.nextArgument == null ? null : this.nextArgument.get(valueArgument);
        if (next2 != null) {
            if (this.infoMap == null) {
                this.infoMap = new HashMap<ValueArgument, DataFlowInfo>();
            }
            this.infoMap.put(next2, dataFlowInfo);
            return;
        }
        this.resultInfo = dataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo getResultInfo() {
        assert (this.initialInfo != null) : "Initial data flow info was not set for call: " + this.call;
        if (this.resultInfo == null) {
            DataFlowInfo dataFlowInfo = this.initialInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getResultInfo"));
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = this.initialInfo.and(this.resultInfo);
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getResultInfo"));
        }
        return dataFlowInfo;
    }
}

