/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.JetAnnotated;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticsElementsCache;
import org.jetbrains.kotlin.resolve.diagnostics.SimpleDiagnostics;
import org.jetbrains.kotlin.util.ExtensionProvider;

public class DiagnosticsWithSuppression
implements Diagnostics {
    private static final Logger LOG = Logger.getInstance(DiagnosticsWithSuppression.class);
    private static final ExtensionProvider<SuppressStringProvider> ADDITIONAL_SUPPRESS_STRING_PROVIDERS = ExtensionProvider.create(SuppressStringProvider.EP_NAME);
    private static final ExtensionProvider<DiagnosticSuppressor> DIAGNOSTIC_SUPPRESSORS = ExtensionProvider.create(DiagnosticSuppressor.EP_NAME);
    private final BindingContext context;
    private final Collection<Diagnostic> diagnostics;
    private final Map<JetAnnotated, Suppressor> suppressors;
    private final Condition<Diagnostic> filter;
    private final DiagnosticsElementsCache elementsCache;

    public DiagnosticsWithSuppression(@NotNull BindingContext context, @NotNull Collection<Diagnostic> diagnostics) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "<init>"));
        }
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "<init>"));
        }
        this.suppressors = new ConcurrentWeakValueHashMap();
        this.filter = new Condition<Diagnostic>(){

            public boolean value(Diagnostic diagnostic) {
                return !DiagnosticsWithSuppression.this.isSuppressed(diagnostic);
            }
        };
        this.elementsCache = new DiagnosticsElementsCache(this);
        this.context = context;
        this.diagnostics = diagnostics;
    }

    @Override
    @NotNull
    public Diagnostics noSuppression() {
        SimpleDiagnostics simpleDiagnostics = new SimpleDiagnostics(this.diagnostics);
        if (simpleDiagnostics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "noSuppression"));
        }
        return simpleDiagnostics;
    }

    @Override
    @NotNull
    public Iterator<Diagnostic> iterator() {
        FilteringIterator filteringIterator = new FilteringIterator(this.diagnostics.iterator(), this.filter);
        if (filteringIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "iterator"));
        }
        return filteringIterator;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> all() {
        List list = ContainerUtil.filter(this.diagnostics, this.filter);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "all"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement2) {
        if (psiElement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "forElement"));
        }
        Collection<Diagnostic> collection = this.elementsCache.getDiagnostics(psiElement2);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "forElement"));
        }
        return collection;
    }

    @Override
    public boolean isEmpty() {
        return this.all().isEmpty();
    }

    private boolean isSuppressed(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "isSuppressed"));
        }
        PsiElement element2 = diagnostic.getPsiElement();
        PsiFile file = element2.getContainingFile();
        if (file instanceof JetFile && PsiPackage.getDoNotAnalyze((JetFile)file) != null) {
            return true;
        }
        for (DiagnosticSuppressor suppressor : (List)DIAGNOSTIC_SUPPRESSORS.get()) {
            if (!suppressor.isSuppressed(diagnostic)) continue;
            return true;
        }
        JetAnnotated annotated = JetStubbedPsiUtil.getPsiOrStubParent(element2, JetAnnotated.class, false);
        if (annotated == null) {
            return false;
        }
        return this.isSuppressedByAnnotated(diagnostic, annotated, 0);
    }

    private boolean isSuppressedByAnnotated(@NotNull Diagnostic diagnostic, @NotNull JetAnnotated annotated, int debugDepth) {
        Suppressor suppressor;
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "isSuppressedByAnnotated"));
        }
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "isSuppressedByAnnotated"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Annotated: ", new Object[]{annotated.getName()});
            LOG.debug("Depth: ", new Object[]{debugDepth});
            LOG.debug("Cache size: ", new Object[]{this.suppressors.size(), "\n"});
        }
        if ((suppressor = this.getOrCreateSuppressor(annotated)).isSuppressed(diagnostic)) {
            return true;
        }
        JetAnnotated annotatedAbove = JetStubbedPsiUtil.getPsiOrStubParent((PsiElement)suppressor.getAnnotatedElement(), JetAnnotated.class, true);
        if (annotatedAbove == null) {
            return false;
        }
        boolean suppressed = this.isSuppressedByAnnotated(diagnostic, annotatedAbove, debugDepth + 1);
        Suppressor suppressorAbove = this.suppressors.get(annotatedAbove);
        if (suppressorAbove != null && suppressorAbove.dominates(suppressor)) {
            this.suppressors.put(annotated, suppressorAbove);
        }
        return suppressed;
    }

    @NotNull
    private Suppressor getOrCreateSuppressor(@NotNull JetAnnotated annotated) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "getOrCreateSuppressor"));
        }
        Suppressor suppressor = this.suppressors.get(annotated);
        if (suppressor == null) {
            Set<String> strings = this.getSuppressingStrings(annotated);
            suppressor = strings.isEmpty() ? new EmptySuppressor(annotated) : (strings.size() == 1 ? new SingularSuppressor(annotated, strings.iterator().next()) : new MultiSuppressor(annotated, strings));
            this.suppressors.put(annotated, suppressor);
        }
        Suppressor suppressor2 = suppressor;
        if (suppressor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "getOrCreateSuppressor"));
        }
        return suppressor2;
    }

    private Set<String> getSuppressingStrings(@NotNull JetAnnotated annotated) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "getSuppressingStrings"));
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        DeclarationDescriptor descriptor2 = this.context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, annotated);
        if (descriptor2 != null) {
            for (AnnotationDescriptor annotationDescriptor : descriptor2.getAnnotations()) {
                this.processAnnotation((ImmutableSet.Builder<String>)builder, annotationDescriptor);
            }
        } else {
            for (JetAnnotationEntry annotationEntry : annotated.getAnnotationEntries()) {
                AnnotationDescriptor annotationDescriptor = this.context.get(BindingContext.ANNOTATION, annotationEntry);
                this.processAnnotation((ImmutableSet.Builder<String>)builder, annotationDescriptor);
            }
        }
        return builder.build();
    }

    private void processAnnotation(ImmutableSet.Builder<String> builder, AnnotationDescriptor annotationDescriptor) {
        if (annotationDescriptor == null) {
            return;
        }
        for (SuppressStringProvider suppressStringProvider : (List)ADDITIONAL_SUPPRESS_STRING_PROVIDERS.get()) {
            builder.addAll(suppressStringProvider.get(annotationDescriptor));
        }
        if (!KotlinBuiltIns.isSuppressAnnotation(annotationDescriptor)) {
            return;
        }
        for (ConstantValue constantValue : annotationDescriptor.getAllValueArguments().values()) {
            if (!(constantValue instanceof ArrayValue)) continue;
            for (ConstantValue value2 : (List)((ArrayValue)constantValue).getValue()) {
                if (!(value2 instanceof StringValue)) continue;
                builder.add((Object)String.valueOf(((StringValue)value2).getValue()).toLowerCase());
            }
        }
    }

    public static boolean isSuppressedByStrings(@NotNull Diagnostic diagnostic, @NotNull Set<String> strings) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "isSuppressedByStrings"));
        }
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "isSuppressedByStrings"));
        }
        if (strings.contains("warnings") && diagnostic.getSeverity() == Severity.WARNING) {
            return true;
        }
        return strings.contains(diagnostic.getFactory().getName().toLowerCase());
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        throw new IllegalStateException("Trying to obtain modification tracker for readonly DiagnosticsWithSuppression.");
    }

    @NotNull
    public Collection<Diagnostic> getDiagnostics() {
        Collection<Diagnostic> collection = this.diagnostics;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "getDiagnostics"));
        }
        return collection;
    }

    private static class MultiSuppressor
    extends Suppressor {
        private final Set<String> strings;

        private MultiSuppressor(@NotNull JetAnnotated annotated, @NotNull Set<String> strings) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$MultiSuppressor", "<init>"));
            }
            if (strings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$MultiSuppressor", "<init>"));
            }
            super(annotated);
            this.strings = strings;
        }

        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$MultiSuppressor", "isSuppressed"));
            }
            return DiagnosticsWithSuppression.isSuppressedByStrings(diagnostic, this.strings);
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$MultiSuppressor", "dominates"));
            }
            return other instanceof EmptySuppressor;
        }
    }

    private static class SingularSuppressor
    extends Suppressor {
        private final String string;

        private SingularSuppressor(@NotNull JetAnnotated annotated, @NotNull String string) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$SingularSuppressor", "<init>"));
            }
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$SingularSuppressor", "<init>"));
            }
            super(annotated);
            this.string = string;
        }

        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$SingularSuppressor", "isSuppressed"));
            }
            return DiagnosticsWithSuppression.isSuppressedByStrings(diagnostic, (Set<String>)ImmutableSet.of((Object)this.string));
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$SingularSuppressor", "dominates"));
            }
            return other instanceof EmptySuppressor || other instanceof SingularSuppressor && ((SingularSuppressor)other).string.equals(this.string);
        }
    }

    private static class EmptySuppressor
    extends Suppressor {
        private EmptySuppressor(@NotNull JetAnnotated annotated) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$EmptySuppressor", "<init>"));
            }
            super(annotated);
        }

        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$EmptySuppressor", "isSuppressed"));
            }
            return false;
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$EmptySuppressor", "dominates"));
            }
            return other instanceof EmptySuppressor;
        }
    }

    private static abstract class Suppressor {
        private final JetAnnotated annotated;

        protected Suppressor(@NotNull JetAnnotated annotated) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$Suppressor", "<init>"));
            }
            this.annotated = annotated;
        }

        @NotNull
        public JetAnnotated getAnnotatedElement() {
            JetAnnotated jetAnnotated = this.annotated;
            if (jetAnnotated == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression$Suppressor", "getAnnotatedElement"));
            }
            return jetAnnotated;
        }

        public abstract boolean isSuppressed(@NotNull Diagnostic var1);

        public abstract boolean dominates(@NotNull Suppressor var1);
    }

    public static interface DiagnosticSuppressor {
        public static final ExtensionPointName<DiagnosticSuppressor> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.kotlin.diagnosticSuppressor");

        public boolean isSuppressed(@NotNull Diagnostic var1);
    }

    public static interface SuppressStringProvider {
        public static final ExtensionPointName<SuppressStringProvider> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.kotlin.suppressStringProvider");

        @NotNull
        public List<String> get(@NotNull AnnotationDescriptor var1);
    }
}

