/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.structure.JavaArrayType;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaTypeSubstitutor;
import org.jetbrains.kotlin.load.java.structure.JavaWildcardType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class JavaResolverUtils {
    private JavaResolverUtils() {
    }

    @Nullable
    public static JavaType erasure(@NotNull JavaType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/JavaResolverUtils", "erasure"));
        }
        return JavaResolverUtils.erasure(type2, JavaTypeSubstitutor.EMPTY);
    }

    @Nullable
    public static JavaType erasure(@NotNull JavaType type2, @NotNull JavaTypeSubstitutor substitutor3) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/JavaResolverUtils", "erasure"));
        }
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/resolve/jvm/JavaResolverUtils", "erasure"));
        }
        if (type2 instanceof JavaClassifierType) {
            JavaClassifier classifier2 = ((JavaClassifierType)type2).getClassifier();
            if (classifier2 instanceof JavaClass) {
                return ((JavaClass)classifier2).getDefaultType();
            }
            if (classifier2 instanceof JavaTypeParameter) {
                JavaTypeParameter typeParameter = (JavaTypeParameter)classifier2;
                return JavaResolverUtils.typeParameterErasure(typeParameter, new HashSet<JavaTypeParameter>(), substitutor3);
            }
            return null;
        }
        if (type2 instanceof JavaPrimitiveType) {
            return type2;
        }
        if (type2 instanceof JavaArrayType) {
            JavaType erasure = JavaResolverUtils.erasure(((JavaArrayType)type2).getComponentType(), substitutor3);
            return erasure == null ? null : erasure.createArrayType();
        }
        if (type2 instanceof JavaWildcardType) {
            JavaWildcardType wildcardType = (JavaWildcardType)type2;
            JavaType bound = wildcardType.getBound();
            if (bound != null && wildcardType.isExtends()) {
                return JavaResolverUtils.erasure(bound, substitutor3);
            }
            return wildcardType.getTypeProvider().createJavaLangObjectType();
        }
        throw new IllegalStateException("Unsupported type: " + type2);
    }

    @Nullable
    private static JavaType typeParameterErasure(@NotNull JavaTypeParameter typeParameter, @NotNull HashSet<JavaTypeParameter> visited, @NotNull JavaTypeSubstitutor substitutor3) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/resolve/jvm/JavaResolverUtils", "typeParameterErasure"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/kotlin/resolve/jvm/JavaResolverUtils", "typeParameterErasure"));
        }
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/resolve/jvm/JavaResolverUtils", "typeParameterErasure"));
        }
        Collection<JavaClassifierType> upperBounds = typeParameter.getUpperBounds();
        if (!upperBounds.isEmpty()) {
            JavaClassifier classifier2 = upperBounds.iterator().next().getClassifier();
            if (classifier2 instanceof JavaTypeParameter && !visited.contains(classifier2)) {
                JavaTypeParameter typeParameterBound = (JavaTypeParameter)classifier2;
                visited.add(typeParameterBound);
                JavaType substitutedType = substitutor3.substitute(typeParameterBound);
                if (substitutedType != null) {
                    return JavaResolverUtils.erasure(substitutedType);
                }
                return JavaResolverUtils.typeParameterErasure(typeParameterBound, visited, substitutor3);
            }
            if (classifier2 instanceof JavaClass) {
                return ((JavaClass)classifier2).getDefaultType();
            }
        }
        return typeParameter.getTypeProvider().createJavaLangObjectType();
    }

    @NotNull
    public static Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> recreateTypeParametersAndReturnMapping(@NotNull List<TypeParameterDescriptor> originalParameters, @Nullable DeclarationDescriptor newOwner) {
        if (originalParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalParameters", "org/jetbrains/kotlin/resolve/jvm/JavaResolverUtils", "recreateTypeParametersAndReturnMapping"));
        }
        LinkedHashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl> result2 = new LinkedHashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl>();
        for (TypeParameterDescriptor typeParameter : originalParameters) {
            result2.put(typeParameter, TypeParameterDescriptorImpl.createForFurtherModification(newOwner == null ? typeParameter.getContainingDeclaration() : newOwner, typeParameter.getAnnotations(), typeParameter.isReified(), typeParameter.getVariance(), typeParameter.getName(), typeParameter.getIndex(), SourceElement.NO_SOURCE));
        }
        LinkedHashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl> linkedHashMap = result2;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JavaResolverUtils", "recreateTypeParametersAndReturnMapping"));
        }
        return linkedHashMap;
    }

    @NotNull
    public static TypeSubstitutor createSubstitutorForTypeParameters(@NotNull Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters) {
        if (originalToAltTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalToAltTypeParameters", "org/jetbrains/kotlin/resolve/jvm/JavaResolverUtils", "createSubstitutorForTypeParameters"));
        }
        HashMap<TypeConstructor, TypeProjection> typeSubstitutionContext = new HashMap<TypeConstructor, TypeProjection>();
        for (Map.Entry<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameter : originalToAltTypeParameters.entrySet()) {
            typeSubstitutionContext.put(originalToAltTypeParameter.getKey().getTypeConstructor(), new TypeProjectionImpl(originalToAltTypeParameter.getValue().getDefaultType()));
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(typeSubstitutionContext);
        if (typeSubstitutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JavaResolverUtils", "createSubstitutorForTypeParameters"));
        }
        return typeSubstitutor2;
    }
}

