/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetAnnotatedExpression;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.psi.JetClassLiteralExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPrefixExpression;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetRootPackageExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetTypeArgumentList;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.callableReferences.CallableReferencesPackage;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.UtilsPackage;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;
import org.jetbrains.kotlin.types.expressions.unqualifiedSuper.UnqualifiedSuperPackage;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BasicExpressionTypingVisitor
extends ExpressionTypingVisitor {
    private static final TokenSet BARE_TYPES_ALLOWED = TokenSet.create((IElementType[])new IElementType[]{JetTokens.AS_KEYWORD, JetTokens.AS_SAFE});

    protected BasicExpressionTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "<init>"));
        }
        super(facade);
    }

    @Override
    public JetTypeInfo visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitSimpleNameExpression"));
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        JetTypeInfo typeInfo = callExpressionResolver.getSimpleNameExpressionTypeInfo(expression2, ReceiverValue.NO_RECEIVER, null, context);
        return this.components.dataFlowAnalyzer.checkType(typeInfo, (JetExpression)expression2, (ResolutionContext)context);
    }

    @Override
    public JetTypeInfo visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitParenthesizedExpression"));
        }
        JetExpression innerExpression = expression2.getExpression();
        if (innerExpression == null) {
            return TypeInfoFactoryPackage.noTypeInfo(context);
        }
        return this.facade.getTypeInfo(innerExpression, (ExpressionTypingContext)context.replaceScope(context.scope));
    }

    @Override
    public JetTypeInfo visitConstantExpression(@NotNull JetConstantExpression expression2, ExpressionTypingContext context) {
        ConstantValue constantValue;
        CompileTimeConstantChecker compileTimeConstantChecker;
        boolean hasError;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitConstantExpression"));
        }
        CompileTimeConstant<?> compileTimeConstant = this.components.constantExpressionEvaluator.evaluateExpression(expression2, context.trace, context.expectedType);
        if (!(compileTimeConstant instanceof IntegerValueTypeConstant) && (hasError = (compileTimeConstantChecker = context.getCompileTimeConstantChecker()).checkConstantExpressionType(constantValue = compileTimeConstant != null ? ((TypedCompileTimeConstant)compileTimeConstant).getConstantValue() : null, expression2, context.expectedType))) {
            IElementType elementType = expression2.getNode().getElementType();
            return TypeInfoFactoryPackage.createTypeInfo(this.getDefaultType(elementType), context);
        }
        assert (compileTimeConstant != null) : "CompileTimeConstant should be evaluated for constant expression or an error should be recorded " + expression2.getText();
        return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(compileTimeConstant, expression2, context);
    }

    @NotNull
    public JetType getDefaultType(IElementType constantType) {
        KotlinBuiltIns builtIns = this.components.builtIns;
        if (constantType == JetNodeTypes.INTEGER_CONSTANT) {
            JetType jetType = builtIns.getIntType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.FLOAT_CONSTANT) {
            JetType jetType = builtIns.getDoubleType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.BOOLEAN_CONSTANT) {
            JetType jetType = builtIns.getBooleanType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.CHARACTER_CONSTANT) {
            JetType jetType = builtIns.getCharType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.NULL) {
            JetType jetType = builtIns.getNullableNothingType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return jetType;
        }
        throw new IllegalArgumentException("Unsupported constant type: " + constantType);
    }

    @Override
    public JetTypeInfo visitBinaryWithTypeRHSExpression(@NotNull JetBinaryExpressionWithTypeRHS expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression left = expression2.getLeft();
        JetTypeReference right = expression2.getRight();
        if (right == null) {
            return this.facade.getTypeInfo(left, contextWithNoExpectedType).clearType();
        }
        IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
        boolean allowBareTypes = BARE_TYPES_ALLOWED.contains(operationType);
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context.scope, context.trace, true, allowBareTypes);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, right);
        if (operationType == JetTokens.COLON) {
            assert (!possiblyBareTarget.isBare()) : "Bare types should not be allowed for static assertions, because argument inference makes no sense there";
            JetType targetType = possiblyBareTarget.getActualType();
            JetTypeInfo typeInfo = this.facade.getTypeInfo(left, (ExpressionTypingContext)contextWithNoExpectedType.replaceExpectedType(targetType));
            this.checkBinaryWithTypeRHS(expression2, context, targetType, typeInfo.getType());
            return this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(targetType), (JetExpression)expression2, (ResolutionContext)context);
        }
        JetTypeInfo typeInfo = this.facade.getTypeInfo(left, contextWithNoExpectedType);
        JetType subjectType = typeInfo.getType();
        JetType targetType = TypeReconstructionUtil.reconstructBareType(right, possiblyBareTarget, subjectType, context.trace, this.components.builtIns);
        if (subjectType != null) {
            this.checkBinaryWithTypeRHS(expression2, contextWithNoExpectedType, targetType, subjectType);
            DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
            if (operationType == JetTokens.AS_KEYWORD) {
                DataFlowValue value2 = DataFlowValueFactory.createDataFlowValue(left, subjectType, context);
                typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo.establishSubtyping(value2, targetType));
            }
        }
        JetType result2 = operationType == JetTokens.AS_SAFE ? TypeUtils.makeNullable(targetType) : targetType;
        return this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(result2), (JetExpression)expression2, (ResolutionContext)context);
    }

    private void checkBinaryWithTypeRHS(@NotNull JetBinaryExpressionWithTypeRHS expression2, @NotNull ExpressionTypingContext context, @NotNull JetType targetType, @Nullable JetType actualType) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkBinaryWithTypeRHS"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkBinaryWithTypeRHS"));
        }
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkBinaryWithTypeRHS"));
        }
        if (actualType == null) {
            return;
        }
        JetSimpleNameExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.COLON) {
            context.trace.report(Errors.DEPRECATED_STATIC_ASSERT.on(expression2));
            return;
        }
        if (operationType != JetTokens.AS_KEYWORD && operationType != JetTokens.AS_SAFE) {
            context.trace.report(Errors.UNSUPPORTED.on((PsiElement)operationSign, "binary operation with type RHS"));
            return;
        }
        this.checkForCastImpossibilityOrRedundancy(expression2, actualType, targetType, context);
    }

    private void checkForCastImpossibilityOrRedundancy(JetBinaryExpressionWithTypeRHS expression2, JetType actualType, JetType targetType, ExpressionTypingContext context) {
        if (actualType == null || TypeUtils.noExpectedType(targetType) || targetType.isError()) {
            return;
        }
        if (TypesPackage.isDynamic(targetType)) {
            JetTypeReference right = expression2.getRight();
            assert (right != null) : "We know target is dynamic, but RHS is missing";
            context.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on(right));
            return;
        }
        if (!CastDiagnosticsUtil.isCastPossible(actualType, targetType, this.components.platformToKotlinClassMap)) {
            context.trace.report(Errors.CAST_NEVER_SUCCEEDS.on(expression2.getOperationReference()));
            return;
        }
        JetTypeChecker typeChecker2 = JetTypeChecker.DEFAULT;
        if (((Object)actualType).equals(targetType)) {
            context.trace.report(Errors.USELESS_CAST.on(expression2));
            return;
        }
        Collection<JetType> possibleTypes = this.components.dataFlowAnalyzer.getAllPossibleTypes(expression2.getLeft(), context.dataFlowInfo, actualType, context);
        boolean checkExactType = BasicExpressionTypingVisitor.checkExactTypeForUselessCast(expression2);
        for (JetType possibleType : possibleTypes) {
            boolean castIsUseless = checkExactType ? ((Object)possibleType).equals(targetType) : typeChecker2.isSubtypeOf(possibleType, targetType);
            if (!castIsUseless) continue;
            context.trace.report(Errors.USELESS_CAST.on(expression2));
            return;
        }
        if (CastDiagnosticsUtil.isCastErased(actualType, targetType, typeChecker2)) {
            context.trace.report(Errors.UNCHECKED_CAST.on(expression2, actualType, targetType));
        }
    }

    private static boolean checkExactTypeForUselessCast(JetBinaryExpressionWithTypeRHS expression2) {
        PsiElement parent2 = expression2.getParent();
        while (parent2 instanceof JetParenthesizedExpression || parent2 instanceof JetLabeledExpression || parent2 instanceof JetAnnotatedExpression) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof JetValueArgument) {
            return true;
        }
        if (parent2 instanceof JetQualifiedExpression) {
            JetExpression receiver = ((JetQualifiedExpression)parent2).getReceiverExpression();
            return PsiTreeUtil.isAncestor((PsiElement)receiver, (PsiElement)expression2, (boolean)false);
        }
        return false;
    }

    @Override
    public JetTypeInfo visitThisExpression(@NotNull JetThisExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitThisExpression"));
        }
        JetType result2 = null;
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = this.resolveToReceiver(expression2, context, false);
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                break;
            }
            case NO_THIS: {
                context.trace.report(Errors.NO_THIS.on(expression2));
                break;
            }
            case SUCCESS: {
                result2 = resolutionResult.getReceiverParameterDescriptor().getType();
                context.trace.recordType(expression2.getInstanceReference(), result2);
            }
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, context, expression2);
    }

    @Override
    public JetTypeInfo visitSuperExpression(@NotNull JetSuperExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitSuperExpression"));
        }
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = this.resolveToReceiver(expression2, context, true);
        if (!JetPsiUtil.isLHSOfDot(expression2)) {
            context.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(expression2, expression2.getText()));
            return this.errorInSuper(expression2, context);
        }
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                return this.errorInSuper(expression2, context);
            }
            case NO_THIS: {
                context.trace.report(Errors.SUPER_NOT_AVAILABLE.on(expression2));
                return this.errorInSuper(expression2, context);
            }
            case SUCCESS: {
                JetType result2 = this.checkPossiblyQualifiedSuper(expression2, context, resolutionResult.getReceiverParameterDescriptor());
                if (result2 != null) {
                    context.trace.recordType(expression2.getInstanceReference(), result2);
                }
                return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, context, expression2);
            }
        }
        throw new IllegalStateException("Unknown code: " + (Object)((Object)resolutionResult.getCode()));
    }

    private JetTypeInfo errorInSuper(JetSuperExpression expression2, ExpressionTypingContext context) {
        JetTypeReference superTypeQualifier = expression2.getSuperTypeQualifier();
        if (superTypeQualifier != null) {
            this.components.typeResolver.resolveType(context.scope, superTypeQualifier, context.trace, true);
        }
        return TypeInfoFactoryPackage.noTypeInfo(context);
    }

    private JetType checkPossiblyQualifiedSuper(JetSuperExpression expression2, ExpressionTypingContext context, ReceiverParameterDescriptor thisReceiver) {
        JetTypeReference superTypeQualifier;
        JetType thisType;
        JetType result2;
        block21: {
            TypeSubstitutor substitutor3;
            Collection<JetType> supertypes2;
            block18: {
                boolean validType;
                JetTypeArgumentList redundantTypeArguments;
                JetType supertype;
                ClassifierDescriptor classifierCandidate;
                block20: {
                    block19: {
                        result2 = null;
                        thisType = thisReceiver.getType();
                        supertypes2 = thisType.getConstructor().getSupertypes();
                        substitutor3 = TypeSubstitutor.create(thisType);
                        superTypeQualifier = expression2.getSuperTypeQualifier();
                        if (superTypeQualifier == null) break block18;
                        JetTypeElement typeElement = superTypeQualifier.getTypeElement();
                        classifierCandidate = null;
                        supertype = null;
                        redundantTypeArguments = null;
                        if (typeElement instanceof JetUserType) {
                            JetUserType userType = (JetUserType)typeElement;
                            if (userType.getTypeArguments().isEmpty()) {
                                classifierCandidate = this.components.typeResolver.resolveClass(context.scope, userType, context.trace);
                            } else {
                                supertype = this.components.typeResolver.resolveType(context.scope, superTypeQualifier, context.trace, true);
                                redundantTypeArguments = userType.getTypeArgumentList();
                            }
                        } else {
                            supertype = this.components.typeResolver.resolveType(context.scope, superTypeQualifier, context.trace, true);
                        }
                        if (supertype == null) break block19;
                        if (!supertypes2.contains(supertype)) break block20;
                        result2 = supertype;
                        break block20;
                    }
                    if (classifierCandidate instanceof ClassDescriptor) {
                        ClassDescriptor superclass = (ClassDescriptor)classifierCandidate;
                        for (JetType declaredSupertype : supertypes2) {
                            if (!declaredSupertype.getConstructor().equals(superclass.getTypeConstructor())) continue;
                            result2 = substitutor3.safeSubstitute(declaredSupertype, Variance.INVARIANT);
                            break;
                        }
                    }
                }
                boolean validClassifier = classifierCandidate != null && !ErrorUtils.isError(classifierCandidate);
                boolean bl = validType = supertype != null && !supertype.isError();
                if (result2 == null && (validClassifier || validType)) {
                    context.trace.report(Errors.NOT_A_SUPERTYPE.on(superTypeQualifier));
                } else if (redundantTypeArguments != null) {
                    context.trace.report(Errors.TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER.on((PsiElement)redundantTypeArguments));
                }
                break block21;
            }
            if (UnqualifiedSuperPackage.isPossiblyAmbiguousUnqualifiedSuper(expression2, supertypes2)) {
                Collection<JetType> supertypesResolvedFromContext = UnqualifiedSuperPackage.resolveUnqualifiedSuperFromExpressionContext(expression2, supertypes2, this.components.builtIns.getAnyType());
                if (supertypesResolvedFromContext.size() == 1) {
                    JetType singleResolvedType = supertypesResolvedFromContext.iterator().next();
                    result2 = substitutor3.substitute(singleResolvedType, Variance.INVARIANT);
                } else if (supertypesResolvedFromContext.isEmpty()) {
                    result2 = this.components.builtIns.getAnyType();
                } else {
                    context.trace.report(Errors.AMBIGUOUS_SUPER.on(expression2));
                }
            } else {
                JetType type2 = supertypes2.isEmpty() ? this.components.builtIns.getAnyType() : supertypes2.iterator().next();
                result2 = substitutor3.substitute(type2, Variance.INVARIANT);
            }
        }
        if (result2 != null) {
            if (DescriptorUtils.isTrait(thisType.getConstructor().getDeclarationDescriptor()) && DescriptorUtils.isClass(result2.getConstructor().getDeclarationDescriptor())) {
                context.trace.report(Errors.SUPERCLASS_NOT_ACCESSIBLE_FROM_TRAIT.on(expression2));
            }
            context.trace.recordType(expression2.getInstanceReference(), result2);
            context.trace.record(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference(), result2.getConstructor().getDeclarationDescriptor());
        }
        if (superTypeQualifier != null) {
            context.trace.record(BindingContext.TYPE_RESOLUTION_SCOPE, superTypeQualifier, UtilsPackage.asJetScope(context.scope));
        }
        return result2;
    }

    @NotNull
    private LabelResolver.LabeledReceiverResolutionResult resolveToReceiver(JetInstanceExpressionWithLabel expression2, ExpressionTypingContext context, boolean onlyClassReceivers) {
        Name labelName = expression2.getLabelNameAsName();
        if (labelName != null) {
            LabelResolver.LabeledReceiverResolutionResult resolutionResult = LabelResolver.INSTANCE.resolveThisOrSuperLabel(expression2, context, labelName);
            if (resolutionResult.success()) {
                ReceiverParameterDescriptor receiverParameterDescriptor = resolutionResult.getReceiverParameterDescriptor();
                this.recordThisOrSuperCallInTraceAndCallExtension(context, receiverParameterDescriptor, expression2);
                if (onlyClassReceivers && !BasicExpressionTypingVisitor.isDeclaredInClass(receiverParameterDescriptor)) {
                    LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(null);
                    if (labeledReceiverResolutionResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveToReceiver"));
                    }
                    return labeledReceiverResolutionResult;
                }
            }
            LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = resolutionResult;
            if (labeledReceiverResolutionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveToReceiver"));
            }
            return labeledReceiverResolutionResult;
        }
        ReceiverParameterDescriptor result2 = null;
        List<ReceiverParameterDescriptor> receivers = UtilsPackage.getImplicitReceiversHierarchy(context.scope);
        if (onlyClassReceivers) {
            for (ReceiverParameterDescriptor receiver : receivers) {
                if (!BasicExpressionTypingVisitor.isDeclaredInClass(receiver)) continue;
                result2 = receiver;
                break;
            }
        } else if (!receivers.isEmpty()) {
            result2 = receivers.get(0);
        }
        if (result2 != null) {
            context.trace.record(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference(), result2.getContainingDeclaration());
            this.recordThisOrSuperCallInTraceAndCallExtension(context, result2, expression2);
        }
        LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(result2);
        if (labeledReceiverResolutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveToReceiver"));
        }
        return labeledReceiverResolutionResult;
    }

    private void recordThisOrSuperCallInTraceAndCallExtension(ExpressionTypingContext context, ReceiverParameterDescriptor descriptor2, JetExpression expression2) {
        BindingTrace trace = context.trace;
        Call call = CallMaker.makeCall(expression2, ReceiverValue.NO_RECEIVER, null, expression2, Collections.emptyList());
        ResolutionCandidate<ReceiverParameterDescriptor> resolutionCandidate = ResolutionCandidate.create(call, descriptor2, ReceiverValue.NO_RECEIVER, ReceiverValue.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
        ResolvedCallImpl<ReceiverParameterDescriptor> resolvedCall = ResolvedCallImpl.create(resolutionCandidate, TemporaryBindingTrace.create(trace, "Fake trace for fake 'this' or 'super' resolved call"), TracingStrategy.EMPTY, new DataFlowInfoForArgumentsImpl(call));
        resolvedCall.markCallAsCompleted();
        trace.record(BindingContext.RESOLVED_CALL, call, resolvedCall);
        trace.record(BindingContext.CALL, expression2, call);
        BasicCallResolutionContext resolutionContext = BasicCallResolutionContext.create(context, call, CheckArgumentTypesMode.CHECK_CALLABLE_TYPE);
        resolutionContext.performContextDependentCallChecks(resolvedCall);
        for (CallChecker checker : this.components.callCheckers) {
            checker.check(resolvedCall, resolutionContext);
        }
        this.components.symbolUsageValidator.validateCall(descriptor2, trace, (PsiElement)expression2);
    }

    private static boolean isDeclaredInClass(ReceiverParameterDescriptor receiver) {
        return receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    @Override
    public JetTypeInfo visitBlockExpression(@NotNull JetBlockExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBlockExpression"));
        }
        return this.components.expressionTypingServices.getBlockReturnedType(expression2, context, false);
    }

    @Override
    public JetTypeInfo visitClassLiteralExpression(@NotNull JetClassLiteralExpression expression2, ExpressionTypingContext c) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitClassLiteralExpression"));
        }
        JetType type2 = this.resolveClassLiteral(expression2, c);
        if (type2 != null && !type2.isError()) {
            return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.reflectionTypes.getKClassType(Annotations.EMPTY, type2), c, expression2);
        }
        return TypeInfoFactoryPackage.createTypeInfo(ErrorUtils.createErrorType("Unresolved class"), c);
    }

    @Nullable
    private JetType resolveClassLiteral(@NotNull JetClassLiteralExpression expression2, ExpressionTypingContext c) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveClassLiteral"));
        }
        JetTypeReference typeReference = expression2.getTypeReference();
        if (typeReference == null) {
            c.trace.report(Errors.UNSUPPORTED.on((PsiElement)expression2, "Class literals with empty left hand side are not yet supported"));
            return null;
        }
        TypeResolutionContext context = new TypeResolutionContext(c.scope, c.trace, false, true);
        PossiblyBareType possiblyBareType = this.components.typeResolver.resolvePossiblyBareType(context, typeReference);
        JetType type2 = null;
        if (possiblyBareType.isBare()) {
            ClassifierDescriptor descriptor2;
            if (!possiblyBareType.isNullable() && (descriptor2 = possiblyBareType.getBareTypeConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
                if (KotlinBuiltIns.isNonPrimitiveArray(classDescriptor)) {
                    context.trace.report(Errors.ARRAY_CLASS_LITERAL_REQUIRES_ARGUMENT.on(expression2));
                    return null;
                }
                type2 = BasicExpressionTypingVisitor.substituteWithStarProjections(classDescriptor);
            }
        } else {
            JetType actualType = possiblyBareType.getActualType();
            if (actualType.isError()) {
                return null;
            }
            if (BasicExpressionTypingVisitor.isAllowedInClassLiteral(actualType)) {
                type2 = actualType;
            }
        }
        if (type2 != null) {
            return type2;
        }
        context.trace.report(Errors.CLASS_LITERAL_LHS_NOT_A_CLASS.on(expression2));
        return null;
    }

    @NotNull
    private static JetType substituteWithStarProjections(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "substituteWithStarProjections"));
        }
        TypeConstructor typeConstructor2 = descriptor2.getTypeConstructor();
        List arguments2 = KotlinPackage.map(typeConstructor2.getParameters(), (Function1)new Function1<TypeParameterDescriptor, TypeProjection>(){

            public TypeProjection invoke(TypeParameterDescriptor descriptor2) {
                return TypeUtils.makeStarProjection(descriptor2);
            }
        });
        JetTypeImpl jetTypeImpl = JetTypeImpl.create(Annotations.EMPTY, descriptor2, false, arguments2);
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "substituteWithStarProjections"));
        }
        return jetTypeImpl;
    }

    private static boolean isAllowedInClassLiteral(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "isAllowedInClassLiteral"));
        }
        return BasicExpressionTypingVisitor.isClassAvailableAtRuntime(type2, false);
    }

    private static boolean isClassAvailableAtRuntime(@NotNull JetType type2, boolean canBeNullable) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "isClassAvailableAtRuntime"));
        }
        if (type2.isMarkedNullable() && !canBeNullable) {
            return false;
        }
        TypeConstructor typeConstructor2 = type2.getConstructor();
        ClassifierDescriptor typeDeclarationDescriptor = typeConstructor2.getDeclarationDescriptor();
        if (typeDeclarationDescriptor instanceof ClassDescriptor) {
            List<TypeParameterDescriptor> parameters2 = typeConstructor2.getParameters();
            if (parameters2.size() != type2.getArguments().size()) {
                return false;
            }
            Iterator<TypeProjection> typeArgumentsIterator = type2.getArguments().iterator();
            for (TypeParameterDescriptor parameter : parameters2) {
                if (!parameter.isReified()) {
                    return false;
                }
                TypeProjection typeArgument = typeArgumentsIterator.next();
                if (typeArgument == null) {
                    return false;
                }
                if (typeArgument.isStarProjection()) {
                    return false;
                }
                if (BasicExpressionTypingVisitor.isClassAvailableAtRuntime(typeArgument.getType(), true)) continue;
                return false;
            }
            return true;
        }
        if (typeDeclarationDescriptor instanceof TypeParameterDescriptor) {
            return ((TypeParameterDescriptor)typeDeclarationDescriptor).isReified();
        }
        return false;
    }

    @Override
    public JetTypeInfo visitCallableReferenceExpression(@NotNull JetCallableReferenceExpression expression2, ExpressionTypingContext c) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitCallableReferenceExpression"));
        }
        JetTypeReference typeReference = expression2.getTypeReference();
        JetType receiverType = typeReference == null ? null : this.components.typeResolver.resolveType(c.scope, typeReference, c.trace, false);
        JetSimpleNameExpression callableReference = expression2.getCallableReference();
        if (callableReference.getReferencedName().isEmpty()) {
            c.trace.report(Errors.UNRESOLVED_REFERENCE.on(callableReference, callableReference));
            JetType errorType = ErrorUtils.createErrorType("Empty callable reference");
            return this.components.dataFlowAnalyzer.createCheckedTypeInfo(errorType, c, expression2);
        }
        JetType result2 = this.getCallableReferenceType(expression2, receiverType, c);
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, c, expression2);
    }

    @Override
    public JetTypeInfo visitObjectLiteralExpression(final @NotNull JetObjectLiteralExpression expression2, final ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitObjectLiteralExpression"));
        }
        final JetType[] result2 = new JetType[1];
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve object literal expression", expression2);
        ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor> handler2 = new ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor>(){

            @Override
            public void handleRecord(WritableSlice<PsiElement, ClassDescriptor> slice, PsiElement declaration, final ClassDescriptor descriptor2) {
                if (slice == BindingContext.CLASS && declaration == expression2.getObjectDeclaration()) {
                    DeferredType defaultType2 = DeferredType.createRecursionIntolerant(BasicExpressionTypingVisitor.this.components.globalContext.getStorageManager(), context.trace, new Function0<JetType>(){

                        public JetType invoke() {
                            return descriptor2.getDefaultType();
                        }
                    });
                    result2[0] = defaultType2;
                }
            }
        };
        ObservableBindingTrace traceAdapter = new ObservableBindingTrace(temporaryTrace);
        traceAdapter.addHandler(BindingContext.CLASS, handler2);
        this.components.localClassifierAnalyzer.processClassOrObject(null, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceBindingTrace(traceAdapter)).replaceContextDependency(ContextDependency.INDEPENDENT), context.scope.getOwnerDescriptor(), expression2.getObjectDeclaration());
        temporaryTrace.commit();
        DataFlowInfo resultFlowInfo = context.dataFlowInfo;
        for (JetDelegationSpecifier specifier : expression2.getObjectDeclaration().getDelegationSpecifiers()) {
            JetDelegatorToSuperCall delegator;
            JetTypeInfo delegatorTypeInfo;
            if (!(specifier instanceof JetDelegatorToSuperCall) || (delegatorTypeInfo = context.trace.get(BindingContext.EXPRESSION_TYPE_INFO, (delegator = (JetDelegatorToSuperCall)specifier).getCalleeExpression())) == null) continue;
            resultFlowInfo = resultFlowInfo.and(delegatorTypeInfo.getDataFlowInfo());
        }
        JetTypeInfo resultTypeInfo = this.components.dataFlowAnalyzer.checkType(TypeInfoFactoryPackage.createTypeInfo(result2[0], resultFlowInfo), (JetExpression)expression2, (ResolutionContext)context);
        context.trace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, resultTypeInfo);
        context.trace.record(BindingContext.PROCESSED, expression2);
        return resultTypeInfo;
    }

    @Nullable
    private JetType getCallableReferenceType(@NotNull JetCallableReferenceExpression expression2, @Nullable JetType lhsType, @NotNull ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getCallableReferenceType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getCallableReferenceType"));
        }
        JetSimpleNameExpression reference = expression2.getCallableReference();
        boolean[] resolved = new boolean[1];
        CallableDescriptor descriptor2 = CallableReferencesPackage.resolveCallableReferenceTarget(expression2, lhsType, context, resolved, this.components.callResolver);
        if (!resolved[0]) {
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
        }
        if (descriptor2 == null) {
            return null;
        }
        return CallableReferencesPackage.createReflectionTypeForResolvedCallableReference(expression2, descriptor2, context, this.components.reflectionTypes);
    }

    @Override
    public JetTypeInfo visitQualifiedExpression(@NotNull JetQualifiedExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitQualifiedExpression"));
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getQualifiedExpressionTypeInfo(expression2, context);
    }

    @Override
    public JetTypeInfo visitCallExpression(@NotNull JetCallExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitCallExpression"));
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getCallExpressionTypeInfo(expression2, ReceiverValue.NO_RECEIVER, null, context);
    }

    @Override
    public JetTypeInfo visitUnaryExpression(@NotNull JetUnaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        JetType result2;
        OverloadResolutionResults<FunctionDescriptor> resolutionResults;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitUnaryExpression"));
        }
        ExpressionTypingContext context = ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType(expression2) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryPackage.noTypeInfo(context);
        }
        JetSimpleNameExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.EXCLEXCL) {
            return this.visitExclExclExpression(expression2, context);
        }
        JetTypeInfo typeInfo = this.facade.safeGetTypeInfo(baseExpression, context);
        JetType type2 = ExpressionTypingUtils.safeGetType(typeInfo);
        ExpressionReceiver receiver = new ExpressionReceiver(baseExpression, type2);
        Call call = CallMaker.makeCall((ReceiverValue)receiver, expression2);
        Name name2 = (Name)OperatorConventions.UNARY_OPERATION_NAMES.get((Object)operationType);
        if (name2 == null) {
            context.trace.report(Errors.UNSUPPORTED.on((PsiElement)operationSign, "visitUnaryExpression"));
            return typeInfo.clearType();
        }
        if ((operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) && baseExpression instanceof JetArrayAccessExpression) {
            JetExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context.trace, "$e", type2);
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve array access set method for unary expression", expression2);
            ExpressionTypingContext newContext = (ExpressionTypingContext)context.replaceBindingTrace(temporaryBindingTrace);
            this.resolveArrayAccessSetMethod((JetArrayAccessExpression)baseExpression, stubExpression, newContext, context.trace);
        }
        if (!(resolutionResults = this.components.callResolver.resolveCallWithGivenName(context, call, expression2.getOperationReference(), name2)).isSuccess()) {
            return typeInfo.clearType();
        }
        JetType returnType2 = resolutionResults.getResultingDescriptor().getReturnType();
        if (operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) {
            assert (returnType2 != null) : "returnType is null for " + resolutionResults.getResultingDescriptor();
            if (KotlinBuiltIns.isUnit(returnType2)) {
                result2 = ErrorUtils.createErrorType(this.components.builtIns.getUnit().getName().asString());
                context.trace.report(Errors.INC_DEC_SHOULD_NOT_RETURN_UNIT.on(operationSign));
            } else {
                JetType receiverType = receiver.getType();
                if (!JetTypeChecker.DEFAULT.isSubtypeOf(returnType2, receiverType)) {
                    context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, name2.asString(), receiverType, returnType2));
                } else {
                    context.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression2);
                    JetExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context.trace, "$e", type2);
                    this.checkLValue(context.trace, context, baseExpression, stubExpression);
                }
                DataFlowValue receiverValue = DataFlowValueFactory.createDataFlowValue(call.getExplicitReceiver(), contextWithExpectedType);
                if (expression2 instanceof JetPrefixExpression) {
                    result2 = returnType2;
                } else {
                    result2 = receiverType;
                    DataFlowValue returnValue = DataFlowValueFactory.createDataFlowValue(expression2, receiverType, contextWithExpectedType);
                    typeInfo = typeInfo.replaceDataFlowInfo(typeInfo.getDataFlowInfo().assign(returnValue, receiverValue));
                }
            }
        } else {
            result2 = returnType2;
        }
        CompileTimeConstant<?> value2 = this.components.constantExpressionEvaluator.evaluateExpression(expression2, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value2 != null) {
            return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, expression2, contextWithExpectedType);
        }
        return this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(result2), (JetExpression)expression2, (ResolutionContext)contextWithExpectedType.replaceDataFlowInfo(typeInfo.getDataFlowInfo()));
    }

    private JetTypeInfo visitExclExclExpression(@NotNull JetUnaryExpression expression2, @NotNull ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitExclExclExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitExclExclExpression"));
        }
        JetExpression baseExpression = expression2.getBaseExpression();
        assert (baseExpression != null);
        JetSimpleNameExpression operationSign = expression2.getOperationReference();
        assert (operationSign.getReferencedNameElementType() == JetTokens.EXCLEXCL);
        Call call = ControlStructureTypingUtils.createCallForSpecialConstruction(expression2, expression2.getOperationReference(), Collections.singletonList(baseExpression));
        this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call, "ExclExcl", Collections.singletonList("baseExpr"), Collections.singletonList(true), context, null);
        JetTypeInfo baseTypeInfo = BindingContextUtils.getRecordedTypeInfo(baseExpression, context.trace.getBindingContext());
        if (ArgumentTypeResolver.isFunctionLiteralArgument(baseExpression, context)) {
            context.trace.report(Errors.NOT_NULL_ASSERTION_ON_FUNCTION_LITERAL.on((PsiElement)operationSign));
            return baseTypeInfo;
        }
        assert (baseTypeInfo != null) : "Base expression was not processed: " + expression2;
        JetType baseType = baseTypeInfo.getType();
        if (baseType == null) {
            return baseTypeInfo;
        }
        DataFlowInfo dataFlowInfo = baseTypeInfo.getDataFlowInfo();
        if (BasicExpressionTypingVisitor.isKnownToBeNotNull(baseExpression, context) && !baseType.isError()) {
            context.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on((PsiElement)operationSign, baseType));
        } else {
            DataFlowValue value2 = DataFlowValueFactory.createDataFlowValue(baseExpression, baseType, context);
            baseTypeInfo = baseTypeInfo.replaceDataFlowInfo(dataFlowInfo.disequate(value2, DataFlowValue.NULL));
        }
        JetType resultingType = TypeUtils.makeNotNullable(baseType);
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            return baseTypeInfo.replaceType(resultingType);
        }
        return this.components.dataFlowAnalyzer.checkType(baseTypeInfo.replaceType(resultingType), (JetExpression)expression2, (ResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
    }

    @Override
    public JetTypeInfo visitLabeledExpression(@NotNull JetLabeledExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        return this.visitLabeledExpression(expression2, context, false);
    }

    @NotNull
    public JetTypeInfo visitLabeledExpression(@NotNull JetLabeledExpression expression2, @NotNull ExpressionTypingContext context, boolean isStatement) {
        JetExpression baseExpression;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        JetSimpleNameExpression labelExpression = expression2.getTargetLabel();
        if (labelExpression != null) {
            PsiElement labelIdentifier = labelExpression.getIdentifier();
            UnderscoreChecker.INSTANCE$.checkIdentifier(labelIdentifier, context.trace);
        }
        if ((baseExpression = expression2.getBaseExpression()) == null) {
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = this.facade.getTypeInfo(baseExpression, context, isStatement);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        return jetTypeInfo;
    }

    private static boolean isKnownToBeNotNull(JetExpression expression2, ExpressionTypingContext context) {
        JetType type2 = context.trace.getType(expression2);
        assert (type2 != null) : "This method is only supposed to be called when the type is not null";
        return BasicExpressionTypingVisitor.isKnownToBeNotNull(expression2, type2, context);
    }

    private static boolean isKnownToBeNotNull(JetExpression expression2, JetType jetType, ExpressionTypingContext context) {
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression2, jetType, context);
        return !context.dataFlowInfo.getNullability(dataFlowValue).canBeNull();
    }

    public boolean checkLValue(@NotNull BindingTrace trace, @NotNull ExpressionTypingContext context, @NotNull JetExpression expression2, @Nullable JetExpression rightHandSide) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        return this.checkLValue(trace, context, expression2, rightHandSide, false);
    }

    private boolean checkLValue(@NotNull BindingTrace trace, @NotNull ExpressionTypingContext context, @NotNull JetExpression expressionWithParenthesis, @Nullable JetExpression rightHandSide, boolean canBeThis) {
        JetExpression selector;
        JetExpression reportOn;
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (expressionWithParenthesis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionWithParenthesis", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        JetExpression expression2 = JetPsiUtil.deparenthesize(expressionWithParenthesis);
        if (expression2 instanceof JetArrayAccessExpression) {
            JetArrayAccessExpression arrayAccessExpression = (JetArrayAccessExpression)expression2;
            JetExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (arrayExpression == null || rightHandSide == null) {
                return false;
            }
            TemporaryBindingTrace ignoreReportsTrace = TemporaryBindingTrace.create(trace, "Trace for checking set function");
            ExpressionTypingContext findSetterContext = (ExpressionTypingContext)context.replaceBindingTrace(ignoreReportsTrace);
            JetTypeInfo info = this.resolveArrayAccessSetMethod(arrayAccessExpression, rightHandSide, findSetterContext, ignoreReportsTrace);
            return info.getType() != null;
        }
        if (canBeThis && expression2 instanceof JetThisExpression) {
            return true;
        }
        VariableDescriptor variable = BindingContextUtils.extractVariableDescriptorIfAny(trace.getBindingContext(), expression2, true);
        boolean result2 = true;
        JetExpression jetExpression = reportOn = expression2 != null ? expression2 : expressionWithParenthesis;
        if (reportOn instanceof JetQualifiedExpression && (selector = ((JetQualifiedExpression)reportOn).getSelectorExpression()) != null) {
            reportOn = selector;
        }
        if (variable instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variable;
            PropertySetterDescriptor setter = propertyDescriptor.getSetter();
            if (propertyDescriptor.isSetterProjectedOut()) {
                trace.report(Errors.SETTER_PROJECTED_OUT.on(reportOn, propertyDescriptor));
                result2 = false;
            } else if (setter != null) {
                this.components.symbolUsageValidator.validateCall(setter, trace, (PsiElement)reportOn);
            }
        }
        if (variable == null) {
            trace.report(Errors.VARIABLE_EXPECTED.on(reportOn));
            result2 = false;
        } else if (!variable.isVar()) {
            result2 = false;
        }
        return result2;
    }

    @Override
    public JetTypeInfo visitBinaryExpression(@NotNull JetBinaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        JetTypeInfo result2;
        Name referencedName;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBinaryExpression"));
        }
        ExpressionTypingContext context = ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType(expression2) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetSimpleNameExpression operationSign = expression2.getOperationReference();
        JetExpression left = expression2.getLeft();
        JetExpression right = expression2.getRight();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.IDENTIFIER) {
            referencedName = operationSign.getReferencedNameAsName();
            result2 = this.getTypeInfoForBinaryCall(referencedName, context, expression2);
        } else if (OperatorConventions.BINARY_OPERATION_NAMES.containsKey((Object)operationType)) {
            referencedName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get((Object)operationType);
            result2 = this.getTypeInfoForBinaryCall(referencedName, context, expression2);
        } else {
            if (operationType == JetTokens.ELVIS) {
                return this.visitElvisExpression(expression2, context);
            }
            if (operationType == JetTokens.EQ) {
                result2 = this.visitAssignment(expression2, context);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey((Object)operationType)) {
                result2 = this.visitAssignmentOperation(expression2, context);
            } else if (OperatorConventions.COMPARISON_OPERATIONS.contains((Object)operationType)) {
                result2 = this.visitComparison(expression2, context, operationSign);
            } else if (OperatorConventions.EQUALS_OPERATIONS.contains((Object)operationType)) {
                result2 = this.visitEquality(expression2, context, operationSign, left, right);
            } else if (OperatorConventions.IDENTITY_EQUALS_OPERATIONS.contains((Object)operationType)) {
                context.trace.record(BindingContext.REFERENCE_TARGET, operationSign, this.components.builtIns.getIdentityEquals());
                this.ensureNonemptyIntersectionOfOperandTypes(expression2, context);
                result2 = TypeInfoFactoryPackage.createTypeInfo(this.components.builtIns.getBooleanType(), context);
            } else if (OperatorConventions.IN_OPERATIONS.contains((Object)operationType)) {
                ValueArgument leftArgument = CallMaker.makeValueArgument(left, left != null ? left : operationSign);
                result2 = this.checkInExpression(expression2, operationSign, leftArgument, right, context);
            } else if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey((Object)operationType)) {
                result2 = this.visitBooleanOperationExpression(operationType, left, right, context);
            } else {
                context.trace.report(Errors.UNSUPPORTED.on((PsiElement)operationSign, "Unknown operation"));
                result2 = TypeInfoFactoryPackage.noTypeInfo(context);
            }
        }
        CompileTimeConstant<?> value2 = this.components.constantExpressionEvaluator.evaluateExpression(expression2, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value2 != null) {
            return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, expression2, contextWithExpectedType);
        }
        return this.components.dataFlowAnalyzer.checkType(result2, (JetExpression)expression2, (ResolutionContext)contextWithExpectedType);
    }

    private JetTypeInfo visitEquality(JetBinaryExpression expression2, ExpressionTypingContext context, JetSimpleNameExpression operationSign, final JetExpression left, final JetExpression right) {
        if (right == null || left == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(right, context, this.facade);
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
            return TypeInfoFactoryPackage.createTypeInfo(this.components.builtIns.getBooleanType(), context);
        }
        JetTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
        JetTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithDataFlow);
        TemporaryBindingTrace traceInterpretingRightAsNullableAny = TemporaryBindingTrace.create(context.trace, "trace to resolve 'equals(Any?)' interpreting as of type Any? an expression:", right);
        traceInterpretingRightAsNullableAny.recordType(right, this.components.builtIns.getNullableAnyType());
        JetType leftType = leftTypeInfo.getType();
        if (leftType != null && KotlinBuiltIns.isNothingOrNullableNothing(leftType)) {
            traceInterpretingRightAsNullableAny.recordType(left, this.components.builtIns.getNullableAnyType());
        }
        ExpressionTypingContext newContext = (ExpressionTypingContext)context.replaceBindingTrace(traceInterpretingRightAsNullableAny);
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, newContext);
        Call call = CallMaker.makeCallWithExpressions(expression2, receiver, new JetPsiFactory(expression2.getProject()).createSafeCallNode(), operationSign, Collections.singletonList(right));
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = this.components.callResolver.resolveCallWithGivenName(newContext, call, operationSign, OperatorConventions.EQUALS);
        traceInterpretingRightAsNullableAny.commit(new TraceEntryFilter(){

            @Override
            public boolean accept(@Nullable WritableSlice<?, ?> slice, Object key) {
                if ((key == right || key == left) && slice == BindingContext.EXPRESSION_TYPE_INFO) {
                    return false;
                }
                return key != left || slice != BindingContext.SMARTCAST;
            }
        }, true);
        if (resolutionResults.isSuccess()) {
            FunctionDescriptor equals = resolutionResults.getResultingCall().getResultingDescriptor();
            if (this.ensureBooleanResult(operationSign, OperatorConventions.EQUALS, equals.getReturnType(), context)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression2, context);
            }
        } else if (resolutionResults.isAmbiguity()) {
            context.trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on((PsiElement)operationSign, resolutionResults.getResultingCalls()));
        } else {
            context.trace.report(Errors.EQUALS_MISSING.on(operationSign));
        }
        return rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
    }

    @NotNull
    private JetTypeInfo visitComparison(@NotNull JetBinaryExpression expression2, @NotNull ExpressionTypingContext context, @NotNull JetSimpleNameExpression operationSign) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        if (operationSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationSign", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        JetTypeInfo typeInfo = this.getTypeInfoForBinaryCall(OperatorConventions.COMPARE_TO, context, expression2);
        JetType compareToReturnType = typeInfo.getType();
        JetType type2 = null;
        if (compareToReturnType != null && !compareToReturnType.isError()) {
            if (JetTypeChecker.DEFAULT.equalTypes(this.components.builtIns.getIntType(), compareToReturnType)) {
                type2 = this.components.builtIns.getBooleanType();
            } else {
                context.trace.report(Errors.COMPARE_TO_TYPE_MISMATCH.on(operationSign, compareToReturnType));
            }
        }
        JetTypeInfo jetTypeInfo = typeInfo.replaceType(type2);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo visitBooleanOperationExpression(@Nullable IElementType operationType, @Nullable JetExpression left, @Nullable JetExpression right, @NotNull ExpressionTypingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBooleanOperationExpression"));
        }
        JetType booleanType = this.components.builtIns.getBooleanType();
        JetTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, (ExpressionTypingContext)context.replaceExpectedType(booleanType), this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        LexicalWritableScope leftScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Left scope of && or ||");
        boolean isAnd = operationType == JetTokens.ANDAND;
        DataFlowInfo flowInfoLeft = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(left, isAnd, context).and(dataFlowInfo);
        LexicalWritableScope rightScope = isAnd ? leftScope : ExpressionTypingUtils.newWritableScopeImpl(context, "Right scope of && or ||");
        ExpressionTypingContext contextForRightExpr = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(flowInfoLeft)).replaceScope(rightScope)).replaceExpectedType(booleanType);
        if (right != null) {
            this.facade.getTypeInfo(right, contextForRightExpr);
        }
        JetTypeInfo jetTypeInfo = leftTypeInfo.replaceType(booleanType);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBooleanOperationExpression"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo visitElvisExpression(@NotNull JetBinaryExpression expression2, @NotNull ExpressionTypingContext contextWithExpectedType) {
        JetType type2;
        JetTypeInfo rightTypeInfo;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
        }
        if (contextWithExpectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextWithExpectedType", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
        }
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression left = expression2.getLeft();
        JetExpression right = expression2.getRight();
        if (left == null || right == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return jetTypeInfo;
        }
        Call call = ControlStructureTypingUtils.createCallForSpecialConstruction(expression2, expression2.getOperationReference(), Lists.newArrayList((Object[])new JetExpression[]{left, right}));
        ResolvedCall<FunctionDescriptor> resolvedCall = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call, "Elvis", Lists.newArrayList((Object[])new String[]{"left", "right"}), Lists.newArrayList((Object[])new Boolean[]{true, false}), contextWithExpectedType, null);
        JetTypeInfo leftTypeInfo = BindingContextUtils.getRecordedTypeInfo(left, context.trace.getBindingContext());
        if (ArgumentTypeResolver.isFunctionLiteralArgument(left, context)) {
            context.trace.report(Errors.USELESS_ELVIS_ON_FUNCTION_LITERAL.on((PsiElement)expression2.getOperationReference()));
            if (leftTypeInfo == null) {
                JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
                }
                return jetTypeInfo;
            }
        }
        assert (leftTypeInfo != null) : "Left expression was not processed: " + expression2;
        JetType leftType = leftTypeInfo.getType();
        if (leftType != null && BasicExpressionTypingVisitor.isKnownToBeNotNull(left, leftType, context)) {
            context.trace.report(Errors.USELESS_ELVIS.on(expression2, leftType));
        }
        if ((rightTypeInfo = BindingContextUtils.getRecordedTypeInfo(right, context.trace.getBindingContext())) == null && ArgumentTypeResolver.isFunctionLiteralArgument(right, context)) {
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return jetTypeInfo;
        }
        assert (rightTypeInfo != null) : "Right expression was not processed: " + expression2;
        boolean loopBreakContinuePossible = leftTypeInfo.getJumpOutPossible() || rightTypeInfo.getJumpOutPossible();
        JetType rightType = rightTypeInfo.getType();
        DataFlowInfo dataFlowInfo = resolvedCall.getDataFlowInfoForArguments().getInfo(call.getValueArguments().get(1));
        if (leftType != null) {
            DataFlowValue leftValue = DataFlowValueFactory.createDataFlowValue(left, leftType, context);
            DataFlowInfo rightDataFlowInfo = resolvedCall.getDataFlowInfoForArguments().getResultInfo();
            if (rightType != null && KotlinBuiltIns.isNothingOrNullableNothing(rightType) && !rightType.isMarkedNullable() || !rightDataFlowInfo.getNullability(leftValue).canBeNull()) {
                dataFlowInfo = dataFlowInfo.disequate(leftValue, DataFlowValue.NULL);
            }
        }
        if ((type2 = resolvedCall.getResultingDescriptor().getReturnType()) == null || rightType == null) {
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return jetTypeInfo;
        }
        if (!TypeUtils.isNullableType(rightType) && TypeUtils.isNullableType(type2)) {
            type2 = TypeUtils.makeNotNullable(type2);
        }
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.createTypeInfo(type2, dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.createTypeInfo(this.components.dataFlowAnalyzer.checkType(type2, (JetExpression)expression2, (ResolutionContext)contextWithExpectedType), dataFlowInfo, loopBreakContinuePossible, context.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo checkInExpression(@NotNull JetElement callElement2, @NotNull JetSimpleNameExpression operationSign, @NotNull ValueArgument leftArgument, @Nullable JetExpression right, @NotNull ExpressionTypingContext context) {
        if (callElement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        if (operationSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationSign", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        if (leftArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftArgument", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        JetExpression left = leftArgument.getArgumentExpression();
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        if (right == null) {
            if (left != null) {
                this.facade.getTypeInfo(left, contextWithNoExpectedType);
            }
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithNoExpectedType);
        DataFlowInfo dataFlowInfo = rightTypeInfo.getDataFlowInfo();
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, right, contextWithNoExpectedType);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
        OverloadResolutionResults<FunctionDescriptor> resolutionResult = this.components.callResolver.resolveCallWithGivenName(contextWithDataFlow, CallMaker.makeCall(callElement2, receiver, null, operationSign, Collections.singletonList(leftArgument)), operationSign, OperatorConventions.CONTAINS);
        JetType containsType = OverloadResolutionResultsUtil.getResultingType(resolutionResult, context.contextDependency);
        this.ensureBooleanResult(operationSign, OperatorConventions.CONTAINS, containsType, context);
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, contextWithDataFlow).getDataFlowInfo().and(dataFlowInfo);
            rightTypeInfo = rightTypeInfo.replaceDataFlowInfo(dataFlowInfo);
        }
        if (resolutionResult.isSuccess()) {
            JetTypeInfo jetTypeInfo = rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = rightTypeInfo.clearType();
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        return jetTypeInfo;
    }

    private boolean ensureBooleanResult(JetExpression operationSign, Name name2, JetType resultType, ExpressionTypingContext context) {
        return this.ensureBooleanResultWithCustomSubject(operationSign, resultType, "'" + name2 + "'", context);
    }

    private boolean ensureBooleanResultWithCustomSubject(JetExpression operationSign, JetType resultType, String subjectName, ExpressionTypingContext context) {
        if (resultType != null && !this.components.builtIns.isBooleanOrSubtype(resultType)) {
            context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, subjectName, this.components.builtIns.getBooleanType(), resultType));
            return false;
        }
        return true;
    }

    private void ensureNonemptyIntersectionOfOperandTypes(JetBinaryExpression expression2, final ExpressionTypingContext context) {
        JetType rightType;
        JetExpression left = expression2.getLeft();
        if (left == null) {
            return;
        }
        JetExpression right = expression2.getRight();
        JetType leftType = this.facade.getTypeInfo(left, context).getType();
        if (leftType != null && right != null && (rightType = this.facade.getTypeInfo(right, context).getType()) != null) {
            if (this.components.typeIntersector.isIntersectionEmpty(leftType, rightType)) {
                context.trace.report(Errors.EQUALITY_NOT_APPLICABLE.on(expression2, expression2.getOperationReference(), leftType, rightType));
            }
            SenselessComparisonChecker.checkSenselessComparisonWithNull(expression2, left, right, context, (Function1<? super JetExpression, ? extends JetType>)new Function1<JetExpression, JetType>(){

                public JetType invoke(JetExpression expression2) {
                    return BasicExpressionTypingVisitor.this.facade.getTypeInfo(expression2, context).getType();
                }
            }, (Function1<? super DataFlowValue, ? extends Nullability>)new Function1<DataFlowValue, Nullability>(){

                public Nullability invoke(DataFlowValue value2) {
                    return context.dataFlowInfo.getNullability(value2);
                }
            });
        }
    }

    @NotNull
    private JetTypeInfo visitAssignmentOperation(JetBinaryExpression expression2, ExpressionTypingContext context) {
        JetTypeInfo jetTypeInfo = this.assignmentIsNotAnExpressionError(expression2, context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitAssignmentOperation"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo visitAssignment(JetBinaryExpression expression2, ExpressionTypingContext context) {
        JetTypeInfo jetTypeInfo = this.assignmentIsNotAnExpressionError(expression2, context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitAssignment"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo assignmentIsNotAnExpressionError(JetBinaryExpression expression2, ExpressionTypingContext context) {
        this.facade.checkStatementType(expression2, context);
        context.trace.report(Errors.ASSIGNMENT_IN_EXPRESSION_CONTEXT.on(expression2));
        JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "assignmentIsNotAnExpressionError"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitArrayAccessExpression"));
        }
        return this.components.dataFlowAnalyzer.checkType(this.resolveArrayAccessGetMethod(expression2, context), (JetExpression)expression2, (ResolutionContext)context);
    }

    @NotNull
    public JetTypeInfo getTypeInfoForBinaryCall(@NotNull Name name2, @NotNull ExpressionTypingContext context, @NotNull JetBinaryExpression binaryExpression) {
        OverloadResolutionResults<Object> resolutionResults;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        JetExpression left = binaryExpression.getLeft();
        JetTypeInfo typeInfo = left != null ? this.facade.getTypeInfo(left, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)) : TypeInfoFactoryPackage.noTypeInfo(context);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        if (left != null) {
            ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context);
            resolutionResults = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)contextWithDataFlow.replaceScope(context.scope), receiver, binaryExpression, name2);
        } else {
            resolutionResults = OverloadResolutionResultsImpl.nameNotFound();
        }
        if (resolutionResults.isSingleResult()) {
            typeInfo = typeInfo.replaceDataFlowInfo(resolutionResults.getResultingCall().getDataFlowInfoForArguments().getResultInfo());
        }
        JetTypeInfo jetTypeInfo = typeInfo.replaceType(OverloadResolutionResultsUtil.getResultingType(resolutionResults, context.contextDependency));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitDeclaration(@NotNull JetDeclaration dcl, ExpressionTypingContext context) {
        if (dcl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dcl", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitDeclaration"));
        }
        context.trace.report(Errors.DECLARATION_IN_ILLEGAL_CONTEXT.on(dcl));
        return TypeInfoFactoryPackage.noTypeInfo(context);
    }

    @Override
    public JetTypeInfo visitRootPackageExpression(@NotNull JetRootPackageExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitRootPackageExpression"));
        }
        if (!JetPsiUtil.isLHSOfDot(expression2)) {
            context.trace.report(Errors.PACKAGE_IS_NOT_AN_EXPRESSION.on(expression2));
        }
        return TypeInfoFactoryPackage.noTypeInfo(context);
    }

    @Override
    public JetTypeInfo visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitStringTemplateExpression"));
        }
        final ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        class StringTemplateVisitor
        extends JetVisitorVoid {
            private JetTypeInfo typeInfo;

            StringTemplateVisitor() {
                this.typeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
            }

            @Override
            public void visitStringTemplateEntryWithExpression(@NotNull JetStringTemplateEntryWithExpression entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor$1StringTemplateVisitor", "visitStringTemplateEntryWithExpression"));
                }
                JetExpression entryExpression = entry.getExpression();
                if (entryExpression != null) {
                    this.typeInfo = BasicExpressionTypingVisitor.this.facade.getTypeInfo(entryExpression, (ExpressionTypingContext)context.replaceDataFlowInfo(this.typeInfo.getDataFlowInfo()));
                }
            }

            @Override
            public void visitEscapeStringTemplateEntry(@NotNull JetEscapeStringTemplateEntry entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor$1StringTemplateVisitor", "visitEscapeStringTemplateEntry"));
                }
                CompileTimeConstantChecker.CharacterWithDiagnostic value2 = CompileTimeConstantChecker.escapedStringToCharacter(entry.getText(), entry);
                Diagnostic diagnostic = value2.getDiagnostic();
                if (diagnostic != null) {
                    context.trace.report(diagnostic);
                }
            }
        }
        StringTemplateVisitor visitor2 = new StringTemplateVisitor();
        for (JetStringTemplateEntry entry : expression2.getEntries()) {
            entry.accept(visitor2);
        }
        this.components.constantExpressionEvaluator.evaluateExpression(expression2, context.trace, contextWithExpectedType.expectedType);
        return this.components.dataFlowAnalyzer.checkType(visitor2.typeInfo.replaceType(this.components.builtIns.getStringType()), (JetExpression)expression2, (ResolutionContext)contextWithExpectedType);
    }

    @Override
    public JetTypeInfo visitAnnotatedExpression(@NotNull JetAnnotatedExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitAnnotatedExpression"));
        }
        return this.visitAnnotatedExpression(expression2, context, false);
    }

    public JetTypeInfo visitAnnotatedExpression(JetAnnotatedExpression expression2, ExpressionTypingContext context, boolean isStatement) {
        this.components.annotationResolver.resolveAnnotationsWithArguments(context.scope, expression2.getAnnotationEntries(), context.trace);
        JetExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryPackage.noTypeInfo(context);
        }
        return this.facade.getTypeInfo(baseExpression, context, isStatement);
    }

    @Override
    public JetTypeInfo visitJetElement(@NotNull JetElement element2, ExpressionTypingContext context) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitJetElement"));
        }
        context.trace.report(Errors.UNSUPPORTED.on((PsiElement)element2, ((Object)((Object)this)).getClass().getCanonicalName()));
        return TypeInfoFactoryPackage.noTypeInfo(context);
    }

    @NotNull
    JetTypeInfo resolveArrayAccessSetMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull JetExpression rightHandSide, @NotNull ExpressionTypingContext context, @NotNull BindingTrace traceForResolveResult) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        if (rightHandSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightHandSide", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        if (traceForResolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceForResolveResult", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        JetTypeInfo jetTypeInfo = this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context, traceForResolveResult, false);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        return jetTypeInfo;
    }

    @NotNull
    JetTypeInfo resolveArrayAccessGetMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull ExpressionTypingContext context) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessGetMethod"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessGetMethod"));
        }
        JetTypeInfo jetTypeInfo = this.resolveArrayAccessSpecialMethod(arrayAccessExpression, null, context, context.trace, true);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessGetMethod"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo resolveArrayAccessSpecialMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @Nullable JetExpression rightHandSide, @NotNull ExpressionTypingContext oldContext, @NotNull BindingTrace traceForResolveResult, boolean isGet) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        if (oldContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldContext", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        if (traceForResolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceForResolveResult", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        JetExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (arrayExpression == null) {
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(oldContext);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo arrayTypeInfo = this.facade.safeGetTypeInfo(arrayExpression, (ExpressionTypingContext)((ExpressionTypingContext)oldContext.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        JetType arrayType = ExpressionTypingUtils.safeGetType(arrayTypeInfo);
        ExpressionTypingContext context = (ExpressionTypingContext)oldContext.replaceDataFlowInfo(arrayTypeInfo.getDataFlowInfo());
        ExpressionReceiver receiver = new ExpressionReceiver(arrayExpression, arrayType);
        if (!isGet) assert (rightHandSide != null);
        Call call = isGet ? CallMaker.makeArrayGetCall(receiver, arrayAccessExpression, Call.CallType.ARRAY_GET_METHOD) : CallMaker.makeArraySetCall(receiver, arrayAccessExpression, rightHandSide, Call.CallType.ARRAY_SET_METHOD);
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.components.callResolver.resolveCallWithGivenName(context, call, arrayAccessExpression, Name.identifier(isGet ? "get" : "set"));
        List<JetExpression> indices = arrayAccessExpression.getIndexExpressions();
        JetTypeInfo resultTypeInfo = arrayTypeInfo;
        if (!indices.isEmpty()) {
            resultTypeInfo = this.facade.getTypeInfo(indices.get(indices.size() - 1), context);
        }
        if (!isGet) {
            resultTypeInfo = this.facade.getTypeInfo(rightHandSide, context);
        }
        if (!functionResults.isSingleResult()) {
            traceForResolveResult.report(isGet ? Errors.NO_GET_METHOD.on(arrayAccessExpression) : Errors.NO_SET_METHOD.on(arrayAccessExpression));
            JetTypeInfo jetTypeInfo = resultTypeInfo.clearType();
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
            }
            return jetTypeInfo;
        }
        traceForResolveResult.record(isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression, functionResults.getResultingCall());
        JetTypeInfo jetTypeInfo = resultTypeInfo.replaceType(functionResults.getResultingDescriptor().getReturnType());
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        return jetTypeInfo;
    }
}

