/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetIsExpression;
import org.jetbrains.kotlin.psi.JetNullableType;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenConditionInRange;
import org.jetbrains.kotlin.psi.JetWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.JetWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;

public class PatternMatchingTypingVisitor
extends ExpressionTypingVisitor {
    protected PatternMatchingTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "<init>"));
        }
        super(facade);
    }

    @Override
    public JetTypeInfo visitIsExpression(@NotNull JetIsExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "visitIsExpression"));
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression leftHandSide = expression2.getLeftHandSide();
        JetTypeInfo typeInfo = this.facade.safeGetTypeInfo(leftHandSide, (ExpressionTypingContext)context.replaceScope(context.scope));
        JetType knownType = typeInfo.getType();
        if (expression2.getTypeReference() != null) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(leftHandSide, knownType, context);
            DataFlowInfo conditionInfo = this.checkTypeForIs(context, knownType, expression2.getTypeReference(), dataFlowValue).thenInfo;
            DataFlowInfo newDataFlowInfo = conditionInfo.and(typeInfo.getDataFlowInfo());
            context.trace.record(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression2, newDataFlowInfo);
        }
        return this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(this.components.builtIns.getBooleanType()), (JetExpression)expression2, (ResolutionContext)contextWithExpectedType);
    }

    @Override
    public JetTypeInfo visitWhenExpression(@NotNull JetWhenExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "visitWhenExpression"));
        }
        return this.visitWhenExpression(expression2, context, false);
    }

    public JetTypeInfo visitWhenExpression(JetWhenExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        JetType subjectType;
        this.components.dataFlowAnalyzer.recordExpectedType(contextWithExpectedType.trace, expression2, contextWithExpectedType.expectedType);
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression subjectExpression = expression2.getSubjectExpression();
        boolean loopBreakContinuePossible = false;
        if (subjectExpression == null) {
            subjectType = ErrorUtils.createErrorType("Unknown type");
        } else {
            JetTypeInfo typeInfo = this.facade.safeGetTypeInfo(subjectExpression, context);
            loopBreakContinuePossible = typeInfo.getJumpOutPossible();
            subjectType = typeInfo.getType();
            assert (subjectType != null);
            if (TypeUtils.isNullableType(subjectType) && !WhenChecker.containsNullCase(expression2, context.trace)) {
                ExpressionTypingContext subjectContext = (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.makeNotNullable(subjectType));
                this.components.dataFlowAnalyzer.checkPossibleCast(subjectType, JetPsiUtil.safeDeparenthesize(subjectExpression, false), subjectContext);
            }
            context = (ExpressionTypingContext)context.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        }
        DataFlowValue subjectDataFlowValue = subjectExpression != null ? DataFlowValueFactory.createDataFlowValue(subjectExpression, subjectType, context) : DataFlowValue.NULL;
        HashSet expressionTypes = Sets.newHashSet();
        DataFlowInfo commonDataFlowInfo = null;
        DataFlowInfo elseDataFlowInfo = context.dataFlowInfo;
        for (JetWhenEntry whenEntry : expression2.getEntries()) {
            DataFlowInfos infosForCondition = this.getDataFlowInfosForEntryCondition(whenEntry, (ExpressionTypingContext)context.replaceDataFlowInfo(elseDataFlowInfo), subjectExpression, subjectType, subjectDataFlowValue);
            elseDataFlowInfo = elseDataFlowInfo.and(infosForCondition.elseInfo);
            JetExpression bodyExpression = whenEntry.getExpression();
            if (bodyExpression == null) continue;
            LexicalWritableScope scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context, "Scope extended in when entry");
            ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceScope(scopeToExtend)).replaceDataFlowInfo(infosForCondition.thenInfo)).replaceContextDependency(ContextDependency.INDEPENDENT);
            CoercionStrategy coercionStrategy = isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION;
            JetTypeInfo typeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(bodyExpression), coercionStrategy, newContext);
            loopBreakContinuePossible |= typeInfo.getJumpOutPossible();
            JetType type2 = typeInfo.getType();
            if (type2 != null) {
                expressionTypes.add(type2);
            }
            if (commonDataFlowInfo == null) {
                commonDataFlowInfo = typeInfo.getDataFlowInfo();
                continue;
            }
            commonDataFlowInfo = commonDataFlowInfo.or(typeInfo.getDataFlowInfo());
        }
        if (commonDataFlowInfo == null) {
            commonDataFlowInfo = context.dataFlowInfo;
        } else if (expression2.getElseExpression() == null && !WhenChecker.isWhenExhaustive(expression2, context.trace)) {
            commonDataFlowInfo = commonDataFlowInfo.or(context.dataFlowInfo);
        }
        return TypeInfoFactoryPackage.createTypeInfo(expressionTypes.isEmpty() ? null : this.components.dataFlowAnalyzer.checkType(this.components.dataFlowAnalyzer.checkImplicitCast(CommonSupertypes.commonSupertype(expressionTypes), (JetExpression)expression2, (ResolutionContext)contextWithExpectedType, isStatement), (JetExpression)expression2, (ResolutionContext)contextWithExpectedType), commonDataFlowInfo, loopBreakContinuePossible, contextWithExpectedType.dataFlowInfo);
    }

    @NotNull
    private DataFlowInfos getDataFlowInfosForEntryCondition(@NotNull JetWhenEntry whenEntry, @NotNull ExpressionTypingContext context, @Nullable JetExpression subjectExpression, @NotNull JetType subjectType, @NotNull DataFlowValue subjectDataFlowValue) {
        if (whenEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenEntry", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        if (subjectDataFlowValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectDataFlowValue", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        if (whenEntry.isElse()) {
            DataFlowInfos dataFlowInfos = new DataFlowInfos(context.dataFlowInfo);
            if (dataFlowInfos == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
            }
            return dataFlowInfos;
        }
        DataFlowInfos infos = null;
        ExpressionTypingContext contextForCondition = context;
        for (JetWhenCondition condition2 : whenEntry.getConditions()) {
            DataFlowInfos conditionInfos = this.checkWhenCondition(subjectExpression, subjectType, condition2, contextForCondition, subjectDataFlowValue);
            infos = infos != null ? new DataFlowInfos(infos.thenInfo.or(conditionInfos.thenInfo), infos.elseInfo.and(conditionInfos.elseInfo)) : conditionInfos;
            contextForCondition = (ExpressionTypingContext)contextForCondition.replaceDataFlowInfo(conditionInfos.elseInfo);
        }
        DataFlowInfos dataFlowInfos = infos != null ? infos : new DataFlowInfos(context.dataFlowInfo);
        if (dataFlowInfos == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        return dataFlowInfos;
    }

    private DataFlowInfos checkWhenCondition(final @Nullable JetExpression subjectExpression, final JetType subjectType, JetWhenCondition condition2, final ExpressionTypingContext context, final DataFlowValue subjectDataFlowValue) {
        final Ref newDataFlowInfo = new Ref((Object)PatternMatchingTypingVisitor.noChange(context));
        condition2.accept(new JetVisitorVoid(){

            @Override
            public void visitWhenConditionInRange(@NotNull JetWhenConditionInRange condition2) {
                if (condition2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$1", "visitWhenConditionInRange"));
                }
                JetExpression rangeExpression = condition2.getRangeExpression();
                if (rangeExpression == null) {
                    return;
                }
                if (subjectExpression == null) {
                    context.trace.report(Errors.EXPECTED_CONDITION.on(condition2));
                    DataFlowInfo dataFlowInfo = PatternMatchingTypingVisitor.this.facade.getTypeInfo(rangeExpression, context).getDataFlowInfo();
                    newDataFlowInfo.set((Object)new DataFlowInfos(dataFlowInfo, dataFlowInfo));
                    return;
                }
                ValueArgument argumentForSubject = CallMaker.makeExternalValueArgument(subjectExpression);
                JetTypeInfo typeInfo = PatternMatchingTypingVisitor.this.facade.checkInExpression(condition2, condition2.getOperationReference(), argumentForSubject, rangeExpression, context);
                DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
                newDataFlowInfo.set((Object)new DataFlowInfos(dataFlowInfo, dataFlowInfo));
                JetType type2 = typeInfo.getType();
                if (type2 == null || !KotlinBuiltIns.isBoolean(type2)) {
                    context.trace.report(Errors.TYPE_MISMATCH_IN_RANGE.on(condition2));
                }
            }

            @Override
            public void visitWhenConditionIsPattern(@NotNull JetWhenConditionIsPattern condition2) {
                if (condition2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$1", "visitWhenConditionIsPattern"));
                }
                if (subjectExpression == null) {
                    context.trace.report(Errors.EXPECTED_CONDITION.on(condition2));
                }
                if (condition2.getTypeReference() != null) {
                    DataFlowInfos result2 = PatternMatchingTypingVisitor.this.checkTypeForIs(context, subjectType, condition2.getTypeReference(), subjectDataFlowValue);
                    if (condition2.isNegated()) {
                        newDataFlowInfo.set((Object)new DataFlowInfos(result2.elseInfo, result2.thenInfo));
                    } else {
                        newDataFlowInfo.set((Object)result2);
                    }
                }
            }

            @Override
            public void visitWhenConditionWithExpression(@NotNull JetWhenConditionWithExpression condition2) {
                if (condition2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$1", "visitWhenConditionWithExpression"));
                }
                JetExpression expression2 = condition2.getExpression();
                if (expression2 != null) {
                    newDataFlowInfo.set((Object)PatternMatchingTypingVisitor.this.checkTypeForExpressionCondition(context, expression2, subjectType, subjectExpression == null, subjectDataFlowValue));
                }
            }

            @Override
            public void visitJetElement(@NotNull JetElement element2) {
                if (element2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$1", "visitJetElement"));
                }
                context.trace.report(Errors.UNSUPPORTED.on((PsiElement)element2, ((Object)((Object)this)).getClass().getCanonicalName()));
            }
        });
        return (DataFlowInfos)newDataFlowInfo.get();
    }

    private DataFlowInfos checkTypeForExpressionCondition(ExpressionTypingContext context, JetExpression expression2, JetType subjectType, boolean conditionExpected, DataFlowValue subjectDataFlowValue) {
        if (expression2 == null) {
            return PatternMatchingTypingVisitor.noChange(context);
        }
        JetTypeInfo typeInfo = this.facade.getTypeInfo(expression2, context);
        JetType type2 = typeInfo.getType();
        if (type2 == null) {
            return PatternMatchingTypingVisitor.noChange(context);
        }
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        if (conditionExpected) {
            JetType booleanType = this.components.builtIns.getBooleanType();
            if (JetTypeChecker.DEFAULT.equalTypes(booleanType, type2)) {
                DataFlowInfo ifInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(expression2, true, context);
                DataFlowInfo elseInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(expression2, false, context);
                return new DataFlowInfos(ifInfo, elseInfo);
            }
            context.trace.report(Errors.TYPE_MISMATCH_IN_CONDITION.on(expression2, type2));
            return PatternMatchingTypingVisitor.noChange(context);
        }
        this.checkTypeCompatibility(context, type2, subjectType, expression2);
        DataFlowValue expressionDataFlowValue = DataFlowValueFactory.createDataFlowValue(expression2, type2, context);
        DataFlowInfos result2 = PatternMatchingTypingVisitor.noChange(context);
        result2 = new DataFlowInfos(result2.thenInfo.equate(subjectDataFlowValue, expressionDataFlowValue), result2.elseInfo.disequate(subjectDataFlowValue, expressionDataFlowValue));
        return result2;
    }

    private DataFlowInfos checkTypeForIs(ExpressionTypingContext context, JetType subjectType, JetTypeReference typeReferenceAfterIs, DataFlowValue subjectDataFlowValue) {
        ClassDescriptor targetDescriptor;
        if (typeReferenceAfterIs == null) {
            return PatternMatchingTypingVisitor.noChange(context);
        }
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context.scope, context.trace, true, true);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, typeReferenceAfterIs);
        JetType targetType = TypeReconstructionUtil.reconstructBareType(typeReferenceAfterIs, possiblyBareTarget, subjectType, context.trace, this.components.builtIns);
        if (TypesPackage.isDynamic(targetType)) {
            context.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on(typeReferenceAfterIs));
        }
        if ((targetDescriptor = TypeUtils.getClassDescriptor(targetType)) != null && DescriptorUtils.isEnumEntry(targetDescriptor)) {
            context.trace.report(Errors.IS_ENUM_ENTRY.on(typeReferenceAfterIs));
        }
        if (!subjectType.isMarkedNullable() && targetType.isMarkedNullable()) {
            JetTypeElement element2 = typeReferenceAfterIs.getTypeElement();
            assert (element2 instanceof JetNullableType) : "element must be instance of " + JetNullableType.class.getName();
            JetNullableType nullableType = (JetNullableType)element2;
            context.trace.report(Errors.USELESS_NULLABLE_CHECK.on(nullableType));
        }
        this.checkTypeCompatibility(context, targetType, subjectType, typeReferenceAfterIs);
        if (CastDiagnosticsUtil.isCastErased(subjectType, targetType, JetTypeChecker.DEFAULT)) {
            context.trace.report(Errors.CANNOT_CHECK_FOR_ERASED.on(typeReferenceAfterIs, targetType));
        }
        return new DataFlowInfos(context.dataFlowInfo.establishSubtyping(subjectDataFlowValue, targetType), context.dataFlowInfo);
    }

    private static DataFlowInfos noChange(ExpressionTypingContext context) {
        return new DataFlowInfos(context.dataFlowInfo, context.dataFlowInfo);
    }

    private void checkTypeCompatibility(@NotNull ExpressionTypingContext context, @Nullable JetType type2, @NotNull JetType subjectType, @NotNull JetElement reportErrorOn) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "checkTypeCompatibility"));
        }
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "checkTypeCompatibility"));
        }
        if (reportErrorOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorOn", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "checkTypeCompatibility"));
        }
        if (type2 == null) {
            return;
        }
        if (this.components.typeIntersector.isIntersectionEmpty(type2, subjectType)) {
            context.trace.report(Errors.INCOMPATIBLE_TYPES.on(reportErrorOn, type2, subjectType));
            return;
        }
        if (KotlinBuiltIns.isNullableNothing(type2) && !TypeUtils.isNullableType(subjectType)) {
            context.trace.report(Errors.SENSELESS_NULL_IN_WHEN.on(reportErrorOn));
        }
    }

    private static class DataFlowInfos {
        private final DataFlowInfo thenInfo;
        private final DataFlowInfo elseInfo;

        private DataFlowInfos(DataFlowInfo thenInfo, DataFlowInfo elseInfo) {
            this.thenInfo = thenInfo;
            this.elseInfo = elseInfo;
        }

        private DataFlowInfos(DataFlowInfo info) {
            this(info, info);
        }
    }
}

