/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.substitutions;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"M\u0006)9r-\u001a;DC2d\u0017M\u00197f'V\u00147\u000f^5ukRLwN\u001c\u0006\rE\u0006\u001cXmQ1mY\u0006\u0014G.\u001a\u0006\u0013\u0007\u0006dG.\u00192mK\u0012+7o\u0019:jaR|'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015-!Wm]2sSB$xN]:\u000b\u001f\u0011,'/\u001b<fI\u000e\u000bG\u000e\\1cY\u0016T!\"T;uC\ndW-T1q\u0015=!\u0016\u0010]3D_:\u001cHO];di>\u0014(\"\u0002;za\u0016\u001c(B\u0004+za\u0016\u0004&o\u001c6fGRLwN\u001c\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'bA'ba*\u00192+\u001e2ti&$X\u000f^5p]V#\u0018\u000e\\:Li*1r-\u001a;DC2d\u0017M\u00197f'V\u00147\u000f^5ukR|'OC\bUsB,7+\u001e2ti&$X\u000f^8s\u0015M9W\r\u001e+za\u0016\u001cVOY:uSR,H/[8o\u0015!\u0011\u0017m]3UsB,'b\u0002&fiRK\b/\u001a\u0006\fI\u0016\u0014\u0018N^3e)f\u0004XMC\u0007MS:\\W\r\u001a%bg\"l\u0015\r\u001d\u0006\u0013O\u0016$H+\u001f9f'V\u00147\u000f^5ukR|'\u000fa\u0001\u000b\u0005A\u0019!\u0002\u0002\u0005\u0001!\u0011QA\u0001C\u0001\u0011\u000b)!\u0001B\u0001\t\u0007\u0015\u0019A1\u0001\u0005\u0002\u0019\u0001)\u0011\u0001#\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0002\u0007\u0001\u000b\t!\u0011\u0001C\u0003\u0006\u0007\u0011\u001d\u0001\u0012\u0002\u0007\u0001\u000b\r!9\u0001c\u0003\r\u0001\u0015\t\u0001BB\u0003\u0003\t\u0015Ai!\u0002\u0002\u0005\f!9QA\u0001C\u0002\u0011\u0005)1\u0001b\u0002\t\u00121\u0001QA\u0001C\u0004\u0011#)1\u0001b\u0002\t\u00151\u0001Qa\u0001C\u0006\u0011-a\u0001!\u0002\u0002\u0005\f!YQA\u0001C\u0004\u0011))A\u0006B\u0002\u0019\u0001u=A\u0001\u0001E\u0001\u001b\r)\u0011\u0001\u0003\u0002\u0019\u0005A\u001b\u0001!h\u0004\u0005\u0001!\u001dQbA\u0003\u0002\u0011\tA\"\u0001UB\u0001C9)\u0011\u0001C\u0002\n\t%\u0019Q!\u0001\u0005\u00051\u0011IA!C\u0002\u0006\u0003!%\u0001\u0014\u0002G\u00011\r\t6a\u0002\u0003\u0001\u0013\u0005Aa!D\u0001\t\u000e5\t\u0001R\u0002-\u0004\u0010\u0015\u0011Ca\u0001\r\t;\u001f!\u0001\u0001#\u0001\u000e\u0007\u0015\t\u0001B\u0001\r\u0003!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u000fi1!B\u0001\t\u0005a\u0011\u0001k!\u0001\"\t\u0015\t\u0001b\u0002G\u00011\u001d\t6a\u0002\u0003\t\u0013\u0005Ay!D\u0001\t\u000e5\t\u0001R\u0002-\u0004\u0010\u0015aCa\u0001\r\n;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001\u0002\u0003\r\t!\u000e\u0001Qt\u0002\u0003\u0001\u0011+i1!B\u0001\t\u0011aA\u0001k!\u0001\"\u001d\u0015\t\u0001\u0012C\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0003\u0019\t%!\u0011bA\u0003\u0002\u0011\u0013AJ\u0001$\u0001\u0019\u0012E\u001bq\u0001B\u0005\n\u0003!IQ\"\u0001E\n\u001b\u0005A\u0019\u0002WB\b\u000b\t\"1\u0001g\u0006\u001e\u0010\u0011\u0001\u00012C\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0001iz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001\u0005\t1!\u00016\u0011A\u0011\u0005\u000b\u0005Aq\u0001$\u0001\u0019\u000fE\u001bq\u0001b\u0006\n\u0003!=Q\"\u0001E\n\u001b\u0005A\u0019\u0002WB\b"})
public final class SubstitutionUtilsKt {
    @Nullable
    public static final LinkedHashMap<TypeConstructor, TypeProjection> getTypeSubstitution(@NotNull JetType baseType, @NotNull JetType derivedType) {
        Intrinsics.checkParameterIsNotNull((Object)baseType, (String)"baseType");
        Intrinsics.checkParameterIsNotNull((Object)derivedType, (String)"derivedType");
        JetType jetType = TypeCheckingProcedure.findCorrespondingSupertype(derivedType, baseType);
        if (jetType == null) {
            return null;
        }
        JetType substitutedType = jetType;
        LinkedHashMap<TypeConstructor, TypeProjection> substitution = new LinkedHashMap<TypeConstructor, TypeProjection>(substitutedType.getArguments().size());
        Iterable iterable = baseType.getConstructor().getParameters();
        Iterable iterable2 = substitutedType.getArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"substitutedType.getArguments()");
        for (Pair pair2 : CollectionsKt.zip((Iterable)iterable, (Iterable)iterable2)) {
            TypeParameterDescriptor param = (TypeParameterDescriptor)pair2.component1();
            TypeProjection arg = (TypeProjection)pair2.component2();
            Map map2 = substitution;
            TypeConstructor typeConstructor2 = param.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"param.getTypeConstructor()");
            TypeProjection typeProjection = arg;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeProjection, (String)"arg");
            MapsKt.set((Map)map2, (Object)typeConstructor2, (Object)typeProjection);
        }
        return substitution;
    }

    @Nullable
    public static final Map<TypeConstructor, TypeProjection> getCallableSubstitution(@NotNull CallableDescriptor baseCallable, @NotNull CallableDescriptor derivedCallable) {
        Intrinsics.checkParameterIsNotNull((Object)baseCallable, (String)"baseCallable");
        Intrinsics.checkParameterIsNotNull((Object)derivedCallable, (String)"derivedCallable");
        DeclarationDescriptor declarationDescriptor = baseCallable.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor baseClass = classDescriptor;
        DeclarationDescriptor declarationDescriptor2 = derivedCallable.getContainingDeclaration();
        if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
            declarationDescriptor2 = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor2;
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor derivedClass = classDescriptor2;
        JetType jetType = baseClass.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"baseClass.getDefaultType()");
        JetType jetType2 = derivedClass.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType2, (String)"derivedClass.getDefaultType()");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = SubstitutionUtilsKt.getTypeSubstitution(jetType, jetType2);
        if (linkedHashMap == null) {
            return null;
        }
        LinkedHashMap<TypeConstructor, TypeProjection> substitution = linkedHashMap;
        Iterable iterable = baseCallable.getTypeParameters();
        Iterable iterable2 = derivedCallable.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"derivedCallable.getTypeParameters()");
        for (Pair pair2 : CollectionsKt.zip((Iterable)iterable, (Iterable)iterable2)) {
            TypeParameterDescriptor baseParam = (TypeParameterDescriptor)pair2.component1();
            TypeParameterDescriptor derivedParam = (TypeParameterDescriptor)pair2.component2();
            Map map2 = substitution;
            TypeConstructor typeConstructor2 = baseParam.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"baseParam.getTypeConstructor()");
            MapsKt.set((Map)map2, (Object)typeConstructor2, (Object)new TypeProjectionImpl(derivedParam.getDefaultType()));
        }
        return substitution;
    }

    @Nullable
    public static final TypeSubstitutor getCallableSubstitutor(@NotNull CallableDescriptor baseCallable, @NotNull CallableDescriptor derivedCallable) {
        TypeSubstitutor typeSubstitutor2;
        Intrinsics.checkParameterIsNotNull((Object)baseCallable, (String)"baseCallable");
        Intrinsics.checkParameterIsNotNull((Object)derivedCallable, (String)"derivedCallable");
        Map<TypeConstructor, TypeProjection> map2 = SubstitutionUtilsKt.getCallableSubstitution(baseCallable, derivedCallable);
        if (map2 != null) {
            Map<TypeConstructor, TypeProjection> $receiver = map2;
            Map<TypeConstructor, TypeProjection> it = $receiver;
            typeSubstitutor2 = TypeSubstitutor.create(it);
        } else {
            typeSubstitutor2 = null;
        }
        return typeSubstitutor2;
    }

    @Nullable
    public static final TypeSubstitutor getTypeSubstitutor(@NotNull JetType baseType, @NotNull JetType derivedType) {
        TypeSubstitutor typeSubstitutor2;
        Intrinsics.checkParameterIsNotNull((Object)baseType, (String)"baseType");
        Intrinsics.checkParameterIsNotNull((Object)derivedType, (String)"derivedType");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = SubstitutionUtilsKt.getTypeSubstitution(baseType, derivedType);
        if (linkedHashMap != null) {
            LinkedHashMap<TypeConstructor, TypeProjection> $receiver = linkedHashMap;
            LinkedHashMap<TypeConstructor, TypeProjection> it = $receiver;
            typeSubstitutor2 = TypeSubstitutor.create((Map<TypeConstructor, TypeProjection>)it);
        } else {
            typeSubstitutor2 = null;
        }
        return typeSubstitutor2;
    }
}

