/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetImportList;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.util.CachedAliasImportData;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"f\u0006))\u0012\tT%B'~KU\nU(S)~#\u0015\tV!`\u0017\u0016K&bA&fs*\u00191m\\7\u000b\u0011%tG/\u001a7mS*Tqa\u001c9f]\u0006\u0004\u0018N\u0003\u0003vi&d'\"F\"bG\",G-\u00117jCNLU\u000e]8si\u0012\u000bG/\u0019\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*Ar-\u001a;B\u0019&\u000b5kX%N!>\u0013Fk\u0018#B)\u0006{6*R-\u000b\u001fQK\b/Z%oI\u0016DX\u000b^5m\u0017RTqAS3u\r&dWMC\u0002qg&Ta\"\u00197jCNLU\u000e]8si6\u000b\u0007O\u0003\u0005Nk2$\u0018.\\1q\u0015\u00199wn\\4mK*11m\\7n_:TqaY8mY\u0016\u001cGO\u0003\u0004TiJLgn\u001a\u0006\f\u0015\u0016$Xk]3s)f\u0004XMC\nck&dG-\u00117jCNLU\u000e]8si6\u000b\u0007OC\u0006TiV\u0014W\t\\3nK:$(\"B:uk\n\u001c(\"F4fi\u000e{g\u000e^1j]&twMR5mKN#XO\u0019\u0006\f!NLg)\u001b7f'R,(M\u0003\tKKR$\u0016\u0010]3SK\u001a,'/\u001a8dK*\t\u0012n\u001d)s_\n\f'\r\\=O_RD\u0017N\\4\u000b\u000f\t{w\u000e\\3b]:\u000f!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0004\t\u0007A\t\u0001\u0004\u0001\u0006\u0003!\u001dQA\u0001C\u0003\u0011\u0011)!\u0001B\u0002\t\n\u0015\u0011Aq\u0001E\u0003\u000b\r!A\u0001C\u0002\r\u0001\u0015\u0011A1\u0001E\u0001\u000b\t!9\u0001#\u0004\u0006\u0007\u0011-\u0001B\u0002\u0007\u0001\u000b\t!\u0001\u0001\u0003\u0005\u0006\u0005\u00115\u0001\u0012C\u0003\u0003\t\u001dA\u0011\"B\u0002\u0005\u0010!=A\u0002A\u0003\u0002\u0011\u0013)1\u0001\"\u0005\t\u00141\u0001QA\u0001C\b\u0011\u001f)!\u0001b\u0003\t\r\u0015\u0019A1\u0002\u0005\u000b\u0019\u0001)!\u0001b\u0003\t\u0015\u0015\u0011A\u0011\u0001E\u0007\u000b\t!9\u0002c\u0006\u0006\u0007\u0011a\u0001b\u0003\u0007\u0001\u000b\r!A\u0002#\u0007\r\u0001\u0015\u0011A\u0001\u0004E\r\u000b\t!A\u0002C\u0006\u0006\u0007\u0011-\u0001\"\u0004\u0007\u0001\u000b\r!\t\u0002\u0003\b\r\u0001\u0015\u0011A1\u0002\u0005\u000e\u000b[!\u0011\r\u0002\r\u0001C!)\u0011\u0001\u0003\u0002\n\t%\u0019Q!\u0001E\u00051\u0013A\"!V\u0002\t\u000b\r!\u0001!C\u0001\t\u000b5\u0019A!B\u0005\u0002\u0011\u0015A61B\u0003\u001d\t\u0005)2!B\u0001\t\ra1\u0001dB\u0011\u000e\u000b\u0005A\u0001\"\u0003\u0003\n\u0007\u0015\t\u0001\"\u0003\r\n\u0013\u0011I1!B\u0001\t\u0013aI\u0001\u0004C)\u0004\u000b\u00119\u0011\"\u0001E\n\u001b\u0005A!\u0002WB\u0006\u000bq!1!F\u0002\u0006\u0003!U\u0001T\u0003\r\bC5)\u0011\u0001\u0003\u0005\n\t%\u0019Q!\u0001\u0005\n1%IA!C\u0002\u0006\u0003!I\u0001$\u0003\r\t#\u000e)AaB\u0005\u0002\u0011'i\u0011\u0001C\u0006Y\u0007\u0017)A\u0004B\u0001\u0016\u0007\u0015\t\u0001B\u0002\r\u00071+\tS\"B\u0001\t\u0011%!\u0011bA\u0003\u0002\u0011%A\u0012\"\u0003\u0003\n\u0007\u0015\t\u0001\"\u0003\r\n1!\t6!\u0002C\u000b\u0013\u0005A\u0019\"D\u0001\t\u0015a\u001bY!\u0002\f\u0005\u0003U)Q!\u0001E\r\u0013\u0005!\u0019\u0001'\u0007\u0019\u0019\u0005*Q!\u0001\u0005\u000e\u0013\u0005!\u0019\u0001G\u0007R\u0007\u0015!A\"C\u0001\t\u001c5\t\u0001B\u0004-\u0004\f\u0015\u0019BaA\u000b\u0005\u000b\u0005Ai\u0002$\u0001\u0019\u001eam\u0011eA\u0003\u0002\u0011=Ar\"U\u0002\u0006\t7I\u0011\u0001\"\u0001\u000e\u0003!}\u0001la\u0003\u0006'\u0011\u0019Q\u0003B\u0003\u0002\u0011+a\t\u0001'\u0006\u0019\u001c\u0005\u001aQ!\u0001\u0005\u00101=\t6!\u0002C\u000e\u0013\u0005!\t!D\u0001\t\u0017a\u001bY\u0001"})
public final class TypeIndexUtilKt {
    @NotNull
    static final Key<CachedAliasImportData> ALIAS_IMPORT_DATA_KEY = new Key("ALIAS_IMPORT_MAP_KEY");

    @NotNull
    public static final Multimap<String, String> aliasImportMap(JetUserType $receiver) {
        PsiFile file;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiFile psiFile = (PsiFile)$receiver.getStub();
        if (psiFile == null || (psiFile = TypeIndexUtilKt.getContainingFileStub((StubElement)psiFile)) == null || (psiFile = (PsiFile)psiFile.getPsi()) == null) {
            Multimap multimap = (Multimap)HashMultimap.create();
            Intrinsics.checkExpressionValueIsNotNull((Object)multimap, (String)"HashMultimap.create()");
            return multimap;
        }
        PsiFile psiFile2 = file = psiFile;
        if (psiFile2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetFile");
        }
        return TypeIndexUtilKt.aliasImportMap((JetFile)psiFile2);
    }

    @NotNull
    public static final Multimap<String, String> aliasImportMap(JetFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CachedAliasImportData cached = (CachedAliasImportData)$receiver.getUserData(ALIAS_IMPORT_DATA_KEY);
        long modificationStamp = $receiver.getModificationStamp();
        if (cached != null && modificationStamp == cached.getFileModificationStamp()) {
            return cached.getMap();
        }
        CachedAliasImportData data2 = new CachedAliasImportData(TypeIndexUtilKt.buildAliasImportMap($receiver), modificationStamp);
        $receiver.putUserData(ALIAS_IMPORT_DATA_KEY, cached);
        return data2.getMap();
    }

    @NotNull
    public static final Multimap<String, String> buildAliasImportMap(JetFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        HashMultimap map2 = HashMultimap.create();
        JetImportList jetImportList = $receiver.getImportList();
        if (jetImportList == null) {
            Multimap multimap = (Multimap)map2;
            Intrinsics.checkExpressionValueIsNotNull((Object)multimap, (String)"map");
            return multimap;
        }
        JetImportList importList = jetImportList;
        for (JetImportDirective jetImportDirective : importList.getImports()) {
            String aliasName;
            if (jetImportDirective.getAliasName() == null) {
                continue;
            }
            Object object = jetImportDirective.getImportPath();
            if (object == null || (object = ((ImportPath)object).fqnPart()) == null || (object = ((FqName)object).shortName()) == null || (object = ((Name)object).asString()) == null) {
                continue;
            }
            Object name2 = object;
            map2.put((Object)aliasName, name2);
        }
        Multimap multimap = (Multimap)map2;
        Intrinsics.checkExpressionValueIsNotNull((Object)multimap, (String)"map");
        return multimap;
    }

    @NotNull
    public static final Key<CachedAliasImportData> getALIAS_IMPORT_DATA_KEY() {
        return ALIAS_IMPORT_DATA_KEY;
    }

    public static final boolean isProbablyNothing(JetTypeReference $receiver) {
        JetTypeReference jetTypeReference = $receiver;
        JetTypeElement jetTypeElement = jetTypeReference != null ? jetTypeReference.getTypeElement() : null;
        if (!(jetTypeElement instanceof JetUserType)) {
            jetTypeElement = null;
        }
        JetUserType jetUserType = (JetUserType)jetTypeElement;
        if (jetUserType == null) {
            return false;
        }
        JetUserType userType = jetUserType;
        return TypeIndexUtilKt.isProbablyNothing(userType);
    }

    public static final boolean isProbablyNothing(JetUserType $receiver) {
        if ($receiver == null) {
            return false;
        }
        String referencedName = $receiver.getReferencedName();
        return Intrinsics.areEqual((Object)referencedName, (Object)"Nothing") || TypeIndexUtilKt.aliasImportMap($receiver).get((Object)referencedName).contains("Nothing");
    }

    @NotNull
    public static final PsiFileStub<?> getContainingFileStub(StubElement<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return $receiver instanceof PsiFileStub ? (PsiFileStub<?>)$receiver : TypeIndexUtilKt.getContainingFileStub($receiver.getParentStub());
    }
}

