/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.VcsAnnotation;
import com.intellij.openapi.vcs.annotate.VcsCacheableAnnotationProvider;
import com.intellij.openapi.vcs.annotate.VcsLineAnnotationData;
import com.intellij.openapi.vcs.annotate.VcsUsualLineAnnotationData;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.annotate.GitFileAnnotation;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.util.StringScanner;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitAnnotationProvider
implements AnnotationProviderEx,
VcsCacheableAnnotationProvider {
    private final Project myProject;
    @NonNls
    private static final String AUTHOR_KEY = "author";
    @NonNls
    private static final String COMMITTER_TIME_KEY = "committer-time";
    private static final Logger LOG = Logger.getInstance(GitAnnotationProvider.class);

    public GitAnnotationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/annotate/GitAnnotationProvider", "<init>"));
        }
        this.myProject = project;
    }

    public FileAnnotation annotate(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        return this.annotate(file, null);
    }

    public FileAnnotation annotate(final @NotNull VirtualFile file, final VcsFileRevision revision) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        if (file.isDirectory()) {
            throw new VcsException("Cannot annotate a directory");
        }
        final FileAnnotation[] annotation = new FileAnnotation[1];
        final Exception[] exception = new Exception[1];
        Runnable command = new Runnable(){

            @Override
            public void run() {
                try {
                    FilePath currentFilePath = VcsUtil.getFilePath((String)file.getPath());
                    GitAnnotationProvider.setProgressIndicatorText(GitBundle.message("getting.history", file.getName()));
                    List<VcsFileRevision> revisions = GitHistoryUtils.history(GitAnnotationProvider.this.myProject, currentFilePath, new String[0]);
                    FilePath realFilePath = revision == null ? GitHistoryUtils.getLastCommitName(GitAnnotationProvider.this.myProject, currentFilePath) : ((GitFileRevision)revision).getPath();
                    GitAnnotationProvider.setProgressIndicatorText(GitBundle.message("computing.annotation", file.getName()));
                    VcsRevisionNumber revisionNumber = revision != null ? revision.getRevisionNumber() : null;
                    GitFileAnnotation result = GitAnnotationProvider.this.annotate(realFilePath, revisionNumber, revisions, file);
                    annotation[0] = result;
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Exception e) {
                    exception[0] = e;
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(command, GitBundle.getString("annotate.action.name"), false, this.myProject);
        } else {
            command.run();
        }
        if (exception[0] != null) {
            throw new VcsException("Failed to annotate: " + exception[0], (Throwable)exception[0]);
        }
        return annotation[0];
    }

    @NotNull
    public FileAnnotation annotate(@NotNull FilePath path, @NotNull VcsRevisionNumber revision) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        GitAnnotationProvider.setProgressIndicatorText(GitBundle.message("getting.history", path.getName()));
        List<VcsFileRevision> revisions = GitHistoryUtils.history(this.myProject, path, null, revision, new String[0]);
        GitFileRevision fileRevision = new GitFileRevision(this.myProject, path, (GitRevisionNumber)revision);
        VcsVirtualFile file = new VcsVirtualFile(path.getPath(), (VcsFileRevision)fileRevision, (VirtualFileSystem)VcsFileSystem.getInstance());
        GitAnnotationProvider.setProgressIndicatorText(GitBundle.message("computing.annotation", path.getName()));
        GitFileAnnotation gitFileAnnotation = this.annotate(path, revision, revisions, (VirtualFile)file);
        if (gitFileAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        return gitFileAnnotation;
    }

    private static void setProgressIndicatorText(@Nullable String text) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.setText(text);
        }
    }

    private GitFileAnnotation annotate(@NotNull FilePath repositoryFilePath, @Nullable VcsRevisionNumber revision, @NotNull List<VcsFileRevision> revisions, @NotNull VirtualFile file) throws VcsException {
        if (repositoryFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryFilePath", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        if (revisions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisions", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/annotate/GitAnnotationProvider", "annotate"));
        }
        GitSimpleHandler h = new GitSimpleHandler(this.myProject, GitUtil.getGitRoot(repositoryFilePath), GitCommand.BLAME);
        h.setStdoutSuppressed(true);
        h.setCharset(file.getCharset());
        h.addParameters("--porcelain", "-l", "-t", "-w");
        if (revision == null) {
            h.addParameters("HEAD");
        } else {
            h.addParameters(revision.asString());
        }
        h.endOptions();
        h.addRelativePaths(repositoryFilePath);
        String output = h.run();
        GitFileAnnotation annotation = new GitFileAnnotation(this.myProject, file, revision == null ? null : revision);
        class CommitInfo {
            Date date;
            String author;
            GitRevisionNumber revision;

            CommitInfo() {
            }
        }
        HashMap<String, CommitInfo> commits = new HashMap<String, CommitInfo>();
        StringScanner s = new StringScanner(output);
        while (s.hasMoreData()) {
            String commitHash = s.spaceToken();
            if (commitHash.equals(GitRevisionNumber.NOT_COMMITTED_HASH)) {
                commitHash = null;
            }
            s.spaceToken();
            String s1 = s.spaceToken();
            int lineNum = Integer.parseInt(s1);
            s.nextLine();
            CommitInfo commit = (CommitInfo)commits.get(commitHash);
            if (commit != null) {
                while (s.hasMoreData() && !s.startsWith('\t')) {
                    s.nextLine();
                }
            } else {
                commit = new CommitInfo();
                while (s.hasMoreData() && !s.startsWith('\t')) {
                    String key = s.spaceToken();
                    String value = s.line();
                    if (commitHash != null && AUTHOR_KEY.equals(key)) {
                        commit.author = value;
                    }
                    if (commitHash == null || !COMMITTER_TIME_KEY.equals(key)) continue;
                    commit.date = GitUtil.parseTimestampWithNFEReport(value, h, output);
                    commit.revision = new GitRevisionNumber(commitHash, commit.date);
                }
                commits.put(commitHash, commit);
            }
            if (!s.hasMoreData()) continue;
            s.skipChars(1);
            String line = s.line(true);
            annotation.appendLineInfo(commit.date, commit.revision, commit.author, line, lineNum);
        }
        annotation.addLogEntries(revisions);
        return annotation;
    }

    public VcsAnnotation createCacheable(FileAnnotation fileAnnotation) {
        GitFileAnnotation gitFileAnnotation = (GitFileAnnotation)fileAnnotation;
        int size = gitFileAnnotation.getNumLines();
        VcsUsualLineAnnotationData basicData = new VcsUsualLineAnnotationData(size);
        for (int i = 0; i < size; ++i) {
            basicData.put(i, gitFileAnnotation.getLineRevisionNumber(i));
        }
        return new VcsAnnotation(VcsUtil.getFilePath((VirtualFile)gitFileAnnotation.getFile()), (VcsLineAnnotationData)basicData, null);
    }

    @Nullable
    public FileAnnotation restore(@NotNull VcsAnnotation vcsAnnotation, @NotNull VcsAbstractHistorySession session, @NotNull String annotatedContent, boolean forCurrentRevision, VcsRevisionNumber revisionNumber) {
        if (vcsAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsAnnotation", "git4idea/annotate/GitAnnotationProvider", "restore"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "git4idea/annotate/GitAnnotationProvider", "restore"));
        }
        if (annotatedContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotatedContent", "git4idea/annotate/GitAnnotationProvider", "restore"));
        }
        VirtualFile virtualFile = vcsAnnotation.getFilePath().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        GitFileAnnotation gitFileAnnotation = new GitFileAnnotation(this.myProject, virtualFile, revisionNumber);
        gitFileAnnotation.addLogEntries(session.getRevisionList());
        VcsLineAnnotationData basicAnnotation = vcsAnnotation.getBasicAnnotation();
        int size = basicAnnotation.getNumLines();
        Map historyAsMap = session.getHistoryAsMap();
        List lines = StringUtil.split((String)StringUtil.convertLineSeparators((String)annotatedContent), (String)"\n", (boolean)false, (boolean)false);
        for (int i = 0; i < size; ++i) {
            VcsRevisionNumber revision = basicAnnotation.getRevision(i);
            VcsFileRevision vcsFileRevision = (VcsFileRevision)historyAsMap.get(revision);
            if (vcsFileRevision == null) {
                return null;
            }
            try {
                gitFileAnnotation.appendLineInfo(vcsFileRevision.getRevisionDate(), (GitRevisionNumber)revision, vcsFileRevision.getAuthor(), (String)lines.get(i), i + 1);
                continue;
            }
            catch (VcsException e) {
                return null;
            }
        }
        return gitFileAnnotation;
    }

    public boolean isAnnotationValid(VcsFileRevision rev) {
        return true;
    }
}

