/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.ui.ChangesBrowserWithRollback;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class LocalChangesWouldBeOverwrittenHelper {
    @NotNull
    private static String getErrorNotificationDescription() {
        String string = LocalChangesWouldBeOverwrittenHelper.getErrorDescription(true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "getErrorNotificationDescription"));
        }
        return string;
    }

    @NotNull
    private static String getErrorDialogDescription() {
        String string = LocalChangesWouldBeOverwrittenHelper.getErrorDescription(false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "getErrorDialogDescription"));
        }
        return string;
    }

    @NotNull
    private static String getErrorDescription(boolean forNotification) {
        String line1 = "Your local changes would be overwritten by merge.";
        String line2 = "Commit, stash or revert them to proceed.";
        if (forNotification) {
            String string = line1 + "<br/>" + line2 + " <a href='view'>View them</a>";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "getErrorDescription"));
            }
            return string;
        }
        String string = line1 + "\n" + line2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "getErrorDescription"));
        }
        return string;
    }

    public static void showErrorNotification(final @NotNull Project project, @NotNull VirtualFile root, final @NotNull String operationName, @NotNull Collection<String> relativeFilePaths) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "showErrorNotification"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "showErrorNotification"));
        }
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationName", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "showErrorNotification"));
        }
        if (relativeFilePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeFilePaths", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "showErrorNotification"));
        }
        final Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativeFilePaths);
        final List<Change> changes = GitUtil.findLocalChangesForPaths(project, root, absolutePaths, false);
        String notificationTitle = "Git " + StringUtil.capitalize((String)operationName) + " Failed";
        VcsNotifier.getInstance((Project)project).notifyError(notificationTitle, LocalChangesWouldBeOverwrittenHelper.getErrorNotificationDescription(), (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/util/LocalChangesWouldBeOverwrittenHelper$1", "hyperlinkActivated"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/util/LocalChangesWouldBeOverwrittenHelper$1", "hyperlinkActivated"));
                }
                LocalChangesWouldBeOverwrittenHelper.showErrorDialog(project, operationName, changes, (Collection<String>)absolutePaths);
            }
        });
    }

    public static void showErrorDialog(@NotNull Project project, @NotNull VirtualFile root, @NotNull String operationName, @NotNull Collection<String> relativeFilePaths) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "showErrorDialog"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "showErrorDialog"));
        }
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationName", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "showErrorDialog"));
        }
        if (relativeFilePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeFilePaths", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "showErrorDialog"));
        }
        Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativeFilePaths);
        List<Change> changes = GitUtil.findLocalChangesForPaths(project, root, absolutePaths, false);
        LocalChangesWouldBeOverwrittenHelper.showErrorDialog(project, operationName, changes, absolutePaths);
    }

    private static void showErrorDialog(@NotNull Project project, @NotNull String operationName, @NotNull List<Change> changes, @NotNull Collection<String> absolutePaths) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "showErrorDialog"));
        }
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationName", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "showErrorDialog"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "showErrorDialog"));
        }
        if (absolutePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "absolutePaths", "git4idea/util/LocalChangesWouldBeOverwrittenHelper", "showErrorDialog"));
        }
        String title = "Local Changes Prevent from " + StringUtil.capitalize((String)operationName);
        String description = LocalChangesWouldBeOverwrittenHelper.getErrorDialogDescription();
        if (changes.isEmpty()) {
            GitUtil.showPathsInDialog(project, absolutePaths, title, description);
        } else {
            DialogBuilder builder = new DialogBuilder(project);
            builder.setNorthPanel((JComponent)new MultiLineLabel(description));
            builder.setCenterPanel((JComponent)((Object)new ChangesBrowserWithRollback(project, changes)));
            builder.addOkAction();
            builder.setTitle(title);
            builder.show();
        }
    }
}

