/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.keychain;

import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.CredentialsStoreKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"c\u0004)!b)\u001b7f\u0007J,G-\u001a8uS\u0006d7o\u0015;pe\u0016T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0005lKf\u001c\u0007.Y5o\u0015A\u0019%/\u001a3f]RL\u0017\r\\:Ti>\u0014XM\u0003\u0004=S:LGO\u0010\u0006\ngR|'/\u001a$jY\u0016TAAR5mK*!!.\u0019<b\u0015\tIwNC\u0006de\u0016$WM\u001c;jC2\u001c(bC\"sK\u0012,g\u000e^5bYNT!\u0002Z1uC2{\u0017\rZ3e\u0015\u001d\u0011un\u001c7fC:Taa[8uY&t'\u0002D3ogV\u0014X\rT8bI\u0016$'\u0002B+oSRT1aZ3u\u0015\u0011Awn\u001d;\u000b\rM#(/\u001b8h\u0015)\u00198\u000f[&fs\u001aKG.\u001a\u0006\u0005Y\u0006twMC\u0003sKN,GO\u0003\u0003tCZ,gN\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\r!\u0011\u0001\u0003\u0001\r\u0001\u0015\u0019A!\u0001\u0005\u0003\u0019\u0001)\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u0015\u0001\u0012B\u0003\u0004\t\rA9\u0001\u0004\u0001\u0006\u0005\u0011\u0019\u0001rA\u0003\u0004\t\u0005AY\u0001\u0004\u0001\u0006\u0005\u0011\t\u00012B\u0003\u0002\u0011\u001d)1\u0001b\u0003\t\u000e1\u0001Qa\u0001C\u0006\u0011!a\u0001!B\u0002\u0005\f!MA\u0002A\u0003\u0003\t\u000bA)\"\u0002\u0002\u0005\u0010!MAa\u0001G\u00023\r)\u0011\u0001\u0003\u0002\u0019\u00055jA!1\u0007\u0019\u000b\u0005\"Q!\u0001E\u0005\u0019\u0003AJ!V\u0002\u0005\u000b\r!Q!C\u0001\t\u000b5bA!1\u0007\u0019\r\u0005\u001aQ!\u0001\u0005\u00071\u0019)6\u0001B\u0003\u0004\t\u0019I\u0011\u0001\"\u0001.\u0019\u0011\tG\u0001G\u0002\"\u0007\u0015\t\u0001r\u0001M\u0004+\u000e!Qa\u0001\u0003\u0004\u0013\u0005AA!,\u0006\u0005\u0003a=\u0011eA\u0003\u0002\u0011\u001bAj!U\u0002\u0004\t\u001fI\u0011\u0001\u0002\u0001.F\u0011Y\u0001\u0014CO\t\t\u0001A\u0011\"\u0004\u0003\u0006\u0003!9A\u0012\u0001\r\b!\u000e\u0001Q\u0014\u0003\u0003\u0001\u0011)iA!B\u0001\t\u000f1\u0005\u0001d\u0002)\u0004\u0002\u0005\"Q!\u0001E\u0005\u0019\u0003AJ!U\u0002\b\t#I\u0011\u0001C\u0003\u000e\u0003!AQ\"\u0001\u0005\t[U!1\u0002G\u0006\u001e\u0010\u0011\u0001\u0001\"C\u0007\u0004\u000b\u0005Aq\u0001G\u0004Q\u0007\u0001\t3!B\u0001\t\u000ea5\u0011kA\u0003\u0005\u0017%\tA\u0001A\u0007\u0002\u0011!iC\u0006B\u0006\u0019\u0018uEA\u0001\u0001\u0005\n\u001b\u0011)\u0011\u0001C\u0004\r\u0002a9\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\"B\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u0003i\n\u0002\u0002\u0001\t\u00155!Q!\u0001\u0005\b\u0019\u0003Ar\u0001U\u0002\u0002C\r)\u0011\u0001#\u0004\u0019\u000eE\u001b\u0011\u0002b\u0006\n\u0003\u0011\u0001Q\"\u0001\u0005\t\u001b\u0005AQ!D\u0001\t\u0011U6R1\u0006\u0003d\u0002a\u0015Qt\u0002\u0003\u0001\u0011\ri1!B\u0001\t\ba\u001d\u0001k\u0001\u0001\"\u0007\u0015\t\u00012\u0001M\u0002#\u000e)AQA\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0003"})
public final class FileCredentialsStore
implements CredentialsStore {
    public static final /* synthetic */ KClass $kotlinClass;
    private Credentials credentials;
    private boolean dataLoaded;
    private final File storeFile;

    static {
        $kotlinClass = Reflection.createKotlinClass(FileCredentialsStore.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureLoaded() {
        if (this.dataLoaded) {
            return;
        }
        this.dataLoaded = true;
        if (this.storeFile.exists()) {
            try {
                boolean hasErrors = true;
                DataInputStream in = new DataInputStream(ByteStreamsKt.buffered$default((InputStream)new FileInputStream(this.storeFile), (int)0, (int)1));
                try {
                    this.credentials = new Credentials(PasswordUtil.decodePassword((String)IOUtil.readString((DataInput)in)), PasswordUtil.decodePassword((String)IOUtil.readString((DataInput)in)));
                    hasErrors = false;
                }
                finally {
                    if (hasErrors) {
                        this.storeFile.delete();
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                CredentialsStoreKt.getLOG().error((Throwable)e);
            }
        }
    }

    @Override
    @Nullable
    public Credentials get(@Nullable String host, @Nullable String sshKeyFile) {
        this.ensureLoaded();
        return this.credentials;
    }

    @Override
    public void reset(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (this.credentials != null) {
            this.dataLoaded = true;
            this.storeFile.delete();
            Credentials credentials = this.credentials;
            if (credentials == null) {
                Intrinsics.throwNpe();
            }
            this.credentials = new Credentials(credentials.getId(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@Nullable String host, @NotNull Credentials credentials, @Nullable String sshKeyFile) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        if (credentials.equals(this.credentials)) {
            return;
        }
        this.credentials = credentials;
        try {
            FileUtil.createParentDirs((File)this.storeFile);
            DataOutputStream out = new DataOutputStream(ByteStreamsKt.buffered$default((OutputStream)new FileOutputStream(this.storeFile), (int)0, (int)1));
            try {
                IOUtil.writeString((String)PasswordUtil.encodePassword((String)credentials.getId()), (DataOutput)out);
                IOUtil.writeString((String)PasswordUtil.encodePassword((String)credentials.getToken()), (DataOutput)out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            CredentialsStoreKt.getLOG().error((Throwable)e);
        }
    }

    public FileCredentialsStore(@NotNull File storeFile) {
        Intrinsics.checkParameterIsNotNull((Object)storeFile, (String)"storeFile");
        this.storeFile = storeFile;
        this.dataLoaded = !this.storeFile.exists();
    }
}

