/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.ide.actions.ExportSettingsActionKt;
import com.intellij.ide.actions.ExportableItem;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"0\b)y1m\u001c9z\u0019>\u001c\u0017\r\\\"p]\u001aLwM\u0003\bti>\u0014\u0018mZ3NC:\fw-\u001a:\u000b/M#\u0018\r^3Ti>\u0014\u0018mZ3NC:\fw-\u001a:J[Bd'bA2p[*A\u0011N\u001c;fY2L'N\u0003\nd_:4\u0017nZ;sCRLwN\\*u_J,'\u0002B+oSRTaa[8uY&t'\"H\"paf\f\u0005\u000f]*fiRLgnZ:U_J+\u0007o\\:ji>\u0014\u0018p\u0013;\u000b\u001d\u001d,GOU8b[&tw\rV=qK*Q1m\\7q_:,g\u000e^:\u000b\u0015\r{G\u000e\\3di&|gN\u0003\bFqB|'\u000f^1cY\u0016LE/Z7\u000b\u0007%$WMC\u0004bGRLwN\\:\u000b\u0017I{\u0017-\\5oORK\b/\u001a\u0006\b_B,g.\u00199j\u0015\u0011Q\u0017M^1\u000b\tU$\u0018\u000e\u001c\u0006\u000eg\u00064X\rR5sK\u000e$xN]=\u000b\rA\f'/\u001a8u\u0015\u00111\u0015\u000e\\3\u000b\u0005%|'B\u00049be\u0016tGOR5mKN\u0003Xm\u0019\u0006\u0007'R\u0014\u0018N\\4\u000b\u0017I|\u0017-\\5oORK\b/\u001a\u0006\u000fgR\u0014X-Y7Qe>4\u0018\u000eZ3s\u0015EI5m]*ue\u0016\fW\u000e\u0015:pm&$WM\u001d\u0006\u000b\u0013\u000e\u001cX*\u00198bO\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0013g\u0016$H/\u001b8hgJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0003mC:<'\u0002H%dg6\u000bg.Y4fe\u0012J5m]*ue\u0016\fW\u000e\u0015:pm&$WM\u001d`\u0002\u0015\t\u00012A\u0003\u0003\t\u0001A!!\u0002\u0002\u0005\u0002!\u0015Qa\u0001\u0003\u0002\u0011\u0005a\u0001!B\u0001\t\b\u0015\u0019AA\u0001\u0005\u0004\u0019\u0001)!\u0001B\u0001\t\u0003\u0015\u0019AA\u0001E\u0006\u0019\u0001)!\u0001\"\u0001\t\u000e\u0015\u0011A\u0001\u0002\u0005\b\u000b\r!I\u0001\u0003\u0004\r\u0001\u0015\u0011A\u0011\u0001\u0005\t\u000b\t!Y\u0001C\u0003\u0006\u0007\u00111\u0001r\u0002\u0007\u0001\u000b\t!a\u0001c\u0004\u0006\u0003!EQA\u0001C\b\u0011%)!\u0001\u0002\u0005\t\f\u0015\u0011Aq\u0002\u0005\f\u000b\r!\u0011\u0002#\u0006\r\u0001\u0015\u0019AA\u0001\u0005\r\u0019\u0001)\u0011\u0001#\b\u0006\u0005\u0011U\u0001bD\u0003\u0003\t-Ay\"B\u0002\u0005\u0018!qA\u0002A\u0003\u0004\t1AY\u0002\u0004\u0001\u0006\u0005\u0011I\u0001RC\u0003\u0003\t\u001fA\u0001#\u0002\u0002\u0005\u001c!aQA\u0001C\f\u0011C)i\u0003B\u0002\u0019\u0001u=A!\u0001E\u0001\u001b\r)\u0011\u0001c\u0001\u0019\u0004A\u001b\u0001!I\u0002\u0006\u0003!\u0015\u0001TA)\u0004\u000b\u0011\u0001\u0011\"\u0001\u0003\u0001\u001b\u0005A1\u0001W\u0002\u0005\u000bo!\u0011\u0001'\u0003\u001e\u001a\u0011\u0001\u0001\"B\u0007\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001\"\u0002\r\u00061\u000f\u00016\u0001A\u0011\u0004\u000b\u0005Ai\u0001'\u0004R\u0007\u0015!I!C\u0001\t\u000f5\t\u0001\u0012\u0003-\u0004\t\u00151D!\u0001M\n;\u001f!\u0001\u0001\u0003\u0006\u000e\u0007\u0015\t\u00012\u0003M\n!\u000e\u0001Qt\u0002\u0003\u0001\u0011/i1!B\u0001\t\u0015aQ\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001\u0012D\u0007\u0004\u000b\u0005Ai\u0001'\u0004Q\u0007\u0005iz\u0001\u0002\u0001\t\u001b5\u0019Q!\u0001E\r13\u000161A\u0011\u0004\u000b\u0005A)\u0001'\u0002R\u0007-!\u0019\"C\u0001\u0005\u00015\t\u0001\"D\u0007\u0002\u00119i\u0011\u0001C\u0004\u000e\u0003!u\u0001l\u0001\u0003"})
public final class CopyAppSettingsToRepositoryKt {
    public static final void copyLocalConfig(@NotNull StateStorageManagerImpl storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        StreamProvider streamProvider = storageManager.getStreamProvider();
        if (streamProvider == null) {
            Intrinsics.throwNpe();
        }
        if (streamProvider == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.settingsRepository.IcsManager.IcsStreamProvider");
        }
        IcsManager.IcsStreamProvider streamProvider2 = (IcsManager.IcsStreamProvider)streamProvider;
        Map fileToComponents = ExportSettingsActionKt.getExportableComponentsMap$default((boolean)true, (boolean)false, (StateStorageManager)((StateStorageManager)storageManager), null, (int)8);
        for (File file : fileToComponents.keySet()) {
            String canonicalPath;
            String absolutePath;
            String string = absolutePath = FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"absolutePath");
            String fileSpec = storageManager.collapseMacros(string);
            IcsManagerKt.LOG.assertTrue(!StringsKt.contains$default((String)fileSpec, (CharSequence)SchemeManagerFactoryImplKt.getROOT_CONFIG(), (boolean)false, (int)2));
            if (fileSpec.equals(absolutePath) && !(canonicalPath = FileUtilRt.toSystemIndependentName((String)file.getCanonicalPath())).equals(absolutePath)) {
                String string2 = canonicalPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"canonicalPath");
                fileSpec = storageManager.collapseMacros(string2);
            }
            Object v = fileToComponents.get(file);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            RoamingType roamingType = CopyAppSettingsToRepositoryKt.getRoamingType((Collection)v);
            if (file.isFile()) {
                byte[] fileBytes = FileUtil.loadFileBytes((File)file);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                streamProvider2.doSave(fileSpec, fileBytes, fileBytes.length, roamingType);
                continue;
            }
            CopyAppSettingsToRepositoryKt.saveDirectory(file, fileSpec, roamingType, streamProvider2);
        }
    }

    public static /* synthetic */ void copyLocalConfig$default(StateStorageManagerImpl stateStorageManagerImpl, int n) {
        if ((n & 1) != 0) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStateStorageManager();
            if (stateStorageManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
            }
            stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        }
        CopyAppSettingsToRepositoryKt.copyLocalConfig(stateStorageManagerImpl);
    }

    public static final void saveDirectory(@NotNull File parent, @NotNull String parentFileSpec, @NotNull RoamingType roamingType, @NotNull IcsManager.IcsStreamProvider streamProvider) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)parentFileSpec, (String)"parentFileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull((Object)streamProvider, (String)"streamProvider");
        File[] files2 = parent.listFiles();
        if (files2 != null) {
            for (int i = 0; i < files2.length; ++i) {
                File file = files2[i];
                String childFileSpec = parentFileSpec + '/' + file.getName();
                if (file.isFile()) {
                    byte[] fileBytes = FileUtil.loadFileBytes((File)file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                    streamProvider.doSave(childFileSpec, fileBytes, fileBytes.length, roamingType);
                    continue;
                }
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                CopyAppSettingsToRepositoryKt.saveDirectory(file2, childFileSpec, roamingType, streamProvider);
            }
        }
    }

    @NotNull
    public static final RoamingType getRoamingType(@NotNull Collection<? extends ExportableItem> components) {
        Intrinsics.checkParameterIsNotNull(components, (String)"components");
        for (ExportableItem exportableItem : components) {
            if (!(exportableItem instanceof ExportableItem)) continue;
            return exportableItem.getRoamingType();
        }
        return RoamingType.DEFAULT;
    }
}

