/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.ui.Messages;
import com.intellij.util.io.URLUtil;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.RepositoryService;
import org.jetbrains.settingsRepository.git.GitExKt;

@KotlinSyntheticClass(version={0, 25, 0}, abiVersion=25, kind=KotlinSyntheticClass.Kind.TRAIT_IMPL)
public final class RepositoryService$$TImpl {
    public static boolean checkUrl(@NotNull RepositoryService $this, @Nullable String uriString, Container messageParent) {
        boolean isFile;
        Intrinsics.checkParameterIsNotNull((Object)uriString, (String)"uriString");
        URIish uri = new URIish(uriString);
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)URLUtil.FILE_PROTOCOL)) {
            isFile = true;
        } else {
            boolean bl = isFile = uri.getScheme() == null && uri.getHost() == null;
        }
        return messageParent == null || !isFile || $this.checkFileRepo(uriString, messageParent);
    }

    public static /* synthetic */ boolean checkUrl$default(RepositoryService repositoryService, String string, Container container, int n) {
        if ((n & 2) != 0) {
            container = null;
        }
        return repositoryService.checkUrl(string, container);
    }

    public static boolean checkFileRepo(@NotNull RepositoryService $this, @NotNull String url, Container messageParent) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)messageParent, (String)"messageParent");
        String suffix = "/" + Constants.DOT_GIT;
        File file = new File(StringsKt.endsWith$default((String)url, (String)suffix, (boolean)false, (int)2) ? StringsKt.substring((String)url, (int)0, (int)(url.length() - suffix.length())) : url);
        if (file.exists()) {
            if (!file.isDirectory()) {
                Messages.showErrorDialog((Component)messageParent, (String)"Specified path is not a directory", (String)"Specified Path is Invalid");
                return false;
            }
            if ($this.isValidRepository(file)) {
                return true;
            }
        } else if (!file.isAbsolute()) {
            Messages.showErrorDialog((Component)messageParent, (String)IcsBundleKt.icsMessage("specify.absolute.path.dialog.message", new Object[0]), (String)"");
            return false;
        }
        if (Messages.showYesNoDialog((Component)messageParent, (String)IcsBundleKt.icsMessage("init.dialog.message", new Object[0]), (String)IcsBundleKt.icsMessage("init.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            try {
                GitExKt.createBareRepository(file);
                return true;
            }
            catch (IOException e) {
                Messages.showErrorDialog((Component)messageParent, (String)IcsBundleKt.icsMessage("init.failed.message", e.getMessage()), (String)IcsBundleKt.icsMessage("init.failed.title", new Object[0]));
                return false;
            }
        }
        return false;
    }
}

