/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.io.Closeable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.merge.MergeResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.BaseRepositoryManagerKt;
import org.jetbrains.settingsRepository.MutableUpdateResult;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.JGitMergeProvider;
import org.jetbrains.settingsRepository.git.JGitMergeProviderKt;
import org.jetbrains.settingsRepository.git.MergeResultEx;
import org.jetbrains.settingsRepository.git.PullKt;
import org.jetbrains.settingsRepository.git.PullKt$WhenMappings;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"C\b)\u0001\"/Z:pYZ,7i\u001c8gY&\u001cGo\u001d\u0006\u000e[\u0016\u0014x-\u001a)s_ZLG-\u001a:\u000b#);\u0015\u000e^'fe\u001e,\u0007K]8wS\u0012,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b%M,G\u000f^5oON\u0014V\r]8tSR|'/\u001f\u0006\u0004O&$(bA!os*11n\u001c;mS:Tq\"\u001e8sKN|GN^3e\r&dWm\u001d\u0006\f\u001bV$\u0018M\u00197f\u0019&\u001cHOC\u0006WSJ$X/\u00197GS2,'bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\u0007Y47O\u0003\u0006sKB|7/\u001b;pefT!BU3q_NLGo\u001c:z\u0015\u001d)7\r\\5qg\u0016TAA[4ji*\u0019A.\u001b2\u000b\t1K7\u000f\u001e\u0006\u0007'R\u0014\u0018N\\4\u000b\t)\fg/\u0019\u0006\u0005kRLGN\u0003\u0004Qk2d7\n\u001e\u0006\f[\u0016\u0014x-\u001a*fgVdGOC\u0007NKJ<WMU3tk2$X\t\u001f\u0006\u0014\u001bV$\u0018M\u00197f+B$\u0017\r^3SKN,H\u000e\u001e\u0006\u0019e\u0016\u001cx\u000e\u001c<f+:lWM]4fI\u000e{gN\u001a7jGR\u001c(\u0002B+oSRT!\"\u001e9eCR,\u0007*Z1e\u00155\u0011XM\u001a'pO6+7o]1hK*i1\u000b\u001e:j]\u001e\u0014U/\u001b7eKJTA\u0001\\1oO*Ia.Z<IK\u0006$\u0017\n\u001a\u0006\t\u001f\nTWm\u0019;JI*Iq\u000e\u001c3IK\u0006$\u0017\n\u0012\u0006\u000fM&D\u0018I\u001c3HKR\u001cF/\u0019;f\u0015=\u0011V\r]8tSR|'/_*uCR,'>\u0001\u0006\u0003!\rQA\u0001\u0003\u0001\u0011\t)!\u0001\"\u0001\t\u0006\u0015\u0011A!\u0001\u0005\u0004\u000b\r!\u0019\u0001C\u0001\r\u0001\u0015\t\u0001\u0002B\u0003\u0004\t\u000bA9\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\"\u0002\u0007\u0001\u000b\u0005Aa!\u0002\u0002\u0005\t!5QA\u0001C\u0005\u0011\u001d)!\u0001B\u0003\t\u0010\u0015\u0019A1\u0002E\u0006\u0019\u0001)!\u0001\u0002\u0001\t\u0013\u0015\u0011AQ\u0002E\n\u000b\t!q\u0001\u0003\u0006\u0006\u0007\u0011=\u0001\u0012\u0003\u0007\u0001\u000b\r!)\u0001#\u0006\r\u0001\u0015\u0019AQ\u0001\u0005\f\u0019\u0001)\u0011\u0001c\u0006\u0006\u0005\u0011M\u0001\u0002D\u0003\u0003\t)A)\"\u0002\u0002\u0005\u0004!\tQA\u0001C\b\u0011#)1\u0001b\u0001\t\u001c1\u0001Qa\u0001\u0003\u0002\u00119a\u0001!\u0002\u0002\u0005\u0003!qQA\u0001C\u0002\u00117)1\u0001\"\u0002\t\u001f1\u0001QA\u0001C\n\u0011E)1\u0001\"\b\t\"1\u0001Qa\u0001C\b\u0011Ia\u0001!\u0002\u0002\u0005\u001e!\u0005RA\u0001C\b\u0011I)1\u0001b\u0004\t(1\u0001QA\u0001C\b\u0011O)9\bB\u0001\u0019\u0001umA\u0001\u0001E\u0001\u001b%)\u0011\u0001\u0003\u0002\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\rA2\u0001\u0007\u0002Q\u0007\u0001iJ\u0002\u0002\u0001\t\n5AQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\ra1\u0001t\u0001)\u0004\u0002u=A\u0001\u0001\u0005\t\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\u0011!\t\u0005\u0006\u0003!E\u0011\u0002B\u0005\u0004\u000b\u0005A\u0011\u0002G\u0005\u0019\u0012E\u001b\u0011\u0002\u0002\u0001\n\u0003!UQ\"\u0001\u0005\f\u001b\u0005A)\"D\u0001\t\u0018a\u001bI\"B\u0011\u0005\u0003a\u0001Qt\u0002\u0003\u0001\u00115i1!B\u0001\t\u0019aa\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0002C\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0003\t3!B\u0001\t\u001aae\u0011kA\u0004\u0005\u0001%\t\u0001\"D\u0007\u0002\u00117i\u0011\u0001c\u0006Y\u00073)i\u0003\u0002\u0001\u0019\u001eu=A\u0001\u0001\u0005\t\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\u0001!I\u0002\u0006\u0003!q\u0001DD)\u0004\u000b\u0011u\u0011\"\u0001\u0003\u0001\u001b\u0005A9\u0002WB\r\u000bY\"\u0011\u0001g\b\u001e\u0010\u0011\u0001\u0001\u0002E\u0007\u0004\u000b\u0005Aq\u0002G\bQ\u0007\u0001iz\u0001\u0002\u0001\t$5\u0019Q!\u0001E\u00101?\u00016\u0011AO\b\t\u0001A)#D\u0002\u0006\u0003!}\u0001t\u0004)\u0004\u0003u=A\u0001\u0001\u0005\t\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\u0019!I\u0002\u0006\u0003!q\u0001DD)\u0004\u0017\u0011}\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0001#D\u0001\t\"5\t\u0001\u0012E\u0007\u0002\u0011/A6\u0011D\u0003\u0013\t\u0001)2!B\u0001\t\u0011aA\u0001dE\u0011\u0004\u000b\u0005A\u0011\u0003G\tR\u0007\u0015!1#C\u0001\t$5\t\u0001r\u0003-\u0004\u001a\u0001"})
public final class PullKt {
    public static final void updateHead(@NotNull StringBuilder refLogMessage, @NotNull ObjectId newHeadId, @NotNull ObjectId oldHeadID, @NotNull Repository repository2) {
        RefUpdate.Result rc;
        Intrinsics.checkParameterIsNotNull((Object)refLogMessage, (String)"refLogMessage");
        Intrinsics.checkParameterIsNotNull((Object)newHeadId, (String)"newHeadId");
        Intrinsics.checkParameterIsNotNull((Object)oldHeadID, (String)"oldHeadID");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        RefUpdate refUpdate = repository2.updateRef(Constants.HEAD);
        refUpdate.setNewObjectId((AnyObjectId)newHeadId);
        refUpdate.setRefLogMessage(refLogMessage.toString(), false);
        refUpdate.setExpectedOldObjectId((AnyObjectId)oldHeadID);
        RefUpdate.Result result = rc = refUpdate.update();
        if (result != null) {
            switch (PullKt$WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
                case 1: 
                case 2: {
                    return;
                }
                case 3: 
                case 4: {
                    throw (Throwable)new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), rc);
                }
            }
        }
        throw (Throwable)new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, Constants.HEAD, newHeadId.toString(), rc));
    }

    @NotNull
    public static final MutableUpdateResult resolveConflicts(@NotNull MergeResultEx mergeResult, @NotNull Repository repository2) {
        Intrinsics.checkParameterIsNotNull((Object)mergeResult, (String)"mergeResult");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        PreconditionsKt.assert((((Object[])mergeResult.getMergedCommits()).length == 2 ? 1 : 0) != 0);
        Map<String, MergeResult<? extends Sequence>> map = mergeResult.getConflicts();
        if (map == null) {
            Intrinsics.throwNpe();
        }
        Map<String, MergeResult<? extends Sequence>> conflicts = map;
        JGitMergeProvider<MergeResult<? extends Sequence>> mergeProvider2 = new JGitMergeProvider<MergeResult<? extends Sequence>>(repository2, conflicts, resolveConflicts.mergeProvider.1.INSTANCE$);
        List<String> mergedFiles = PullKt.resolveConflicts(mergeProvider2, JGitMergeProviderKt.conflictsToVirtualFiles(conflicts), repository2);
        return mergeResult.getResult().toMutable().addChanged((Collection<? extends String>)mergedFiles);
    }

    @NotNull
    public static final List<String> resolveConflicts(@NotNull JGitMergeProvider<? extends Object> mergeProvider2, @NotNull List<VirtualFile> unresolvedFiles, @NotNull Repository repository2) {
        Intrinsics.checkParameterIsNotNull(mergeProvider2, (String)"mergeProvider");
        Intrinsics.checkParameterIsNotNull(unresolvedFiles, (String)"unresolvedFiles");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        SmartList mergedFiles = new SmartList();
        while (true) {
            List<VirtualFile> resolvedFiles = BaseRepositoryManagerKt.resolveConflicts(unresolvedFiles, mergeProvider2);
            for (VirtualFile file : resolvedFiles) {
                mergedFiles.add((Object)file.getPath());
            }
            if (resolvedFiles.size() == unresolvedFiles.size()) break;
            unresolvedFiles.removeAll((Collection)mergedFiles);
        }
        GitExKt.commit$default(repository2, null, null, null, null, 15);
        return (List)mergedFiles;
    }

    @NotNull
    public static final RepositoryState fixAndGetState(Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        RepositoryState state = $receiver.getRepositoryState();
        if (Intrinsics.areEqual((Object)state, (Object)RepositoryState.MERGING)) {
            PullKt.resolveUnmergedConflicts($receiver);
            state = $receiver.getRepositoryState();
        }
        RepositoryState repositoryState = state;
        Intrinsics.checkExpressionValueIsNotNull((Object)repositoryState, (String)"state");
        return repositoryState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void resolveUnmergedConflicts(@NotNull Repository repository2) {
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        LinkedHashMap conflicts = new LinkedHashMap();
        Closeable $receiver = (Closeable)repository2.newObjectReader();
        boolean closed = false;
        try {
            ObjectReader reader = (ObjectReader)$receiver;
            DirCache dirCache = repository2.readDirCache();
            int n = 0;
            int n2 = dirCache.getEntryCount() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    DirCacheEntry entry;
                    if (!(entry = dirCache.getEntry((int)i)).isMerged()) {
                        Object object;
                        void key;
                        void $receiver2;
                        Map map = (Map)conflicts;
                        String string = entry.getPathString();
                        Object value = $receiver2.get(key);
                        if (value == null && !$receiver2.containsKey(key)) {
                            byte[][] answer = new byte[3][];
                            $receiver2.put(key, answer);
                            object = answer;
                        } else {
                            object = value;
                        }
                        ((byte[][])object)[entry.getStage() - 1] = reader.open((AnyObjectId)entry.getObjectId(), Constants.OBJ_BLOB).getCachedBytes();
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            reader = Unit.INSTANCE$;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver.close();
            }
        }
        PullKt.resolveConflicts(new JGitMergeProvider(repository2, (Map)conflicts, resolveUnmergedConflicts.2.INSTANCE$), JGitMergeProviderKt.conflictsToVirtualFiles((Map)conflicts), repository2);
    }
}

