/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.java.decompiler.main.DecompilerContext;

public class TextBuffer {
    private final String myLineSeparator = DecompilerContext.getNewLineSeparator();
    private final String myIndent = (String)DecompilerContext.getProperty("ind");
    private final StringBuilder myStringBuilder;
    private Map<Integer, Integer> myLineToOffsetMapping = null;
    private Map<Integer, Set<Integer>> myLineMapping = null;

    public TextBuffer() {
        this.myStringBuilder = new StringBuilder();
    }

    public TextBuffer(int size) {
        this.myStringBuilder = new StringBuilder(size);
    }

    public TextBuffer(String text) {
        this.myStringBuilder = new StringBuilder(text);
    }

    public void setCurrentLine(int line) {
        this.setLineMapping(line, this.myStringBuilder.length() + 1);
    }

    public void setLineMapping(int line, int offset) {
        if (line >= 0) {
            this.checkMapCreated();
            this.myLineToOffsetMapping.put(line, offset);
        }
    }

    public TextBuffer append(String str) {
        this.myStringBuilder.append(str);
        return this;
    }

    public TextBuffer append(char ch) {
        this.myStringBuilder.append(ch);
        return this;
    }

    public TextBuffer append(int i) {
        this.myStringBuilder.append(i);
        return this;
    }

    public TextBuffer appendLineSeparator() {
        this.myStringBuilder.append(this.myLineSeparator);
        return this;
    }

    public TextBuffer appendIndent(int length) {
        while (length-- > 0) {
            this.append(this.myIndent);
        }
        return this;
    }

    public TextBuffer prepend(String s) {
        this.insert(0, s);
        return this;
    }

    public TextBuffer enclose(String left, String right) {
        this.prepend(left);
        this.append(right);
        return this;
    }

    public boolean containsOnlyWhitespaces() {
        for (int i = 0; i < this.myStringBuilder.length(); ++i) {
            if (this.myStringBuilder.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String original = this.myStringBuilder.toString();
        if (this.myLineToOffsetMapping == null || this.myLineToOffsetMapping.isEmpty()) {
            if (this.myLineMapping != null) {
                return this.addOriginalLineNumbers();
            }
            return original;
        }
        StringBuilder res = new StringBuilder();
        String[] srcLines = original.split(this.myLineSeparator);
        int currentLineStartOffset = 0;
        int currentLine = 0;
        int previousMarkLine = 0;
        int dumpedLines = 0;
        ArrayList<Integer> linesWithMarks = new ArrayList<Integer>(this.myLineToOffsetMapping.keySet());
        Collections.sort(linesWithMarks);
        block0: for (Integer markLine : linesWithMarks) {
            Integer markOffset = this.myLineToOffsetMapping.get(markLine);
            while (currentLine < srcLines.length) {
                String line = srcLines[currentLine];
                int lineEnd = currentLineStartOffset + line.length() + this.myLineSeparator.length();
                if (markOffset <= lineEnd) {
                    int requiredLine = markLine - 1;
                    int linesToAdd = requiredLine - dumpedLines;
                    dumpedLines = requiredLine;
                    this.appendLines(res, srcLines, previousMarkLine, currentLine, linesToAdd);
                    previousMarkLine = currentLine;
                    continue block0;
                }
                currentLineStartOffset = lineEnd;
                ++currentLine;
            }
        }
        if (previousMarkLine < srcLines.length) {
            this.appendLines(res, srcLines, previousMarkLine, srcLines.length, srcLines.length - previousMarkLine);
        }
        return res.toString();
    }

    private String addOriginalLineNumbers() {
        int lineEnd;
        StringBuilder sb = new StringBuilder();
        int lineStart = 0;
        int count = 0;
        int length = this.myLineSeparator.length();
        while ((lineEnd = this.myStringBuilder.indexOf(this.myLineSeparator, lineStart)) > 0) {
            sb.append(this.myStringBuilder.substring(lineStart, lineEnd));
            Set<Integer> integers = this.myLineMapping.get(++count);
            if (integers != null) {
                sb.append("//");
                for (Integer integer : integers) {
                    sb.append(' ').append(integer);
                }
            }
            sb.append(this.myLineSeparator);
            lineStart = lineEnd + length;
        }
        if (lineStart < this.myStringBuilder.length()) {
            sb.append(this.myStringBuilder.substring(lineStart));
        }
        return sb.toString();
    }

    private void appendLines(StringBuilder res, String[] srcLines, int from, int to, int requiredLineNumber) {
        if (to - from > requiredLineNumber) {
            List<String> strings = TextBuffer.compactLines(Arrays.asList(srcLines).subList(from, to), requiredLineNumber);
            int separatorsRequired = requiredLineNumber - 1;
            for (String s : strings) {
                res.append(s);
                if (separatorsRequired-- <= 0) continue;
                res.append(this.myLineSeparator);
            }
            res.append(this.myLineSeparator);
        } else if (to - from <= requiredLineNumber) {
            int i;
            for (i = from; i < to; ++i) {
                res.append(srcLines[i]).append(this.myLineSeparator);
            }
            for (i = 0; i < requiredLineNumber - to + from; ++i) {
                res.append(this.myLineSeparator);
            }
        }
    }

    public int length() {
        return this.myStringBuilder.length();
    }

    public String substring(int start) {
        return this.myStringBuilder.substring(start);
    }

    public TextBuffer setStart(int position) {
        this.myStringBuilder.delete(0, position);
        this.shiftMapping(0, -position);
        return this;
    }

    public void setLength(int position) {
        this.myStringBuilder.setLength(position);
        if (this.myLineToOffsetMapping != null) {
            HashMap<Integer, Integer> newMap = new HashMap<Integer, Integer>();
            for (Map.Entry<Integer, Integer> entry : this.myLineToOffsetMapping.entrySet()) {
                if (entry.getValue() > position) continue;
                newMap.put(entry.getKey(), entry.getValue());
            }
            this.myLineToOffsetMapping = newMap;
        }
    }

    public TextBuffer append(TextBuffer buffer) {
        if (buffer.myLineToOffsetMapping != null && !buffer.myLineToOffsetMapping.isEmpty()) {
            this.checkMapCreated();
            for (Map.Entry<Integer, Integer> entry : buffer.myLineToOffsetMapping.entrySet()) {
                this.myLineToOffsetMapping.put(entry.getKey(), entry.getValue() + this.myStringBuilder.length());
            }
        }
        this.myStringBuilder.append((CharSequence)buffer.myStringBuilder);
        return this;
    }

    private void shiftMapping(int startOffset, int shiftOffset) {
        if (this.myLineToOffsetMapping != null) {
            HashMap<Integer, Integer> newMap = new HashMap<Integer, Integer>();
            for (Map.Entry<Integer, Integer> entry : this.myLineToOffsetMapping.entrySet()) {
                int newValue = entry.getValue();
                if (newValue >= startOffset) {
                    newValue += shiftOffset;
                }
                if (newValue < 0) continue;
                newMap.put(entry.getKey(), newValue);
            }
            this.myLineToOffsetMapping = newMap;
        }
    }

    private void checkMapCreated() {
        if (this.myLineToOffsetMapping == null) {
            this.myLineToOffsetMapping = new HashMap<Integer, Integer>();
        }
    }

    public TextBuffer insert(int offset, String s) {
        this.myStringBuilder.insert(offset, s);
        this.shiftMapping(offset, s.length());
        return this;
    }

    public int countLines() {
        return this.countLines(0);
    }

    public int countLines(int from) {
        return this.count(this.myLineSeparator, from);
    }

    public int count(String substring, int from) {
        int count = 0;
        int length = substring.length();
        int p = from;
        while ((p = this.myStringBuilder.indexOf(substring, p)) > 0) {
            ++count;
            p += length;
        }
        return count;
    }

    private static List<String> compactLines(List<String> srcLines, int requiredLineNumber) {
        String s;
        int i;
        if (srcLines.size() < 2 || srcLines.size() <= requiredLineNumber) {
            return srcLines;
        }
        LinkedList<String> res = new LinkedList<String>(srcLines);
        for (i = res.size() - 1; i > 0; --i) {
            s = (String)res.get(i);
            if (s.trim().equals("{") || s.trim().equals("}")) {
                res.set(i - 1, ((String)res.get(i - 1)).concat(s));
                res.remove(i);
            }
            if (res.size() > requiredLineNumber) continue;
            return res;
        }
        for (i = res.size() - 1; i > 0; --i) {
            s = (String)res.get(i);
            if (s.trim().isEmpty()) {
                res.set(i - 1, ((String)res.get(i - 1)).concat(s));
                res.remove(i);
            }
            if (res.size() > requiredLineNumber) continue;
            return res;
        }
        return res;
    }

    public StringBuilder getOriginalText() {
        return this.myStringBuilder;
    }

    public void dumpOriginalLineNumbers(int[] lineMapping) {
        if (lineMapping.length > 0) {
            this.myLineMapping = new HashMap<Integer, Set<Integer>>();
            for (int i = 0; i < lineMapping.length; i += 2) {
                int key = lineMapping[i + 1];
                Set<Integer> existing = this.myLineMapping.get(key);
                if (existing == null) {
                    existing = new TreeSet<Integer>();
                    this.myLineMapping.put(key, existing);
                }
                existing.add(lineMapping[i]);
            }
        }
    }
}

