/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.meta;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.PatternFilter;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaRegistry
extends MetaDataRegistrar {
    private static final Logger LOG = Logger.getInstance(MetaRegistry.class);
    private static final List<MyBinding> ourBindings = ContainerUtil.createLockFreeCopyOnWriteList();
    private static volatile boolean ourContributorsLoaded = false;
    private static final Key<CachedValue<PsiMetaData>> META_DATA_KEY = Key.create("META DATA KEY");
    private static final UserDataCache<CachedValue<PsiMetaData>, PsiElement, Object> ourCachedMetaCache = new UserDataCache<CachedValue<PsiMetaData>, PsiElement, Object>(){

        @Override
        protected CachedValue<PsiMetaData> compute(final PsiElement element, Object p) {
            return CachedValuesManager.getManager(element.getProject()).createCachedValue(new CachedValueProvider<PsiMetaData>(){

                @Override
                public CachedValueProvider.Result<PsiMetaData> compute() {
                    MetaRegistry.ensureContributorsLoaded();
                    for (MyBinding binding : ourBindings) {
                        Object[] dependences;
                        PsiMetaData data2;
                        if (!binding.myFilter.isClassAcceptable(element.getClass()) || !binding.myFilter.isAcceptable(element, element.getParent())) continue;
                        try {
                            data2 = (PsiMetaData)binding.myDataClass.newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new RuntimeException("failed to instantiate " + binding.myDataClass, e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("failed to instantiate " + binding.myDataClass, e);
                        }
                        data2.init(element);
                        for (Object dependence : dependences = data2.getDependences()) {
                            if (dependence != null) continue;
                            LOG.error(data2 + "(" + binding.myDataClass + ") provided null dependency");
                        }
                        return new CachedValueProvider.Result<PsiMetaData>(data2, ArrayUtil.append(dependences, element));
                    }
                    return new CachedValueProvider.Result<Object>(null, element);
                }
            }, false);
        }
    };

    public static void bindDataToElement(final PsiElement element, final PsiMetaData data2) {
        CachedValue<PsiMetaData> value = CachedValuesManager.getManager(element.getProject()).createCachedValue(new CachedValueProvider<PsiMetaData>(){

            @Override
            public CachedValueProvider.Result<PsiMetaData> compute() {
                data2.init(element);
                return new CachedValueProvider.Result<PsiMetaData>(data2, data2.getDependences());
            }
        });
        element.putUserData(META_DATA_KEY, value);
    }

    public static PsiMetaData getMeta(PsiElement element) {
        PsiMetaData base = MetaRegistry.getMetaBase(element);
        return base != null ? base : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureContributorsLoaded() {
        if (!ourContributorsLoaded) {
            List<MyBinding> list = ourBindings;
            synchronized (list) {
                if (!ourContributorsLoaded) {
                    for (MetaDataContributor contributor : Extensions.getExtensions(MetaDataContributor.EP_NAME)) {
                        contributor.contributeMetaData(MetaDataRegistrar.getInstance());
                    }
                    ourContributorsLoaded = true;
                }
            }
        }
    }

    @Nullable
    public static PsiMetaData getMetaBase(PsiElement element) {
        ProgressIndicatorProvider.checkCanceled();
        return ourCachedMetaCache.get(META_DATA_KEY, element, (Object)null).getValue();
    }

    public static <T extends PsiMetaData> void addMetadataBinding(ElementFilter filter2, Class<T> aMetadataClass, Disposable parentDisposable) {
        final MyBinding binding = new MyBinding(filter2, aMetadataClass);
        MetaRegistry.addBinding(binding);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                ourBindings.remove(binding);
            }
        });
    }

    public static <T extends PsiMetaData> void addMetadataBinding(ElementFilter filter2, Class<T> aMetadataClass) {
        MetaRegistry.addBinding(new MyBinding(filter2, aMetadataClass));
    }

    private static void addBinding(MyBinding binding) {
        ourBindings.add(0, binding);
    }

    @Override
    public <T extends PsiMetaData> void registerMetaData(ElementFilter filter2, Class<T> metadataDescriptorClass) {
        MetaRegistry.addMetadataBinding(filter2, metadataDescriptorClass);
    }

    @Override
    public <T extends PsiMetaData> void registerMetaData(ElementPattern<?> pattern, Class<T> metadataDescriptorClass) {
        MetaRegistry.addMetadataBinding(new PatternFilter(pattern), metadataDescriptorClass);
    }

    private static class MyBinding {
        private final ElementFilter myFilter;
        private final Class<? extends PsiMetaData> myDataClass;

        public MyBinding(@NotNull ElementFilter filter2, @NotNull Class<? extends PsiMetaData> dataClass) {
            if (filter2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/impl/meta/MetaRegistry$MyBinding", "<init>"));
            }
            if (dataClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataClass", "com/intellij/psi/impl/meta/MetaRegistry$MyBinding", "<init>"));
            }
            this.myFilter = filter2;
            this.myDataClass = dataClass;
        }
    }
}

