/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCodeBlockImpl
extends LazyParseablePsiElement
implements PsiCodeBlock {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiCodeBlockImpl");
    private volatile Set<String> myVariablesSet = null;
    private volatile Set<String> myClassesSet = null;
    private volatile boolean myConflict = false;

    public PsiCodeBlockImpl(CharSequence text) {
        super(JavaElementType.CODE_BLOCK, text);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myVariablesSet = null;
        this.myClassesSet = null;
        this.myConflict = false;
    }

    @Override
    @NotNull
    public PsiStatement[] getStatements() {
        PsiStatement[] psiStatementArray = PsiImplUtil.getChildStatements(this);
        if (psiStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl", "getStatements"));
        }
        return psiStatementArray;
    }

    @Override
    public PsiElement getFirstBodyElement() {
        PsiJavaToken lBrace = this.getLBrace();
        if (lBrace == null) {
            return null;
        }
        PsiElement nextSibling = lBrace.getNextSibling();
        return nextSibling == this.getRBrace() ? null : nextSibling;
    }

    @Override
    public PsiElement getLastBodyElement() {
        PsiJavaToken rBrace = this.getRBrace();
        if (rBrace != null) {
            PsiElement prevSibling = rBrace.getPrevSibling();
            return prevSibling == this.getLBrace() ? null : prevSibling;
        }
        return this.getLastChild();
    }

    @Override
    public PsiJavaToken getLBrace() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(18);
    }

    @Override
    public PsiJavaToken getRBrace() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(19);
    }

    @Nullable
    private Couple<Set<String>> buildMaps() {
        Set<String> set1 = this.myClassesSet;
        Set<String> set2 = this.myVariablesSet;
        boolean wasConflict = this.myConflict;
        if (set1 == null || set2 == null) {
            final THashSet localsSet = new THashSet();
            final THashSet classesSet = new THashSet();
            final Ref<Boolean> conflict = new Ref<Boolean>(Boolean.FALSE);
            PsiScopesUtil.walkChildrenScopes(this, new BaseScopeProcessor(){

                @Override
                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    PsiClass psiClass;
                    String name;
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl$1", "execute"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl$1", "execute"));
                    }
                    if (element instanceof PsiLocalVariable) {
                        PsiLocalVariable variable = (PsiLocalVariable)element;
                        String name2 = variable.getName();
                        if (!localsSet.add(name2)) {
                            conflict.set(Boolean.TRUE);
                            localsSet.clear();
                            classesSet.clear();
                        }
                    } else if (element instanceof PsiClass && !classesSet.add(name = (psiClass = (PsiClass)element).getName())) {
                        conflict.set(Boolean.TRUE);
                        localsSet.clear();
                        classesSet.clear();
                    }
                    return (Boolean)conflict.get() == false;
                }
            }, ResolveState.initial(), this, this);
            set1 = classesSet.isEmpty() ? Collections.emptySet() : classesSet;
            this.myClassesSet = set1;
            set2 = localsSet.isEmpty() ? Collections.emptySet() : localsSet;
            this.myVariablesSet = set2;
            this.myConflict = wasConflict = conflict.get().booleanValue();
        }
        return wasConflict ? null : Couple.of(set1, set2);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor2, Boolean before) {
        block6: {
            block5: {
                if (anchor2 == null) {
                    if (before == null || before.booleanValue()) {
                        anchor2 = this.findChildByRole(19);
                        before = Boolean.TRUE;
                    } else {
                        anchor2 = this.findChildByRole(18);
                        before = Boolean.FALSE;
                    }
                }
                if (before != Boolean.TRUE) break block5;
                while (PsiCodeBlockImpl.isNonJavaStatement(anchor2)) {
                    anchor2 = anchor2.getTreePrev();
                    before = Boolean.FALSE;
                }
                break block6;
            }
            if (before != Boolean.FALSE) break block6;
            while (PsiCodeBlockImpl.isNonJavaStatement(anchor2)) {
                anchor2 = anchor2.getTreeNext();
                before = Boolean.TRUE;
            }
        }
        return super.addInternal(first, last, anchor2, before);
    }

    private static boolean isNonJavaStatement(ASTNode anchor2) {
        PsiElement psi = anchor2.getPsi();
        return psi instanceof PsiStatement && psi.getLanguage() != JavaLanguage.INSTANCE;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 18: {
                return this.findChildByType(JavaTokenType.LBRACE);
            }
            case 19: 
        }
        return TreeUtil.findChildBackward(this, JavaTokenType.RBRACE);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.LBRACE) {
            return this.getChildRole(child, 18);
        }
        if (i == JavaTokenType.RBRACE) {
            return this.getChildRole(child, 19);
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitCodeBlock(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiCodeBlock";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        if (lastParent == null) {
            return true;
        }
        Couple<Set<String>> pair = this.buildMaps();
        boolean conflict = pair == null;
        Set classesSet = conflict ? null : (Set)pair.getFirst();
        Set variablesSet = conflict ? null : (Set)pair.getSecond();
        NameHint hint = processor.getHint(NameHint.KEY);
        if (hint != null && !conflict) {
            ElementClassHint elementClassHint = processor.getHint(ElementClassHint.KEY);
            String name = hint.getName(state);
            if ((elementClassHint == null || elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && classesSet.contains(name)) {
                return PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place);
            }
            if ((elementClassHint == null || elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) && variablesSet.contains(name)) {
                return PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place);
            }
        } else {
            return PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place);
        }
        return true;
    }

    @Override
    public boolean shouldChangeModificationCount(PsiElement place) {
        PsiElement parent = this.getParent();
        return !(parent instanceof PsiMethod) && !(parent instanceof PsiClassInitializer);
    }
}

