/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import com.google.common.base.Predicates;
import com.intellij.openapi.Disposable;
import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.messages.MessageSeverityCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.modules.ModuleScriptData;
import org.jetbrains.kotlin.cli.jvm.PluginCliParser;
import org.jetbrains.kotlin.cli.jvm.compiler.CommandLineScriptUtils;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.repl.ReplFromTerminal;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionsKt;
import org.jetbrains.kotlin.compiler.plugin.PluginCliOptionProcessingException;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u007f\u0006)i1J\r&W\u001b\u000e{W\u000e]5mKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004G2L'b\u00016w[*Y1\tT%D_6\u0004\u0018\u000e\\3s\u0015\u0019\u0019w.\\7p]*12J\r&W\u001b\u000e{W\u000e]5mKJ\f%oZ;nK:$8OC\u0005be\u001e,X.\u001a8ug*1A(\u001b8jizRqb\u0019:fCR,\u0017I]4v[\u0016tGo\u001d\u0006\u0016GJ,\u0017\r^3D_J,WI\u001c<je>tW.\u001a8u\u00159\u0011xn\u001c;ESN\u0004xn]1cY\u0016T!\u0002R5ta>\u001c\u0018M\u00197f\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'\"D2p]\u001aLw-\u001e:bi&|gNC\u000bD_6\u0004\u0018\u000e\\3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u000b\r\r|gNZ5h\u0015UYu\u000e\u001e7j]\u000e{'/Z#om&\u0014xN\\7f]RT\u0001bY8na&dWM\u001d\u0006\nI>,\u00050Z2vi\u0016T\u0001b]3sm&\u001cWm\u001d\u0006\t'\u0016\u0014h/[2fg*\u0001R.Z:tC\u001e,7i\u001c7mK\u000e$xN\u001d\u0006\u0011\u001b\u0016\u001c8/Y4f\u0007>dG.Z2u_JT\u0001\"\\3tg\u0006<Wm\u001d\u0006\t\u000bbLGoQ8eK*I1i\\7qC:LwN\u001c_\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)!\u0001b\u0001\t\b\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)!\u0001B\u0002\t\n\u0015\u0019A\u0001\u0002\u0005\u0005\u0019\u0001)!\u0001\u0002\u0003\t\t\u0015\t\u0001rB\u0003\u0003\t\u0017A\u0001\"\u0002\u0002\u0005\r!EQa\u0001C\u0007\u0011\u001da\u0001!\u0002\u0002\u0005\u0003!QQa\u0001C\b\u0011'a\u0001!\u0002\u0002\u0005\u0005!YQa\u0001C\t\u0011+a\u0001!\u0002\u0002\u0005\u0012!UQA\u0001C\u0007\u0011\u001d)!\u0001b\u0004\t\u0014\u0015\u0019Aq\u0002E\r\u0019\u0001)!\u0001B\u0002\t\u001d\u0015\u0019Aq\u0003E\u000e\u0019\u0001)1\u0001B\u0002\t\u001e1\u0001QA\u0001\u0003\u0004\u0011;)!\u0001b\u0004\t\u001a\u0015\u0011Aq\u0003E\u000e\t-a)\u0001E\b\u001a\u0011\u0015\t\u0001rA\u0005\u0005\u0013\r)\u0011\u0001#\u0003\u0019\na\u001dQ\u0014A\b.\u0016\u0011Q\u00014B\u0011\u0004\u000b\u0005AI\u0001'\u0003R\u0007\r!Y!C\u0001\t\u000b5~B!\u0001\r\u0007;\u001f!\u0001\u0001#\u0004\u000e\u0007\u0015\t\u0001b\u0002\r\b!\u000e\u0001Qt\u0002\u0003\u0001\u0011%i1!B\u0001\t\u0011aA\u0001k!\u0001\"\u0007\u0015\t\u0001\"\u0003\r\n#\u000e9AAB\u0005\u0002\u0011'i\u0011\u0001\u0003\u0006\u000e\u0003!UQ\u0016\u000e\u0003\u000b1/iz\u0001\u0002\u0001\t\n5\u0019Q!\u0001E\u00051\u0013\u00016\u0001AO\b\t\u0001AA\"D\u0002\u0006\u0003!Y\u0001d\u0003)\u0004\u0002u=A\u0001\u0001\u0005\u000e\u001b\r)\u0011\u0001\u0003\u0007\u0019\u0019A\u001b\u0011!h\u0004\u0005\u0001!5QbA\u0003\u0002\u0011\u001dAr\u0001UB\u0002C\r)\u0011\u0001#\u0007\u0019\u001aE\u001b1\u0002b\u0006\n\u0003!iQ\"\u0001\u0005\u0006\u001b\u0005AY\"D\u0001\t\u001d5\t\u0001BC\u001b\r\u000b-!1\u001d\u0001\r\u0006C\r)\u0011\u0001#\u0002\u0019\u0006E\u001b1\u0001B\u0003\n\u0003\u0011\u0001\u0001"})
public class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    public static final /* synthetic */ KClass $kotlinClass;
    private static long initStartNanos;
    private static final HashMap<String, Long> elapsedGCTime;
    private static long elapsedJITTime;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(K2JVMCompiler.class);
        Companion companion = Companion = new Companion(null);
        initStartNanos = System.nanoTime();
        elapsedGCTime = MapsKt.hashMapOf(new Pair[0]);
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments2, @NotNull Services services, @NotNull MessageCollector messageCollector, @NotNull Disposable rootDisposable) {
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(services, "services");
        Intrinsics.checkParameterIsNotNull(messageCollector, "messageCollector");
        Intrinsics.checkParameterIsNotNull(rootDisposable, "rootDisposable");
        MessageSeverityCollector messageSeverityCollector = new MessageSeverityCollector(messageCollector);
        KotlinPaths paths = arguments2.kotlinHome != null ? (KotlinPaths)new KotlinPathsFromHomeDir(new File(arguments2.kotlinHome)) : PathUtil.getKotlinPathsForCompiler();
        messageSeverityCollector.report(CompilerMessageSeverity.LOGGING, "Using Kotlin home directory " + paths.getHomePath(), CompilerMessageLocation.Companion.getNO_LOCATION());
        PerformanceCounter.Companion.setTimeCounterEnabled(arguments2.reportPerf);
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageSeverityCollector);
        configuration.put(CLIConfigurationKeys.REPORT_PERF, arguments2.reportPerf);
        if (IncrementalCompilation.isEnabled()) {
            IncrementalCompilationComponents incrementalCompilationComponents = services.get(IncrementalCompilationComponents.class);
            configuration.put(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS, incrementalCompilationComponents);
        }
        CompilerJarLocator locator = services.get(CompilerJarLocator.class);
        configuration.put(JVMConfigurationKeys.COMPILER_JAR_LOCATOR, locator);
        try {
            if (!arguments2.noJdk) {
                List<File> list = PathUtil.getJdkClassesRoots();
                Intrinsics.checkExpressionValueIsNotNull(list, "PathUtil.getJdkClassesRoots()");
                JvmContentRootsKt.addJvmClasspathRoots(configuration, list);
            }
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageSeverityCollector, t);
            return ExitCode.INTERNAL_ERROR;
        }
        try {
            PluginCliParser.loadPlugins(arguments2, configuration);
        }
        catch (PluginCliOptionProcessingException e) {
            String message = e.getMessage() + "\n\n" + CliOptionsKt.cliPluginUsageString(e.getPluginId(), e.getOptions());
            messageSeverityCollector.report(CompilerMessageSeverity.ERROR, message, CompilerMessageLocation.Companion.getNO_LOCATION());
            return ExitCode.INTERNAL_ERROR;
        }
        catch (CliOptionProcessingException e) {
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            messageSeverityCollector.report(CompilerMessageSeverity.ERROR, string, CompilerMessageLocation.Companion.getNO_LOCATION());
            return ExitCode.INTERNAL_ERROR;
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageSeverityCollector, t);
            return ExitCode.INTERNAL_ERROR;
        }
        if (arguments2.script) {
            if (arguments2.freeArgs.isEmpty()) {
                messageSeverityCollector.report(CompilerMessageSeverity.ERROR, "Specify script source path to evaluate", CompilerMessageLocation.Companion.getNO_LOCATION());
                return ExitCode.COMPILATION_ERROR;
            }
            String string = arguments2.freeArgs.get(0);
            Intrinsics.checkExpressionValueIsNotNull(string, "arguments.freeArgs.get(0)");
            ContentRootsKt.addKotlinSourceRoot(configuration, string);
        } else if (arguments2.module == null) {
            Iterator<String> message = arguments2.freeArgs.iterator();
            while (message.hasNext()) {
                String arg;
                String string = arg = message.next();
                Intrinsics.checkExpressionValueIsNotNull(string, "arg");
                ContentRootsKt.addKotlinSourceRoot(configuration, string);
                File file = new File(arg);
                if (!file.isDirectory()) continue;
                JvmContentRootsKt.addJavaSourceRoot(configuration, file);
            }
        }
        KotlinPaths kotlinPaths = paths;
        Intrinsics.checkExpressionValueIsNotNull(kotlinPaths, "paths");
        JvmContentRootsKt.addJvmClasspathRoots(configuration, K2JVMCompiler.Companion.getClasspath(kotlinPaths, arguments2));
        KotlinPaths kotlinPaths2 = paths;
        Intrinsics.checkExpressionValueIsNotNull(kotlinPaths2, "paths");
        configuration.addAll(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, (Collection)K2JVMCompiler.Companion.getAnnotationsPath(kotlinPaths2, arguments2));
        String string = arguments2.moduleName;
        if (string == null) {
            string = JvmAbi.DEFAULT_MODULE_NAME;
        }
        configuration.put(JVMConfigurationKeys.MODULE_NAME, string);
        if (arguments2.module == null && arguments2.freeArgs.isEmpty() && !arguments2.version) {
            ReplFromTerminal.run(rootDisposable, configuration);
            return ExitCode.OK;
        }
        configuration.put(JVMConfigurationKeys.SCRIPT_PARAMETERS, arguments2.script ? CommandLineScriptUtils.scriptParameters() : CollectionsKt.emptyList());
        K2JVMCompiler.Companion.putAdvancedOptions(configuration, arguments2);
        messageSeverityCollector.report(CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", CompilerMessageLocation.Companion.getNO_LOCATION());
        try {
            KotlinCoreEnvironment environment2;
            File outputDir;
            File jar;
            this.configureEnvironment(configuration, (CommonCompilerArguments)arguments2);
            String destination = arguments2.destination;
            if (destination != null) {
                boolean isJar = StringsKt.endsWith$default(destination, ".jar", false, 2);
                jar = isJar ? new File(destination) : (File)null;
                outputDir = isJar ? (File)null : new File(destination);
            } else {
                jar = null;
                outputDir = null;
            }
            if (arguments2.module != null) {
                CompilerConfiguration compilerConfiguration;
                FilteringMessageCollector sanitizedCollector = new FilteringMessageCollector(messageSeverityCollector, Predicates.in((Collection)CompilerMessageSeverity.VERBOSE));
                ModuleScriptData moduleScript = CompileEnvironmentUtil.loadModuleDescriptions(arguments2.module, sanitizedCollector);
                if (outputDir != null) {
                    messageSeverityCollector.report(CompilerMessageSeverity.WARNING, "The '-d' option with a directory destination is ignored because '-module' is specified", CompilerMessageLocation.Companion.getNO_LOCATION());
                }
                File directory = new File(arguments2.module).getAbsoluteFile().getParentFile();
                CompilerConfiguration compilerConfiguration2 = compilerConfiguration = KotlinToJVMBytecodeCompiler.createCompilerConfiguration(configuration, moduleScript.getModules(), directory);
                Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration2, "compilerConfiguration");
                environment2 = this.createCoreEnvironment(rootDisposable, compilerConfiguration2);
                if (messageSeverityCollector.anyReported(CompilerMessageSeverity.ERROR)) {
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinToJVMBytecodeCompiler.compileModules(environment2, configuration, moduleScript.getModules(), directory, jar, arguments2.includeRuntime);
            } else if (arguments2.script) {
                List<String> scriptArgs = arguments2.freeArgs.subList(1, arguments2.freeArgs.size());
                environment2 = this.createCoreEnvironment(rootDisposable, configuration);
                if (messageSeverityCollector.anyReported(CompilerMessageSeverity.ERROR)) {
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinToJVMBytecodeCompiler.compileAndExecuteScript(configuration, paths, environment2, scriptArgs);
            } else {
                environment2 = this.createCoreEnvironment(rootDisposable, configuration);
                if (messageSeverityCollector.anyReported(CompilerMessageSeverity.ERROR)) {
                    return ExitCode.COMPILATION_ERROR;
                }
                if (environment2.getSourceFiles().isEmpty()) {
                    messageSeverityCollector.report(CompilerMessageSeverity.ERROR, "No source files", CompilerMessageLocation.Companion.getNO_LOCATION());
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinToJVMBytecodeCompiler.compileBunchOfSources(environment2, jar, outputDir, arguments2.includeRuntime);
            }
            if (arguments2.reportPerf) {
                Companion.reportGCTime(environment2.getConfiguration());
                Companion.reportCompilationTime(environment2.getConfiguration());
                PerformanceCounter.Companion.report((Function1<? super String, ? extends Unit>)new Function1<String, Unit>(environment2){
                    final /* synthetic */ KotlinCoreEnvironment $environment;

                    public final void invoke(@NotNull String s) {
                        Intrinsics.checkParameterIsNotNull(s, "s");
                        K2JVMCompiler.Companion.reportPerf(this.$environment.getConfiguration(), s);
                    }
                    {
                        this.$environment = kotlinCoreEnvironment;
                        super(1);
                    }
                });
            }
            return ExitCode.OK;
        }
        catch (CompilationException e) {
            messageSeverityCollector.report(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException(e), MessageUtil.psiElementToMessageLocation(e.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
    }

    private final KotlinCoreEnvironment createCoreEnvironment(Disposable rootDisposable, CompilerConfiguration configuration) {
        List<String> list = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        Intrinsics.checkExpressionValueIsNotNull(list, "EnvironmentConfigFiles.JVM_CONFIG_FILES");
        KotlinCoreEnvironment result2 = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, list);
        if (K2JVMCompiler.Companion.getInitStartNanos() != 0L) {
            long initNanos = System.nanoTime() - K2JVMCompiler.Companion.getInitStartNanos();
            Companion.reportPerf(configuration, "INIT: Compiler initialized in " + TimeUnit.NANOSECONDS.toMillis(initNanos) + " ms");
            K2JVMCompiler.Companion.setInitStartNanos(0L);
        }
        return result2;
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments result2 = new K2JVMCompilerArguments();
        if (System.getenv("KOTLIN_REPORT_PERF") != null) {
            result2.reportPerf = true;
        }
        return result2;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Companion.main(args);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0019\n)I1i\\7qC:LwN\u001c\u0006\u000e\u0017JRe+T\"p[BLG.\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1a\u00197j\u0015\rQg/\u001c\u0006\u0004\u0003:L(\"D3mCB\u001cX\rZ$D)&lWMC\u0004ICNDW*\u00199\u000b\t)\fg/\u0019\u0006\u0005kRLGN\u0003\u0004TiJLgn\u001a\u0006\u0005\u0019>twM\u0003\thKR,E.\u00199tK\u0012<5\tV5nK*qQ\r\\1qg\u0016$'*\u0013+US6,'\"E4fi\u0016c\u0017\r]:fI*KE\u000bV5nK*\t2/\u001a;FY\u0006\u00048/\u001a3K\u0013R#\u0016.\\3\u000b\u001d%t\u0017\u000e^*uCJ$h*\u00198pg*\tr-\u001a;J]&$8\u000b^1si:\u000bgn\\:\u000b#M,G/\u00138jiN#\u0018M\u001d;OC:|7O\u0003\nhKR\feN\\8uCRLwN\\:QCRD'\"\u00029bi\"\u001c(bC&pi2Lg\u000eU1uQNTQ!\u001e;jYNT\u0011\"\u0019:hk6,g\u000e^:\u000b--\u0013$JV'D_6\u0004\u0018\u000e\\3s\u0003J<W/\\3oiNTaaY8n[>t'\u0002\u0002'jgRTAAR5mK*\u0011\u0011n\u001c\u0006\rO\u0016$8\t\\1tgB\fG\u000f\u001b\u0006\u0005[\u0006LgN\u0003\u0003be\u001e\u001c(\"B!se\u0006L(\u0002B+oSRTA\u0001\\1oO*\u0011\u0002/\u001e;BIZ\fgnY3e\u001fB$\u0018n\u001c8t\u00155\u0019wN\u001c4jOV\u0014\u0018\r^5p]*)2i\\7qS2,'oQ8oM&<WO]1uS>t'BB2p]\u001aLwMC\u000bsKB|'\u000f^\"p[BLG.\u0019;j_:$\u0016.\\3\u000b\u0019I,\u0007o\u001c:u\u000f\u000e#\u0016.\\3\u000b\u0015I,\u0007o\u001c:u!\u0016\u0014hMC\u0004nKN\u001c\u0018mZ3\u000b%I,7/\u001a;J]&$8\u000b^1siRKW.\u001an\u0002\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0019AA\u0001E\u0001\u0019\u0001)1\u0001\"\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!9\u0001c\u0002\r\u0001\u0015\t\u0001\"B\u0003\u0003\t\u0013AY!B\u0002\u0005\u000b!%A\u0002A\u0003\u0004\t\u000fAa\u0001\u0004\u0001\u0006\u0007\u0011\u001d\u0001R\u0002\u0007\u0001\u000b\t!Q\u0001#\u0003\u0006\u0005\u0011\t\u0001\u0002D\u0003\u0004\t\u001fA9\u0002\u0004\u0001\u0006\u0005\u0011\r\u00012D\u0003\u0003\t#AI\"B\u0002\u0005\u0013!iA\u0002A\u0003\u0004\t\u000fAa\u0002\u0004\u0001\u0006\u0005\u0011%\u0001bD\u0003\u0004\t+Ai\u0002\u0004\u0001\u0006\u0005\u0011)\u0001BD\u0003\u0003\t\u001fA9\"\u0002\u0002\u0005\u0013!iQa\u0001C\u0004\u0011Ea\u0001!B\u0002\u0005\b!\rB\u0002A\u0003\u0003\t\u0013A!#\u0002\u0002\u0005\u001d!1QA\u0001\u0003\u0002\u0011Q)1\u0001B\b\t(1\u0001QA\u0001\u0003\u0010\u0011O!19\u0001\u0007\u00043\r)\u0011\u0001\u0003\u0003\u0019\t5ZB!\u0019\u0003\u0019\t\u0005jQ!\u0001E\u0006\u0013\u0011I1!B\u0001\t\ra1\u0011\u0002B\u0005\u0004\u000b\u0005Ai\u0001'\u0004\u0019\fU\u001b\u0011\"\u0002\u0003\u0005\t%\t\u0001b\u0002G\u0001\u001b\r!q!C\u0001\t\u000f5:B!1\u0007\u0019\u0010\u0005\u001aQ!\u0001E\u00071\u001b)6aD\u0003\u0005\t\u001fI\u0011\u0001b\u0002\r\u00025\u0019A\u0001C\u0005\u0002\t\u000f\tR\u0001\"\u0005\n\u0003\u0011\u0001Q\"\u0001C\u0004[]!\u0011\u0019\u0004\r\nC\r)\u0011\u0001#\u0004\u0019\u000eU\u001bq\"\u0002\u0003\u0005\u0013%\tAq\u0001G\u0001\u001b\r!\u0019\"C\u0001\u0005\bE)AAC\u0005\u0002\t\u0001i\u0011\u0001b\u0002.J\u0011\t\u0001TCO\b\t\u0001A1\"D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0001u=A\u0001\u0001E\r\u001b\r)\u0011\u0001c\u0005\u0019\u0014A\u001b\t!\t\u0005\u0006\u0003!Q\u0011\u0002B\u0005\u0004\u000b\u0005A1\u0002G\u0006\u0019\u0015E\u001bq\u0001\"\u0006\n\u0003!]Q\"\u0001\u0005\r\u001b\u0005AI\",\u0013\u0005\u0003a}Qt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0011aA\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012D\u0007\u0004\u000b\u0005A\u0019\u0002g\u0005Q\u0007\u0003\t\u0003\"B\u0001\t\u0015%!\u0011bA\u0003\u0002\u0011-A2\u0002\u0007\u0006R\u0007\u001d!y\"C\u0001\t\u00185\t\u0001\u0002D\u0007\u0002\u00113i3\u0004b\u0002\u0019!ueA\u0001\u0001E\u0011\u001b!)\u0011\u0001C\u0007\n\t%\u0019Q!\u0001\u0005\u00071\u0019AR\u0002U\u0002\u0001C\r)\u0011\u0001c\u0007\u0019\u001cE\u001ba\u0001\u0002\t\n\u0003\u0011\u0001QB\u0001E\u000f\u0019\u0003i{\u0004B\u0001\u0019&u=A\u0001\u0001\u0005\u0014\u001b\r)\u0011\u0001c\b\u0019 A\u001b\u0001!h\u0004\u0005\u0001!eQbA\u0003\u0002\u0011'A\u001a\u0002UB\u0001C\r)\u0011\u0001c\u0007\u0019\u001cE\u001bq\u0001\"\n\n\u0003\u0011\u0001Q\"\u0001\u0005\u0011\u001b\u0005AI\"L\u000b\u0005\u0007a%Rt\u0002\u0003\u0001\u0011Mi1!B\u0001\t a}\u0001k\u0001\u0001\"\u0007\u0015\t\u00012\u0004M\u000e#\u000e)A\u0011F\u0005\u0002\t\u0001i\u0011\u0001\u0003\t.+\u0011\u0019\u0001$FO\b\t\u0001A1#D\u0002\u0006\u0003!}\u0001t\u0004)\u0004\u0001\u0005\u001aQ!\u0001E\u000e17\t6!\u0002\u0003\u0016\u0013\u0005!\u0001!D\u0001\t!5~Ba\u0001M\u0016;\u001f!\u0001\u0001C\n\u000e\u0007\u0015\t\u0001r\u0004M\u0010!\u000e\u0001Qt\u0002\u0003\u0001\u0011Yi1!B\u0001\t\ra1\u0001k!\u0001\"\u0007\u0015\t\u00012\u0004M\u000e#\u000e9A1F\u0005\u0002\t\u0001i\u0011\u0001\u0003\t\u000e\u0003!uQV\u0003\u0003\u00041[\t3!B\u0001\t\u001cam\u0011kA\u0002\u0005.%\tA\u0001A\u001b\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final long getInitStartNanos() {
            return initStartNanos;
        }

        private final void setInitStartNanos(long l) {
            initStartNanos = l;
        }

        private final HashMap<String, Long> getElapsedGCTime() {
            return elapsedGCTime;
        }

        private final long getElapsedJITTime() {
            return elapsedJITTime;
        }

        private final void setElapsedJITTime(long l) {
            elapsedJITTime = l;
        }

        public final void resetInitStartTime() {
            if (this.getInitStartNanos() == 0L) {
                this.setInitStartNanos(System.nanoTime());
            }
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull(args, "args");
            CLICompiler.doMain(new K2JVMCompiler(), args);
        }

        public final void reportPerf(@NotNull CompilerConfiguration configuration, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(message, "message");
            if (Intrinsics.areEqual(configuration.get(CLIConfigurationKeys.REPORT_PERF), true)) {
                MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
                if (messageCollector == null) {
                    Intrinsics.throwNpe();
                }
                MessageCollector collector2 = messageCollector;
                collector2.report(CompilerMessageSeverity.INFO, "PERF: " + message, CompilerMessageLocation.Companion.getNO_LOCATION());
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void reportGCTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Iterable $receiver = ManagementFactory.getGarbageCollectorMXBeans();
            for (Object element : $receiver) {
                void key;
                void $receiver2;
                GarbageCollectorMXBean it = (GarbageCollectorMXBean)element;
                long currentTime = it.getCollectionTime();
                Map map2 = Companion.getElapsedGCTime();
                Intrinsics.checkExpressionValueIsNotNull(it.getName(), "it.getName()");
                Object value = $receiver2.get(key);
                long elapsedTime = ((Number)(value == null && !$receiver2.containsKey(key) ? Long.valueOf(0L) : value)).longValue();
                long time = currentTime - elapsedTime;
                Companion.reportPerf(configuration, "GC time for " + it.getName() + " is " + time + " ms");
                Map map3 = Companion.getElapsedGCTime();
                String string = it.getName();
                Intrinsics.checkExpressionValueIsNotNull(string, "it.getName()");
                MapsKt.set(map3, string, currentTime);
            }
        }

        public final void reportCompilationTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
            if (compilationMXBean == null) {
                return;
            }
            CompilationMXBean bean = compilationMXBean;
            long currentTime = bean.getTotalCompilationTime();
            this.reportPerf(configuration, "JIT time is " + (currentTime - this.getElapsedJITTime()) + " ms");
            this.setElapsedJITTime(currentTime);
        }

        private final void putAdvancedOptions(CompilerConfiguration configuration, K2JVMCompilerArguments arguments2) {
            configuration.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments2.noCallAssertions);
            configuration.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments2.noParamAssertions);
            configuration.put(JVMConfigurationKeys.DISABLE_INLINE, arguments2.noInline);
            configuration.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments2.noOptimize);
            configuration.put(JVMConfigurationKeys.PACKAGE_FACADES_AS_MULTIFILE_CLASSES, arguments2.packageFacadesAsMultifileClasses);
        }

        /*
         * WARNING - void declaration
         */
        private final List<File> getClasspath(KotlinPaths paths, K2JVMCompilerArguments arguments2) {
            ArrayList<File> classpath = CollectionsKt.arrayListOf(new File[0]);
            if (arguments2.classpath != null) {
                List list;
                void destination;
                void $receiver;
                void $receiver2;
                Iterable iterable = StringsKt.split$default(arguments2.classpath, new char[]{File.pathSeparatorChar}, false, 0, 6);
                ArrayList<File> arrayList = classpath;
                void var5_6 = $receiver2;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
                for (Object item : $receiver) {
                    void it;
                    String string = (String)item;
                    list = destination;
                    File file = new File((String)it);
                    list.add(file);
                }
                list = (List)destination;
                arrayList.addAll(list);
            }
            if (!arguments2.noStdlib) {
                classpath.add(paths.getRuntimePath());
            }
            return classpath;
        }

        /*
         * WARNING - void declaration
         */
        private final List<File> getAnnotationsPath(KotlinPaths paths, K2JVMCompilerArguments arguments2) {
            ArrayList<File> annotationsPath = CollectionsKt.arrayListOf(new File[0]);
            if (arguments2.annotations != null) {
                List list;
                void destination;
                void $receiver;
                void $receiver2;
                Iterable iterable = StringsKt.split$default(arguments2.annotations, new char[]{File.pathSeparatorChar}, false, 0, 6);
                ArrayList<File> arrayList = annotationsPath;
                void var5_6 = $receiver2;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
                for (Object item : $receiver) {
                    void it;
                    String string = (String)item;
                    list = destination;
                    File file = new File((String)it);
                    list.add(file);
                }
                list = (List)destination;
                arrayList.addAll(list);
            }
            if (!arguments2.noJdkAnnotations) {
                annotationsPath.add(paths.getJdkAnnotationsPath());
            }
            return annotationsPath;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

