/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.types.DescriptorSubstitutor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.SmartSet;
import org.jetbrains.kotlin.utils.UtilsPackage;

public abstract class FunctionDescriptorImpl
extends DeclarationDescriptorNonRootImpl
implements FunctionDescriptor {
    private List<TypeParameterDescriptor> typeParameters;
    private List<ValueParameterDescriptor> unsubstitutedValueParameters;
    private JetType unsubstitutedReturnType;
    private ReceiverParameterDescriptor extensionReceiverParameter;
    private ReceiverParameterDescriptor dispatchReceiverParameter;
    private Modality modality;
    private Visibility visibility;
    private boolean isOperator;
    private final Set<FunctionDescriptor> overriddenFunctions;
    private final FunctionDescriptor original;
    private final CallableMemberDescriptor.Kind kind;

    protected FunctionDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @Nullable FunctionDescriptor original, @NotNull Annotations annotations2, @NotNull Name name, @NotNull CallableMemberDescriptor.Kind kind, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, annotations2, name, source);
        this.visibility = Visibilities.UNKNOWN;
        this.overriddenFunctions = SmartSet.create();
        this.original = original == null ? this : original;
        this.kind = kind;
    }

    @NotNull
    public FunctionDescriptorImpl initialize(@Nullable JetType receiverParameterType, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @Nullable JetType unsubstitutedReturnType, @Nullable Modality modality, @NotNull Visibility visibility, boolean isOperator) {
        int i;
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "initialize"));
        }
        if (unsubstitutedValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedValueParameters", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "initialize"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "initialize"));
        }
        this.typeParameters = UtilsPackage.toReadOnlyList(typeParameters);
        this.unsubstitutedValueParameters = unsubstitutedValueParameters;
        this.unsubstitutedReturnType = unsubstitutedReturnType;
        this.modality = modality;
        this.visibility = visibility;
        this.isOperator = isOperator;
        this.extensionReceiverParameter = DescriptorFactory.createExtensionReceiverParameterForCallable(this, receiverParameterType);
        this.dispatchReceiverParameter = dispatchReceiverParameter;
        for (i = 0; i < typeParameters.size(); ++i) {
            TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
            if (typeParameterDescriptor.getIndex() == i) continue;
            throw new IllegalStateException(typeParameterDescriptor + " index is " + typeParameterDescriptor.getIndex() + " but position is " + i);
        }
        for (i = 0; i < unsubstitutedValueParameters.size(); ++i) {
            int firstValueParameterOffset = 0;
            ValueParameterDescriptor valueParameterDescriptor = unsubstitutedValueParameters.get(i);
            if (valueParameterDescriptor.getIndex() == i + firstValueParameterOffset) continue;
            throw new IllegalStateException(valueParameterDescriptor + "index is " + valueParameterDescriptor.getIndex() + " but position is " + i);
        }
        FunctionDescriptorImpl functionDescriptorImpl = this;
        if (functionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "initialize"));
        }
        return functionDescriptorImpl;
    }

    public void setVisibility(@NotNull Visibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "setVisibility"));
        }
        this.visibility = visibility;
    }

    public void setReturnType(@NotNull JetType unsubstitutedReturnType) {
        if (unsubstitutedReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedReturnType", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "setReturnType"));
        }
        if (this.unsubstitutedReturnType != null) {
            // empty if block
        }
        this.unsubstitutedReturnType = unsubstitutedReturnType;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getExtensionReceiverParameter() {
        return this.extensionReceiverParameter;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getDispatchReceiverParameter() {
        return this.dispatchReceiverParameter;
    }

    @Override
    @NotNull
    public Collection<? extends FunctionDescriptor> getOverriddenDescriptors() {
        Set<FunctionDescriptor> set = this.overriddenFunctions;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getOverriddenDescriptors"));
        }
        return set;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isOperator() {
        if (this.isOperator) {
            return true;
        }
        for (FunctionDescriptor descriptor : this.overriddenFunctions) {
            if (!descriptor.isOperator()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addOverriddenDescriptor(@NotNull CallableMemberDescriptor overriddenFunction) {
        if (overriddenFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenFunction", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "addOverriddenDescriptor"));
        }
        this.overriddenFunctions.add((FunctionDescriptor)overriddenFunction);
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        List<TypeParameterDescriptor> list = this.typeParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getTypeParameters"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<ValueParameterDescriptor> getValueParameters() {
        List<ValueParameterDescriptor> list = this.unsubstitutedValueParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getValueParameters"));
        }
        return list;
    }

    @Override
    public boolean hasStableParameterNames() {
        return true;
    }

    @Override
    public boolean hasSynthesizedParameterNames() {
        return false;
    }

    @Override
    public JetType getReturnType() {
        return this.unsubstitutedReturnType;
    }

    @Override
    @NotNull
    public FunctionDescriptor getOriginal() {
        FunctionDescriptor functionDescriptor = this.original == this ? this : this.original.getOriginal();
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getOriginal"));
        }
        return functionDescriptor;
    }

    @Override
    @NotNull
    public CallableMemberDescriptor.Kind getKind() {
        CallableMemberDescriptor.Kind kind = this.kind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getKind"));
        }
        return kind;
    }

    @Override
    public final FunctionDescriptor substitute(@NotNull TypeSubstitutor originalSubstitutor) {
        if (originalSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSubstitutor", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "substitute"));
        }
        if (originalSubstitutor.isEmpty()) {
            return this;
        }
        return this.doSubstitute(originalSubstitutor, this.getContainingDeclaration(), this.modality, this.visibility, this.isOperator, this.getOriginal(), true, this.getKind());
    }

    @Nullable
    protected FunctionDescriptor doSubstitute(@NotNull TypeSubstitutor originalSubstitutor, @NotNull DeclarationDescriptor newOwner, @NotNull Modality newModality, @NotNull Visibility newVisibility, boolean isOperator, @Nullable FunctionDescriptor original, boolean copyOverrides, @NotNull CallableMemberDescriptor.Kind kind) {
        if (originalSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSubstitutor", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (newModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModality", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (newVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVisibility", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        return this.doSubstitute(originalSubstitutor, newOwner, newModality, newVisibility, isOperator, original, copyOverrides, kind, this.getValueParameters(), this.getExtensionReceiverParameterType(), this.getReturnType());
    }

    @Nullable
    protected JetType getExtensionReceiverParameterType() {
        if (this.extensionReceiverParameter == null) {
            return null;
        }
        return this.extensionReceiverParameter.getType();
    }

    @Nullable
    protected FunctionDescriptor doSubstitute(@NotNull TypeSubstitutor originalSubstitutor, @NotNull DeclarationDescriptor newOwner, @NotNull Modality newModality, @NotNull Visibility newVisibility, boolean isOperator, @Nullable FunctionDescriptor original, boolean copyOverrides, @NotNull CallableMemberDescriptor.Kind kind, @NotNull List<ValueParameterDescriptor> newValueParameterDescriptors, @Nullable JetType newExtensionReceiverParameterType, @NotNull JetType newReturnType) {
        if (originalSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSubstitutor", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (newModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModality", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (newVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVisibility", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (newValueParameterDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValueParameterDescriptors", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (newReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newReturnType", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        FunctionDescriptorImpl substitutedDescriptor = this.createSubstitutedCopy(newOwner, original, kind);
        List<TypeParameterDescriptor> originalTypeParameters = this.getTypeParameters();
        ArrayList<TypeParameterDescriptor> substitutedTypeParameters = new ArrayList<TypeParameterDescriptor>(originalTypeParameters.size());
        TypeSubstitutor substitutor2 = DescriptorSubstitutor.substituteTypeParameters(originalTypeParameters, originalSubstitutor.getSubstitution(), substitutedDescriptor, substitutedTypeParameters);
        JetType substitutedReceiverParameterType = null;
        if (newExtensionReceiverParameterType != null && (substitutedReceiverParameterType = substitutor2.substitute(newExtensionReceiverParameterType, Variance.IN_VARIANCE)) == null) {
            return null;
        }
        ReceiverParameterDescriptor substitutedExpectedThis = null;
        if (this.dispatchReceiverParameter != null && (substitutedExpectedThis = this.dispatchReceiverParameter.substitute(substitutor2)) == null) {
            return null;
        }
        List<ValueParameterDescriptor> substitutedValueParameters = FunctionDescriptorImpl.getSubstitutedValueParameters(substitutedDescriptor, newValueParameterDescriptors, substitutor2);
        if (substitutedValueParameters == null) {
            return null;
        }
        JetType substitutedReturnType = substitutor2.substitute(newReturnType, Variance.OUT_VARIANCE);
        if (substitutedReturnType == null) {
            return null;
        }
        substitutedDescriptor.initialize(substitutedReceiverParameterType, substitutedExpectedThis, substitutedTypeParameters, substitutedValueParameters, substitutedReturnType, newModality, newVisibility, isOperator);
        if (copyOverrides) {
            for (FunctionDescriptor overriddenFunction : this.overriddenFunctions) {
                substitutedDescriptor.addOverriddenDescriptor(overriddenFunction.substitute(substitutor2));
            }
        }
        return substitutedDescriptor;
    }

    @NotNull
    protected abstract FunctionDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor var1, @Nullable FunctionDescriptor var2, @NotNull CallableMemberDescriptor.Kind var3);

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return visitor2.visitFunctionDescriptor(this, data2);
    }

    @Nullable
    public static List<ValueParameterDescriptor> getSubstitutedValueParameters(FunctionDescriptor substitutedDescriptor, @NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @NotNull TypeSubstitutor substitutor2) {
        if (unsubstitutedValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedValueParameters", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getSubstitutedValueParameters"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/descriptors/impl/FunctionDescriptorImpl", "getSubstitutedValueParameters"));
        }
        ArrayList<ValueParameterDescriptor> result2 = new ArrayList<ValueParameterDescriptor>(unsubstitutedValueParameters.size());
        for (ValueParameterDescriptor unsubstitutedValueParameter : unsubstitutedValueParameters) {
            JetType substituteVarargElementType;
            JetType substitutedType = substitutor2.substitute(unsubstitutedValueParameter.getType(), Variance.IN_VARIANCE);
            JetType varargElementType = unsubstitutedValueParameter.getVarargElementType();
            JetType jetType = substituteVarargElementType = varargElementType == null ? null : substitutor2.substitute(varargElementType, Variance.IN_VARIANCE);
            if (substitutedType == null) {
                return null;
            }
            result2.add(new ValueParameterDescriptorImpl(substitutedDescriptor, unsubstitutedValueParameter, unsubstitutedValueParameter.getIndex(), unsubstitutedValueParameter.getAnnotations(), unsubstitutedValueParameter.getName(), substitutedType, unsubstitutedValueParameter.declaresDefaultValue(), substituteVarargElementType, SourceElement.NO_SOURCE));
        }
        return result2;
    }
}

