/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"2\b)A!*\u001a;DY\u0006\u001c8OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\r\u00018/\u001b\u0006\u0011\u0015\u0016$8\t\\1tg>\u0013xJ\u00196fGRTa\u0001P5oSRt$\u0002\u00028pI\u0016Tq!Q*U\u001d>$WMC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0005Y\u0006twM\u0003\u0003tiV\u0014'bD&pi2Lgn\u00117bgN\u001cF/\u001e2\u000b\u000bM$XOY:\u000b\u0003IS1!\u00118z\u0015\u0005!%BB1dG\u0016\u0004HOC\u0004wSNLGo\u001c:\u000b\u0015)+GOV5tSR|'O\u0003\u0003eCR\f'\u0002\u00026bm\u0006Taa\u00142kK\u000e$(BG4fi\u000ec\u0017m]:Pe&sG/\u001a:gC\u000e,7*Z=x_J$'B\u0003)tS\u0016cW-\\3oi*Aq-\u001a;D_2|gNC\nhKR\u001cu.\u001c9b]&|gn\u00142kK\u000e$8O\u0003\u0003MSN$(\u0002\u0006&fi>\u0013'.Z2u\t\u0016\u001cG.\u0019:bi&|gN\u0003\u0003vi&d'\"D4fiB\u0013x\u000e]3si&,7OC\u0006KKR\u0004&o\u001c9feRL(\u0002E4fiF+\u0018\r\\5gS\u0016$g*Y7f\u0015\u0019\u0019FO]5oO*9q-\u001a;TiV\u0014'BB5t\u000b:,XNC\u0004C_>dW-\u00198\u000b\u001d%\u001cX)];jm\u0006dWM\u001c;U_*9\u0011M\\8uQ\u0016\u0014(bB5t\u0013:tWM\u001d\u0006\fSNLe\u000e^3sM\u0006\u001cWM\u0003\u0005jgN+\u0017\r\\3e!\bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0004\t\u0007A)\u0001\u0004\u0001\u0006\u0003!%QA\u0001\u0003\u0004\u0011\u0015)!\u0001b\u0002\t\f\u0015\u0019A\u0001\u0002\u0005\u0005\u0019\u0001)!\u0001\u0002\u0003\t\t\u0015\u0011A1\u0001\u0005\b\u000b\r!Y\u0001#\u0004\r\u0001\u0015\u0011A1\u0002E\u0007\u000b\u0005A\u0019!B\u0002\u0005\u000f!AA\u0002A\u0003\u0004\t\u0007A!\u0002\u0004\u0001\u0006\u0003!YQA\u0001C\t\u0011\u0017)!\u0001B\u0005\t\u0018\u0015\u0011A1\u0001\u0005\u000b\u000b\t!9\u0001\u0003\u0002\u0006\u0007\u0011U\u0001\u0012\u0004\u0007\u0001\u000b\t!)\u0002#\u0007\u0006\u0007\u00119\u0001B\u0004\u0007\u0001\u000b\r!\u0019\u0001#\b\r\u0001\u0015\u0011A\u0011\u0003\u0005\u0010\u000b\t!Q\u0002\u0003\b\u0006\u0007\u0011\r\u0001\u0002\u0005\u0007\u0001\u000b\r!q\u0001C\t\r\u0001\u0015\u0011A!\u0003\u0005\u0012\u000b\r!q\u0001#\n\r\u0001\u0011YABA\r\u0004\u000b\u0005A)\u0001'\u0002.|\u0011Y\u0011c\u0002\u0003\u0001\u0011\u001f)B!B\u0001\t\u00101\u0005\u0001tB\t\b\t\u0003A\t\"\u0006\u0003\u0006\u0003!=A\u0012\u0001M\b1%i:\u0003\u0002\u0001\t\u00145yQ!\u0001\u0005\t\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004A\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0002q\u0005\u0001\u0004\u0003)\u0004\u0001uEA\u0001\u0001E\u000b\u001b\u0011)!\u0001\"\u0001\t\u0002q\u0005\u0001k!\u0001\"\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001\t6a\u0002\u0003\n\u0013\u0005A\u0019\"D\u0001\t\u00155\t\u00012CW\f\t\rAB\"\t\u0003\u0006\u0003!YA\u0012\u0001\r\f#\u000e\u0019A\u0001D\u0005\u0002\u0011/i;\u0002B\u0002\u0019\u001b\u0005\"Q!\u0001\u0005\f\u0019\u0003A2\"U\u0002\u0004\t5I\u0011\u0001c\u0006. \u0011\u0019\u00014D\u0011\t\u000b\u0005AA\"\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0004M\r11\t6a\u0001C\u000e\u0013\u0005AY\"l\b\u0005\u0007a}\u0011\u0005C\u0003\u0002\u00111IA!C\u0002\u0006\u0003!q\u0001D\u0004\r\r#\u000e\u0019AqD\u0005\u0002\u00117i;\u0002\u0002\u0002\u0019\"\u0005\"Q!\u0001E\u000f\u0019\u0003Aj\"U\u0002\u0004\tCI\u0011\u0001C\b.\u0018\u0011Y\u00014E\u0011\u0005\u000b\u0005Aa\u0001$\u0001\u0019\rE\u001b1\u0001b\t\n\u0003!5QV\u0003\u0003\u00041I\t3!B\u0001\t a}\u0011kA\u0002\u0005%%\tA\u0011A\u0017\u0017\t-A2#(\u0005\u0005\u0001!\u001dR\u0002B\u0003\u0002\u0011-a\t\u0001G\u0006Q\u0007\u0001\t3!B\u0001\t a}\u0011kA\u0003\u0005'%\tA\u0011A\u0007\u0002\u0011/i+\u0002B\u0002\u0019)\u0005\u001aQ!\u0001E\u00101?\t6a\u0001\u0003\u0015\u0013\u0005!\t!,\u0006\u0005\u0007a%\u0012eA\u0003\u0002\u0011?Az\"U\u0002\u0004\tSI\u0011\u0001\"\u0001.\u0016\u0011\u0019\u0001$F\u0011\u0004\u000b\u0005Ay\u0002g\bR\u0007\r!Q#C\u0001\u0005\u0002e.Ba9\u0001\u0019\u0007u=A\u0001\u0001E\u0004\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\u0001!I\u0002\u0006\u0003!\u0011\u0001DA)\u0004\u000b\u0011\u0019\u0011\"\u0001\u0003\u0001\u001b\u0005AQ!o\u000b\u0005G\u0004A2!h\u0004\u0005\u0001!1QbA\u0003\u0002\u0011\u0019Ab\u0001U\u0002\u0001C\r)\u0011\u0001\u0003\u0002\u0019\u0005E\u001bQ\u0001B\u0002\n\u0003\u0011\u0001Q\"\u0001E\u0007"})
public class JetClass
extends JetClassOrObject {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(JetClass.class);
    }

    @Override
    @Nullable
    public KotlinClassStub getStub() {
        Object t = super.getStub();
        if (!(t instanceof KotlinClassStub)) {
            t = null;
        }
        return (KotlinClassStub)t;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitClass(this, data2);
    }

    @Nullable
    public final PsiElement getColon() {
        return this.findChildByType(JetTokens.COLON);
    }

    @NotNull
    public final List<JetProperty> getProperties() {
        JetClassBody jetClassBody = this.getBody();
        return CollectionsKt.orEmpty(jetClassBody != null ? jetClassBody.getProperties() : null);
    }

    public final boolean isInterface() {
        KotlinClassStub kotlinClassStub = this.getStub();
        return kotlinClassStub != null ? kotlinClassStub.isInterface() : this.findChildByType(JetTokens.INTERFACE_KEYWORD) != null;
    }

    public final boolean isEnum() {
        return this.hasModifier(JetTokens.ENUM_KEYWORD);
    }

    public final boolean isSealed() {
        return this.hasModifier(JetTokens.SEALED_KEYWORD);
    }

    public final boolean isInner() {
        return this.hasModifier(JetTokens.INNER_KEYWORD);
    }

    @Override
    public boolean isEquivalentTo(@Nullable PsiElement another) {
        if (super.isEquivalentTo(another)) {
            return true;
        }
        if (another instanceof JetClass) {
            String fq1 = this.getQualifiedName();
            String fq2 = ((JetClass)another).getQualifiedName();
            return fq1 != null && fq2 != null && Intrinsics.areEqual(fq1, fq2);
        }
        return false;
    }

    @Nullable
    protected final String getQualifiedName() {
        KotlinClassStub stub = this.getStub();
        if (stub != null) {
            FqName fqName2;
            FqName fqName3 = fqName2 = stub.getFqName();
            return fqName3 != null ? fqName3.asString() : null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        JetClassOrObject current = this;
        while (current != null) {
            String string = current.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            parts.add(string);
            current = PsiTreeUtil.getParentOfType((PsiElement)current, JetClassOrObject.class);
        }
        PsiFile file = this.getContainingFile();
        if (!(file instanceof JetFile)) {
            return null;
        }
        String fileQualifiedName = ((JetFile)file).getPackageFqName().asString();
        if (!StringsKt.isEmpty(fileQualifiedName)) {
            parts.add(fileQualifiedName);
        }
        Collections.reverse((List)parts);
        return StringUtil.join((Collection<String>)parts, ".");
    }

    @NotNull
    public final List<JetObjectDeclaration> getCompanionObjects() {
        JetClassBody jetClassBody = this.getBody();
        return CollectionsKt.orEmpty(jetClassBody != null ? jetClassBody.getAllCompanionObjects() : null);
    }

    @Nullable
    public final PsiElement getClassOrInterfaceKeyword() {
        return this.findChildByType(TokenSet.create(JetTokens.CLASS_KEYWORD, JetTokens.INTERFACE_KEYWORD));
    }

    public JetClass(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }

    public JetClass(@NotNull KotlinClassStub stub) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        IStubElementType iStubElementType = JetStubElementTypes.CLASS;
        Intrinsics.checkExpressionValueIsNotNull(iStubElementType, "JetStubElementTypes.CLASS");
        super(kotlinClassOrObjectStub, iStubElementType);
    }
}

