/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetTypedef;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodyResolver;
import org.jetbrains.kotlin.resolve.DeclarationResolver;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.OverloadResolver;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.LazyFileScope;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.varianceChecker.VarianceChecker;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"Q\u0012)\u0019B*\u0019>z)>\u0004Hi\\<o\u0003:\fG.\u001f>fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u0007\u0005s\u0017P\u0003\u0004=S:LGO\u0010\u0006\u0006iJ\f7-\u001a\u0006\r\u0005&tG-\u001b8h)J\f7-\u001a\u0006\u0014I\u0016\u001cG.\u0019:bi&|gNU3t_24XM\u001d\u0006\u0014\t\u0016\u001cG.\u0019:bi&|gNU3t_24XM\u001d\u0006\u0011_Z,'O]5eKJ+7o\u001c7wKJT\u0001c\u0014<feJLG-\u001a*fg>dg/\u001a:\u000b!=4XM\u001d7pC\u0012\u0014Vm]8mm\u0016\u0014(\u0002E(wKJdw.\u00193SKN|GN^3s\u0015=1\u0018M]5b]\u000e,7\t[3dW\u0016\u0014(b\u0004,be&\fgnY3DQ\u0016\u001c7.\u001a:\u000b!5|G-\u001e7f\t\u0016\u001c8M]5qi>\u0014(\u0002E'pIVdW\rR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b/1\f'0\u001f#fG2\f'/\u0019;j_:\u0014Vm]8mm\u0016\u0014(b\u0006'buf$Um\u00197be\u0006$\u0018n\u001c8SKN|GN^3s\u0015\u0011a\u0017M_=\u000b\u0019\t|G-\u001f*fg>dg/\u001a:\u000b\u0019\t{G-\u001f*fg>dg/\u001a:\u000b5Q|\u0007\u000fT3wK2$Um]2sSB$xN\u001d)s_ZLG-\u001a:\u000b5Q{\u0007\u000fT3wK2$Um]2sSB$xN\u001d)s_ZLG-\u001a:\u000b#\u0019LG.Z*d_B,\u0007K]8wS\u0012,'OC\tGS2,7kY8qKB\u0013xN^5eKJT\u0001\u0004Z3dY\u0006\u0014\u0018\r^5p]N\u001bw\u000e]3Qe>4\u0018\u000eZ3s\u0015a!Um\u00197be\u0006$\u0018n\u001c8TG>\u0004X\r\u0015:pm&$WM\u001d\u0006\u001ccV\fG.\u001b4jK\u0012,\u0005\u0010\u001d:fgNLwN\u001c*fg>dg/\u001a:\u000b7E+\u0018\r\\5gS\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8SKN|GN^3s\u0015M\tg.\u00197zu\u0016$Um\u00197be\u0006$\u0018n\u001c8t\u0015M!x\u000e\u001d#po:\fe.\u00197zg&\u001cXj\u001c3f\u0015M!v\u000e\u001d#po:\fe.\u00197zg&\u001cXj\u001c3f\u00151!Wm\u00197be\u0006$\u0018n\u001c8t\u0015)\u0019u\u000e\u001c7fGRLwN\u001c\u0006\u000b!NLW\t\\3nK:$(bA2p[*A\u0011N\u001c;fY2L'NC\u0002qg&T\u0011c\\;uKJ$\u0015\r^1GY><\u0018J\u001c4p\u00151!\u0015\r^1GY><\u0018J\u001c4p\u0015\u0015\u0019\u0017\r\u001c7t\u0015)\u0019X.\u0019:uG\u0006\u001cHo\u001d\u0006\u0017)>\u0004Hi\\<o\u0003:\fG._:jg\u000e{g\u000e^3yi*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b3\r\u0014X-\u0019;f\rVt7\r^5p]\u0012+7o\u0019:jaR|'o\u001d\u0006\u0002G*Ia-\u001e8di&|gn\u001d\u0006\u0005\u0019&\u001cHO\u0003\tKKRt\u0015-\\3e\rVt7\r^5p]*!QK\\5u\u0015e\u0019'/Z1uKB\u0013x\u000e]3sif$Um]2sSB$xN]:\u000b\u001fQ|\u0007\u000fT3wK24\u0015OT1nKNT\u0001\"T;mi&l\u0017\r\u001d\u0006\u0007O>|w\r\\3\u000b\r\r|W.\\8o\u0015\u001d\u0019w\u000e\u001c7fGRTaAR9OC6,'\u0002\u00028b[\u0016T!BS3u\u000b2,W.\u001a8u\u0015)\u0001(o\u001c9feRLWm\u001d\u0006\f\u0015\u0016$\bK]8qKJ$\u0018P\u0003\fsK\u001eL7\u000f^3s)>\u0004H*\u001a<fY\u001a\u000bh*Y7f\u0015-!Wm\u00197be\u0006$\u0018n\u001c8\u000b')+GOT1nK\u0012$Um\u00197be\u0006$\u0018n\u001c8\u000b\u0015\u0011,7o\u0019:jaR|'OC\u000bEK\u000ed\u0017M]1uS>tG)Z:de&\u0004Ho\u001c:\u000b5I,7o\u001c7wK\u0006cG\u000eS3bI\u0016\u00148/\u00138DY\u0006\u001c8/Z:I\b)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011Qa\u0001C\u0002\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019AQ\u0001E\u0003\u0019\u0001)1\u0001b\u0001\t\t1\u0001Qa\u0001C\u0002\u0011\u0015a\u0001!B\u0002\u0005\u0004!1A\u0002A\u0003\u0004\t\u0007Aq\u0001\u0004\u0001\u0006\u0005\u0011\r\u0001rB\u0003\u0004\t\u0017A\u0001\u0002\u0004\u0001\u0006\u0005\u0011\t\u00012C\u0003\u0004\t\u001bA\u0011\u0002\u0004\u0001\u0006\u0005\u0011\r\u0001bC\u0003\u0004\t\u001fA)\u0002\u0004\u0001\u0006\u0007\u0011\r\u0001\u0002\u0004\u0007\u0001\u000b\r!y\u0001C\u0007\r\u0001\u0015\u0019Aq\u0002\u0005\u000f\u0019\u0001)1\u0001b\u0004\t\u001f1\u0001Qa\u0001C\u0002\u0011Aa\u0001!\u0002\u0002\u0005\u0004!!QA\u0001C\u0002\u0011\u0015)!\u0001b\u0001\t\r\u0015\u0011A1\u0001\u0005\b\u000b\t!Y\u0001\u0003\u0005\u0006\u0005\u00115\u0001\"C\u0003\u0003\t\u001fA)\"\u0002\u0002\u0005\u0004!aQA\u0001C\b\u00115)!\u0001b\u0004\t\u001d\u0015\u0011Aq\u0002\u0005\u0010\u000b\t!\u0019\u0001\u0003\t\u0006\u0007\u0011\r\u00012\u0005\u0007\u0001\u000b\r!)\u0001#\n\r\u0001\u0015\t\u0001rE\u0003\u0003\tIAA#\u0002\u0002\u0005&!%Ra\u0001\u0003\u0014\u0011Ma\u0001!\u0002\u0002\u0005\u0004!1RA\u0001\u0003\u0015\u0011[)1\u0001\"\u000b\t,1\u0001Qa\u0001C\u0002\u0011]a\u0001!\u0002\u0002\u0005\u0004!9RA\u0001C\u0002\u0011G)\u0011\u0001c\f\u0006\u0005\u00119\u0002\u0002G\u0003\u0003\t_A)#\u0002\u0002\u0005*!-Ra\u0001C\u0003\u0011ia\u0001!\u0002\u0002\u0005\u0003!%Ra\u0001C\u001a\u0011ka\u0001!B\u0002\u0005\u0006!YB\u0002A\u0003\u0003\t_A!$\u0002\u0002\u0005%!iRA\u0001C\u001c\u0011w)!\u0001\u0002\u000f\t=\u0015\u0019A\u0011\bE\u001d\u0019\u0001)!\u0001B\u0001\t?\u0015\u0019A1\bE\u001f\u0019\u0001)1\u0001b\r\t@1\u0001Qa\u0001C\u001a\u0011\u0003b\u0001!\u0002\u0002\u0005:!eRa\u0001C\u001a\u0011\tb\u0001!B\u0002\u0005\u000e!\u0019C\u0002A\u0003\u0003\tgA!%\u0002\u0002\u0005\u000e!\u0019Ca\u0001\u0007\u00033\r)\u0011\u0001C\u0002\u0019\u00075bA!\u0019\u0003\u0019\u0018\u0005\u001aQ!\u0001E\t1#)6\u0001B\u0003\u0004\t/I\u0011\u0001#\b.\u0019\u0011\tG\u0001'\u0003\"\u0007\u0015\t\u0001\u0002\u0002\r\u0005+\u000e!Qa\u0001C\u0005\u0013\u0005A9\"\f\u0007\u0005C\u0012Aj\"I\u0002\u0006\u0003!Q\u0001DC+\u0004\t\u0015\u0019AQD\u0005\u0002\u0011AiC\u0002B1\u000517\t3!B\u0001\t\u0014aMQk\u0001\u0003\u0006\u0007\u0011m\u0011\"\u0001E\u0010[1!\u0011\r\u0002\r\u000bC\r)\u0011\u0001\u0003\u0005\u0019\u0011U\u001bA!B\u0002\u0005\u0015%\t\u0001BD\u0017\r\t\u0005$\u0001\u0014C\u0011\u0004\u000b\u0005Aq\u0001G\u0004V\u0007\u0011)1\u0001\"\u0005\n\u0003!mQ\u0006\u0004\u0003b\ta5\u0011eA\u0003\u0002\u0011\u0015AR!V\u0002\u0005\u000b\r!i!C\u0001\t\u001a5bA!\u0019\u0003\u0019\f\u0005\u001aQ!\u0001E\u00051\u0013)6\u0001B\u0003\u0004\t\u0017I\u0011\u0001\u0003\u0007.\u0019\u0011\tG\u0001g\b\"\u0007\u0015\t\u0001R\u0003M\u000b+\u000e!Qa\u0001C\u0010\u0013\u0005A\t#\f\u0007\u0005C\u0012AJ\"I\u0002\u0006\u0003!I\u0001$C+\u0004\t\u0015\u0019A\u0011D\u0005\u0002\u0011=iC\u0002B1\u00051\u000f\t3!B\u0001\t\ba\u001dQk\u0001\u0003\u0006\u0007\u0011\u001d\u0011\"\u0001\u0005\f[1!\u0011\r\u0002M\bC\r)\u0011\u0001\u0003\u0004\u0019\rU\u001bA!B\u0002\u0005\u0010%\t\u0001\"D\u00170\t\rA\n#h\u0004\u0005\u0001!\tRbA\u0003\u0002\u0011EA\u0012\u0003U\u0002\u0001;3!\u0001\u0001\u0003\n\u000e\u0011\u0015\t\u00012E\u0005\u0005\u0013\r)\u0011\u0001c\n\u0019(a\r\u0002k!\u0001\u001e\u0010\u0011\u0001\u0001\"F\u0007\u0004\u000b\u0005AQ\u0003G\u000bQ\u0007\u0005\t3!B\u0001\t,a-\u0012kA\u0005\u0005\"%\t\u0001BF\u0007\u0002\u0011[i\u0011\u0001\u0003\r\u000e\u0003!ER\u0016\n\u0003\u00021ciz\u0001\u0002\u0001\t35\u0019Q!\u0001E\u00161W\u00016\u0001AO\r\t\u0001A\u0019$\u0004\u0005\u0006\u0003!I\u0012\u0002B\u0005\u0004\u000b\u0005A!\u0004\u0007\u000e\u00193A\u001b\t!I\u0002\u0006\u0003!U\u0002TG)\u0004\u000f\u0011E\u0012\"\u0001\u0003\u0001\u001b\u0005Aa#D\u0001\t75JD!\u0001M\u001c;\u001f!\u0001\u0001C\r\u000e\u0007\u0015\t\u00012\u0006M\u0016!\u000e\u0001Q4\u0005\u0003\u0001\u0011qiQ\"B\u0001\t;%!\u0011bA\u0003\u0002\u0011yAb$\u0003\u0003\n\u0007\u0015\t\u0001R\bM\u001f1u\u00016\u0011AO\r\t\u0001A\u0001%\u0004\u0005\u0006\u0003!I\u0012\u0002B\u0005\u0004\u000b\u0005Aq\u0004G\u0010\u00193A\u001b\u0011!I\u0002\u0006\u0003!U\u0002TG)\u0004\u0013\u0011]\u0012\"\u0001\u0003\u0001\u001b\u0005Aa#D\u0001\t@5\t\u0001bG\u00175\t\u0005A\u0012%h\t\u0005\u0001!aR\"D\u0003\u0002\u0011uIA!C\u0002\u0006\u0003!q\u0002DH\u0005\u0005\u0013\r)\u0011\u0001#\u0010\u0019>ai\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u00012I\u0007\u0004\u000b\u0005A\u0001\u0005\u0007\u0011Q\u0007\u0003iz\u0001\u0002\u0001\tF5\u0019Q!\u0001E!1\u0003\u00026!A\u0011\u0004\u000b\u0005A)\u0004'\u000eR\u0007%!\u0011%C\u0001\u0005\u00015\t\u0001rH\u0007\u0002\u0011\u0005j\u0011\u0001c\u0011.+\u0011\t\u0001tIO\b\t\u0001A\u0011$D\u0002\u0006\u0003!-\u00024\u0006)\u0004\u0001\u0005\u001aQ!\u0001E\u001b1k\t6!\u0002C$\u0013\u0005!\u0001!D\u0001\t-UV\u0015!B%\u0002\t\r\b\u0001dAO\b\t\u0001A9!D\u0002\u0006\u0003!\u001d\u0001t\u0001)\u0004\u0001u=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\t!h\u0004\u0005\u0001!-QbA\u0003\u0002\u0011\u0013AJ\u0001U\u0002\u0002;\u001f!\u0001\u0001#\u0004\u000e\u0007\u0015\t\u0001\"\u0002\r\u0006!\u000e\rQt\u0002\u0003\u0001\u0011\u001fi1!B\u0001\t\ra1\u0001k\u0001\u0002\u001e\u0010\u0011\u0001\u0001\u0012C\u0007\u0004\u000b\u0005Aq\u0001G\u0004Q\u0007\u000biz\u0001\u0002\u0001\t\u00155\u0019Q!\u0001\u0005\t1!\u00016aAO\b\t\u0001A9\"D\u0002\u0006\u0003!E\u0001\u0014\u0003)\u0004\bu=A\u0001\u0001E\r\u001b\r)\u0011\u0001C\u0005\u0019\u0013A\u001bA!h\u0004\u0005\u0001!mQbA\u0003\u0002\u0011'A\u001a\u0002UB\u0005;\u001f!\u0001\u0001#\b\u000e\u0007\u0015\t\u0001B\u0003\r\u000b!\u000e)Qt\u0002\u0003\u0001\u0011?i1!B\u0001\t\u0016aU\u0001ka\u0003\"\u0007\u0015\t\u0001B\u0001\r\u0003#\u000eYBaA\u0005\u0002\t\u0001i\u0011\u0001C\u0006\u000e\u0003!]Q\"\u0001\u0005\r\u001b\u0005AI\"D\u0001\t\u001b5\t\u00012D\u0007\u0002\u00119i\u0011\u0001#\b\u000e\u0003!yQ\"\u0001E\u0010\u001b\u0005A\u0001#D\u0001\t\"\u0001"})
public final class LazyTopDownAnalyzer {
    public static final /* synthetic */ KClass $kotlinClass;
    private final BindingTrace trace;
    private final DeclarationResolver declarationResolver;
    private final OverrideResolver overrideResolver;
    private final OverloadResolver overloadResolver;
    private final VarianceChecker varianceChecker;
    private final ModuleDescriptor moduleDescriptor;
    private final LazyDeclarationResolver lazyDeclarationResolver;
    private final BodyResolver bodyResolver;
    private final TopLevelDescriptorProvider topLevelDescriptorProvider;
    private final FileScopeProvider fileScopeProvider;
    private final DeclarationScopeProvider declarationScopeProvider;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;

    static {
        $kotlinClass = Reflection.createKotlinClass(LazyTopDownAnalyzer.class);
    }

    @NotNull
    public final TopDownAnalysisContext analyzeDeclarations(@NotNull TopDownAnalysisMode topDownAnalysisMode, @NotNull Collection<? extends PsiElement> declarations, @NotNull DataFlowInfo outerDataFlowInfo) {
        Intrinsics.checkParameterIsNotNull((Object)topDownAnalysisMode, "topDownAnalysisMode");
        Intrinsics.checkParameterIsNotNull(declarations, "declarations");
        Intrinsics.checkParameterIsNotNull(outerDataFlowInfo, "outerDataFlowInfo");
        TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisMode, outerDataFlowInfo, this.declarationScopeProvider);
        HashMultimap topLevelFqNames = HashMultimap.create();
        ArrayList properties2 = new ArrayList();
        ArrayList functions2 = new ArrayList();
        for (PsiElement psiElement : declarations) {
            psiElement.accept(new JetVisitorVoid(this, c, topLevelFqNames, functions2, properties2){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ LazyTopDownAnalyzer this$0;
                final /* synthetic */ TopDownAnalysisContext $c;
                final /* synthetic */ HashMultimap $topLevelFqNames;
                final /* synthetic */ ArrayList $functions;
                final /* synthetic */ ArrayList $properties;

                static {
                    $kotlinClass = Reflection.createKotlinClass(analyzeDeclarations.1.class);
                }

                private final void registerDeclarations(List<? extends JetDeclaration> declarations) {
                    for (JetDeclaration jetDeclaration : declarations) {
                        jetDeclaration.accept(this);
                    }
                }

                public void visitDeclaration(@NotNull JetDeclaration dcl) {
                    Intrinsics.checkParameterIsNotNull(dcl, "dcl");
                    throw (Throwable)new IllegalArgumentException("Unsupported declaration: " + dcl + " " + dcl.getText());
                }

                public void visitJetFile(@NotNull JetFile file) {
                    Intrinsics.checkParameterIsNotNull(file, "file");
                    if (file.isScript()) {
                        JetScript jetScript = file.getScript();
                        if (jetScript == null) {
                            throw (Throwable)((Object)new AssertionError((Object)("getScript() is null for file: " + file)));
                        }
                        JetScript script = jetScript;
                        DescriptorResolver.registerFileInPackage(LazyTopDownAnalyzer.access$getTrace$0(this.this$0), file);
                        Map<JetScript, ScriptDescriptor> map2 = this.$c.getScripts();
                        TopLevelDescriptorProvider topLevelDescriptorProvider = LazyTopDownAnalyzer.access$getTopLevelDescriptorProvider$1(this.this$0);
                        JetScript jetScript2 = script;
                        Intrinsics.checkExpressionValueIsNotNull(jetScript2, "script");
                        map2.put(script, topLevelDescriptorProvider.getScriptDescriptor(jetScript2));
                    } else {
                        JetPackageDirective packageDirective = file.getPackageDirective();
                        boolean value = packageDirective != null;
                        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
                            String message = "No package in a non-script file: " + file;
                            throw (Throwable)((Object)new AssertionError((Object)message));
                        }
                        this.$c.addFile(file);
                        JetPackageDirective jetPackageDirective = packageDirective;
                        if (jetPackageDirective == null) {
                            Intrinsics.throwNpe();
                        }
                        jetPackageDirective.accept(this);
                        DescriptorResolver.registerFileInPackage(LazyTopDownAnalyzer.access$getTrace$0(this.this$0), file);
                        List<JetDeclaration> list = file.getDeclarations();
                        Intrinsics.checkExpressionValueIsNotNull(list, "file.getDeclarations()");
                        this.registerDeclarations(list);
                        this.$topLevelFqNames.put(file.getPackageFqName(), packageDirective);
                    }
                }

                public void visitPackageDirective(@NotNull JetPackageDirective directive) {
                    Intrinsics.checkParameterIsNotNull(directive, "directive");
                    LazyTopDownAnalyzer.access$getQualifiedExpressionResolver$2(this.this$0).resolvePackageHeader(directive, LazyTopDownAnalyzer.access$getModuleDescriptor$3(this.this$0), LazyTopDownAnalyzer.access$getTrace$0(this.this$0));
                }

                public void visitImportDirective(@NotNull JetImportDirective importDirective) {
                    Intrinsics.checkParameterIsNotNull(importDirective, "importDirective");
                    FileScopeProvider fileScopeProvider = LazyTopDownAnalyzer.access$getFileScopeProvider$4(this.this$0);
                    JetFile jetFile = importDirective.getContainingJetFile();
                    Intrinsics.checkExpressionValueIsNotNull(jetFile, "importDirective.getContainingJetFile()");
                    LazyFileScope fileScope = fileScopeProvider.getFileScope(jetFile);
                    fileScope.forceResolveImport(importDirective);
                }

                public void visitClassOrObject(@NotNull JetClassOrObject classOrObject) {
                    Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
                    LookupLocation location = classOrObject.isTopLevel() ? (LookupLocation)new KotlinLookupLocation(classOrObject) : (LookupLocation)NoLookupLocation.WHEN_RESOLVE_DECLARATION;
                    ClassDescriptor classDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$5(this.this$0).getClassDescriptor(classOrObject, location);
                    if (classDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes");
                    }
                    ClassDescriptorWithResolutionScopes descriptor = (ClassDescriptorWithResolutionScopes)classDescriptor;
                    this.$c.getDeclaredClasses().put(classOrObject, descriptor);
                    this.registerDeclarations(classOrObject.getDeclarations());
                    Multimap multimap = this.$topLevelFqNames;
                    Intrinsics.checkExpressionValueIsNotNull(multimap, "topLevelFqNames");
                    LazyTopDownAnalyzer.access$registerTopLevelFqName$6(this.this$0, multimap, classOrObject, descriptor);
                    this.checkClassOrObjectDeclarations(classOrObject, descriptor);
                }

                private final void checkClassOrObjectDeclarations(JetClassOrObject classOrObject, ClassDescriptor classDescriptor) {
                    boolean companionObjectAlreadyFound = false;
                    for (JetDeclaration jetDeclaration : classOrObject.getDeclarations()) {
                        if (jetDeclaration instanceof JetObjectDeclaration && ((JetObjectDeclaration)jetDeclaration).isCompanion()) {
                            if (companionObjectAlreadyFound) {
                                LazyTopDownAnalyzer.access$getTrace$0(this.this$0).report(Errors.MANY_COMPANION_OBJECTS.on((JetObjectDeclaration)jetDeclaration));
                            }
                            companionObjectAlreadyFound = true;
                            continue;
                        }
                        if (!(jetDeclaration instanceof JetSecondaryConstructor)) continue;
                        if (DescriptorUtils.isSingletonOrAnonymousObject(classDescriptor)) {
                            LazyTopDownAnalyzer.access$getTrace$0(this.this$0).report(Errors.CONSTRUCTOR_IN_OBJECT.on((JetDeclaration)((PsiElement)jetDeclaration)));
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE))) continue;
                        LazyTopDownAnalyzer.access$getTrace$0(this.this$0).report(Errors.CONSTRUCTOR_IN_TRAIT.on((JetDeclaration)((PsiElement)jetDeclaration)));
                    }
                }

                public void visitClass(@NotNull JetClass klass) {
                    Intrinsics.checkParameterIsNotNull(klass, "klass");
                    this.visitClassOrObject(klass);
                    this.registerPrimaryConstructorParameters(klass);
                }

                private final void registerPrimaryConstructorParameters(JetClass klass) {
                    for (JetParameter jetParameter : klass.getPrimaryConstructorParameters()) {
                        if (!jetParameter.hasValOrVar()) continue;
                        DeclarationDescriptor declarationDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$5(this.this$0).resolveToDescriptor(jetParameter);
                        if (declarationDescriptor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                        }
                        this.$c.getPrimaryConstructorParameterProperties().put(jetParameter, (PropertyDescriptor)declarationDescriptor);
                    }
                }

                public void visitSecondaryConstructor(@NotNull JetSecondaryConstructor constructor) {
                    Intrinsics.checkParameterIsNotNull(constructor, "constructor");
                    DeclarationDescriptor declarationDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$5(this.this$0).resolveToDescriptor(constructor);
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ConstructorDescriptor");
                    }
                    this.$c.getSecondaryConstructors().put(constructor, (ConstructorDescriptor)declarationDescriptor);
                }

                public void visitEnumEntry(@NotNull JetEnumEntry enumEntry) {
                    Intrinsics.checkParameterIsNotNull(enumEntry, "enumEntry");
                    this.visitClassOrObject(enumEntry);
                }

                public void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    this.visitClassOrObject(declaration);
                }

                public void visitAnonymousInitializer(@NotNull JetClassInitializer initializer) {
                    Intrinsics.checkParameterIsNotNull(initializer, "initializer");
                    JetClassOrObject jetClassOrObject = PsiTreeUtil.getParentOfType((PsiElement)initializer, JetClassOrObject.class);
                    if (jetClassOrObject == null) {
                        Intrinsics.throwNpe();
                    }
                    JetClassOrObject classOrObject = jetClassOrObject;
                    DeclarationDescriptor declarationDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$5(this.this$0).resolveToDescriptor(classOrObject);
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes");
                    }
                    this.$c.getAnonymousInitializers().put(initializer, (ClassDescriptorWithResolutionScopes)declarationDescriptor);
                }

                public void visitTypedef(@NotNull JetTypedef typedef) {
                    Intrinsics.checkParameterIsNotNull(typedef, "typedef");
                    LazyTopDownAnalyzer.access$getTrace$0(this.this$0).report(Errors.UNSUPPORTED.on(typedef, "Typedefs are not supported"));
                }

                public void visitMultiDeclaration(@NotNull JetMultiDeclaration multiDeclaration) {
                    Intrinsics.checkParameterIsNotNull(multiDeclaration, "multiDeclaration");
                }

                public void visitNamedFunction(@NotNull JetNamedFunction function) {
                    Intrinsics.checkParameterIsNotNull(function, "function");
                    this.$functions.add(function);
                }

                public void visitProperty(@NotNull JetProperty property) {
                    Intrinsics.checkParameterIsNotNull(property, "property");
                    this.$properties.add(property);
                }
                {
                    this.this$0 = $outer;
                    this.$c = $captured_local_variable$1;
                    this.$topLevelFqNames = $captured_local_variable$2;
                    this.$functions = $captured_local_variable$3;
                    this.$properties = $captured_local_variable$4;
                }
            });
        }
        this.createFunctionDescriptors(c, functions2);
        Multimap multimap = topLevelFqNames;
        Intrinsics.checkExpressionValueIsNotNull(multimap, "topLevelFqNames");
        this.createPropertyDescriptors(c, multimap, properties2);
        this.resolveAllHeadersInClasses(c);
        Multimap multimap2 = topLevelFqNames;
        Intrinsics.checkExpressionValueIsNotNull(multimap2, "topLevelFqNames");
        this.declarationResolver.checkRedeclarationsInPackages(this.topLevelDescriptorProvider, multimap2);
        this.declarationResolver.checkRedeclarations(c);
        this.overrideResolver.check(c);
        this.varianceChecker.check(c);
        this.declarationResolver.resolveAnnotationsOnFiles(c, this.fileScopeProvider);
        this.overloadResolver.process(c);
        this.bodyResolver.resolveBodies(c);
        return c;
    }

    private final void resolveAllHeadersInClasses(TopDownAnalysisContext c) {
        Iterator<ClassDescriptorWithResolutionScopes> iterator2 = c.getAllClasses().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptorWithResolutionScopes classDescriptor;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor = iterator2.next();
            if (classDescriptorWithResolutionScopes == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor");
            }
            ((LazyClassDescriptor)classDescriptorWithResolutionScopes).resolveMemberHeaders();
        }
    }

    private final void createPropertyDescriptors(TopDownAnalysisContext c, Multimap<FqName, JetElement> topLevelFqNames, List<? extends JetProperty> properties2) {
        for (JetProperty jetProperty : properties2) {
            DeclarationDescriptor declarationDescriptor = this.lazyDeclarationResolver.resolveToDescriptor(jetProperty);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
            }
            PropertyDescriptor descriptor = (PropertyDescriptor)declarationDescriptor;
            c.getProperties().put(jetProperty, descriptor);
            ForceResolveUtil.forceResolveAllContents(descriptor.getAnnotations());
            this.registerTopLevelFqName(topLevelFqNames, jetProperty, descriptor);
        }
    }

    private final void createFunctionDescriptors(TopDownAnalysisContext c, List<? extends JetNamedFunction> functions2) {
        for (JetNamedFunction jetNamedFunction : functions2) {
            DeclarationDescriptor declarationDescriptor = this.lazyDeclarationResolver.resolveToDescriptor(jetNamedFunction);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor");
            }
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)declarationDescriptor;
            c.getFunctions().put(jetNamedFunction, simpleFunctionDescriptor);
            ForceResolveUtil.forceResolveAllContents(simpleFunctionDescriptor.getAnnotations());
            for (ValueParameterDescriptor parameterDescriptor : simpleFunctionDescriptor.getValueParameters()) {
                ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
            }
        }
    }

    private final void registerTopLevelFqName(Multimap<FqName, JetElement> topLevelFqNames, JetNamedDeclaration declaration, DeclarationDescriptor descriptor) {
        FqName fqName2;
        if (DescriptorUtils.isTopLevelDeclaration(descriptor) && (fqName2 = declaration.getFqName()) != null) {
            topLevelFqNames.put(fqName2, declaration);
        }
    }

    public LazyTopDownAnalyzer(@NotNull BindingTrace trace, @NotNull DeclarationResolver declarationResolver, @NotNull OverrideResolver overrideResolver, @NotNull OverloadResolver overloadResolver, @NotNull VarianceChecker varianceChecker, @NotNull ModuleDescriptor moduleDescriptor, @NotNull LazyDeclarationResolver lazyDeclarationResolver, @NotNull BodyResolver bodyResolver, @NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull FileScopeProvider fileScopeProvider, @NotNull DeclarationScopeProvider declarationScopeProvider, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(declarationResolver, "declarationResolver");
        Intrinsics.checkParameterIsNotNull(overrideResolver, "overrideResolver");
        Intrinsics.checkParameterIsNotNull(overloadResolver, "overloadResolver");
        Intrinsics.checkParameterIsNotNull(varianceChecker, "varianceChecker");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(lazyDeclarationResolver, "lazyDeclarationResolver");
        Intrinsics.checkParameterIsNotNull(bodyResolver, "bodyResolver");
        Intrinsics.checkParameterIsNotNull(topLevelDescriptorProvider, "topLevelDescriptorProvider");
        Intrinsics.checkParameterIsNotNull(fileScopeProvider, "fileScopeProvider");
        Intrinsics.checkParameterIsNotNull(declarationScopeProvider, "declarationScopeProvider");
        Intrinsics.checkParameterIsNotNull(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        this.trace = trace;
        this.declarationResolver = declarationResolver;
        this.overrideResolver = overrideResolver;
        this.overloadResolver = overloadResolver;
        this.varianceChecker = varianceChecker;
        this.moduleDescriptor = moduleDescriptor;
        this.lazyDeclarationResolver = lazyDeclarationResolver;
        this.bodyResolver = bodyResolver;
        this.topLevelDescriptorProvider = topLevelDescriptorProvider;
        this.fileScopeProvider = fileScopeProvider;
        this.declarationScopeProvider = declarationScopeProvider;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
    }

    @NotNull
    public static final /* synthetic */ BindingTrace access$getTrace$0(LazyTopDownAnalyzer $this) {
        return $this.trace;
    }

    @NotNull
    public static final /* synthetic */ TopLevelDescriptorProvider access$getTopLevelDescriptorProvider$1(LazyTopDownAnalyzer $this) {
        return $this.topLevelDescriptorProvider;
    }

    @NotNull
    public static final /* synthetic */ QualifiedExpressionResolver access$getQualifiedExpressionResolver$2(LazyTopDownAnalyzer $this) {
        return $this.qualifiedExpressionResolver;
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$3(LazyTopDownAnalyzer $this) {
        return $this.moduleDescriptor;
    }

    @NotNull
    public static final /* synthetic */ FileScopeProvider access$getFileScopeProvider$4(LazyTopDownAnalyzer $this) {
        return $this.fileScopeProvider;
    }

    @NotNull
    public static final /* synthetic */ LazyDeclarationResolver access$getLazyDeclarationResolver$5(LazyTopDownAnalyzer $this) {
        return $this.lazyDeclarationResolver;
    }

    public static final /* synthetic */ void access$registerTopLevelFqName$6(LazyTopDownAnalyzer $this, @NotNull Multimap<FqName, JetElement> topLevelFqNames, @NotNull JetNamedDeclaration declaration, @NotNull DeclarationDescriptor descriptor) {
        $this.registerTopLevelFqName(topLevelFqNames, declaration, descriptor);
    }
}

