/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.SequencesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"%\n)\t1JC\u0002B]fTaa[8uY&t'\"\u0001,\u000b\u001d\tKg\u000eZ5oO\u000e{g\u000e^3yi*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(b\u0002:fg>dg/\u001a\u0006\u0004O\u0016$(\"B:mS\u000e,'\"\u0004*fC\u0012|e\u000e\\=TY&\u001cWM\u0003\u0003vi&d'\"C:mS\u000e,G-T1q\u0015\rYW-\u001f\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'BB(cU\u0016\u001cGOC\u000bCS:$\u0017N\\4D_:$X\r\u001f;Vi&d7o\u0013;\u000b\u001f\u001d,G\u000fR1uC\u001acwn^%oM>T!\"\u001a=qe\u0016\u001c8/[8o\u00155QU\r^#yaJ,7o]5p]*\u0019\u0001o]5\u000b\u0019\u0011\u000bG/\u0019$m_^LeNZ8\u000b\u000b\r\fG\u000e\\:\u000b\u0015Ml\u0017M\u001d;dCN$8OC\nhKR\u0014VMZ3sK:\u001cW\rV1sO\u0016$8OC\u0004d_:$X\r\u001f;\u000b\u0015\r{G\u000e\\3di&|gNC\u000bEK\u000ed\u0017M]1uS>tG)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006\u0014\u0015\u0016$(+\u001a;ve:,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0012O\u0016$H+\u0019:hKR4UO\\2uS>t'B\u0006&fi\u000e\u000bG\u000e\\1cY\u0016$Um\u00197be\u0006$\u0018n\u001c8\u000b7\u001d,G\u000fV1sO\u0016$h)\u001e8di&|g\u000eR3tGJL\u0007\u000f^8s\u0015I1UO\\2uS>tG)Z:de&\u0004Ho\u001c:\u000b#%\u001cXK\u001c:fC\u000eD\u0017M\u00197f\u0007>$WMC\u0004C_>dW-\u00198\u000b%%\u001cXk]3e\u0003N,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0012SN,6/\u001a3BgN#\u0018\r^3nK:$(\"A\"\u000b#I+7o\u001c7vi&|gnQ8oi\u0016DHO\u0003\u000esK\u000e|'\u000fZ*d_B,\u0017I\u001c3ECR\fg\t\\8x\u0013:4wN\u0003\u0003V]&$\b@\u0001\u0006\u0003!\tQa\u0001\u0003\u0001\u0011\u0003a\u0001!B\u0001\t\u0006\u0015\u0011A!\u0001\u0005\u0004\u000b\t!\u0019\u0001C\u0001\u0006\u0005\u0011\u0011\u0001rA\u0003\u0004\t\u000bA!\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u00012B\u0003\u0003\t\u000fAa!B\u0002\u0005\t!)A\u0002A\u0003\u0002\u0011\u001d)!\u0001B\u0003\t\u0010\u0015\u0011A1\u0002\u0005\t\u000b\t!)\u0001\u0003\u0002\u0006\u0005\u0011!\u0001\"B\u0003\u0003\t\tA)\"B\u0002\u0005\u0010!QA\u0002A\u0003\u0003\t\u000bA9\"\u0002\u0002\u0005\u0012!aQa\u0001\u0003\n\u0011-a\u0001!\u0002\u0002\u0005\u0013!YQA\u0001C\b\u0011))1\u0001\u0002\u0001\t\u001c1\u0001QA\u0001\u0003\u0003\u0011;)1\u0001b\u0006\t\u001d1\u0001QA\u0001\u0003\u0006\u0011\u0017)!\u0001\"\u0007\t\u001c\u0015\u0019Aq\u0002\u0005\u0010\u0019\u0001)1\u0001b\u0004\t!1\u0001QA\u0001C\b\u0011A)!\u0001b\u0004\t\u001f\u0015\u0019Aq\u0003\u0005\u0012\u0019\u0001)!\u0001b\u0006\t#\u0015\u0019A\u0001\u0001\u0005\u0013\u0019\u0001)!\u0001\"\u0005\t\u001b\u0015\u0019A!\u0005\u0005\u0015\u0019\u0001)1\u0001\u0002\u0001\t+1\u0001QA\u0001\u0003\u0012\u0011Q)a\u0019\u0001\u0003D\u0001\u0006\tr\u0001\u0002\u0001\t\u0001U!Q!\u0001E\u0001\u0019\u0003A\n!\u0005\u0004\u0005\u0002!\rQcA\u0003\u0002\u0011\u0003A\n!F\u0002\u0006\u0003!\u0019\u0001d\u0001\r\u0005;O!\u0001\u0001#\u0003\u000e\u001f\u0015\t\u0001\u0012B\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0011\"B\u0005\u0005\u000b\t!\t\u0001#\u0001\u001d\u0002a%\u0001k!\u0001\u001e\u0012\u0011\u0001\u0001RB\u0007\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001A\u001b\u0011!I\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001G\u00019\u0003\t6!\u0003\u0003\u0005\u0013\u0005Aa!D\u0001\t\u000e5\t\u0001bB\u0007\u0002\u0011\u0019A6\u0011CC\u001e\t\r)2!B\u0001\t\u0007a\u0019\u0001$CO\t\t\u0001A\u0019\"\u0004\u0003\u0006\u0003!AA\u0012\u0001\r\t!\u000e\u0005\u0011eA\u0003\u0002\u0011'A\u001a\"U\u0002\b\t%I\u0011\u0001\u0003\u0006\u000e\u0003!5Q\"\u0001E\u000b1\u000eEQ1\t\u0003\u0004+\r)\u0011\u0001\u0003\u0005\u0019\u0011aeQt\u0002\u0003\u0001\u00115i1!B\u0001\t\u0007a\u0019\u0001k!\u0001\"\u0011\u0015\t\u0001bC\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0007\u0019\u0019aY\u0011kA\u0004\u0005\u001a%\t\u0001\"D\u0007\u0002\u0011+i\u0011\u0001#\u0004Y\u0007#)Y\u0004B\u0002\u0016\u0007\u0015\t\u00012\u0004M\u000e1?iz\u0001\u0002\u0001\t\u001b5\u0019Q!\u0001\u0005\u00041\r\u00016\u0011A\u0011\u0005\u000b\u0005Aa\u0002$\u0001\u0019\u001dE\u001bq\u0001b\b\n\u0003!uQ\"\u0001\u0005\u0010\u001b\u0005Ai\u0001WB\t\u000bw!1!F\u0002\u0006\u0003!m\u00014\u0004M\u0011;\u001f!\u0001\u0001C\u0007\u000e\u0007\u0015\t\u0001b\u0001\r\u0004!\u000e\u0005\u0011\u0005B\u0003\u0002\u0011?a\t\u0001g\bR\u0007\u001d!\t#C\u0001\t!5\t\u0001bD\u0007\u0002\u0011\u001bA6\u0011CC\u001d\t\r)2!B\u0001\t\u0011aA\u00014EO\b\t\u0001AQ\"D\u0002\u0006\u0003!\u0019\u0001d\u0001)\u0004\u0002\u0005\u001aQ!\u0001E\u00111C\t6a\u0002C\u0012\u0013\u0005!\t!D\u0001\t\u00165\t\u0001R\u0002-\u0004\u0012\u0015eBaA\u000b\u0004\u000b\u0005A\u0001\u0002\u0007\u0005\u0019&u=A\u0001\u0001\u0005\u000e\u001b\r)\u0011\u0001C\u0002\u0019\u0007A\u001b\t!I\u0002\u0006\u0003!\u0005\u0002\u0014E)\u0004\u000f\u0011\u0015\u0012\"\u0001C\u0001\u001b\u0005A)\"D\u0001\t\u000ea\u001b\t\"\"\u000f\u0005\u0007U\u0019Q!\u0001\u0005\t1!A2#h\u0004\u0005\u0001!iQbA\u0003\u0002\u0011\rA2\u0001UB\u0001C\r)\u0011\u0001#\t\u0019\"E\u001bq\u0001B\n\n\u0003\u0011\u0005Q\"\u0001E\u000b\u001b\u0005Ai\u0001WB\t\u000bC\"1!\u0005\u0007\u0005\u0001!\u001dR#C\u0003\u0002\u0011GIQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011G)\u0012\"B\u0001\t$%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019$a%R\u0014\u0003\u0003\u0001\u0011'iA!B\u0001\t\u00111\u0005\u0001\u0004\u0003)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00131I\t6a\u0002C\u0015\u0013\u0005!\u0001!D\u0001\t&5\t\u0001R\u0003-\u0004\u0012\u0001"})
public final class BindingContextUtilsKt {
    @Nullable
    public static final <K, V> V get(BindingContext $receiver, @NotNull ReadOnlySlice<K, V> slice, K key) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(slice, "slice");
        return $receiver.get(slice, key);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(JetReturnExpression $receiver, @NotNull BindingContext context) {
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JetSimpleNameExpression targetLabel = $receiver.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            ReadOnlySlice readOnlySlice = BindingContext.LABEL_TARGET;
            Intrinsics.checkExpressionValueIsNotNull(readOnlySlice, "LABEL_TARGET");
            PsiElement psiElement = (PsiElement)BindingContextUtilsKt.get(context, readOnlySlice, targetLabel);
            if (psiElement != null) {
                PsiElement $receiver3 = psiElement;
                PsiElement it = $receiver3;
                ReadOnlySlice readOnlySlice2 = BindingContext.FUNCTION;
                Intrinsics.checkExpressionValueIsNotNull(readOnlySlice2, "FUNCTION");
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)BindingContextUtilsKt.get(context, readOnlySlice2, it);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
        Intrinsics.checkExpressionValueIsNotNull(readOnlySlice, "DECLARATION_TO_DESCRIPTOR");
        PsiElement it = $receiver;
        ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice3 = readOnlySlice;
        BindingContext bindingContext = context;
        JetDeclarationWithBody jetDeclarationWithBody = PsiTreeUtil.getParentOfType((PsiElement)$receiver2, JetDeclarationWithBody.class, false);
        DeclarationDescriptor declarationDescriptor = BindingContextUtilsKt.get(bindingContext, readOnlySlice3, jetDeclarationWithBody);
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (containingFunctionDescriptor == null) {
            return null;
        }
        return SequencesKt.firstOrNull(SequencesKt.dropWhile(SequencesKt.sequence(containingFunctionDescriptor, (Function1)getTargetFunctionDescriptor.2.INSTANCE$), getTargetFunctionDescriptor.3.INSTANCE$));
    }

    @Nullable
    public static final JetCallableDeclaration getTargetFunction(JetReturnExpression $receiver, @NotNull BindingContext context) {
        JetCallableDeclaration jetCallableDeclaration;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        FunctionDescriptor functionDescriptor = BindingContextUtilsKt.getTargetFunctionDescriptor($receiver, context);
        if (functionDescriptor != null) {
            FunctionDescriptor $receiver2 = functionDescriptor;
            FunctionDescriptor it = $receiver2;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(it);
            if (!(psiElement instanceof JetCallableDeclaration)) {
                psiElement = null;
            }
            jetCallableDeclaration = (JetCallableDeclaration)psiElement;
        } else {
            jetCallableDeclaration = null;
        }
        return jetCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(JetExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ReadOnlySlice readOnlySlice = BindingContext.USED_AS_EXPRESSION;
        Intrinsics.checkExpressionValueIsNotNull(readOnlySlice, "BindingContext.USED_AS_EXPRESSION");
        Object v = BindingContextUtilsKt.get(context, readOnlySlice, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    public static final boolean isUsedAsStatement(JetExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return !BindingContextUtilsKt.isUsedAsExpression($receiver, context);
    }

    public static final <C extends ResolutionContext<C>> void recordScopeAndDataFlowInfo(ResolutionContext<C> $receiver, @Nullable JetExpression expression) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (expression == null) {
            return;
        }
        LexicalScope scopeToRecord = ScopeUtilsKt.takeSnapshot($receiver.scope);
        $receiver.trace.record(BindingContext.RESOLUTION_SCOPE, expression, ScopeUtilsKt.asJetScope(scopeToRecord));
        $receiver.trace.record(BindingContext.LEXICAL_SCOPE, expression, scopeToRecord);
        JetTypeInfo typeInfo = (JetTypeInfo)$receiver.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (Intrinsics.areEqual($receiver.dataFlowInfo, DataFlowInfo.EMPTY) ^ true) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, TypeInfoFactoryKt.noTypeInfo(dataFlowInfo));
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfo(BindingContext $receiver, @Nullable JetExpression expression) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                object = expression;
                if (object == null) break block2;
                JetExpression $receiver2 = object;
                JetExpression it = $receiver2;
                ReadOnlySlice readOnlySlice = BindingContext.EXPRESSION_TYPE_INFO;
                Intrinsics.checkExpressionValueIsNotNull(readOnlySlice, "BindingContext.EXPRESSION_TYPE_INFO");
                JetTypeInfo jetTypeInfo = (JetTypeInfo)BindingContextUtilsKt.get($receiver, readOnlySlice, it);
                object = jetTypeInfo != null ? jetTypeInfo.getDataFlowInfo() : null;
                if (object != null) break block3;
            }
            object = DataFlowInfo.EMPTY;
        }
        Intrinsics.checkExpressionValueIsNotNull(object, "expression?.let { this[B\u2026o } ?: DataFlowInfo.EMPTY");
        return object;
    }

    public static final boolean isUnreachableCode(JetExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ReadOnlySlice readOnlySlice = BindingContext.UNREACHABLE_CODE;
        Intrinsics.checkExpressionValueIsNotNull(readOnlySlice, "BindingContext.UNREACHABLE_CODE");
        Object v = BindingContextUtilsKt.get(context, readOnlySlice, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(JetExpression $receiver, @NotNull BindingContext context) {
        Collection<DeclarationDescriptor> collection;
        DeclarationDescriptor targetDescriptor;
        List<DeclarationDescriptor> list;
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if ($receiver instanceof JetReferenceExpression) {
            ReadOnlySlice readOnlySlice = BindingContext.REFERENCE_TARGET;
            Intrinsics.checkExpressionValueIsNotNull(readOnlySlice, "BindingContext.REFERENCE_TARGET");
            declarationDescriptor = (DeclarationDescriptor)BindingContextUtilsKt.get(context, readOnlySlice, $receiver);
        } else {
            declarationDescriptor = null;
        }
        if ((list = (targetDescriptor = declarationDescriptor)) != null) {
            DeclarationDescriptor $receiver2 = list;
            DeclarationDescriptor it = $receiver2;
            list = CollectionsKt.listOf(it);
            if (list != null) {
                collection = (Collection<DeclarationDescriptor>)list;
                return collection;
            }
        }
        ReadOnlySlice readOnlySlice = BindingContext.AMBIGUOUS_REFERENCE_TARGET;
        Intrinsics.checkExpressionValueIsNotNull(readOnlySlice, "BindingContext.AMBIGUOUS_REFERENCE_TARGET");
        collection = CollectionsKt.orEmpty((Collection)BindingContextUtilsKt.get(context, readOnlySlice, $receiver));
        return collection;
    }
}

