/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetProjectionKind;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.callableReferences.CallableReferencesResolutionUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.ValueArgumentsToParametersMapper;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CandidateResolveMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.kotlin.resolve.calls.tasks.SynthesizedInvokesKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={".\u001e)\t2)\u00198eS\u0012\fG/\u001a*fg>dg/\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TqA]3t_24XMC\u0003dC2d7OC\u0002B]fTa\u0001P5oSRt$\u0002F1sOVlWM\u001c;UsB,'+Z:pYZ,'O\u0003\u000bBe\u001e,X.\u001a8u)f\u0004XMU3t_24XM\u001d\u0006\u0019O\u0016tWM]5d\u0007\u0006tG-\u001b3bi\u0016\u0014Vm]8mm\u0016\u0014(\u0002G$f]\u0016\u0014\u0018nY\"b]\u0012LG-\u0019;f%\u0016\u001cx\u000e\u001c<fe*y!/\u001a4mK\u000e$\u0018n\u001c8UsB,7OC\bSK\u001adWm\u0019;j_:$\u0016\u0010]3t\u0015!\u0011W/\u001b7uS:\u001c(\u0002E7pI&4\u0017.\u001a:t\u0007\",7m[3s\u0015Aiu\u000eZ5gS\u0016\u00148o\u00115fG.,'O\u0003\fbI\u0012LG/[8oC2$\u0016\u0010]3DQ\u0016\u001c7.\u001a:t\u0015!IE/\u001a:bE2,'\"F!eI&$\u0018n\u001c8bYRK\b/Z\"iK\u000e\\WM\u001d\u0006\tG\",7m[3sg*\u00012/\\1si\u000e\u000b7\u000f^'b]\u0006<WM\u001d\u0006\u0011'6\f'\u000f^\"bgRl\u0015M\\1hKJT!b]7beR\u001c\u0017m\u001d;t\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u001f\u0007\u0006dGnQ1oI&$\u0017\r^3SKN|G.\u001e;j_:\u001cuN\u001c;fqRTqaY8oi\u0016DHOC\ndC:$\u0017\u000eZ1uK\u0012+7o\u0019:jaR|'O\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTacZ3u\u0007\u0006tG-\u001b3bi\u0016$Um]2sSB$xN\u001d\u0006\u0002\t*12\r[3dW\u0006cGNV1mk\u0016\f%oZ;nK:$8OC\u000fsKN|GN^3Gk:\u001cG/[8o\u0003J<W/\\3oi\n{G-[3t\u0015Q\u0011Vm]8mm\u0016\f%oZ;nK:$8/T8eK*\u00012-\u00197m%\u0016\u001cx\u000e\u001c<feV#\u0018\u000e\u001c\u0006\u001d-\u0006dW/Z!sOVlWM\u001c;t\u0007\",7m[5oOJ+7/\u001e7u\u00159\u001a\u0015M\u001c3jI\u0006$XMU3t_24XM\u001d\u0013WC2,X-\u0011:hk6,g\u000e^:DQ\u0016\u001c7.\u001b8h%\u0016\u001cX\u000f\u001c;\u000bC\rDWmY6HK:,'/[2C_VtGm]%o\u0003\u001a+hn\u0019;j_:\u001c\u0015\r\u001c7\u000b!),G\u000fV=qK\u0006\u0013x-^7f]R\u001c(\u0002\u0002'jgRT\u0011CS3u)f\u0004X\r\u0015:pU\u0016\u001cG/[8o\u0015\r\u00018/\u001b\u0006\u000eif\u0004X-\u0011:hk6,g\u000e^:\u000b\u000f)+G\u000fV=qK*)A/\u001f9fg*\u0011b-\u001e8di&|g\u000eR3tGJL\u0007\u000f^8s\u0015-\u0019XOY:uSR,Ho\u001c:\u000b\u001fQK\b/Z*vEN$\u0018\u000e^;u_JTQ\u0001\u001e:bG\u0016TABQ5oI&tw\r\u0016:bG\u0016TA!\u00168ji*!Q\u000f^5m\u0015\u0005\u001a\u0007.Z2l\u001fV$XM]\"mCN\u001cX*Z7cKJL5/Q2dKN\u001c\u0018N\u00197f\u0015\u001d\u0011un\u001c7fC:Tab\u00195fG.\u0014VmY3jm\u0016\u00148O\u0003\tSKN|G.\u001e;j_:\u001cF/\u0019;vg*9!/Z:vYR\u001c(\"A\"\u000b+\r\u000bG\u000e\u001c*fg>dW\u000f^5p]\u000e{g\u000e^3yi*92\r[3dWZ\u000bG.^3Be\u001e,X.\u001a8u)f\u0004Xm\u001d\u0006\u000eG\u0006tG-\u001b3bi\u0016\u001c\u0015\r\u001c7\u000b'5+H/\u00192mKJ+7o\u001c7wK\u0012\u001c\u0015\r\u001c7\u000b\u000b5|G-\u001a7\u000b#\u001d,G\u000fR3dY\u0006\u0014\u0018N\\4DY\u0006\u001c8OC\u0005dC:$\u0017\u000eZ1uK*y1\t\\1tg\u0012+7o\u0019:jaR|'O\u0003\thKR\u0014VmY3jm\u0016\u00148+\u001e9fe*A!/Z2fSZ,'OC\u0007SK\u000e,\u0017N^3s-\u0006dW/\u001a\u0006\u0007g\u000e|\u0007/Z:\u000b\u0013I,7-Z5wKJ\u001c(B\u0005&fiN+\b/\u001a:FqB\u0014Xm]:j_:T\u0011A\u0012\u0006\"a\u0016\u0014hm\u001c:n%\u0016\u001cx\u000e\\;uS>tgi\u001c:DC:$\u0017\u000eZ1uK\u000e\u000bG\u000e\u001c\u0006\u0005i\u0006\u001c8N\u0003\bSKN|G.\u001e;j_:$\u0016m]6\u000b\u000bQ\f7o[:\u000bIMl\u0017M\u001d;DCN$h+\u00197vK\u0006\u0013x-^7f]R$\u0016\u0010]3JMB{7o]5cY\u0016T!\"\u001a=qe\u0016\u001c8/[8o\u00155QU\r^#yaJ,7o]5p]*aQ\r\u001f9fGR,G\rV=qK*Q\u0011m\u0019;vC2$\u0016\u0010]3\u000b#I+7o\u001c7vi&|gnQ8oi\u0016DHOC\u0003dQ\u0016\u001c7NC\u0004dQ\u0016\u001c7.\u001a:\u000b\u0013\u0019+hn\u0019;j_:\f$\"C#yi\u0016t7/[8o\u0015\rQg/\u001c\u0006\nMVt7\r^5p]NTQc\u00195fG.\f%m\u001d;sC\u000e$\u0018I\u001c3TkB,'O\u0003\bdQ\u0016\u001c7.\u00118e%\u0016\u0004xN\u001d;\u000b+\rDWmY6ESN\u0004\u0018\r^2i%\u0016\u001cW-\u001b<fe*I2\r[3dW\u0016C\b/Z2uK\u0012\u001c\u0015\r\u001c7bE2,G+\u001f9f\u0015Y\u0019\u0007.Z2l\u000bb$XM\\:j_:\u0014VmY3jm\u0016\u0014(bI2iK\u000e\\gj\u001c8FqR,gn]5p]\u000e\u000bG\u000e\\3e/&$\bNU3dK&4XM\u001d\u0006\u000eG\",7m\u001b*fG\u0016Lg/\u001a:\u000b\u0019I+7o\u001c7wK\u0012\u001c\u0015\r\u001c7\u000b#I,7-Z5wKJ\u0004\u0016M]1nKR,'OC\u000eSK\u000e,\u0017N^3s!\u0006\u0014\u0018-\\3uKJ$Um]2sSB$xN\u001d\u0006\u0011e\u0016\u001cW-\u001b<fe\u0006\u0013x-^7f]RT!#[:FqBd\u0017nY5u%\u0016\u001cW-\u001b<fe*\u0019\u0012.\u001c9mS\u000eLG/\u00138w_.,7\t[3dW*12\r[3dWJ+7-Z5wKJ$\u0016\u0010]3FeJ|'OC\u000esK\u000e,\u0017N^3s!\u0006\u0014\u0018-\\3uKJ$Um]2sSB$xN\u001d\u0006\u0014G\",7m\u001b,bYV,\u0017I]4v[\u0016tGo\u001d\u0006\u0010G\",7m\u001b,jg&\u0014\u0017\u000e\\5us*aQ.\u00199Be\u001e,X.\u001a8ug*!\u0002O]8dKN\u001cH+\u001f9f\u0003J<W/\\3oiNTab\u001d5pk2$7i\u001c8uS:,XM,\u0003\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\t\u00012A\u0003\u0004\t\rA1\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001\u0012\u0002\u0007\u0001\u000b\r!!\u0001c\u0003\r\u0001\u0015\u0011A!\u0001\u0005\b\u000b\r!Q\u0001#\u0004\r\u0001\u0015\u0019A1\u0001\u0005\t\u0019\u0001)1\u0001B\u0002\t\u00131\u0001QA\u0001\u0003\u0003\u0011))1\u0001B\u0004\t\u00141\u0001QA\u0001\u0003\u0003\u0011/)1\u0001\u0002\u0005\t\u00171\u0001QA\u0001\u0003\u0003\u0011\u0013)!\u0001\u0002\u0002\t\f\u0015\u0011A!\u0002E\u0007\u000b\t!\u0019\u0001\u0003\u0005\u0006\u0003!aQA\u0001\u0003\f\u00113)!\u0001b\u0006\t\u0013\u0015\u0011A\u0001\u0003\u0005\f\u000b\t!!\u0001c\u0007\u0006\u0007\u0011i\u0001\"\u0004\u0007\u0001\u000b\t!\u0011\u0001C\b\u0006\u0007\u0011q\u0001R\u0004\u0007\u0001\u000b\t!a\u0002#\b\u0006\u0005\u0011i\u0001\"D\u0003\u0003\t\tA!#B\u0002\u0005!!\rB\u0002A\u0003\u0004\t\u000bA)\u0003\u0004\u0001\u0006\u0005\u0011\u0011\u0001bE\u0003\u0003\tAA\u0019#B\u0002\u0005\u0007!%B\u0002A\u0003\u0003\t\u0005AY#B\u0002\u0005'!)B\u0002A\u0003\u0003\t\u0005Aq#B\u0002\u0005)!5B\u0002A\u0003\u0004\tQA\t\u0004\u0004\u0001\u0006\u0007\u0011\r\u00012\u0007\u0007\u0001\u000b\r!1\u0001\u0003\u000e\r\u0001\u0015\u0011Aa\u0003E\u001b\u000b\t!i\u0003#\u000b\u0006\u0005\u0011!\u0002\u0012G\u0003\u0003\t\u0007A\u0019$B\u0002\u0005\u0007!]B\u0002A\u0003\u0003\t\tAQ$B\u0002\u00053!eB\u0002A\u0003\u0003\teAI$B\u0002\u0005\u001b!qB\u0002A\u0003\u0003\t\tA\u0001%B\u0002\u00057!}B\u0002A\u0003\u0003\t5Aa$\u0002\u0002\u00057!}Ra\u0001\u0003\u000f\u0011\u0007b\u0001!\u0002\u0002\u0005\u001d!\rSA\u0001C\u0002\u0011\u000f*!\u0001\u0002\u0010\tI\u0015\u0019AQ\b\u0005$\u0019\u0001)1\u0001B\n\tJ1\u0001QA\u0001\u0003\u0014\u0011\u0013*!\u0001\"\u0010\tG\u0015\u0011AA\u0001\u0005(\u000b\r!\u0011\u0005#\u0014\r\u0001\u0015\u0011A!\tE'\u000b\r!1\u0003#\u0015\r\u0001\u0015\u0019A!\u0004\u0005+\u0019\u0001)!\u0001\u0002\u000b\t.\u0015\u0011Aa\u0005E)\u000b\t!Q\u0002\u0003\u0016\u0006\u0007\u0011\u0019\u0001r\u000b\u0007\u0001\u000b\r!1\u0001\u0003\u0017\r\u0001\u0015\u0011Aa\u0001E-\u000b\t!a\u0005C\u0017\u0006\u0005\u00115\u0003rK\u0003\u0004\tmA\u0011\u0007\u0004\u0001\u0006\u0007\u0011q\u0001B\r\u0007\u0001\u000b\t!1\u0004C\u0019\u0006\u0005\u0011q\u0001B\r\u0003\u0004\u0019\u000bI2!B\u0001\t\ba\u001dQ\u0014!\n.#\u0011\tG\u0001'\u0005\"\u0011\u0015\t\u0001RB\u0005\u0005\u0013\r)\u0011\u0001c\u0004\u0019\u0010a5Qk\u0001\u0003\u0006\u0007\u0011E\u0011\"\u0001\u0005\r[1!\u0011\r\u0002\r\u0005C\r)\u0011\u0001\u0003\u0003\u0019\tU\u001bA!B\u0002\u0005\t%\t\u0001\"C\u0017\r\t\u0005$\u0001$B\u0011\u0004\u000b\u0005AI\u0001'\u0003V\u0007\u0011)1\u0001B\u0003\n\u0003!MQ\u0006\u0004\u0003b\ta=\u0011eA\u0003\u0002\u0011\u0019Ab!V\u0002\u0005\u000b\r!y!C\u0001\t\u00165bA!\u0019\u0003\u0019\r\u0005\u001aQ!\u0001E\u00061\u0017)6\u0001B\u0003\u0004\t\u0019I\u0011\u0001\u0003\u0006.\u0019\u0011\tG\u0001'\u0006\"\u0007\u0015\t\u0001\u0012\u0003M\t+\u000e!Qa\u0001C\u000b\u0013\u0005AI\"L\u000b\u0005C\u0012)R!B\u0001\t\u001c%\tA1\u0001M\u000e19\t3!B\u0001\t\u001eauA%I+\u0004\r5)AqD\u0005\u0002\u0011=i\u0011\u0001c\b.Z\u0011\u0019\u0011C\u0002\u0003\u0001\u0011A)2!B\u0001\t\u001eau\u0001\u0014EO\u000e\t\u0001AY\"D\u0005\u0006\u0003!m\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001am\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\"E\u0007\u0004\u000b\u0005A\t\u0003'\tQ\u0007\u0003\t3!B\u0001\t#a\t\u0012kA\u0004\u0005\"%\t\u00012E\u0007\u0002\u0011?i\u0011\u0001\u0003\n.\u0013\u0004!\u0011\u0001g\n\u001e\u001a\u0011\u0001\u0001\u0002F\u0007\t\u000b\u0005A)#\u0003\u0003\n\u0007\u0015\t\u0001r\u0005M\u00141K\u00016\u0001AO\r\t\u0001Aa#\u0004\u0005\u0006\u0003!\u0015\u0012\u0002B\u0005\u0004\u000b\u0005AI\u0003'\u000b\u0019&A\u001b\t!h\u0004\u0005\u0001!=RbA\u0003\u0002\u0011;Aj\u0002U\u0002\u0002;\u001f!\u0001\u0001\u0003\r\u000e\u0007\u0015\t\u0001\"\u0006\r\u0016!\u000e\rQt\u0002\u0003\u0001\u0011ei1!B\u0001\t,a-\u0002k\u0001\u0002\"\u0007\u0015\t\u0001B\u0006\r\u0017#\u000eiAqE\u0005\u0002\t\u0001i\u0011\u0001C\f\u000e\u0003!9R\"\u0001\u0005\u0010\u001b\u0005Ay#D\u0001\t15:B!\u0001\r\u001c;'!\u0001\u0001c\u0007\u000e\u000b\u0015\t\u00012D\u0005\u0002\t\u0007AZ\u0002U\u0002\u0001C\r)\u0011\u0001#\r\u00192E\u001bQ\u0001B\u000e\n\u0003\u0011\u0005Q\"\u0001E\u0010[\t\"\u0011!\u0005\u0004\u0005\u0001!\u0001RcA\u0003\u0002\u0011;Aj\u0002\u0007\u000f\u001e\u001c\u0011\u0001\u00012D\u0007\n\u000b\u0005AY\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001AZ\u0002U\u0002\u0001C\r)\u0011\u0001c\r\u00194E\u001bQ\u0001\u0002\u000f\n\u0003!QR\"\u0001E\u0010[)\u0007A!A\t\u0007\t\u0001A\u0001#F\u0002\u0006\u0003!u\u0001TD\t\r\t\u0003AY$F\u0005\u0006\u0003!U\u0012\"B\u0005\u0005\u000b\t!\t\u0001#\u0001\u001d\u0002aU\u0002THO\u000e\t\u0001AY\"D\u0005\u0006\u0003!U\u0012\"B\u0005\u0005\u000b\t!\t\u0001#\u0001\u001d\u0002aU\u0002k\u0001\u0001\u001e\u001c\u0011\u0001\u0001bH\u0007\n\u000b\u0005A9$C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001A:\u0004UB\u0001;\u001f!\u0001\u0001C\t\u000e\u0007\u0015\t\u0001\u0012\u0005M\u0011!\u000e\t\u0011eA\u0003\u0002\u0011EA\u0012#U\u0002\n\t{I\u0011\u0001c\t\u000e\u0003!aR\"\u0001E\u001d\u001b\u0005A!#\f\f\u0005\u0003a\u0005St\u0002\u0003\u0001\u0011\u0005j1!B\u0001\t\u001eau\u0001k\u0001\u0001\"\t\u0015\t\u0001\"\bG\u00011u\t6!\u0002C!\u0013\u0005AY$D\u0001\t\u001f52B!\u0001\r#;\u001f!\u0001\u0001#\u0012\u000e\u0007\u0015\t\u0001b\b\r !\u000e\u0001\u0011\u0005B\u0003\u0002\u0011\u007fa\t\u0001g\u0010R\u0007\u0015!!%C\u0001\tA5\t\u0001\u0012IWA\u0002\u0011\u0019\u0011C\u0002\u0003\u0001\u0011A)2!B\u0001\t\u001eau\u0011c\u0002C\u0001\u0011\u0015*B!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001M&;7!\u0001\u0001c\u0007\u000e\u0013\u0015\t\u00012D\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u00014\u0004)\u0004\u0001u\u001dB\u0001\u0001\u0005'\u001b=)\u0011\u0001c\u0011\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002!C\u0003\n\t\u0015\u0011A\u0011\u0001E\u00019\u0003A\u001a\u0005UB\u0001C\r)\u0011\u0001\u0003\f\u0019-E\u001bq\u0001b\u0013\n\u0003\u0011\u0001Q\"\u0001E\u0010\u001b\u0005A!%l\u001c\u0005\u0003a=St\u0002\u0003\u0001\u0011!j1!B\u0001\tFa\u0015\u0003k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\"K\u0007\u0004\u000b\u0005AI\u0003'\u000bQ\u0007\u0003iz\u0001\u0002\u0001\tT5\u0019Q!\u0001E\u00151S\u00016!AO\n\t\u0001AY\"D\u0003\u0006\u0003!\u0019\u0013\"\u0001C\u00021\r\u000261A\u0011\u0005\u000b\u0005AI\u0003$\u0001\u0019*E\u001b1\u0002b\u0014\n\u0003!\u001dS\"\u0001\u0005%\u001b\u0005A9%D\u0001\tH5\t\u0001\u0012JW;\t\u0007\tb\u0001\u0002\u0001\t!U\u0019Q!\u0001E\u000f1;)\u0012\"B\u0001\t\u001c%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\u001caUSD\u0007\u0003\u0001\u0011-jY#B\u0001\tK%Q\u0011\"C\u0003\u0002\u00117IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u000117IA!C\u0002\u0006\u0003!1\u0002D\u0006\r&#\u000e\tA1\n)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00171Y\t6a\u0002C+\u0013\u0005!\u0001!D\u0001\t 5\t\u0001bJW\u0013\t\u0005)R!B\u0001\t\u001c%\tA1\u0001M\u000e17\n3!B\u0001\t-a1\u0012kA\u0003\u0005\\%\tA\u0001A\u0007\u0002\u0011?i+\bb\u0001\u0012\r\u0011\u0001\u0001\u0002E\u000b\u0004\u000b\u0005Ai\u0002'\b\u0016\u0013\u0015\t\u00012D\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u00014\u0004\r/;i!\u0001\u0001C\u0016\u000e,\u0015\t\u0001\"J\u0005\u000b\u0013%)\u0011\u0001c\u0007\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002\u0001g\u0007\n\t%\u0019Q!\u0001E\u001a1gAR%U\u0002\u0002\t\u0017\u00026\u0011A\u0011\u0004\u000b\u0005Aa\u0003\u0007\fR\u0007\u001d!a&C\u0001\u0005\u00015\t\u0001rD\u0007\u0002\u0011\u001dj+\u0003B\u0001\u0016\u000b\u0015\t\u00012D\u0005\u0002\t\u0007AZ\u0002'\u0018\"\u0007\u0015\t\u0001B\u0006\r\u0017#\u000e)AQL\u0005\u0002\t\u0001i\u0011\u0001c\b.L\u0011\t\u0011C\u0002\u0003\u0001\u0011A)2!B\u0001\t\u001eau\u0011c\u0002C\u0001\u0011\u0015*B!\u0002\u0002\u0005\u0002!\u0001A\u0004A\u000b\n\u000b\u0005AY\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001AZ\u0002G\u0018\"\u0007\u0015\t\u0001B\u0006\r\u0017#\u000e)AaL\u0005\u0002\t\u0001i\u0011\u0001c\b.&\u0011\tQ#B\u0003\u0002\u00117I\u0011\u0001b\u0001\u0019\u001ca}\u0013eA\u0003\u0002\u0011YAb#U\u0002\u0006\t?J\u0011\u0001\u0002\u0001\u000e\u0003!}QV\u0005\u0003\u0002+\u0015)\u0011\u0001c\u0007\n\u0003\u0011\r\u00014\u0004\r1C\r)\u0011\u0001\u0003\f\u0019-E\u001bQ\u0001\u0002\u0019\n\u0003\u0011\u0001Q\"\u0001E\u0010[e\u0007A!A\t\u0007\t\u0001A\u0001#F\u0002\u0006\u0003!u\u0001TD\u000b\n\u000b\u0005AY\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001AZ\u0002'\u0019\u001e\u001c\u0011\u0001\u0001bH\u0007\n\u000b\u0005Ay%C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001Az\u0005UB\u0001;#!\u0001\u0001c\u0019\u000e\t\u0015\t\u0001\u0002\u000bG\u00011!\u00026!AO\b\t\u0001A)'D\u0002\u0006\u0003!y\u0002d\b)\u0004\u0004u=A\u0001\u0001\u00054\u001b\r)\u0011\u0001#\r\u00192A\u001b!!h\u0004\u0005\u0001!\u001dTbA\u0003\u0002\u0011cA\n\u0004UB\u0003C\r)\u0011\u0001c\r\u00194E\u001bq\u0002\"\u0019\n\u0003!QR\"\u0001E\u0010\u001b\u0005A\t&D\u0001\tS5\t\u0001\u0012I\u0007\u0002\t\u0003i\u0011\u0001\"\u0001.&\u0011\tQ#B\u0003\u0002\u00117I\u0011\u0001b\u0001\u0019\u001ca!\u0014eA\u0003\u0002\u0011YAb#U\u0002\u0006\tQJ\u0011\u0001\u0002\u0001\u000e\u0003!}Q\u0016\u000b\u0003\u0002+\u0015)\u0011\u0001c\u0007\n\u0003\u0011\r\u00014\u0004\r5;#!\u0001\u0001#\u001b\u000e\t\u0015\t\u0001\u0002\u000bG\u00011!\u00026\u0011AO\b\t\u0001A)'D\u0002\u0006\u0003!y\u0002d\b)\u0004\u0003\u0005\u001aQ!\u0001\u0005\u00171Y\t6!\u0003\u00035\u0013\u0005!\u0001!D\u0001\t 5\t\u0001\"K\u0007\u0002\u0011\u0003j+\u0003B\u0001\u0016\u000b\u0015\t\u00012D\u0005\u0002\t\u0007AZ\u0002G\u001b\"\u0007\u0015\t\u0001B\u0006\r\u0017#\u000e)A!N\u0005\u0002\t\u0001i\u0011\u0001c\b.&\u0011\tQ#B\u0003\u0002\u00117I\u0011\u0001b\u0001\u0019\u001ca-\u0014eA\u0003\u0002\u0011YAb#U\u0002\u0006\tWJ\u0011\u0001\u0002\u0001\u000e\u0003!}Q6\n\u0003\u0002#\u0019!\u0001\u0001\u0003\t\u0016\u0007\u0015\t\u0001R\u0004M\u000f#\u001d!\t\u0001C\u0013\u0016\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001)\u0012\"B\u0001\t\u001c%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\u001ca1\u0014eA\u0003\u0002\u0011YAb#U\u0002\u0006\tYJ\u0011\u0001\u0002\u0001\u000e\u0003!}QV\u0005\u0003\u0002+\u0015)\u0011\u0001c\u0007\n\u0003\u0011\r\u00014\u0004M7C\r)\u0011\u0001\u0003\f\u0019-E\u001bQ\u0001\"\u001c\n\u0003\u0011\u0001Q\"\u0001E\u0010[w!\u0011!\u0005\u0004\u0005\u0001!\u0001RcA\u0003\u0002\u0011;Aj\"F\u0005\u0006\u0003!m\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001am\u0001dN\u0011\u0004\u000b\u0005A\t\u0004'\rR\u0007\u0015!q'C\u0001\u0005\u00025\t\u0001rD[Q\u0002\u0015y\r\u0001Br\u00011\u000fiz\u0001\u0002\u0001\t\t5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0001AO\b\t\u0001AQ!D\u0002\u0006\u0003!%\u0001\u0014\u0002)\u0004\u0002u=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\u0011!h\u0004\u0005\u0001!=QbA\u0003\u0002\u0011\u0019Ab\u0001UB\u0002;3!\u0001\u0001#\u0005\u000e\u0011\u0015\t\u0001RB\u0005\u0005\u0013\r)\u0011\u0001c\u0004\u0019\u0010a5\u0001k\u0001\u0002\u001e\u0010\u0011\u0001\u0001RC\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u000b\t3!B\u0001\t\u0006a\u0015\u0011kA\b\u0005\b%\tA\u0001A\u0007\u0002\u0011%i\u0011\u0001c\u0005\u000e\u0003!QQ\"\u0001E\u000b\u001b\u0005AA\"D\u0001\t\u001a\u0001"})
public final class CandidateResolver {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ArgumentTypeResolver argumentTypeResolver;
    private final GenericCandidateResolver genericCandidateResolver;
    private final ReflectionTypes reflectionTypes;
    private final ModifiersChecker modifiersChecker;
    private final Iterable<? extends AdditionalTypeChecker> additionalTypeCheckers;
    private final SmartCastManager smartCastManager;

    static {
        $kotlinClass = Reflection.createKotlinClass(CandidateResolver.class);
    }

    public final <D extends CallableDescriptor, F extends D> void performResolutionForCandidateCall(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolutionTask<D, F> task) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(task, "task");
        CallCandidateResolutionContext<D> $receiver = context;
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (ErrorUtils.isError(this.getCandidateDescriptor($receiver))) {
            $receiver.candidateCall.addStatus(ResolutionStatus.SUCCESS);
            return;
        }
        if (!this.checkOuterClassMemberIsAccessible($receiver)) {
            $receiver.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            return;
        }
        this.checkVisibility($receiver);
        switch (CandidateResolver$WhenMappings.$EnumSwitchMapping$0[task.checkArguments.ordinal()]) {
            case 1: {
                this.mapArguments($receiver);
                break;
            }
            case 2: {
                this.checkExpectedCallableType($receiver);
            }
        }
        this.checkReceiverTypeError($receiver);
        this.checkExtensionReceiver($receiver);
        this.checkDispatchReceiver($receiver);
        this.processTypeArguments($receiver);
        this.checkValueArguments($receiver);
        this.checkAbstractAndSuper($receiver);
        this.checkNonExtensionCalledWithReceiver($receiver);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkValueArguments(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue((CallCandidateResolutionContext)$receiver2)) {
            void $receiver3;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver2;
            MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
            ResolutionStatus resolutionStatus = $receiver.call.getTypeArguments().isEmpty() && !this.getCandidateDescriptor($receiver3).getTypeParameters().isEmpty() && $receiver.candidateCall.getKnownTypeParametersSubstitutor() == null ? this.genericCandidateResolver.inferTypeArguments($receiver3) : this.checkAllValueArguments((CallCandidateResolutionContext)$receiver3, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS).getStatus();
            mutableResolvedCall.addStatus(resolutionStatus);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processTypeArguments(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue((CallCandidateResolutionContext)$receiver2)) {
            CallCandidateResolutionContext $receiver3 = (CallCandidateResolutionContext)$receiver2;
            List<JetTypeProjection> jetTypeArguments = $receiver.call.getTypeArguments();
            if (!jetTypeArguments.isEmpty()) {
                int type22;
                ArrayList<JetType> typeArguments = new ArrayList<JetType>();
                for (JetTypeProjection projection : jetTypeArguments) {
                    JetType type22;
                    if (Intrinsics.areEqual((Object)projection.getProjectionKind(), (Object)JetProjectionKind.NONE) ^ true) {
                        $receiver.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on((JetTypeProjection)((PsiElement)projection)));
                        JetModifierListOwner jetModifierListOwner = projection;
                        Intrinsics.checkExpressionValueIsNotNull(jetModifierListOwner, "projection");
                        BindingTrace bindingTrace = $receiver.trace;
                        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "trace");
                        ModifierCheckerCore.INSTANCE$.check(jetModifierListOwner, bindingTrace, null);
                    }
                    if (this.argumentTypeResolver.resolveTypeRefWithDefault(projection.getTypeReference(), $receiver.scope, $receiver.trace, ErrorUtils.createErrorType("Star projection in a call")) == null) {
                        Intrinsics.throwNpe();
                    }
                    ForceResolveUtil.forceResolveAllContents(type22);
                    typeArguments.add(type22);
                }
                int expectedTypeArgumentCount = this.getCandidateDescriptor($receiver3).getTypeParameters().size();
                int n = jetTypeArguments.size();
                if (n <= (type22 = expectedTypeArgumentCount - 1)) {
                    while (true) {
                        void index2;
                        typeArguments.add(ErrorUtils.createErrorType("Explicit type argument expected for " + this.getCandidateDescriptor($receiver3).getTypeParameters().get((int)index2).getName()));
                        if (index2 == type22) break;
                        ++index2;
                    }
                }
                CallableDescriptor callableDescriptor = this.getCandidateDescriptor($receiver3);
                if (callableDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                }
                TypeSubstitution substitution = FunctionDescriptorUtil.createSubstitution((FunctionDescriptor)callableDescriptor, (List<JetType>)typeArguments);
                TypeSubstitutor substitutor2 = TypeSubstitutor.create(substitution);
                if (expectedTypeArgumentCount != jetTypeArguments.size()) {
                    $receiver.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                    $receiver.tracing.wrongNumberOfTypeArguments($receiver.trace, expectedTypeArgumentCount);
                } else {
                    List<JetTypeProjection> list = jetTypeArguments;
                    Intrinsics.checkExpressionValueIsNotNull(list, "jetTypeArguments");
                    List list2 = typeArguments;
                    CallableDescriptor callableDescriptor2 = this.getCandidateDescriptor($receiver3);
                    TypeSubstitutor typeSubstitutor2 = substitutor2;
                    Intrinsics.checkExpressionValueIsNotNull(typeSubstitutor2, "substitutor");
                    BindingTrace bindingTrace = $receiver.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "trace");
                    this.checkGenericBoundsInAFunctionCall(list, list2, callableDescriptor2, typeSubstitutor2, bindingTrace);
                }
                $receiver.candidateCall.setResultingSubstitutor(substitutor2);
            } else if ($receiver.candidateCall.getKnownTypeParametersSubstitutor() != null) {
                MutableResolvedCall mutableResolvedCall = $receiver.candidateCall;
                TypeSubstitutor typeSubstitutor3 = $receiver.candidateCall.getKnownTypeParametersSubstitutor();
                if (typeSubstitutor3 == null) {
                    Intrinsics.throwNpe();
                }
                mutableResolvedCall.setResultingSubstitutor(typeSubstitutor3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor, F extends D> void mapArguments(CallCandidateResolutionContext<D> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue((CallCandidateResolutionContext<D>)$receiver2)) {
            CallCandidateResolutionContext $receiver3 = (CallCandidateResolutionContext)$receiver2;
            ValueArgumentsToParametersMapper.Status argumentMappingStatus = ValueArgumentsToParametersMapper.mapValueArgumentsToParameters($receiver3.call, $receiver3.tracing, $receiver3.candidateCall, Sets.newLinkedHashSet());
            if (!argumentMappingStatus.isSuccess()) {
                $receiver3.candidateCall.addStatus(ResolutionStatus.ARGUMENTS_MAPPING_ERROR);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor, F extends D> void checkExpectedCallableType(CallCandidateResolutionContext<D> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue((CallCandidateResolutionContext<D>)$receiver2)) {
            CallCandidateResolutionContext $receiver3 = (CallCandidateResolutionContext)$receiver2;
            if (!TypeUtils.noExpectedType($receiver3.expectedType)) {
                Object candidate;
                Object d = candidate = $receiver3.candidateCall.getCandidateDescriptor();
                Intrinsics.checkExpressionValueIsNotNull(d, "candidate");
                JetType candidateReflectionType = CallableReferencesResolutionUtilsKt.getReflectionTypeForCandidateDescriptor(d, $receiver3, this.reflectionTypes);
                if (candidateReflectionType != null && !JetTypeChecker.DEFAULT.isSubtypeOf(candidateReflectionType, $receiver3.expectedType)) {
                    $receiver3.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue((CallCandidateResolutionContext)$receiver2)) {
            ResolutionStatus resolutionStatus;
            void $receiver3;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver2;
            MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
            ReceiverValue receiverValue = ExpressionTypingUtils.normalizeReceiverValueForVisibility($receiver.candidateCall.getDispatchReceiver(), $receiver.trace.getBindingContext());
            DeclarationDescriptorWithVisibility invisibleMember = Visibilities.findInvisibleMember(receiverValue, this.getCandidateDescriptor($receiver3), $receiver.scope.getOwnerDescriptor());
            if (invisibleMember != null) {
                $receiver.tracing.invisibleMember($receiver.trace, invisibleMember);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExtensionReceiver(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue((CallCandidateResolutionContext)$receiver2)) {
            ResolutionStatus resolutionStatus;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver2;
            MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
            ReceiverParameterDescriptor receiverParameter = $receiver.candidateCall.getCandidateDescriptor().getExtensionReceiverParameter();
            ReceiverValue receiverArgument = $receiver.candidateCall.getExtensionReceiver();
            if (receiverParameter != null && !receiverArgument.exists()) {
                $receiver.tracing.missingReceiver($receiver.candidateCall.getTrace(), receiverParameter);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else if (receiverParameter == null && receiverArgument.exists()) {
                $receiver.tracing.noReceiverAllowed($receiver.candidateCall.getTrace());
                resolutionStatus = $receiver.call.getCalleeExpression() instanceof JetSimpleNameExpression ? ResolutionStatus.RECEIVER_PRESENCE_ERROR : ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDispatchReceiver(CallCandidateResolutionContext<?> $receiver) {
        block6: {
            var3_2 = $receiver;
            var2_3 = this;
            if (!var2_3.shouldContinue((CallCandidateResolutionContext<D>)$receiver)) break block6;
            var4_4 = (CallCandidateResolutionContext)$receiver;
            var9_5 = $receiver.candidateCall;
            candidateDescriptor = CandidateResolver.access$getCandidateDescriptor$0(this, $receiver);
            dispatchReceiver = $receiver.candidateCall.getDispatchReceiver();
            if (!dispatchReceiver.exists()) ** GOTO lbl-1000
            nestedClass = null;
            if (candidateDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isStaticNestedClass(((ConstructorDescriptor)candidateDescriptor).getContainingDeclaration())) {
                nestedClass = ((ConstructorDescriptor)candidateDescriptor).getContainingDeclaration();
            } else if (candidateDescriptor instanceof FakeCallableDescriptorForObject) {
                nestedClass = ((FakeCallableDescriptorForObject)candidateDescriptor).getReferencedDescriptor();
            }
            if (nestedClass != null) {
                $receiver.tracing.nestedClassAccessViaInstanceReference($receiver.trace, nestedClass, $receiver.candidateCall.getExplicitReceiverKind());
                v0 = ResolutionStatus.OTHER_ERROR;
            } else lbl-1000:
            // 2 sources

            {
                nestedClass = dispatchReceiver.exists() == ($receiver.candidateCall.getResultingDescriptor().getDispatchReceiverParameter() != null);
                if (PreconditionsKt.getASSERTIONS_ENABLED() && value == false) {
                    message = "Shouldn't happen because of TaskPrioritizer: " + candidateDescriptor;
                    throw (Throwable)new AssertionError((Object)message);
                }
                v0 = ResolutionStatus.SUCCESS;
            }
            var10_11 = v0;
            var9_5.addStatus(var10_11);
        }
    }

    private final boolean checkOuterClassMemberIsAccessible(CallCandidateResolutionContext<?> context) {
        if (context.call.getExplicitReceiver().exists() || context.call.getDispatchReceiver().exists()) {
            return true;
        }
        Object d = context.candidateCall.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "context.candidateCall.getCandidateDescriptor()");
        ClassDescriptor candidateThis = this.getDeclaringClass((CallableDescriptor)d);
        if (candidateThis == null || candidateThis.getKind().isSingleton()) {
            return true;
        }
        return DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, context.call.getCallElement(), candidateThis);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAbstractAndSuper(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue((CallCandidateResolutionContext)$receiver2)) {
            Modality modality;
            CallCandidateResolutionContext $receiver3 = (CallCandidateResolutionContext)$receiver2;
            CallableDescriptor descriptor = this.getCandidateDescriptor($receiver3);
            JetExpression expression = $receiver.candidateCall.getCall().getCalleeExpression();
            if (expression instanceof JetSimpleNameExpression && descriptor instanceof ConstructorDescriptor && Intrinsics.areEqual((Object)(modality = ((ConstructorDescriptor)descriptor).getContainingDeclaration().getModality()), (Object)Modality.ABSTRACT)) {
                $receiver.tracing.instantiationOfAbstractClass($receiver.trace);
            }
            ReceiverValue receiverValue = $receiver.candidateCall.getDispatchReceiver();
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "candidateCall.getDispatchReceiver()");
            JetSuperExpression superDispatchReceiver = this.getReceiverSuper(receiverValue);
            if (superDispatchReceiver != null && descriptor instanceof MemberDescriptor && Intrinsics.areEqual((Object)((MemberDescriptor)((Object)descriptor)).getModality(), (Object)Modality.ABSTRACT)) {
                $receiver.tracing.abstractSuperCall($receiver.trace);
                $receiver.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
            ReceiverValue receiverValue2 = $receiver.candidateCall.getExtensionReceiver();
            Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "candidateCall.getExtensionReceiver()");
            JetSuperExpression superExtensionReceiver = this.getReceiverSuper(receiverValue2);
            if (superExtensionReceiver != null) {
                $receiver.trace.report(Errors.SUPER_CANT_BE_EXTENSION_RECEIVER.on((JetSuperExpression)((PsiElement)superExtensionReceiver), superExtensionReceiver.getText()));
                $receiver.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkNonExtensionCalledWithReceiver(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue((CallCandidateResolutionContext)$receiver2)) {
            ResolutionStatus resolutionStatus;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver2;
            MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)$receiver.candidateCall.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "candidateCall.getCandidateDescriptor()");
            if (SynthesizedInvokesKt.isSynthesizedInvoke(declarationDescriptor) && !KotlinBuiltIns.isExtensionFunctionType($receiver.candidateCall.getDispatchReceiver().getType())) {
                $receiver.tracing.freeFunctionCalledAsExtension($receiver.trace);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    private final JetSuperExpression getReceiverSuper(ReceiverValue receiver) {
        JetExpression expression;
        if (receiver instanceof ExpressionReceiver && (expression = ((ExpressionReceiver)receiver).getExpression()) instanceof JetSuperExpression) {
            return (JetSuperExpression)expression;
        }
        return null;
    }

    private final ClassDescriptor getDeclaringClass(CallableDescriptor candidate) {
        ReceiverParameterDescriptor receiverParameterDescriptor = candidate.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor expectedThis = receiverParameterDescriptor;
        DeclarationDescriptor descriptor = expectedThis.getContainingDeclaration();
        return descriptor instanceof ClassDescriptor ? (ClassDescriptor)descriptor : (ClassDescriptor)null;
    }

    @NotNull
    public final <D extends CallableDescriptor> ValueArgumentsCheckingResult checkAllValueArguments(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolveArgumentsMode resolveFunctionArgumentBodies) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull((Object)resolveFunctionArgumentBodies, "resolveFunctionArgumentBodies");
        CallResolutionContext callResolutionContext = context;
        MutableResolvedCall mutableResolvedCall = context.candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(mutableResolvedCall, "context.candidateCall");
        ValueArgumentsCheckingResult checkingResult = this.checkValueArgumentTypes(callResolutionContext, mutableResolvedCall, resolveFunctionArgumentBodies);
        ResolutionStatus resultStatus = checkingResult.getStatus();
        ResolutionStatus resolutionStatus = resultStatus.combine(this.checkReceivers(context));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus, "resultStatus.combine(checkReceivers(context))");
        resultStatus = resolutionStatus;
        return new ValueArgumentsCheckingResult(resultStatus, checkingResult.getArgumentTypes());
    }

    private final <D extends CallableDescriptor, C extends CallResolutionContext<C>> ValueArgumentsCheckingResult checkValueArgumentTypes(CallResolutionContext<C> context, MutableResolvedCall<D> candidateCall, ResolveArgumentsMode resolveFunctionArgumentBodies) {
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        ArrayList<JetType> argumentTypes = Lists.newArrayList();
        MutableDataFlowInfoForArguments infoForArguments = candidateCall.getDataFlowInfoForArguments();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : candidateCall.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                JetExpression expression;
                if (argument.getArgumentExpression() == null) {
                    continue;
                }
                ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameterDescriptor");
                ValueArgument valueArgument = argument;
                Intrinsics.checkExpressionValueIsNotNull(valueArgument, "argument");
                JetType expectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
                CallResolutionContext newContext = (CallResolutionContext)((CallResolutionContext)context.replaceDataFlowInfo(infoForArguments.getInfo(argument))).replaceExpectedType(expectedType);
                JetTypeInfo typeInfoForCall = this.argumentTypeResolver.getArgumentTypeInfo(expression, newContext, resolveFunctionArgumentBodies);
                JetType type2 = typeInfoForCall.getType();
                infoForArguments.updateInfo(argument, typeInfoForCall.getDataFlowInfo());
                ArgumentMatchStatus matchStatus = ArgumentMatchStatus.SUCCESS;
                JetType resultingType = type2;
                if (type2 == null || type2.isError() && !ErrorUtils.isFunctionPlaceholder(type2)) {
                    matchStatus = ArgumentMatchStatus.ARGUMENT_HAS_NO_TYPE;
                } else if (!TypeUtils.noExpectedType(expectedType)) {
                    if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(type2, expectedType)) {
                        JetType jetType = newContext.expectedType;
                        Intrinsics.checkExpressionValueIsNotNull(jetType, "newContext.expectedType");
                        ResolutionContext resolutionContext = newContext;
                        Intrinsics.checkExpressionValueIsNotNull(resolutionContext, "newContext");
                        JetType smartCast = this.smartCastValueArgumentTypeIfPossible(expression, jetType, type2, resolutionContext);
                        if (smartCast == null) {
                            resultStatus = ResolutionStatus.OTHER_ERROR;
                            matchStatus = ArgumentMatchStatus.TYPE_MISMATCH;
                        } else {
                            resultingType = smartCast;
                        }
                    } else if (ErrorUtils.containsUninferredParameter(expectedType)) {
                        matchStatus = ArgumentMatchStatus.MATCH_MODULO_UNINFERRED_TYPES;
                    }
                }
                argumentTypes.add(resultingType);
                candidateCall.recordArgumentMatchStatus(argument, matchStatus);
            }
        }
        List list = argumentTypes;
        Intrinsics.checkExpressionValueIsNotNull(list, "argumentTypes");
        return new ValueArgumentsCheckingResult(resultStatus, list);
    }

    private final JetType smartCastValueArgumentTypeIfPossible(JetExpression expression, JetType expectedType, JetType actualType, ResolutionContext<?> context) {
        ExpressionReceiver receiverToCast = new ExpressionReceiver(JetPsiUtil.safeDeparenthesize(expression, false), actualType);
        Collection<JetType> variants = this.smartCastManager.getSmartCastVariantsExcludingReceiver(context, receiverToCast);
        for (JetType possibleType : variants) {
            if (!JetTypeChecker.DEFAULT.isSubtypeOf(possibleType, expectedType)) continue;
            return possibleType;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReceiverTypeError(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue((CallCandidateResolutionContext)$receiver2)) {
            CallCandidateResolutionContext $receiver3 = (CallCandidateResolutionContext)$receiver2;
            ReceiverParameterDescriptor extensionReceiver2 = this.getCandidateDescriptor($receiver3).getExtensionReceiverParameter();
            ReceiverParameterDescriptor dispatchReceiver = this.getCandidateDescriptor($receiver3).getDispatchReceiverParameter();
            Call call = $receiver.call;
            Intrinsics.checkExpressionValueIsNotNull(call, "call");
            if (!CallResolverUtilKt.isInvokeCallOnExpressionWithBothReceivers(call)) {
                ReceiverValue receiverValue = $receiver.candidateCall.getExtensionReceiver();
                Intrinsics.checkExpressionValueIsNotNull(receiverValue, "candidateCall.getExtensionReceiver()");
                this.checkReceiverTypeError($receiver3, extensionReceiver2, receiverValue);
            }
            ReceiverValue receiverValue = $receiver.candidateCall.getDispatchReceiver();
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "candidateCall.getDispatchReceiver()");
            this.checkReceiverTypeError($receiver3, dispatchReceiver, receiverValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReceiverTypeError(CallCandidateResolutionContext<?> $receiver, ReceiverParameterDescriptor receiverParameterDescriptor, ReceiverValue receiverArgument) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue((CallCandidateResolutionContext)$receiver2)) {
            ResolutionStatus resolutionStatus;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver2;
            MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
            if (receiverParameterDescriptor == null || !receiverArgument.exists()) {
                resolutionStatus = ResolutionStatus.SUCCESS;
            } else {
                void $receiver3;
                JetType erasedReceiverType = CallResolverUtilKt.getErasedReceiverType(receiverParameterDescriptor, this.getCandidateDescriptor($receiver3));
                resolutionStatus = !this.smartCastManager.isSubTypeBySmartCastIgnoringNullability(receiverArgument, erasedReceiverType, (ResolutionContext)$receiver3) ? ResolutionStatus.RECEIVER_TYPE_ERROR : ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    private final <D extends CallableDescriptor> ResolutionStatus checkReceivers(CallCandidateResolutionContext<D> context) {
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        MutableResolvedCall candidateCall = context.candidateCall;
        ResolvedCall resolvedCall = candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(resolvedCall, "candidateCall");
        ReceiverParameterDescriptor receiverParameterDescriptor = candidateCall.getResultingDescriptor().getExtensionReceiverParameter();
        ReceiverValue receiverValue = candidateCall.getExtensionReceiver();
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "candidateCall.getExtensionReceiver()");
        ResolutionStatus resolutionStatus = resultStatus.combine(this.checkReceiver(context, resolvedCall, receiverParameterDescriptor, receiverValue, candidateCall.getExplicitReceiverKind().isExtensionReceiver(), false));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus, "resultStatus.combine(con\u2026ensionReceiver(), false))");
        resultStatus = resolutionStatus;
        ResolvedCall resolvedCall2 = candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, "candidateCall");
        ReceiverParameterDescriptor receiverParameterDescriptor2 = candidateCall.getResultingDescriptor().getDispatchReceiverParameter();
        ReceiverValue receiverValue2 = candidateCall.getDispatchReceiver();
        Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "candidateCall.getDispatchReceiver()");
        ResolutionStatus resolutionStatus2 = resultStatus.combine(this.checkReceiver(context, resolvedCall2, receiverParameterDescriptor2, receiverValue2, candidateCall.getExplicitReceiverKind().isDispatchReceiver(), context.call instanceof CallTransformer.CallForImplicitInvoke));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus2, "resultStatus.combine(con\u2026s CallForImplicitInvoke))");
        resultStatus = resolutionStatus2;
        return resultStatus;
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> ResolutionStatus checkReceiver(CallCandidateResolutionContext<D> $receiver, ResolvedCall<D> candidateCall, ReceiverParameterDescriptor receiverParameter, ReceiverValue receiverArgument, boolean isExplicitReceiver, boolean implicitInvokeCheck) {
        void $receiver2;
        if (receiverParameter == null || !receiverArgument.exists()) {
            return ResolutionStatus.SUCCESS;
        }
        D candidateDescriptor = candidateCall.getCandidateDescriptor();
        if (TypeUtils.dependsOnTypeParameters(receiverParameter.getType(), (Collection<TypeParameterDescriptor>)candidateDescriptor.getTypeParameters())) {
            return ResolutionStatus.SUCCESS;
        }
        boolean safeAccess = isExplicitReceiver && !implicitInvokeCheck && CallUtilKt.isExplicitSafeCall(candidateCall.getCall());
        boolean isSubtypeBySmartCastIgnoringNullability = this.smartCastManager.isSubTypeBySmartCastIgnoringNullability(receiverArgument, receiverParameter.getType(), $receiver);
        if (!isSubtypeBySmartCastIgnoringNullability) {
            $receiver.tracing.wrongReceiverType($receiver.trace, receiverParameter, receiverArgument);
            return ResolutionStatus.OTHER_ERROR;
        }
        JetType expectedReceiverParameterType = safeAccess ? TypeUtils.makeNullable(receiverParameter.getType()) : receiverParameter.getType();
        boolean smartCastNeeded = !ArgumentTypeResolver.isSubtypeOfForArgumentType(receiverArgument.getType(), expectedReceiverParameterType);
        boolean reportUnsafeCall = false;
        if (smartCastNeeded) {
            ReceiverValue receiverValue = receiverArgument;
            if (!(receiverValue instanceof ExpressionReceiver)) {
                receiverValue = null;
            }
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
            JetExpression expression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverArgument, $receiver);
            SmartCastResult smartCastResult = this.smartCastManager.checkAndRecordPossibleCast(dataFlowValue, expectedReceiverParameterType, expression, $receiver, true);
            if (smartCastResult == null) {
                reportUnsafeCall = true;
            } else if (!smartCastResult.getIsCorrect()) {
                return ResolutionStatus.OTHER_ERROR;
            }
        }
        JetType receiverArgumentType = receiverArgument.getType();
        if (reportUnsafeCall) {
            $receiver.tracing.unsafeCall($receiver.trace, receiverArgumentType, implicitInvokeCheck);
            return ResolutionStatus.UNSAFE_CALL_ERROR;
        }
        BindingContext bindingContext = $receiver.trace.getBindingContext();
        DataFlowValue receiverValue = DataFlowValueFactory.createDataFlowValue(receiverArgument, bindingContext, $receiver.scope.getOwnerDescriptor());
        if (safeAccess && !$receiver.dataFlowInfo.getNullability(receiverValue).canBeNull()) {
            $receiver.tracing.unnecessarySafeCall($receiver.trace, receiverArgument.getType());
        }
        Iterable<? extends AdditionalTypeChecker> iterable = this.additionalTypeCheckers;
        for (Object element : $receiver2) {
            AdditionalTypeChecker it = (AdditionalTypeChecker)element;
            it.checkReceiver(receiverParameter, receiverArgument, safeAccess, (CallResolutionContext)$receiver);
        }
        return ResolutionStatus.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkGenericBoundsInAFunctionCall(List<? extends JetTypeProjection> jetTypeArguments, List<? extends JetType> typeArguments, CallableDescriptor functionDescriptor, TypeSubstitutor substitutor2, BindingTrace trace) {
        int n = 0;
        List<TypeParameterDescriptor> typeParameters = functionDescriptor.getTypeParameters();
        int n2 = Math.min(typeParameters.size(), jetTypeArguments.size()) - 1;
        if (n <= n2) {
            while (true) {
                void i;
                TypeParameterDescriptor typeParameterDescriptor = typeParameters.get((int)i);
                JetType typeArgument = typeArguments.get((int)i);
                JetTypeReference typeReference = jetTypeArguments.get((int)i).getTypeReference();
                if (typeReference != null) {
                    DescriptorResolver.checkBounds(typeReference, typeArgument, typeParameterDescriptor, substitutor2, trace);
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final <D extends CallableDescriptor> boolean shouldContinue(CallCandidateResolutionContext<D> $receiver) {
        return Intrinsics.areEqual((Object)$receiver.candidateResolveMode, (Object)CandidateResolveMode.FULLY) || $receiver.candidateCall.getStatus().possibleTransformToSuccess();
    }

    private final CallableDescriptor getCandidateDescriptor(CallCandidateResolutionContext<?> $receiver) {
        Object d = $receiver.candidateCall.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "candidateCall.getCandidateDescriptor()");
        return d;
    }

    public CandidateResolver(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull GenericCandidateResolver genericCandidateResolver, @NotNull ReflectionTypes reflectionTypes, @NotNull ModifiersChecker modifiersChecker, @NotNull Iterable<? extends AdditionalTypeChecker> additionalTypeCheckers, @NotNull SmartCastManager smartCastManager) {
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(genericCandidateResolver, "genericCandidateResolver");
        Intrinsics.checkParameterIsNotNull(reflectionTypes, "reflectionTypes");
        Intrinsics.checkParameterIsNotNull(modifiersChecker, "modifiersChecker");
        Intrinsics.checkParameterIsNotNull(additionalTypeCheckers, "additionalTypeCheckers");
        Intrinsics.checkParameterIsNotNull(smartCastManager, "smartCastManager");
        this.argumentTypeResolver = argumentTypeResolver;
        this.genericCandidateResolver = genericCandidateResolver;
        this.reflectionTypes = reflectionTypes;
        this.modifiersChecker = modifiersChecker;
        this.additionalTypeCheckers = additionalTypeCheckers;
        this.smartCastManager = smartCastManager;
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"X\u0004)ab+\u00197vK\u0006\u0013x-^7f]R\u001c8\t[3dW&twMU3tk2$(\"E\"b]\u0012LG-\u0019;f%\u0016\u001cx\u000e\u001c<fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u000b\r\fG\u000e\\:\u000b\u0007\u0005s\u0017P\u0003\u0004=S:LGO\u0010\u0006\u0007gR\fG/^:\u000b!I+7o\u001c7vi&|gn\u0015;biV\u001c(b\u0002:fgVdGo\u001d\u0006\u000eCJ<W/\\3oiRK\b/Z:\u000b\t1K7\u000f\u001e\u0006\b\u0015\u0016$H+\u001f9f\u0015\u0015!\u0018\u0010]3t\u0015\u0011Q\u0017M^1\u000b\tU$\u0018\u000e\u001c\u0006\u0011O\u0016$\u0018I]4v[\u0016tG\u000fV=qKNT\u0011bZ3u'R\fG/^:y\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0019AA\u0001E\u0001\u0019\u0001)1\u0001\"\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!9\u0001c\u0002\r\u0001\u0015\u0011AA\u0001E\u0006\u000b\r!I\u0001C\u0003\r\u0001\u0015\u0019Aq\u0001E\u0007\u0019\u0001)!\u0001B\u0001\t\u0010\u0015\u0019AA\u0002\u0005\b\u0019\u0001)!\u0001\u0002\u0002\t\u0002\u0015\u0011A\u0011\u0002\u0005\u0006\u000b\u0005A\u0001\"\u0002\u0002\u0005\u0011!EQA\u0001C\t\u0011\u001b!1I\u0001\u0007\u00043\r)\u0011\u0001\u0003\u0003\u0019\t5*Ba\u0019\u0003\u0019\r\u0005BQ!\u0001E\u0006\u0013\u0011I1!B\u0001\t\u000ea5\u00014B+\u0004\u0011\u0015\u0019AAB\u0005\u0002\u0011%i1\u0001B\u0005\n\u0003!IQ\u0006\u0005\u0003d\ta%\u0011eA\u0003\u0002\u0011\u0015AR!V\u0002\t\u000b\r!I!C\u0001\t\u00105\u0019A1C\u0005\u0002\u0011\u001f)\u0004&B\u0014\u0005G\u0004AB!h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011\u0015AR\u0001UB\u0001;3!\u0001\u0001\u0003\u0004\u000e\u0011\u0015\t\u00012B\u0005\u0005\u0013\r)\u0011\u0001#\u0004\u0019\u000ea-\u0001kA\u0001\"\u0007\u0015\t\u0001b\u0001\r\u0004#\u000eIA\u0001B\u0005\u0002\t\u0001i\u0011\u0001C\u0004\u000e\u0003!=Q\"\u0001\u0005\n"})
    public final class ValueArgumentsCheckingResult {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final ResolutionStatus status;
        @NotNull
        private final List<? extends JetType> argumentTypes;

        static {
            $kotlinClass = Reflection.createKotlinClass(ValueArgumentsCheckingResult.class);
        }

        @NotNull
        public final ResolutionStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final List<JetType> getArgumentTypes() {
            return this.argumentTypes;
        }

        public ValueArgumentsCheckingResult(@NotNull ResolutionStatus status, @NotNull List<? extends JetType> argumentTypes) {
            Intrinsics.checkParameterIsNotNull((Object)status, "status");
            Intrinsics.checkParameterIsNotNull(argumentTypes, "argumentTypes");
            this.status = status;
            this.argumentTypes = argumentTypes;
        }
    }
}

