/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant$$TImpl;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={")\b)A\u0012J\u001c;fO\u0016\u0014h+\u00197vKRK\b/Z\"p]N$\u0018M\u001c;\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TqA]3t_24XMC\u0005d_:\u001cH/\u00198ug*\u00192i\\7qS2,G+[7f\u0007>t7\u000f^1oi*1a*^7cKJTa\u0001P5oSRt$\"\u0002<bYV,'\u0002\u00032vS2$\u0018J\\:\u000b\u001d-{G\u000f\\5o\u0005VLG\u000e^%og*A!-^5mi&t7O\u0003\u0006qCJ\fW.\u001a;feNT!\u0002U1sC6,G/\u001a:t\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u001f\u0007>l\u0007/\u001b7f)&lWmQ8ogR\fg\u000e\u001e\u0013QCJ\fW.\u001a;feNTQbZ3u!\u0006\u0014\u0018-\\3uKJ\u001c(b\u0004;za\u0016\u001cuN\\:ueV\u001cGo\u001c:\u000b7%sG/Z4feZ\u000bG.^3UsB,7i\u001c8tiJ,8\r^8s\u0015I)hn\u001b8po:Le\u000e^3hKJ$\u0016\u0010]3\u000b\u0017)+G\u000fV=qK&k\u0007\u000f\u001c\u0006\u0006if\u0004Xm\u001d\u0006\u0016O\u0016$XK\\6o_^t\u0017J\u001c;fO\u0016\u0014H+\u001f9f\u0015\u001d9W\r\u001e+za\u0016TA\"\u001a=qK\u000e$X\r\u001a+za\u0016TqAS3u)f\u0004XMC\bu_\u000e{gn\u001d;b]R4\u0016\r\\;f\u00155\u0019uN\\:uC:$h+\u00197vK*AAo\\*ue&twM\u0003\u0004TiJLgn\u001a\\\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)1\u0001\u0002\u0002\t\u00071\u0001Q!\u0001E\u0002\u000b\r!9\u0001c\u0002\r\u0001\u0015\u0011A!\u0001\u0005\u0007\u000b\r!I\u0001c\u0003\r\u0001\u0015\u0019Aa\u0001\u0005\b\u0019\u0001)\u0011\u0001c\u0004\u0006\u0005\u00111\u0001\u0002C\u0003\u0003\t\u001bA9!\u0002\u0002\u0005\n!-QA\u0001\u0003\u0003\u0011#)1\u0001\u0002\u0002\t\u00151\u0001QA\u0001\u0003\u0003\u0011))!\u0001B\u0001\t\u0018\u0015\u0019A1\u0003\u0005\f\u0019\u0001)!\u0001b\u0005\t\u0017\u0015\u0019A1\u0003E\u000e\u0019\u0001)!\u0001b\u0005\t\u001c\u0015\u0019AA\u0001E\u000f\u0019\u0001)!\u0001\u0002\u0002\t\u001e\u0015\u0019Aq\u0001E\u0010\u0019\u0001)!\u0001\"\u0004\t \u0011\u0019ARA\r\t\u000b\u0005A1!\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0002\r\u00051\riC\u0002B1\u00051\u0015\t3!B\u0001\t\u000ba)Qk\u0001\u0003\u0006\u0007\u0011)\u0011\"\u0001E\b[A!1\u000e\u0002M\u0007C\r)\u0011\u0001c\u0003\u0019\fU\u001b\u0001\"B\u0002\u0005\u000e%\t\u0001\u0002C\u0007\u0004\t%I\u0011\u0001\u0003\u0005.\u0019\u0011\tG\u0001g\u0005\"\u0007\u0015\t\u0001\u0012\u0003M\t+\u000e!Qa\u0001C\n\u0013\u0005A\u0011\"\f\t\u0005G\u0012A*\"I\u0002\u0006\u0003!Q\u0001DC+\u0004\u0011\u0015\u0019AQC\u0005\u0002\u0011+i1\u0001\u0002\u0007\n\u0003!UQ\u0006\u0004\u0003b\ta%\u0011eA\u0003\u0002\u0011\u0011AB!V\u0002\u0005\u000b\r!I!C\u0001\t\u000f5*Ba\u0001M\r;\u001f!\u0001\u0001C\u0007\u000e\u0007\u0015\t\u0001b\u0003\r\f!\u000e\u0001\u0011eA\u0003\u0002\u0011-A2\"U\u0002\u0006\t3I\u0011\u0001c\u0006\u000e\u0003!]QF\u0007\u0003\f19iz\u0001\u0002\u0001\t\u001b5\u0019Q!\u0001\u0005\f1-\u00016\u0001A\u0011\t\u000b\u0005AA\"\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0002\r\u000511\t6!\u0002\u0003\u000f\u0013\u0005AI\"D\u0001\t\u00185VAa\u0003\r\u0010C\r)\u0011\u0001C\u0007\u0019\u001bE\u001b1\u0001B\b\n\u0003!mQwKC+\t\r\b\u0001\u0004BO\b\t\u0001AI!D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0001u=A\u0001\u0001\u0005\u0006\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\t!h\u0004\u0005\u0001!5QbA\u0003\u0002\u0011\u0017AZ\u0001U\u0002\u0002C\r)\u0011\u0001#\u0002\u0019\u0006E\u001b\u0011\u0002\u0002\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\b\u001b\u0005Ay!D\u0001\t\u0011\u0001"})
public final class IntegerValueTypeConstant
implements CompileTimeConstant<Number> {
    public static final /* synthetic */ KClass $kotlinClass;
    private final IntegerValueTypeConstructor typeConstructor;
    @NotNull
    private final JetTypeImpl unknownIntegerType;
    private final Number value;
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;

    static {
        $kotlinClass = Reflection.createKotlinClass(IntegerValueTypeConstant.class);
    }

    @Override
    @NotNull
    public ConstantValue<Number> toConstantValue(@NotNull JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        ConstantValueFactory factory = new ConstantValueFactory(this.builtIns);
        JetType type2 = this.getType(expectedType);
        return KotlinBuiltIns.isInt(type2) ? (IntegerValueConstant)factory.createIntValue(this.value.intValue()) : (KotlinBuiltIns.isByte(type2) ? (IntegerValueConstant)factory.createByteValue(this.value.byteValue()) : (KotlinBuiltIns.isShort(type2) ? (IntegerValueConstant)factory.createShortValue(this.value.shortValue()) : (IntegerValueConstant)factory.createLongValue(this.value.longValue())));
    }

    @NotNull
    public final JetTypeImpl getUnknownIntegerType() {
        return this.unknownIntegerType;
    }

    @NotNull
    public final JetType getType(@NotNull JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        JetType jetType = TypeUtils.getPrimitiveNumberType(this.typeConstructor, expectedType);
        Intrinsics.checkExpressionValueIsNotNull(jetType, "TypeUtils.getPrimitiveNu\u2026onstructor, expectedType)");
        return jetType;
    }

    @NotNull
    public String toString() {
        return this.typeConstructor.toString();
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    public IntegerValueTypeConstant(@NotNull Number value, @NotNull KotlinBuiltIns builtIns, @NotNull CompileTimeConstant.Parameters parameters2) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        this.value = value;
        this.builtIns = builtIns;
        this.parameters = parameters2;
        this.typeConstructor = new IntegerValueTypeConstructor(this.value.longValue(), this.builtIns);
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        TypeConstructor typeConstructor2 = this.typeConstructor;
        List list = CollectionsKt.emptyList();
        JetScope jetScope = ErrorUtils.createErrorScope("Scope for number value type (" + this.typeConstructor.toString() + ")", true);
        Intrinsics.checkExpressionValueIsNotNull(jetScope, "ErrorUtils.createErrorSc\u2026r.toString() + \")\", true)");
        this.unknownIntegerType = JetTypeImpl.Companion.create(annotations2, typeConstructor2, false, list, jetScope);
    }

    @Override
    public boolean getIsPure() {
        return CompileTimeConstant$$TImpl.getIsPure(this);
    }

    @Override
    public boolean getUsesVariableAsConstant() {
        return CompileTimeConstant$$TImpl.getUsesVariableAsConstant(this);
    }

    @Override
    public boolean getIsError() {
        return CompileTimeConstant$$TImpl.getIsError(this);
    }

    @Override
    @NotNull
    public Number getValue(@NotNull JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        return (Number)CompileTimeConstant$$TImpl.getValue(this, expectedType);
    }

    @Override
    public boolean getCanBeUsedInAnnotations() {
        return CompileTimeConstant$$TImpl.getCanBeUsedInAnnotations(this);
    }

    @Override
    public boolean getUsesNonConstValAsConstant() {
        return CompileTimeConstant$$TImpl.getUsesNonConstValAsConstant(this);
    }
}

