/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.context.ContextPackage;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleParameters;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.PackagePartProvider;
import org.jetbrains.kotlin.frontend.java.di.ContainerForTopDownAnalyzerForJvm;
import org.jetbrains.kotlin.frontend.java.di.DiPackage;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackagePartProvider;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.modules.ModulesPackage;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.jvm.JvmAnalyzerFacade;
import org.jetbrains.kotlin.resolve.jvm.extensions.AnalysisCompletedHandlerExtension;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;

public enum TopDownAnalyzerFacadeForJVM {
    INSTANCE;

    public static final List<ImportPath> DEFAULT_IMPORTS;
    public static ModuleParameters JVM_MODULE_PARAMETERS;

    private static void addAllClassifiersToImportPathList(List<ImportPath> list, JetScope scope2) {
        for (DeclarationDescriptor descriptor : scope2.getDescriptors(DescriptorKindFilter.CLASSIFIERS, JetScope.ALL_NAME_FILTER)) {
            list.add(new ImportPath(DescriptorUtils.getFqNameSafe(descriptor), false));
        }
    }

    private static List<ImportPath> buildDefaultImports() {
        ArrayList<ImportPath> list = new ArrayList<ImportPath>();
        list.add(new ImportPath("java.lang.*"));
        list.add(new ImportPath("kotlin.*"));
        list.add(new ImportPath("kotlin.annotation.*"));
        list.add(new ImportPath("kotlin.jvm.*"));
        list.add(new ImportPath("kotlin.io.*"));
        TopDownAnalyzerFacadeForJVM.addAllClassifiersToImportPathList(list, KotlinBuiltIns.getInstance().getBuiltInsPackageScope());
        TopDownAnalyzerFacadeForJVM.addAllClassifiersToImportPathList(list, KotlinBuiltIns.getInstance().getAnnotationPackageScope());
        return list;
    }

    @NotNull
    public static AnalysisResult analyzeFilesWithJavaIntegrationNoIncremental(@NotNull ModuleContext moduleContext, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull TopDownAnalysisMode topDownAnalysisMode, PackagePartProvider packagePartProvider) {
        if (moduleContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleContext", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        if (topDownAnalysisMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisMode", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(moduleContext, files, trace, topDownAnalysisMode, null, null, packagePartProvider);
        if (analysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        return analysisResult;
    }

    @NotNull
    public static AnalysisResult analyzeFilesWithJavaIntegrationWithCustomContext(@NotNull ModuleContext moduleContext, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @Nullable List<Module> modules, @Nullable IncrementalCompilationComponents incrementalCompilationComponents, @NotNull PackagePartProvider packagePartProvider) {
        if (moduleContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleContext", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (packagePartProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePartProvider", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(moduleContext, files, trace, TopDownAnalysisMode.TopLevelDeclarations, modules, incrementalCompilationComponents, packagePartProvider);
        if (analysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        return analysisResult;
    }

    @NotNull
    private static AnalysisResult analyzeFilesWithJavaIntegration(@NotNull ModuleContext moduleContext, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull TopDownAnalysisMode topDownAnalysisMode, @Nullable List<Module> modules, @Nullable IncrementalCompilationComponents incrementalCompilationComponents, @NotNull PackagePartProvider packagePartProvider) {
        if (moduleContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleContext", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (topDownAnalysisMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisMode", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        if (packagePartProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePartProvider", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        Project project = moduleContext.getProject();
        List<JetFile> allFiles = JvmAnalyzerFacade.getAllFilesToAnalyze(project, null, files);
        FileBasedDeclarationProviderFactory providerFactory = new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), allFiles);
        LookupTracker lookupTracker = incrementalCompilationComponents != null ? incrementalCompilationComponents.getLookupTracker() : LookupTracker.DO_NOTHING;
        ArrayList<TargetId> targetIds = null;
        if (modules != null) {
            targetIds = new ArrayList<TargetId>(modules.size());
            for (Module module : modules) {
                targetIds.add(ModulesPackage.TargetId(module));
            }
        }
        packagePartProvider = IncrementalPackagePartProvider.create(packagePartProvider, files, targetIds, incrementalCompilationComponents, moduleContext.getStorageManager());
        ContainerForTopDownAnalyzerForJvm container = DiPackage.createContainerForTopDownAnalyzerForJvm(moduleContext, trace, providerFactory, GlobalSearchScope.allScope(project), lookupTracker, packagePartProvider);
        ArrayList<PackageFragmentProvider> additionalProviders = new ArrayList<PackageFragmentProvider>();
        if (targetIds != null && incrementalCompilationComponents != null) {
            for (TargetId targetId : targetIds) {
                IncrementalCache incrementalCache = incrementalCompilationComponents.getIncrementalCache(targetId);
                additionalProviders.add(new IncrementalPackageFragmentProvider(files, moduleContext.getModule(), moduleContext.getStorageManager(), container.getDeserializationComponentsForJava().getComponents(), incrementalCache, targetId));
            }
        }
        additionalProviders.add(container.getJavaDescriptorResolver().getPackageFragmentProvider());
        container.getLazyTopDownAnalyzerForTopLevel().analyzeFiles(topDownAnalysisMode, allFiles, additionalProviders);
        BindingContext bindingContext = trace.getBindingContext();
        ModuleDescriptor module = moduleContext.getModule();
        Collection analysisCompletedHandlerExtensions = AnalysisCompletedHandlerExtension.Companion.getInstances(moduleContext.getProject());
        for (AnalysisCompletedHandlerExtension extension : analysisCompletedHandlerExtensions) {
            AnalysisResult result2 = extension.analysisCompleted(project, module, bindingContext, files);
            if (result2 == null) continue;
            AnalysisResult analysisResult = result2;
            if (analysisResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
            }
            return analysisResult;
        }
        AnalysisResult analysisResult = AnalysisResult.success(bindingContext, module);
        if (analysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        return analysisResult;
    }

    @NotNull
    public static MutableModuleContext createContextWithSealedModule(@NotNull Project project, @NotNull String moduleName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "createContextWithSealedModule"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "createContextWithSealedModule"));
        }
        MutableModuleContext context = ContextPackage.ContextForNewModule(project, Name.special("<" + moduleName + ">"), JVM_MODULE_PARAMETERS);
        context.setDependencies(context.getModule(), KotlinBuiltIns.getInstance().getBuiltInsModule());
        MutableModuleContext mutableModuleContext = context;
        if (mutableModuleContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "createContextWithSealedModule"));
        }
        return mutableModuleContext;
    }

    static {
        DEFAULT_IMPORTS = TopDownAnalyzerFacadeForJVM.buildDefaultImports();
        JVM_MODULE_PARAMETERS = new ModuleParameters(){

            @Override
            @NotNull
            public List<ImportPath> getDefaultImports() {
                List<ImportPath> list = DEFAULT_IMPORTS;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM$1", "getDefaultImports"));
                }
                return list;
            }

            @Override
            @NotNull
            public PlatformToKotlinClassMap getPlatformToKotlinClassMap() {
                JavaToKotlinClassMap javaToKotlinClassMap = JavaToKotlinClassMap.INSTANCE;
                if (javaToKotlinClassMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM$1", "getPlatformToKotlinClassMap"));
                }
                return javaToKotlinClassMap;
            }
        };
    }
}

