/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypesPackage;

public class ForceResolveUtil {
    private static final Logger LOG = Logger.getInstance(ForceResolveUtil.class);

    private ForceResolveUtil() {
    }

    public static <T> T forceResolveAllContents(@NotNull T descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        ForceResolveUtil.doForceResolveAllContents(descriptor);
        return descriptor;
    }

    public static void forceResolveAllContents(@NotNull JetScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        ForceResolveUtil.forceResolveAllContents(scope2.getAllDescriptors());
    }

    public static void forceResolveAllContents(@NotNull Iterable<? extends DeclarationDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            ForceResolveUtil.forceResolveAllContents(declarationDescriptor);
        }
    }

    public static void forceResolveAllContents(@NotNull Collection<JetType> types2) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        for (JetType type2 : types2) {
            ForceResolveUtil.forceResolveAllContents(type2);
        }
    }

    public static void forceResolveAllContents(@NotNull TypeConstructor typeConstructor2) {
        if (typeConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/kotlin/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        ForceResolveUtil.doForceResolveAllContents(typeConstructor2);
    }

    public static void forceResolveAllContents(@NotNull Annotations annotations2) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        ForceResolveUtil.doForceResolveAllContents(annotations2);
        for (AnnotationWithTarget annotationWithTarget : annotations2.getAllAnnotations()) {
            ForceResolveUtil.doForceResolveAllContents(annotationWithTarget.getAnnotation());
        }
    }

    private static void doForceResolveAllContents(Object object) {
        if (object instanceof LazyEntity) {
            LazyEntity lazyEntity = (LazyEntity)object;
            lazyEntity.forceResolveAllContents();
        } else if (object instanceof CallableDescriptor) {
            CallableDescriptor callableDescriptor = (CallableDescriptor)object;
            ReceiverParameterDescriptor parameter = callableDescriptor.getExtensionReceiverParameter();
            if (parameter != null) {
                ForceResolveUtil.forceResolveAllContents(parameter.getType());
            }
            for (ValueParameterDescriptor parameterDescriptor : callableDescriptor.getValueParameters()) {
                ForceResolveUtil.forceResolveAllContents(parameterDescriptor);
            }
            for (TypeParameterDescriptor typeParameterDescriptor : callableDescriptor.getTypeParameters()) {
                ForceResolveUtil.forceResolveAllContents(typeParameterDescriptor.getUpperBounds());
            }
            ForceResolveUtil.forceResolveAllContents(callableDescriptor.getReturnType());
            ForceResolveUtil.forceResolveAllContents(callableDescriptor.getAnnotations());
        }
    }

    @Nullable
    public static JetType forceResolveAllContents(@Nullable JetType type2) {
        if (type2 == null) {
            return null;
        }
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        if (TypesPackage.isFlexible(type2)) {
            ForceResolveUtil.forceResolveAllContents(TypesPackage.flexibility(type2).getLowerBound());
            ForceResolveUtil.forceResolveAllContents(TypesPackage.flexibility(type2).getUpperBound());
        } else {
            ForceResolveUtil.forceResolveAllContents(type2.getConstructor());
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                ForceResolveUtil.forceResolveAllContents(projection.getType());
            }
        }
        return type2;
    }
}

