/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.StringsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.JetTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionTypes {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final String KCALLABLE_CLASS_NAME = "KCallable";
    private final Lazy<? extends JetScope> kotlinReflectScope$delegate;
    @NotNull
    private final ClassLookup kClass$delegate;
    @NotNull
    private final ClassLookup kProperty0$delegate;
    @NotNull
    private final ClassLookup kProperty1$delegate;
    @NotNull
    private final ClassLookup kProperty2$delegate;
    @NotNull
    private final ClassLookup kMutableProperty0$delegate;
    @NotNull
    private final ClassLookup kMutableProperty1$delegate;
    private final ModuleDescriptor module;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(ReflectionTypes.class);
        Companion companion = Companion = new Companion(null);
        KCALLABLE_CLASS_NAME = KCALLABLE_CLASS_NAME;
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("kotlinReflectScope"), new PropertyMetadataImpl("kClass"), new PropertyMetadataImpl("kProperty0"), new PropertyMetadataImpl("kProperty1"), new PropertyMetadataImpl("kProperty2"), new PropertyMetadataImpl("kMutableProperty0"), new PropertyMetadataImpl("kMutableProperty1")};
    }

    private final JetScope getKotlinReflectScope() {
        return LazyKt.get(this.kotlinReflectScope$delegate, this, $propertyMetadata[0]);
    }

    @NotNull
    public final ClassDescriptor find(@NotNull String className) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull(className, "className");
        Name name = Name.identifier(className);
        JetScope jetScope = this.getKotlinReflectScope();
        Name name2 = name;
        Intrinsics.checkExpressionValueIsNotNull(name2, "name");
        ClassifierDescriptor classifierDescriptor = jetScope.getClassifier(name2, NoLookupLocation.FROM_REFLECTION);
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        if ((classDescriptor = (ClassDescriptor)classifierDescriptor) == null) {
            ClassDescriptor classDescriptor2 = ErrorUtils.createErrorClass(ReflectionTypesKt.getKOTLIN_REFLECT_FQ_NAME().child(name).asString());
            classDescriptor = classDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "ErrorUtils.createErrorCl\u2026E.child(name).asString())");
        }
        return classDescriptor;
    }

    @NotNull
    public final ClassDescriptor getKFunction(int n) {
        return this.find("KFunction" + n);
    }

    @NotNull
    public final ClassDescriptor getkClass() {
        return this.kClass$delegate.get(this, $propertyMetadata[1]);
    }

    @NotNull
    public final ClassDescriptor getkProperty0() {
        return this.kProperty0$delegate.get(this, $propertyMetadata[2]);
    }

    @NotNull
    public final ClassDescriptor getkProperty1() {
        return this.kProperty1$delegate.get(this, $propertyMetadata[3]);
    }

    @NotNull
    public final ClassDescriptor getkProperty2() {
        return this.kProperty2$delegate.get(this, $propertyMetadata[4]);
    }

    @NotNull
    public final ClassDescriptor getkMutableProperty0() {
        return this.kMutableProperty0$delegate.get(this, $propertyMetadata[5]);
    }

    @NotNull
    public final ClassDescriptor getkMutableProperty1() {
        return this.kMutableProperty1$delegate.get(this, $propertyMetadata[6]);
    }

    @NotNull
    public final JetType getKClassType(@NotNull Annotations annotations2, @NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        ClassDescriptor descriptor2 = this.getkClass();
        if (ErrorUtils.isError(descriptor2)) {
            JetType jetType = descriptor2.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(jetType, "descriptor.getDefaultType()");
            return jetType;
        }
        List<TypeProjectionImpl> arguments2 = CollectionsKt.listOf(new TypeProjectionImpl(Variance.INVARIANT, type2));
        return JetTypeImpl.Companion.create(annotations2, descriptor2, false, arguments2);
    }

    @NotNull
    public final JetType getKFunctionType(@NotNull Annotations annotations2, @Nullable JetType receiverType, @NotNull List<? extends JetType> parameterTypes, @NotNull JetType returnType2) {
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(parameterTypes, "parameterTypes");
        Intrinsics.checkParameterIsNotNull(returnType2, "returnType");
        List<TypeProjection> arguments2 = KotlinBuiltIns.getFunctionTypeArgumentProjections(receiverType, parameterTypes, returnType2);
        ClassDescriptor classDescriptor = this.getKFunction(arguments2.size() - 1);
        if (ErrorUtils.isError(classDescriptor)) {
            JetType jetType = classDescriptor.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(jetType, "classDescriptor.getDefaultType()");
            return jetType;
        }
        List<TypeProjection> list = arguments2;
        Intrinsics.checkExpressionValueIsNotNull(list, "arguments");
        return JetTypeImpl.Companion.create(annotations2, classDescriptor, false, list);
    }

    @NotNull
    public final JetType getKPropertyType(@NotNull Annotations annotations2, @Nullable JetType receiverType, @NotNull JetType returnType2, boolean mutable) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(returnType2, "returnType");
        ClassDescriptor classDescriptor2 = receiverType != null ? (mutable ? this.getkMutableProperty1() : this.getkProperty1()) : (classDescriptor = mutable ? this.getkMutableProperty0() : this.getkProperty0());
        if (ErrorUtils.isError(classDescriptor)) {
            JetType jetType = classDescriptor.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(jetType, "classDescriptor.getDefaultType()");
            return jetType;
        }
        ArrayList<TypeProjectionImpl> arguments2 = new ArrayList<TypeProjectionImpl>(2);
        if (receiverType != null) {
            arguments2.add(new TypeProjectionImpl(receiverType));
        }
        arguments2.add(new TypeProjectionImpl(returnType2));
        return JetTypeImpl.Companion.create(annotations2, classDescriptor, false, (List<? extends TypeProjection>)arguments2);
    }

    public ReflectionTypes(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        this.module = module;
        this.kotlinReflectScope$delegate = LazyKt.lazy((Function0)new Function0<JetScope>(this){
            final /* synthetic */ ReflectionTypes this$0;

            @NotNull
            public final JetScope invoke() {
                return ReflectionTypes.access$getModule$1(this.this$0).getPackage(ReflectionTypesKt.getKOTLIN_REFLECT_FQ_NAME()).getMemberScope();
            }
            {
                this.this$0 = reflectionTypes;
                super(0);
            }
        });
        this.kClass$delegate = ClassLookup.INSTANCE$;
        this.kProperty0$delegate = ClassLookup.INSTANCE$;
        this.kProperty1$delegate = ClassLookup.INSTANCE$;
        this.kProperty2$delegate = ClassLookup.INSTANCE$;
        this.kMutableProperty0$delegate = ClassLookup.INSTANCE$;
        this.kMutableProperty1$delegate = ClassLookup.INSTANCE$;
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModule$1(ReflectionTypes $this) {
        return $this.module;
    }

    private static final class ClassLookup {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final ClassLookup INSTANCE$;

        static {
            $kotlinClass = Reflection.createKotlinClass(ClassLookup.class);
            new ClassLookup();
        }

        @NotNull
        public final ClassDescriptor get(@NotNull ReflectionTypes types, @NotNull PropertyMetadata property) {
            Intrinsics.checkParameterIsNotNull(types, "types");
            Intrinsics.checkParameterIsNotNull(property, "property");
            return types.find(StringsKt.capitalize(property.getName()));
        }

        ClassLookup() {
            INSTANCE$ = this;
        }
    }

    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        public final boolean isReflectionClass(@NotNull ClassDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            PackageFragmentDescriptor containingPackage = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class);
            return containingPackage != null && Intrinsics.areEqual(containingPackage.getFqName(), ReflectionTypesKt.getKOTLIN_REFLECT_FQ_NAME());
        }

        private final String getKCALLABLE_CLASS_NAME() {
            return KCALLABLE_CLASS_NAME;
        }

        public final boolean isCallableType(@NotNull JetType type2) {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            return KotlinBuiltIns.isFunctionOrExtensionFunctionType(type2) || this.isCallableReflectionType(type2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isCallableReflectionType(@NotNull JetType type2) {
            JetType jetType;
            Intrinsics.checkParameterIsNotNull(type2, "type");
            if (this.isExactCallableReflectionType(type2)) return true;
            Iterable $receiver = type2.getConstructor().getSupertypes();
            Iterator iterator2 = $receiver.iterator();
            do {
                JetType it;
                if (!iterator2.hasNext()) return false;
                Object element = iterator2.next();
                jetType = it = (JetType)element;
                Intrinsics.checkExpressionValueIsNotNull(jetType, "it");
            } while (!Companion.isCallableReflectionType(jetType));
            return true;
        }

        public final boolean isExactCallableReflectionType(@NotNull JetType type2) {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (descriptor2 instanceof ClassDescriptor) {
                FqNameUnsafe fqName2 = DescriptorUtils.getFqName(descriptor2);
                String parentName = fqName2.parent().asString();
                if (Intrinsics.areEqual(parentName, ReflectionTypesKt.getKOTLIN_REFLECT_FQ_NAME().asString()) ^ true) {
                    return false;
                }
                String shortName = fqName2.shortName().asString();
                return Intrinsics.areEqual(this.getKCALLABLE_CLASS_NAME(), shortName);
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

