/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.reflect.IllegalCallableAccessException;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KotlinReflectionInternalError;
import kotlin.reflect.jvm.JvmPackage;
import kotlin.reflect.jvm.internal.FunctionCaller;
import kotlin.reflect.jvm.internal.KAnnotatedElementImpl$$TImpl;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KParameterImpl;
import kotlin.reflect.jvm.internal.KTypeImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinSyntheticClass(version={0, 25, 0}, abiVersion=25, kind=KotlinSyntheticClass.Kind.TRAIT_IMPL)
public final class KCallableImpl$$TImpl {
    @NotNull
    public static Annotated getAnnotated(KCallableImpl<? extends R> $this) {
        return $this.getDescriptor();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static List<KParameter> getParameters(KCallableImpl<? extends R> $this) {
        int n;
        CallableMemberDescriptor descriptor2 = $this.getDescriptor();
        ArrayList<KParameterImpl> result = new ArrayList<KParameterImpl>();
        int index = 0;
        if (descriptor2.getDispatchReceiverParameter() != null) {
            result.add(new KParameterImpl($this, index++, KParameter.Kind.INSTANCE, (Function0<? extends ParameterDescriptor>)new Function0<ReceiverParameterDescriptor>(descriptor2){
                final /* synthetic */ CallableMemberDescriptor $descriptor;

                @NotNull
                public final ReceiverParameterDescriptor invoke() {
                    ReceiverParameterDescriptor receiverParameterDescriptor = this.$descriptor.getDispatchReceiverParameter();
                    if (receiverParameterDescriptor == null) {
                        Intrinsics.throwNpe();
                    }
                    return receiverParameterDescriptor;
                }
                {
                    this.$descriptor = callableMemberDescriptor;
                    super(0);
                }
            }));
        }
        if (descriptor2.getExtensionReceiverParameter() != null) {
            result.add(new KParameterImpl($this, index++, KParameter.Kind.EXTENSION_RECEIVER, (Function0<? extends ParameterDescriptor>)new Function0<ReceiverParameterDescriptor>(descriptor2){
                final /* synthetic */ CallableMemberDescriptor $descriptor;

                @NotNull
                public final ReceiverParameterDescriptor invoke() {
                    ReceiverParameterDescriptor receiverParameterDescriptor = this.$descriptor.getExtensionReceiverParameter();
                    if (receiverParameterDescriptor == null) {
                        Intrinsics.throwNpe();
                    }
                    return receiverParameterDescriptor;
                }
                {
                    this.$descriptor = callableMemberDescriptor;
                    super(0);
                }
            }));
        }
        IntRange intRange = CollectionsKt.getIndices((Collection)descriptor2.getValueParameters());
        int n2 = ((Number)intRange.getStart()).intValue();
        if (n2 <= (n = ((Number)intRange.getEnd()).intValue())) {
            while (true) {
                void i;
                result.add(new KParameterImpl($this, index++, KParameter.Kind.VALUE, (Function0<? extends ParameterDescriptor>)new Function0<ValueParameterDescriptor>(descriptor2, (int)i){
                    final /* synthetic */ CallableMemberDescriptor $descriptor;
                    final /* synthetic */ int $i;

                    public final ValueParameterDescriptor invoke() {
                        ValueParameterDescriptor valueParameterDescriptor = this.$descriptor.getValueParameters().get(this.$i);
                        Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "descriptor.valueParameters[i]");
                        return valueParameterDescriptor;
                    }
                    {
                        this.$descriptor = callableMemberDescriptor;
                        this.$i = n;
                        super(0);
                    }
                }));
                if (i == n) break;
                ++i;
            }
        }
        result.trimToSize();
        return result;
    }

    @NotNull
    public static KType getReturnType(KCallableImpl<? extends R> $this) {
        JetType jetType = $this.getDescriptor().getReturnType();
        if (jetType == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(jetType, "descriptor.returnType!!");
        return new KTypeImpl(jetType, (Function0<? extends Type>)new Function0<Type>($this){
            final /* synthetic */ KCallableImpl this$0;

            @NotNull
            public final Type invoke() {
                return this.this$0.getCaller().getReturnType();
            }
            {
                this.this$0 = kCallableImpl;
                super(0);
            }
        });
    }

    public static R call(@NotNull KCallableImpl<? extends R> $this, Object ... args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        try {
            return $this.getCaller().call(args);
        }
        catch (IllegalAccessException e) {
            throw (Throwable)new IllegalCallableAccessException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static R callBy(@NotNull KCallableImpl<? extends R> $this, Map<KParameter, ? extends Object> args) {
        Object object;
        Collection thisCollection;
        Intrinsics.checkParameterIsNotNull(args, "args");
        List<KParameter> parameters2 = $this.getParameters();
        ArrayList<Object> arguments2 = new ArrayList<Object>(parameters2.size());
        int mask = 0;
        ArrayList<Integer> masks = new ArrayList<Integer>(1);
        int index = 0;
        for (KParameter kParameter : parameters2) {
            if (index != 0 && index % Integer.SIZE == 0) {
                masks.add(mask);
                mask = 0;
            }
            if (args.containsKey(kParameter)) {
                arguments2.add(args.get(kParameter));
            } else if (kParameter.getIsOptional()) {
                arguments2.add(KCallableImpl$$TImpl.defaultPrimitiveValue($this, JvmPackage.getJavaType(kParameter.getType())));
                mask |= 1 << index % Integer.SIZE;
            } else {
                throw (Throwable)new IllegalArgumentException("No argument provided for a required parameter: " + kParameter);
            }
            if (!Intrinsics.areEqual((Object)kParameter.getKind(), (Object)KParameter.Kind.VALUE)) continue;
            ++index;
        }
        if (mask == 0 && masks.isEmpty()) {
            Collection collection = arguments2;
            KCallableImpl kCallableImpl = $this;
            thisCollection = collection;
            Object[] objectArray = thisCollection.toArray(new Object[thisCollection.size()]);
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray2 = objectArray;
            return kCallableImpl.call(objectArray2);
        }
        masks.add(mask);
        FunctionCaller<?> functionCaller = $this.getDefaultCaller();
        if (functionCaller == null) {
            throw (Throwable)new KotlinReflectionInternalError("This callable does not support a default call: " + $this.getDescriptor());
        }
        FunctionCaller<?> functionCaller2 = functionCaller;
        arguments2.addAll((Collection)masks);
        if (functionCaller2 instanceof FunctionCaller.Constructor) {
            arguments2.add(null);
        }
        try {
            void $receiver;
            thisCollection = arguments2;
            FunctionCaller<?> functionCaller3 = functionCaller2;
            Collection thisCollection2 = (Collection)$receiver;
            Object[] objectArray = thisCollection2.toArray(new Object[thisCollection2.size()]);
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray3 = objectArray;
            object = functionCaller3.call(objectArray3);
        }
        catch (IllegalAccessException e) {
            throw (Throwable)new IllegalCallableAccessException(e);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    static Object defaultPrimitiveValue(@NotNull KCallableImpl<? extends R> $this, Type type2) {
        Comparable comparable;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        if (type2 instanceof Class && ((Class)type2).isPrimitive()) {
            Type type3 = type2;
            if (Intrinsics.areEqual(type3, Boolean.TYPE)) {
                comparable = Boolean.valueOf(false);
                return comparable;
            }
            if (Intrinsics.areEqual(type3, Character.TYPE)) {
                comparable = Character.valueOf((char)0);
                return comparable;
            }
            if (Intrinsics.areEqual(type3, Byte.TYPE)) {
                comparable = Byte.valueOf((byte)0);
                return comparable;
            }
            if (Intrinsics.areEqual(type3, Short.TYPE)) {
                comparable = Short.valueOf((short)0);
                return comparable;
            }
            if (Intrinsics.areEqual(type3, Integer.TYPE)) {
                comparable = Integer.valueOf(0);
                return comparable;
            }
            if (Intrinsics.areEqual(type3, Float.TYPE)) {
                comparable = Float.valueOf(0.0f);
                return comparable;
            }
            if (Intrinsics.areEqual(type3, Long.TYPE)) {
                comparable = Long.valueOf(0L);
                return comparable;
            }
            if (Intrinsics.areEqual(type3, Double.TYPE)) {
                comparable = Double.valueOf(0.0);
                return comparable;
            }
            if (!Intrinsics.areEqual(type3, Void.TYPE)) throw (Throwable)new UnsupportedOperationException("Unknown primitive: " + type2);
            throw (Throwable)new IllegalStateException("Parameter with void type is illegal");
        }
        comparable = null;
        return comparable;
    }

    @NotNull
    public static List<Annotation> getAnnotations(KCallableImpl<? extends R> $this) {
        return KAnnotatedElementImpl$$TImpl.getAnnotations($this);
    }
}

