/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationWithTarget;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilteredAnnotations
implements Annotations {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Annotations delegate;
    private final Function1<? super FqName, ? extends Boolean> fqNameFilter;

    static {
        $kotlinClass = Reflection.createKotlinClass(FilteredAnnotations.class);
    }

    @Override
    @Nullable
    public AnnotationDescriptor findAnnotation(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.fqNameFilter.invoke(fqName2) != false ? this.delegate.findAnnotation(fqName2) : (AnnotationDescriptor)null;
    }

    @Override
    @Nullable
    public AnnotationDescriptor findExternalAnnotation(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.fqNameFilter.invoke(fqName2) != false ? this.delegate.findExternalAnnotation(fqName2) : (AnnotationDescriptor)null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationWithTarget> getUseSiteTargetedAnnotations() {
        void var3_3;
        void $receiver;
        Iterable $receiver2 = this.delegate.getUseSiteTargetedAnnotations();
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            AnnotationWithTarget it = (AnnotationWithTarget)element;
            if (!this.shouldBeReturned(it.getAnnotation())) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationWithTarget> getAllAnnotations() {
        void var3_3;
        void $receiver;
        Iterable $receiver2 = this.delegate.getAllAnnotations();
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            AnnotationWithTarget it = (AnnotationWithTarget)element;
            if (!this.shouldBeReturned(it.getAnnotation())) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<AnnotationDescriptor> iterator() {
        void var3_3;
        void $receiver;
        Iterable $receiver2 = this.delegate;
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            AnnotationDescriptor it = (AnnotationDescriptor)element;
            if (!this.shouldBeReturned(it)) continue;
            destination.add(element);
        }
        return ((List)var3_3).iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldBeReturned(AnnotationDescriptor annotation) {
        ClassifierDescriptor descriptor2 = annotation.getType().getConstructor().getDeclarationDescriptor();
        if (descriptor2 == null) return false;
        FqNameUnsafe $receiver = DescriptorUtils.getFqName(descriptor2);
        FqNameUnsafe fqName2 = $receiver;
        if (!fqName2.isSafe()) return false;
        Function1<FqName, Boolean> function1 = this.fqNameFilter;
        FqName fqName3 = fqName2.toSafe();
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName.toSafe()");
        if (function1.invoke(fqName3) == false) return false;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public FilteredAnnotations(@NotNull Annotations delegate2, @NotNull Function1<? super FqName, ? extends Boolean> fqNameFilter) {
        Intrinsics.checkParameterIsNotNull(delegate2, "delegate");
        Intrinsics.checkParameterIsNotNull(fqNameFilter, "fqNameFilter");
        this.delegate = delegate2;
        this.fqNameFilter = fqNameFilter;
    }
}

