/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import javax.tools.JavaCompiler;
import org.gradle.api.JavaVersion;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.reflect.DirectInstantiator;

public class JdkTools {
    private static final String DEFAULT_COMPILER_IMPL_NAME = "com.sun.tools.javac.api.JavacTool";
    private static final AtomicReference<JdkTools> INSTANCE = new AtomicReference();
    private final ClassLoader isolatedToolsLoader;

    public static JdkTools current() {
        JdkTools jdkTools = INSTANCE.get();
        if (jdkTools == null) {
            INSTANCE.compareAndSet(null, new JdkTools(Jvm.current()));
            jdkTools = INSTANCE.get();
        }
        return jdkTools;
    }

    JdkTools(JavaInfo javaInfo) {
        DefaultClassLoaderFactory defaultClassLoaderFactory = new DefaultClassLoaderFactory();
        JavaVersion javaVersion = Jvm.current().getJavaVersion();
        FilteringClassLoader filteringClassLoader = defaultClassLoaderFactory.createSystemFilteringClassLoader();
        if (!javaVersion.isJava9Compatible()) {
            File toolsJar = javaInfo.getToolsJar();
            if (toolsJar == null) {
                throw new IllegalStateException("Could not find tools.jar");
            }
            DefaultClassPath defaultClassPath = new DefaultClassPath(toolsJar);
            this.isolatedToolsLoader = new MutableURLClassLoader((ClassLoader)filteringClassLoader, defaultClassPath.getAsURLs());
        } else {
            filteringClassLoader.allowPackage("com.sun.tools");
            this.isolatedToolsLoader = filteringClassLoader;
        }
    }

    public JavaCompiler getSystemJavaCompiler() {
        Class<?> compilerImplClass;
        try {
            compilerImplClass = this.isolatedToolsLoader.loadClass(DEFAULT_COMPILER_IMPL_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load class 'com.sun.tools.javac.api.JavacTool");
        }
        return DirectInstantiator.instantiate(compilerImplClass.asSubclass(JavaCompiler.class), new Object[0]);
    }
}

