/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.editors.strings.StringResourceEditor;
import com.android.tools.idea.editors.strings.StringResourceEditorProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class OpenStringResourceEditorAction
extends AnAction {
    public OpenStringResourceEditorAction() {
        super("Open Translations Editor", null, StringResourceEditor.ICON);
    }

    public void update(AnActionEvent e) {
        boolean show = false;
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        if (project != null && file != null) {
            show = StringResourceEditorProvider.canViewTranslations(project, file);
        }
        e.getPresentation().setVisible(show);
        e.getPresentation().setEnabled(show);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext context = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (project == null || file == null) {
            return;
        }
        StringResourceEditorProvider.openEditor(project, file);
    }
}

