/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.descriptors.IdDisplay;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibilityRenderTarget
implements IAndroidTarget {
    private final int myApiLevel;
    private final IAndroidTarget myDelegate;
    private final AndroidVersion myVersion;
    private final IAndroidTarget myRealTarget;

    public CompatibilityRenderTarget(@NotNull IAndroidTarget delegate, int apiLevel, @Nullable IAndroidTarget realTarget) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/android/tools/idea/rendering/multi/CompatibilityRenderTarget", "<init>"));
        }
        this.myDelegate = delegate;
        this.myApiLevel = apiLevel;
        this.myRealTarget = realTarget;
        this.myVersion = realTarget != null ? realTarget.getVersion() : new AndroidVersion(apiLevel, null);
    }

    @NotNull
    public IAndroidTarget getRenderTarget() {
        IAndroidTarget iAndroidTarget = this.myDelegate;
        if (iAndroidTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/CompatibilityRenderTarget", "getRenderTarget"));
        }
        return iAndroidTarget;
    }

    @Nullable
    public IAndroidTarget getRealTarget() {
        return this.myRealTarget;
    }

    public String getDescription() {
        return this.myDelegate.getDescription();
    }

    @NonNull
    public AndroidVersion getVersion() {
        return this.myVersion;
    }

    public String getVersionName() {
        String name = SdkVersionInfo.getAndroidName((int)this.myApiLevel);
        if (name == null) {
            name = Integer.toString(this.myApiLevel);
        }
        return name;
    }

    public String hashString() {
        return AndroidTargetHash.getPlatformHashString((AndroidVersion)this.myVersion);
    }

    public int compareTo(@NonNull IAndroidTarget other) {
        int delta = this.myApiLevel - other.getVersion().getApiLevel();
        if (delta != 0) {
            return delta;
        }
        return this.myDelegate.compareTo((Object)other);
    }

    public int getRevision() {
        return 1;
    }

    public String getPath(int pathId) {
        return this.myDelegate.getPath(pathId);
    }

    public File getFile(int pathId) {
        return this.myDelegate.getFile(pathId);
    }

    public String getLocation() {
        return this.myDelegate.getLocation();
    }

    public String getVendor() {
        return this.myDelegate.getVendor();
    }

    public String getName() {
        return this.myDelegate.getName();
    }

    public String getFullName() {
        return this.myDelegate.getFullName();
    }

    public String getClasspathName() {
        return this.myDelegate.getClasspathName();
    }

    public String getShortClasspathName() {
        return this.myDelegate.getShortClasspathName();
    }

    public boolean isPlatform() {
        return this.myDelegate.isPlatform();
    }

    public IAndroidTarget getParent() {
        return this.myDelegate.getParent();
    }

    public BuildToolInfo getBuildToolInfo() {
        return this.myDelegate.getBuildToolInfo();
    }

    @NonNull
    public List<String> getBootClasspath() {
        return this.myDelegate.getBootClasspath();
    }

    public boolean hasRenderingLibrary() {
        return this.myDelegate.hasRenderingLibrary();
    }

    @NonNull
    public File[] getSkins() {
        return this.myDelegate.getSkins();
    }

    @Nullable
    public File getDefaultSkin() {
        return this.myDelegate.getDefaultSkin();
    }

    public List<IAndroidTarget.OptionalLibrary> getOptionalLibraries() {
        return this.myDelegate.getOptionalLibraries();
    }

    public List<IAndroidTarget.OptionalLibrary> getAdditionalLibraries() {
        return this.myDelegate.getAdditionalLibraries();
    }

    public String[] getPlatformLibraries() {
        return this.myDelegate.getPlatformLibraries();
    }

    public String getProperty(String name) {
        return this.myDelegate.getProperty(name);
    }

    public Integer getProperty(String name, Integer defaultValue) {
        return this.myDelegate.getProperty(name, defaultValue);
    }

    public Boolean getProperty(String name, Boolean defaultValue) {
        return this.myDelegate.getProperty(name, defaultValue);
    }

    public Map<String, String> getProperties() {
        return this.myDelegate.getProperties();
    }

    public int getUsbVendorId() {
        return this.myDelegate.getUsbVendorId();
    }

    public ISystemImage[] getSystemImages() {
        return this.myDelegate.getSystemImages();
    }

    @Nullable
    public ISystemImage getSystemImage(@NonNull IdDisplay tag, @NonNull String abiType) {
        return this.myDelegate.getSystemImage(tag, abiType);
    }

    public boolean canRunOn(IAndroidTarget target) {
        return this.myDelegate.canRunOn(target);
    }
}

