/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.ast.Node;
import lombok.ast.Position;
import org.jetbrains.android.inspections.lint.IntellijLintUtils;
import org.jetbrains.android.inspections.lint.LombokPsiConverter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class LombokPsiParser
extends JavaParser {
    private final LintClient myClient;
    private AccessToken myLock;

    public LombokPsiParser(LintClient client) {
        this.myClient = client;
    }

    public void prepareJavaParse(@NonNull List<JavaContext> contexts) {
    }

    @Nullable
    public Node parseJava(@NonNull JavaContext context) {
        assert (this.myLock == null);
        this.myLock = ApplicationManager.getApplication().acquireReadActionLock();
        Node compilationUnit = this.parse(context);
        if (compilationUnit == null) {
            this.myLock.finish();
            this.myLock = null;
        }
        return compilationUnit;
    }

    public void dispose(@NonNull JavaContext context, @NonNull Node compilationUnit) {
        if (context.getCompilationUnit() != null) {
            this.myLock.finish();
            this.myLock = null;
            context.setCompilationUnit(null);
        }
    }

    @Nullable
    private Node parse(@NonNull JavaContext context) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        PsiFile psiFile = IntellijLintUtils.getPsiFile((Context)context);
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        try {
            return LombokPsiConverter.convert(javaFile);
        }
        catch (Throwable t) {
            this.myClient.log(t, "Failed converting PSI parse tree to Lombok for file %1$s", new Object[]{context.file.getPath()});
            return null;
        }
    }

    @NonNull
    public Location getLocation(@NonNull JavaContext context, @NonNull Node node) {
        Position position = node.getPosition();
        if (position == null) {
            this.myClient.log(Severity.WARNING, null, "No position data found for node %1$s", new Object[]{node});
            return Location.create((File)context.file);
        }
        return Location.create((File)context.file, null, (int)position.getStart(), (int)position.getEnd());
    }

    @NonNull
    public Location.Handle createLocationHandle(@NonNull JavaContext context, @NonNull Node node) {
        return new LocationHandle(context.file, node);
    }

    @Nullable
    private static PsiElement getPsiElement(@NonNull Node node) {
        Object nativeNode = node.getNativeNode();
        if (nativeNode == null) {
            return null;
        }
        return (PsiElement)nativeNode;
    }

    @Nullable
    public JavaParser.ResolvedNode resolve(@NonNull JavaContext context, @NonNull Node node) {
        final PsiElement element = LombokPsiParser.getPsiElement(node);
        if (element == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            return LombokPsiParser.resolve(element);
        }
        return (JavaParser.ResolvedNode)application.runReadAction((Computable)new Computable<JavaParser.ResolvedNode>(){

            @Nullable
            public JavaParser.ResolvedNode compute() {
                return LombokPsiParser.resolve(element);
            }
        });
    }

    @Nullable
    public JavaParser.ResolvedClass findClass(@NonNull JavaContext context, final @NonNull String fullyQualifiedName) {
        Node compilationUnit = context.getCompilationUnit();
        if (compilationUnit == null) {
            return null;
        }
        final PsiElement element = LombokPsiParser.getPsiElement(compilationUnit);
        if (element == null) {
            return null;
        }
        return (JavaParser.ResolvedClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<JavaParser.ResolvedClass>(){

            @Nullable
            public JavaParser.ResolvedClass compute() {
                PsiClass aClass = JavaPsiFacade.getInstance((Project)element.getProject()).findClass(fullyQualifiedName, element.getResolveScope());
                if (aClass != null) {
                    return new ResolvedPsiClass(aClass);
                }
                return null;
            }
        });
    }

    @Nullable
    public JavaParser.TypeDescriptor getType(@NonNull JavaContext context, @NonNull Node node) {
        final PsiElement element = LombokPsiParser.getPsiElement(node);
        if (element == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            return LombokPsiParser.getTypeDescriptor(element);
        }
        return (JavaParser.TypeDescriptor)application.runReadAction((Computable)new Computable<JavaParser.TypeDescriptor>(){

            @Nullable
            public JavaParser.TypeDescriptor compute() {
                return LombokPsiParser.getTypeDescriptor(element);
            }
        });
    }

    @Nullable
    static JavaParser.ResolvedNode resolve(@NonNull PsiElement element) {
        PsiJavaCodeReferenceElement r;
        String qualifiedName;
        PsiElement resolved;
        if (element instanceof PsiCall) {
            PsiMethod resolved2 = ((PsiCall)element).resolveMethod();
            if (resolved2 != null) {
                return new ResolvedPsiMethod(resolved2);
            }
            return null;
        }
        PsiReference reference = element.getReference();
        if (reference != null && (resolved = reference.resolve()) != null) {
            element = resolved;
        }
        if (element instanceof PsiField) {
            return new ResolvedPsiField((PsiField)element);
        }
        if (element instanceof PsiMethod) {
            return new ResolvedPsiMethod((PsiMethod)element);
        }
        if (element instanceof PsiVariable) {
            return new ResolvedPsiVariable((PsiVariable)element);
        }
        if (element instanceof PsiClass) {
            return new ResolvedPsiClass((PsiClass)element);
        }
        if (element instanceof PsiJavaCodeReferenceElement && (qualifiedName = (r = (PsiJavaCodeReferenceElement)element).getQualifiedName()) != null) {
            return new ResolvedPsiClassName(element.getManager(), qualifiedName);
        }
        return null;
    }

    @Nullable
    private static JavaParser.TypeDescriptor getTypeDescriptor(@NonNull PsiElement element) {
        PsiType type = null;
        if (element instanceof PsiExpression) {
            type = ((PsiExpression)element).getType();
        } else if (element instanceof PsiVariable) {
            type = ((PsiVariable)element).getType();
        } else if (element instanceof PsiMethod) {
            type = ((PsiMethod)element).getReturnType();
        } else if (element instanceof PsiAnnotation) {
            final PsiAnnotation annotation = (PsiAnnotation)element;
            return new JavaParser.DefaultTypeDescriptor(annotation.getQualifiedName()){

                @Nullable
                public JavaParser.ResolvedClass getTypeClass() {
                    GlobalSearchScope resolveScope = annotation.getResolveScope();
                    if (resolveScope.getProject() != null) {
                        ApplicationManager.getApplication().assertReadAccessAllowed();
                        PsiClass aClass = JavaPsiFacade.getInstance((Project)resolveScope.getProject()).findClass(this.getSignature(), resolveScope);
                        if (aClass != null) {
                            return new ResolvedPsiClass(aClass);
                        }
                    }
                    return null;
                }
            };
        }
        return LombokPsiParser.getTypeDescriptor(type);
    }

    @Contract(value="!null -> !null")
    @Nullable
    private static JavaParser.TypeDescriptor getTypeDescriptor(@Nullable PsiType type) {
        return type != null ? new PsiTypeDescriptor(type) : null;
    }

    private static int computeModifiers(@Nullable PsiModifierListOwner owner) {
        int modifiers = 0;
        if (owner != null) {
            if (owner.hasModifierProperty("abstract")) {
                modifiers |= 0x400;
            }
            if (owner.hasModifierProperty("public")) {
                modifiers |= 1;
            }
            if (owner.hasModifierProperty("static")) {
                modifiers |= 8;
            }
            if (owner.hasModifierProperty("private")) {
                modifiers |= 2;
            }
            if (owner.hasModifierProperty("protected")) {
                modifiers |= 4;
            }
            if (owner.hasModifierProperty("final")) {
                modifiers |= 0x10;
            }
        }
        return modifiers;
    }

    @NonNull
    private static Iterable<JavaParser.ResolvedAnnotation> getAnnotations(@Nullable PsiModifierListOwner owner) {
        if (owner != null) {
            PsiAnnotation[] annotations;
            PsiModifierList modifierList = owner.getModifierList();
            if (modifierList != null && (annotations = modifierList.getAnnotations()).length > 0) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)annotations.length);
                for (PsiAnnotation method : annotations) {
                    result.add(new ResolvedPsiAnnotation(method));
                }
                return result;
            }
            ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)owner.getProject());
            PsiAnnotation[] annotations2 = annotationsManager.findExternalAnnotations(owner);
            if (annotations2 != null) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)annotations2.length);
                for (PsiAnnotation method : annotations2) {
                    result.add(new ResolvedPsiAnnotation(method));
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    public static JavaParser.ResolvedAnnotation createResolvedAnnotation(@NonNull PsiAnnotation annotation) {
        ResolvedPsiAnnotation resolvedPsiAnnotation = new ResolvedPsiAnnotation(annotation);
        if (resolvedPsiAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/LombokPsiParser", "createResolvedAnnotation"));
        }
        return resolvedPsiAnnotation;
    }

    private static class ResolvedPsiAnnotation
    extends JavaParser.ResolvedAnnotation {
        private PsiAnnotation myAnnotation;

        private ResolvedPsiAnnotation(@NonNull PsiAnnotation annotation) {
            this.myAnnotation = annotation;
        }

        @NonNull
        public String getName() {
            String qualifiedName = this.myAnnotation.getQualifiedName();
            if (qualifiedName == null) {
                return "?";
            }
            return qualifiedName;
        }

        public boolean matches(@NonNull String name) {
            return name.equals(this.getName());
        }

        @NonNull
        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = LombokPsiParser.getTypeDescriptor((PsiElement)this.myAnnotation);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        @Nullable
        public JavaParser.ResolvedClass getClassType() {
            PsiElement element;
            PsiJavaCodeReferenceElement reference = this.myAnnotation.getNameReferenceElement();
            if (reference != null && (element = reference.resolve()) instanceof PsiClass) {
                return new ResolvedPsiClass((PsiClass)element);
            }
            return null;
        }

        @NonNull
        public List<JavaParser.ResolvedAnnotation.Value> getValues() {
            PsiNameValuePair[] attributes = this.myAnnotation.getParameterList().getAttributes();
            if (attributes.length > 0) {
                ArrayList values = Lists.newArrayListWithExpectedSize((int)attributes.length);
                for (PsiNameValuePair pair : attributes) {
                    String name = pair.getName();
                    if (name == null) {
                        name = "value";
                    }
                    values.add(new JavaParser.ResolvedAnnotation.Value(name, ResolvedPsiAnnotation.getAnnotationPairValue(pair)));
                }
                return values;
            }
            return Collections.emptyList();
        }

        @Nullable
        public Object getValue(@NonNull String name) {
            PsiNameValuePair[] attributes = this.myAnnotation.getParameterList().getAttributes();
            if (attributes.length > 0) {
                for (PsiNameValuePair pair : attributes) {
                    String pairName = pair.getName();
                    if (!name.equals(pairName) && (pairName != null || !name.equals("value"))) continue;
                    return ResolvedPsiAnnotation.getAnnotationPairValue(pair);
                }
            }
            return null;
        }

        @Nullable
        private static Object getAnnotationPairValue(@NonNull PsiNameValuePair pair) {
            PsiAnnotationMemberValue v = pair.getValue();
            if (v instanceof PsiLiteral) {
                PsiLiteral literal = (PsiLiteral)v;
                return literal.getValue();
            }
            if (v instanceof PsiArrayInitializerMemberValue) {
                PsiElement resolved;
                PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)v;
                PsiAnnotationMemberValue[] values = mv.getInitializers();
                ArrayList list = Lists.newArrayListWithExpectedSize((int)values.length);
                for (PsiAnnotationMemberValue mmv : values) {
                    if (mmv instanceof PsiLiteral) {
                        PsiLiteral literal = (PsiLiteral)mmv;
                        list.add(literal.getValue());
                        continue;
                    }
                    if (!(mmv instanceof PsiExpression)) continue;
                    list.add(JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)mmv), (boolean)false));
                }
                PsiReference reference = pair.getReference();
                if (reference != null && (resolved = reference.resolve()) instanceof PsiAnnotationMethod) {
                    PsiType returnType = ((PsiAnnotationMethod)resolved).getReturnType();
                    if (returnType != null && returnType.getDeepComponentType().getCanonicalText().equals("java.lang.String")) {
                        return list.toArray(new String[list.size()]);
                    }
                    if (returnType != null && returnType.getDeepComponentType().getCanonicalText().equals("java.lang.annotation.Annotation")) {
                        return list.toArray(new Annotation[list.size()]);
                    }
                    if (returnType == PsiType.INT) {
                        return list.toArray(new Integer[list.size()]);
                    }
                    if (returnType == PsiType.LONG) {
                        return list.toArray(new Long[list.size()]);
                    }
                    if (returnType == PsiType.DOUBLE) {
                        return list.toArray(new Double[list.size()]);
                    }
                    if (returnType == PsiType.FLOAT) {
                        return list.toArray(new Float[list.size()]);
                    }
                }
                if (!list.isEmpty()) {
                    Object first = list.get(0);
                    if (first instanceof String) {
                        return list.toArray(new String[list.size()]);
                    }
                    if (first instanceof Annotation) {
                        return list.toArray(new Annotation[list.size()]);
                    }
                    if (first instanceof Class) {
                        return list.toArray(new Class[list.size()]);
                    }
                } else {
                    return ArrayUtil.EMPTY_STRING_ARRAY;
                }
                return list.toArray();
            }
            if (v instanceof PsiExpression) {
                return JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)v), (boolean)false);
            }
            return null;
        }

        public int getModifiers() {
            return 0;
        }

        public String getSignature() {
            return this.myAnnotation.getQualifiedName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResolvedPsiAnnotation that = (ResolvedPsiAnnotation)((Object)o);
            return this.myAnnotation.equals(that.myAnnotation);
        }

        public int hashCode() {
            return this.myAnnotation.hashCode();
        }
    }

    private static class ResolvedPsiClass
    extends JavaParser.ResolvedClass {
        @Nullable
        protected PsiClass myClass;

        private ResolvedPsiClass(@Nullable PsiClass cls) {
            this.myClass = cls;
        }

        @NonNull
        public String getName() {
            if (this.myClass != null) {
                String qualifiedName = this.myClass.getQualifiedName();
                if (qualifiedName != null) {
                    return qualifiedName;
                }
                return this.myClass.getName();
            }
            return "";
        }

        @NonNull
        public String getSimpleName() {
            if (this.myClass != null) {
                return this.myClass.getName();
            }
            return "";
        }

        public boolean matches(@NonNull String name) {
            return name.equals(this.getName());
        }

        @Nullable
        public JavaParser.ResolvedClass getSuperClass() {
            if (this.myClass != null) {
                PsiClass[] interfaces;
                PsiClass superClass = this.myClass.getSuperClass();
                if (PsiUtil.isLocalOrAnonymousClass((PsiClass)this.myClass) && (interfaces = this.myClass.getInterfaces()).length > 0) {
                    return new ResolvedPsiClass(interfaces[0]);
                }
                if (superClass != null) {
                    return new ResolvedPsiClass(superClass);
                }
            }
            return null;
        }

        @Nullable
        public JavaParser.ResolvedClass getContainingClass() {
            PsiClass containingClass;
            if (this.myClass != null && (containingClass = this.myClass.getContainingClass()) != null) {
                return new ResolvedPsiClass(containingClass);
            }
            return null;
        }

        public boolean isSubclassOf(@NonNull String name, boolean strict) {
            if (this.myClass != null) {
                PsiClass cls = this.myClass;
                if (strict) {
                    cls = cls.getSuperClass();
                }
                while (cls != null) {
                    if (name.equals(cls.getQualifiedName())) {
                        return true;
                    }
                    cls = cls.getSuperClass();
                }
            }
            return false;
        }

        @NonNull
        public Iterable<JavaParser.ResolvedMethod> getConstructors() {
            PsiMethod[] methods;
            if (this.myClass != null && (methods = this.myClass.getConstructors()).length > 0) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)methods.length);
                for (PsiMethod method : methods) {
                    result.add(new ResolvedPsiMethod(method));
                }
                return result;
            }
            return Collections.emptyList();
        }

        @NonNull
        public Iterable<JavaParser.ResolvedMethod> getMethods(boolean includeInherited) {
            if (this.myClass != null) {
                PsiMethod[] methods;
                PsiMethod[] psiMethodArray = methods = includeInherited ? this.myClass.getAllMethods() : this.myClass.getMethods();
                if (methods.length > 0) {
                    ArrayList result = Lists.newArrayListWithExpectedSize((int)methods.length);
                    for (PsiMethod method : methods) {
                        if (method.isConstructor()) continue;
                        result.add(new ResolvedPsiMethod(method));
                    }
                    return result;
                }
            }
            return Collections.emptyList();
        }

        @NonNull
        public Iterable<JavaParser.ResolvedMethod> getMethods(@NonNull String name, boolean includeInherited) {
            PsiMethod[] methods;
            if (this.myClass != null && (methods = this.myClass.findMethodsByName(name, includeInherited)).length > 0) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)methods.length);
                for (PsiMethod method : methods) {
                    if (method.isConstructor()) continue;
                    result.add(new ResolvedPsiMethod(method));
                }
                return result;
            }
            return Collections.emptyList();
        }

        @Nullable
        public JavaParser.ResolvedField getField(@NonNull String name, boolean includeInherited) {
            PsiField field;
            if (this.myClass != null && (field = this.myClass.findFieldByName(name, includeInherited)) != null) {
                return new ResolvedPsiField(field);
            }
            return null;
        }

        @NonNull
        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            return LombokPsiParser.getAnnotations((PsiModifierListOwner)this.myClass);
        }

        public int getModifiers() {
            return LombokPsiParser.computeModifiers((PsiModifierListOwner)this.myClass);
        }

        public String getSignature() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResolvedPsiClass that = (ResolvedPsiClass)((Object)o);
            return !(this.myClass != null ? !this.myClass.equals(that.myClass) : that.myClass != null);
        }

        public int hashCode() {
            return this.myClass != null ? this.myClass.hashCode() : 0;
        }
    }

    private static class ResolvedPsiClassName
    extends ResolvedPsiClass {
        private final String myName;
        private final PsiManager myManager;
        private boolean myInitialized;

        private ResolvedPsiClassName(PsiManager manager, @NonNull String name) {
            super(null);
            this.myManager = manager;
            this.myName = name;
        }

        @Override
        @NonNull
        public String getName() {
            return this.myName;
        }

        @Override
        public boolean matches(@NonNull String name) {
            return name.equals(this.myName);
        }

        private void ensureInitialized() {
            if (this.myInitialized) {
                return;
            }
            this.myInitialized = true;
            Project project = this.myManager.getProject();
            this.myClass = JavaPsiFacade.getInstance((Project)project).findClass(this.myName, GlobalSearchScope.allScope((Project)project));
        }

        @Override
        @Nullable
        public JavaParser.ResolvedClass getSuperClass() {
            this.ensureInitialized();
            if (this.myClass != null) {
                return super.getSuperClass();
            }
            return null;
        }

        @Override
        @Nullable
        public JavaParser.ResolvedClass getContainingClass() {
            this.ensureInitialized();
            if (this.myClass != null) {
                return super.getContainingClass();
            }
            return null;
        }

        @Override
        public boolean isSubclassOf(@NonNull String name, boolean strict) {
            if (!strict && name.equals(this.myName)) {
                return true;
            }
            this.ensureInitialized();
            if (this.myClass != null) {
                return super.isSubclassOf(name, strict);
            }
            return false;
        }

        @Override
        @NonNull
        public Iterable<JavaParser.ResolvedMethod> getConstructors() {
            this.ensureInitialized();
            if (this.myClass != null) {
                return super.getConstructors();
            }
            return Collections.emptyList();
        }

        @Override
        @NonNull
        public Iterable<JavaParser.ResolvedMethod> getMethods(@NonNull String name, boolean includeInherited) {
            this.ensureInitialized();
            if (this.myClass != null) {
                return super.getMethods(name, includeInherited);
            }
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public JavaParser.ResolvedField getField(@NonNull String name, boolean includeInherited) {
            this.ensureInitialized();
            if (this.myClass != null) {
                return super.getField(name, includeInherited);
            }
            return null;
        }

        @Override
        public int getModifiers() {
            this.ensureInitialized();
            return LombokPsiParser.computeModifiers((PsiModifierListOwner)this.myClass);
        }

        @Override
        public String getSignature() {
            return this.myName;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResolvedPsiClassName that = (ResolvedPsiClassName)((Object)o);
            return this.myName.equals(that.myName);
        }

        @Override
        public int hashCode() {
            return this.myName.hashCode();
        }
    }

    private static class ResolvedPsiField
    extends JavaParser.ResolvedField {
        private PsiField myField;

        private ResolvedPsiField(@NonNull PsiField field) {
            this.myField = field;
        }

        @NonNull
        public String getName() {
            return this.myField.getName();
        }

        public boolean matches(@NonNull String name) {
            return name.equals(this.myField.getName());
        }

        @NonNull
        public JavaParser.TypeDescriptor getType() {
            return LombokPsiParser.getTypeDescriptor(this.myField.getType());
        }

        @NonNull
        public JavaParser.ResolvedClass getContainingClass() {
            return new ResolvedPsiClass(this.myField.getContainingClass());
        }

        @Nullable
        public Object getValue() {
            return this.myField.computeConstantValue();
        }

        @NonNull
        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            return LombokPsiParser.getAnnotations((PsiModifierListOwner)this.myField);
        }

        public int getModifiers() {
            return LombokPsiParser.computeModifiers((PsiModifierListOwner)this.myField);
        }

        public String getSignature() {
            return this.myField.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResolvedPsiField that = (ResolvedPsiField)((Object)o);
            return this.myField.equals(that.myField);
        }

        public int hashCode() {
            return this.myField.hashCode();
        }
    }

    private static class ResolvedPsiVariable
    extends JavaParser.ResolvedVariable {
        private PsiVariable myVariable;

        private ResolvedPsiVariable(@NonNull PsiVariable variable) {
            this.myVariable = variable;
        }

        @NonNull
        public String getName() {
            return this.myVariable.getName();
        }

        public boolean matches(@NonNull String name) {
            return name.equals(this.myVariable.getName());
        }

        @NonNull
        public JavaParser.TypeDescriptor getType() {
            return LombokPsiParser.getTypeDescriptor(this.myVariable.getType());
        }

        public int getModifiers() {
            return LombokPsiParser.computeModifiers((PsiModifierListOwner)this.myVariable);
        }

        @NonNull
        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            return LombokPsiParser.getAnnotations((PsiModifierListOwner)this.myVariable);
        }

        public String getSignature() {
            return this.myVariable.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResolvedPsiVariable that = (ResolvedPsiVariable)((Object)o);
            return this.myVariable.equals(that.myVariable);
        }

        public int hashCode() {
            return this.myVariable.hashCode();
        }
    }

    private static class ResolvedPsiMethod
    extends JavaParser.ResolvedMethod {
        private PsiMethod myMethod;

        private ResolvedPsiMethod(@NonNull PsiMethod method) {
            this.myMethod = method;
        }

        @NonNull
        public String getName() {
            return this.myMethod.getName();
        }

        public boolean matches(@NonNull String name) {
            return name.equals(this.myMethod.getName());
        }

        @NonNull
        public JavaParser.ResolvedClass getContainingClass() {
            PsiClass containingClass = this.myMethod.getContainingClass();
            return new ResolvedPsiClass(containingClass);
        }

        public int getArgumentCount() {
            return this.myMethod.getParameterList().getParametersCount();
        }

        @NonNull
        public JavaParser.TypeDescriptor getArgumentType(int index) {
            PsiParameter parameter = this.myMethod.getParameterList().getParameters()[index];
            PsiType type = parameter.getType();
            return LombokPsiParser.getTypeDescriptor(type);
        }

        @Nullable
        public JavaParser.TypeDescriptor getReturnType() {
            if (this.myMethod.isConstructor()) {
                return null;
            }
            return LombokPsiParser.getTypeDescriptor(this.myMethod.getReturnType());
        }

        public String getSignature() {
            return this.myMethod.toString();
        }

        @NonNull
        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            return LombokPsiParser.getAnnotations((PsiModifierListOwner)this.myMethod);
        }

        @NonNull
        public Iterable<JavaParser.ResolvedAnnotation> getParameterAnnotations(int index) {
            PsiParameter[] parameters = this.myMethod.getParameterList().getParameters();
            if (index >= 0 && index < parameters.length) {
                return LombokPsiParser.getAnnotations((PsiModifierListOwner)parameters[index]);
            }
            return Collections.emptyList();
        }

        @Nullable
        public JavaParser.ResolvedAnnotation getParameterAnnotation(@NonNull String type, int parameterIndex) {
            PsiParameter parameter;
            PsiAnnotation annotation;
            PsiParameter[] parameters = this.myMethod.getParameterList().getParameters();
            if (parameterIndex >= 0 && parameterIndex < parameters.length && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)(parameter = parameters[parameterIndex]), (String[])new String[]{type})) != null) {
                return new ResolvedPsiAnnotation(annotation);
            }
            return null;
        }

        @Nullable
        public JavaParser.ResolvedAnnotation getAnnotation(@NonNull String type) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)this.myMethod, (String[])new String[]{type});
            if (annotation != null) {
                return new ResolvedPsiAnnotation(annotation);
            }
            return null;
        }

        public int getModifiers() {
            int modifiers = 0;
            if (this.myMethod.hasModifierProperty("abstract")) {
                modifiers |= 0x400;
            }
            if (this.myMethod.hasModifierProperty("public")) {
                modifiers |= 1;
            }
            if (this.myMethod.hasModifierProperty("static")) {
                modifiers |= 8;
            }
            if (this.myMethod.hasModifierProperty("private")) {
                modifiers |= 2;
            }
            if (this.myMethod.hasModifierProperty("protected")) {
                modifiers |= 4;
            }
            if (this.myMethod.hasModifierProperty("final")) {
                modifiers |= 0x10;
            }
            return modifiers;
        }

        @Nullable
        public JavaParser.ResolvedMethod getSuperMethod() {
            PsiMethod[] superMethods = this.myMethod.findSuperMethods();
            if (superMethods.length > 0) {
                return new ResolvedPsiMethod(superMethods[0]);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResolvedPsiMethod that = (ResolvedPsiMethod)((Object)o);
            return this.myMethod.equals(that.myMethod);
        }

        public int hashCode() {
            return this.myMethod.hashCode();
        }
    }

    private class LocationHandle
    implements Location.Handle {
        private final File myFile;
        private final Node myNode;
        private Object mClientData;

        public LocationHandle(File file, Node node) {
            this.myFile = file;
            this.myNode = node;
        }

        @NonNull
        public Location resolve() {
            Position pos = this.myNode.getPosition();
            if (pos == null) {
                LombokPsiParser.this.myClient.log(Severity.WARNING, null, "No position data found for node %1$s", new Object[]{this.myNode});
                return Location.create((File)this.myFile);
            }
            return Location.create((File)this.myFile, null, (int)pos.getStart(), (int)pos.getEnd());
        }

        public void setClientData(@Nullable Object clientData) {
            this.mClientData = clientData;
        }

        @Nullable
        public Object getClientData() {
            return this.mClientData;
        }
    }

    private static class PsiTypeDescriptor
    extends JavaParser.DefaultTypeDescriptor {
        @NonNull
        private final PsiType myType;

        public PsiTypeDescriptor(@NonNull PsiType type) {
            super(type.getCanonicalText());
            this.myType = type;
        }

        @Nullable
        public JavaParser.ResolvedClass getTypeClass() {
            GlobalSearchScope resolveScope;
            if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)this.myType) && (resolveScope = this.myType.getResolveScope()) != null && resolveScope.getProject() != null) {
                ApplicationManager.getApplication().assertReadAccessAllowed();
                PsiClass aClass = JavaPsiFacade.getInstance((Project)resolveScope.getProject()).findClass(this.getSignature(), resolveScope);
                if (aClass != null) {
                    return new ResolvedPsiClass(aClass);
                }
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            PsiTypeDescriptor that = (PsiTypeDescriptor)((Object)o);
            return this.myType.equals(that.myType);
        }

        public int hashCode() {
            return this.myType.hashCode();
        }
    }
}

