/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.keychain;

import com.intellij.openapi.util.PasswordUtil;
import gnu.trove.THashMap;
import java.util.Map;
import kotlin.MapsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.OSXKeychainLibrary;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!IQ!\u0001C\u0003\u000b\u0005A\u0011!B\u0001\u0005\u00041\u0001\u0001\u0013C\r\u00021\u0003i\n\u0011CQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&\u001f\u0011Y\u0001\u0012B\u0007\u0003\u0019\u0003A:!\u0007\u0003\t\u000b5\u0011A\u0012\u0001M\u00023\u0011AY!\u0004\u0002\r\u0002a\rQ%\u0003\u0003\u0002\u0011\u0019i\u0011\u0001\u0007\u0003\u001a\t!-QB\u0001G\u00011\u0007)\u0003\u0002B\u0006\t\u000e5\t\u0001dB\r\u0004\u0011\u0015i\u0011\u0001g\u0001&%\u0011Y\u0001rB\u0007\u00021\u001dIB\u0001C\u0003\u000e\u00051\u0005\u00014A\r\u0004\u0011!i\u0011\u0001g\u0002\u001a\t!-QB\u0001G\u00011\u0007IS\u0002B!\t\u0011\u000biq!\u0003\u0002\n\u0003a\r\u0011BA\u0005\u00021\u000fA2!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0005i\u0011\u0001\u0007\u0003R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/keychain/OsXCredentialsStore;", "Lorg/jetbrains/keychain/CredentialsStore;", "serviceName", "", "(Ljava/lang/String;)V", "accountToCredentials", "Lgnu/trove/THashMap;", "Lorg/jetbrains/keychain/Credentials;", "", "get", "host", "sshKeyFile", "getServiceName", "reset", "", "save", "credentials", "Companion"}, moduleName="settings-repository")
public final class OsXCredentialsStore
implements CredentialsStore {
    @NotNull
    public static final byte[] SSH;
    private final byte[] serviceName;
    private final THashMap<String, Credentials> accountToCredentials;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.keychain.OsXCredentialsStore$Companion.INSTANCE;
        SSH = StringsKt.toByteArray$default((String)"SSH", null, (int)1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Credentials get(@Nullable String host, @Nullable String sshKeyFile) {
        if (host == null) {
            return null;
        }
        String string = sshKeyFile;
        if (string == null) {
            string = host;
        }
        String accountName = string;
        Credentials credentials = (Credentials)this.accountToCredentials.get((Object)accountName);
        if (credentials != null) {
            return credentials;
        }
        String string2 = OSXKeychainLibrary.Companion.INSTANCE.findGenericPassword(this.getServiceName(sshKeyFile), accountName);
        if (string2 == null) {
            return null;
        }
        String data = string2;
        if (sshKeyFile == null) {
            int separatorIndex = StringsKt.indexOf$default((String)data, (char)'@', (int)0, (boolean)false, (int)6);
            if (separatorIndex <= 0) return null;
            String username = PasswordUtil.decodePassword((String)StringsKt.substring((String)data, (int)0, (int)separatorIndex));
            String password = PasswordUtil.decodePassword((String)StringsKt.substring((String)data, (int)(separatorIndex + 1)));
            credentials = new Credentials(username, password);
        } else {
            credentials = new Credentials(sshKeyFile, data);
        }
        MapsKt.set((Map)((Map)this.accountToCredentials), (Object)accountName, (Object)credentials);
        return credentials;
    }

    private final byte[] getServiceName(String sshKeyFile) {
        return sshKeyFile == null ? this.serviceName : org.jetbrains.keychain.OsXCredentialsStore$Companion.INSTANCE.getSSH();
    }

    @Override
    public void save(@Nullable String host, @NotNull Credentials credentials, @Nullable String sshKeyFile) {
        String string;
        String accountName;
        Credentials oldCredentials;
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        String string2 = sshKeyFile;
        if (string2 == null && (string2 = host) == null) {
            Intrinsics.throwNpe();
        }
        if (credentials.equals(oldCredentials = (Credentials)this.accountToCredentials.put((Object)(accountName = string2), (Object)credentials))) {
            return;
        }
        if (sshKeyFile == null) {
            string = PasswordUtil.encodePassword((String)credentials.getId()) + "@" + PasswordUtil.encodePassword((String)credentials.getToken());
        } else {
            string = credentials.getToken();
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        String data = string;
        OSXKeychainLibrary.Companion.INSTANCE.saveGenericPassword(this.getServiceName(sshKeyFile), accountName, data);
    }

    @Override
    public void reset(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (this.accountToCredentials.remove((Object)host) != null) {
            OSXKeychainLibrary.Companion.INSTANCE.deleteGenericPassword(this.serviceName, host);
        }
    }

    public OsXCredentialsStore(@NotNull String serviceName) {
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        this.serviceName = StringsKt.toByteArray$default((String)serviceName, null, (int)1);
        this.accountToCredentials = new THashMap();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!IQ!\u0001\u0003\u0002\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!K\u0006\u0005\u0007\"A\u0019!D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011AQ\u0001\u0005\u0004"}, strings={"Lorg/jetbrains/keychain/OsXCredentialsStore$Companion;", "", "()V", "SSH", "", "getSSH", "()[B"}, moduleName="settings-repository")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final byte[] getSSH() {
            return SSH;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

