/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUseSiteTarget;
import kotlin.reflect.jvm.internal.impl.name.FqNameBase;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$Companion$WhenMappings;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptionsImpl;
import kotlin.reflect.jvm.internal.impl.renderer.Renderer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DescriptorRenderer
implements Renderer<DeclarationDescriptor> {
    @NotNull
    public static final DescriptorRenderer COMPACT_WITH_MODIFIERS;
    @NotNull
    public static final DescriptorRenderer COMPACT;
    @NotNull
    public static final DescriptorRenderer COMPACT_WITH_SHORT_TYPES;
    @NotNull
    public static final DescriptorRenderer ONLY_NAMES_WITH_SHORT_TYPES;
    @NotNull
    public static final DescriptorRenderer FQ_NAMES_IN_TYPES;
    @NotNull
    public static final DescriptorRenderer SHORT_NAMES_IN_TYPES;
    @NotNull
    public static final DescriptorRenderer DEBUG_TEXT;
    @NotNull
    public static final DescriptorRenderer FLEXIBLE_TYPES_FOR_CODE;
    @NotNull
    public static final DescriptorRenderer HTML;
    public static final Companion Companion;

    static {
        Companion = kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$Companion.INSTANCE;
        COMPACT_WITH_MODIFIERS = kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$Companion.INSTANCE.withOptions(Companion.COMPACT_WITH_MODIFIERS.1.INSTANCE);
        COMPACT = kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$Companion.INSTANCE.withOptions(Companion.COMPACT.1.INSTANCE);
        COMPACT_WITH_SHORT_TYPES = kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$Companion.INSTANCE.withOptions(Companion.COMPACT_WITH_SHORT_TYPES.1.INSTANCE);
        ONLY_NAMES_WITH_SHORT_TYPES = kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$Companion.INSTANCE.withOptions(Companion.ONLY_NAMES_WITH_SHORT_TYPES.1.INSTANCE);
        FQ_NAMES_IN_TYPES = kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$Companion.INSTANCE.withOptions(Companion.FQ_NAMES_IN_TYPES.1.INSTANCE);
        SHORT_NAMES_IN_TYPES = kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$Companion.INSTANCE.withOptions(Companion.SHORT_NAMES_IN_TYPES.1.INSTANCE);
        DEBUG_TEXT = kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$Companion.INSTANCE.withOptions(Companion.DEBUG_TEXT.1.INSTANCE);
        FLEXIBLE_TYPES_FOR_CODE = kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$Companion.INSTANCE.withOptions(Companion.FLEXIBLE_TYPES_FOR_CODE.1.INSTANCE);
        HTML = kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$Companion.INSTANCE.withOptions(Companion.HTML.1.INSTANCE);
    }

    @NotNull
    public final DescriptorRenderer withOptions(@NotNull Function1<? super DescriptorRendererOptions, ? extends Unit> changeOptions) {
        Intrinsics.checkParameterIsNotNull(changeOptions, "changeOptions");
        DescriptorRenderer descriptorRenderer = this;
        if (descriptorRenderer == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.renderer.DescriptorRendererImpl");
        }
        DescriptorRendererOptionsImpl options = ((DescriptorRendererImpl)descriptorRenderer).getOptions().copy();
        changeOptions.invoke(options);
        options.lock();
        return new DescriptorRendererImpl(options);
    }

    @NotNull
    public abstract String renderType(@NotNull KotlinType var1);

    @NotNull
    public abstract String renderTypeArguments(@NotNull List<? extends TypeProjection> var1);

    @NotNull
    public abstract String renderTypeProjection(@NotNull TypeProjection var1);

    @NotNull
    public abstract String renderTypeConstructor(@NotNull TypeConstructor var1);

    @NotNull
    public abstract String renderClassifierName(@NotNull ClassifierDescriptor var1);

    @NotNull
    public abstract String renderAnnotation(@NotNull AnnotationDescriptor var1, @Nullable AnnotationUseSiteTarget var2);

    @NotNull
    public static /* synthetic */ String renderAnnotation$default(DescriptorRenderer descriptorRenderer, AnnotationDescriptor annotationDescriptor, AnnotationUseSiteTarget annotationUseSiteTarget, int n) {
        if ((n & 2) != 0) {
            annotationUseSiteTarget = null;
        }
        return descriptorRenderer.renderAnnotation(annotationDescriptor, annotationUseSiteTarget);
    }

    @Override
    @NotNull
    public abstract String render(@NotNull DeclarationDescriptor var1);

    @NotNull
    public abstract String renderValueParameters(@NotNull Collection<? extends ValueParameterDescriptor> var1, boolean var2);

    @NotNull
    public final String renderFunctionParameters(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        Collection collection = functionDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(collection, "functionDescriptor.valueParameters");
        return this.renderValueParameters(collection, functionDescriptor.hasSynthesizedParameterNames());
    }

    @NotNull
    public abstract String renderName(@NotNull Name var1);

    @NotNull
    public abstract String renderFqName(@NotNull FqNameBase var1);

    public static interface ValueParametersHandler {
        public void appendBeforeValueParameters(int var1, @NotNull StringBuilder var2);

        public void appendAfterValueParameters(int var1, @NotNull StringBuilder var2);

        public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor var1, int var2, int var3, @NotNull StringBuilder var4);

        public void appendAfterValueParameter(@NotNull ValueParameterDescriptor var1, int var2, int var3, @NotNull StringBuilder var4);

        public static final class DEFAULT
        implements ValueParametersHandler {
            public static final DEFAULT INSTANCE;
            public static final DEFAULT INSTANCE$;

            @Override
            public void appendBeforeValueParameters(int parameterCount, @NotNull StringBuilder builder) {
                Intrinsics.checkParameterIsNotNull(builder, "builder");
                builder.append("(");
            }

            @Override
            public void appendAfterValueParameters(int parameterCount, @NotNull StringBuilder builder) {
                Intrinsics.checkParameterIsNotNull(builder, "builder");
                builder.append(")");
            }

            @Override
            public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor parameter, int parameterIndex, int parameterCount, @NotNull StringBuilder builder) {
                Intrinsics.checkParameterIsNotNull(parameter, "parameter");
                Intrinsics.checkParameterIsNotNull(builder, "builder");
            }

            @Override
            public void appendAfterValueParameter(@NotNull ValueParameterDescriptor parameter, int parameterIndex, int parameterCount, @NotNull StringBuilder builder) {
                Intrinsics.checkParameterIsNotNull(parameter, "parameter");
                Intrinsics.checkParameterIsNotNull(builder, "builder");
                if (parameterIndex != parameterCount - 1) {
                    builder.append(", ");
                }
            }

            static {
                new DEFAULT();
            }

            private DEFAULT() {
                INSTANCE = this;
                INSTANCE$ = this;
            }
        }

        public static final class DefaultImpls {
        }
    }

    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final DescriptorRenderer withOptions(@NotNull Function1<? super DescriptorRendererOptions, ? extends Unit> changeOptions) {
            Intrinsics.checkParameterIsNotNull(changeOptions, "changeOptions");
            DescriptorRendererOptionsImpl options = new DescriptorRendererOptionsImpl();
            changeOptions.invoke(options);
            options.lock();
            return new DescriptorRendererImpl(options);
        }

        @NotNull
        public final DescriptorRenderer getCOMPACT_WITH_MODIFIERS() {
            return COMPACT_WITH_MODIFIERS;
        }

        @NotNull
        public final DescriptorRenderer getCOMPACT() {
            return COMPACT;
        }

        @NotNull
        public final DescriptorRenderer getCOMPACT_WITH_SHORT_TYPES() {
            return COMPACT_WITH_SHORT_TYPES;
        }

        @NotNull
        public final DescriptorRenderer getONLY_NAMES_WITH_SHORT_TYPES() {
            return ONLY_NAMES_WITH_SHORT_TYPES;
        }

        @NotNull
        public final DescriptorRenderer getFQ_NAMES_IN_TYPES() {
            return FQ_NAMES_IN_TYPES;
        }

        @NotNull
        public final DescriptorRenderer getSHORT_NAMES_IN_TYPES() {
            return SHORT_NAMES_IN_TYPES;
        }

        @NotNull
        public final DescriptorRenderer getDEBUG_TEXT() {
            return DEBUG_TEXT;
        }

        @NotNull
        public final DescriptorRenderer getFLEXIBLE_TYPES_FOR_CODE() {
            return FLEXIBLE_TYPES_FOR_CODE;
        }

        @NotNull
        public final DescriptorRenderer getHTML() {
            return HTML;
        }

        @NotNull
        public final String getClassKindPrefix(@NotNull ClassDescriptor klass) {
            String string;
            Intrinsics.checkParameterIsNotNull(klass, "klass");
            if (klass.isCompanionObject()) {
                return "companion object";
            }
            switch (DescriptorRenderer$Companion$WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
                case 1: {
                    string = "class";
                    break;
                }
                case 2: {
                    string = "interface";
                    break;
                }
                case 3: {
                    string = "enum class";
                    break;
                }
                case 4: {
                    string = "object";
                    break;
                }
                case 5: {
                    string = "annotation class";
                    break;
                }
                case 6: {
                    string = "enum entry";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

