/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Iterator;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypes;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.OperatorChecks;
import kotlin.reflect.jvm.internal.impl.util.OperatorNameConventions;
import org.jetbrains.annotations.NotNull;

public final class OperatorChecks {
    public static final OperatorChecks INSTANCE;
    public static final OperatorChecks INSTANCE$;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canBeOperator(@NotNull FunctionDescriptor functionDescriptor) {
        boolean bl;
        boolean bl2;
        FunctionDescriptor $receiver;
        Name name;
        block28: {
            Object receiver;
            Name it;
            void $receiver2;
            block32: {
                ReceiverParameterDescriptor receiverParameterDescriptor;
                block31: {
                    block30: {
                        block29: {
                            boolean bl3;
                            block27: {
                                Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
                                name = functionDescriptor.getName();
                                $receiver = functionDescriptor;
                                if (!OperatorChecks.INSTANCE.isMemberOrExtension(functionDescriptor)) {
                                    return false;
                                }
                                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getGET(), name)) {
                                    if ($receiver.getValueParameters().size() < 1) return false;
                                    return true;
                                }
                                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getSET(), name)) {
                                    boolean bl4;
                                    ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.lastOrNull($receiver.getValueParameters());
                                    if (valueParameterDescriptor != null) {
                                        void $receiver3;
                                        ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
                                        ValueParameterDescriptor it2 = (ValueParameterDescriptor)$receiver3;
                                        bl4 = !DescriptorUtilsKt.hasDefaultValue(it2) && it2.getVarargElementType() == null;
                                    } else {
                                        bl4 = false;
                                    }
                                    boolean lastIsOk = bl4;
                                    if ($receiver.getValueParameters().size() < 2) return false;
                                    if (!lastIsOk) return false;
                                    return true;
                                }
                                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getGET_VALUE(), name)) {
                                    if (!OperatorChecks.INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                                    if ($receiver.getValueParameters().size() < 2) return false;
                                    if (!OperatorChecks.INSTANCE.isKProperty($receiver.getValueParameters().get(1))) return false;
                                    return true;
                                }
                                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getSET_VALUE(), name)) {
                                    if (!OperatorChecks.INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                                    if ($receiver.getValueParameters().size() < 3) return false;
                                    if (!OperatorChecks.INSTANCE.isKProperty($receiver.getValueParameters().get(1))) return false;
                                    return true;
                                }
                                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getINVOKE(), name)) {
                                    bl2 = OperatorChecks.INSTANCE.isMemberOrExtension($receiver);
                                    return bl2;
                                }
                                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getCONTAINS(), name)) {
                                    if (!OperatorChecks.INSTANCE.getSingleValueParameter($receiver)) return false;
                                    if (!OperatorChecks.INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                                    if (!OperatorChecks.INSTANCE.getReturnsBoolean($receiver)) return false;
                                    return true;
                                }
                                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getITERATOR(), name)) {
                                    bl2 = OperatorChecks.INSTANCE.getNoValueParameters($receiver);
                                    return bl2;
                                }
                                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getNEXT(), name)) {
                                    bl2 = OperatorChecks.INSTANCE.getNoValueParameters($receiver);
                                    return bl2;
                                }
                                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getHAS_NEXT(), name)) {
                                    if (!OperatorChecks.INSTANCE.getNoValueParameters($receiver)) return false;
                                    if (!OperatorChecks.INSTANCE.getReturnsBoolean($receiver)) return false;
                                    return true;
                                }
                                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getRANGE_TO(), name)) {
                                    if (!OperatorChecks.INSTANCE.getSingleValueParameter($receiver)) return false;
                                    if (!OperatorChecks.INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                                    return true;
                                }
                                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getEQUALS(), name)) {
                                    Object element;
                                    FunctionDescriptor it3;
                                    canBeOperator.1.1 isAny$ = canBeOperator.1.1.INSTANCE;
                                    if (!OperatorChecks.INSTANCE.isMember($receiver)) return false;
                                    Iterable $receiver3 = $receiver.getOverriddenDescriptors();
                                    Iterator it2 = $receiver3.iterator();
                                    do {
                                        if (!it2.hasNext()) return false;
                                    } while (!canBeOperator.1.1.INSTANCE.invoke((it3 = (FunctionDescriptor)(element = it2.next())).getContainingDeclaration()));
                                    return true;
                                }
                                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getCOMPARE_TO(), name)) {
                                    if (!OperatorChecks.INSTANCE.getReturnsInt($receiver)) return false;
                                    if (!OperatorChecks.INSTANCE.getSingleValueParameter($receiver)) return false;
                                    if (!OperatorChecks.INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                                    return true;
                                }
                                Iterable isAny$ = OperatorNameConventions.INSTANCE.getBINARY_OPERATION_NAMES$kotlin_core();
                                for (Object element : $receiver2) {
                                    it = (Name)element;
                                    if (!Intrinsics.areEqual(it, name)) continue;
                                    bl3 = true;
                                    break block27;
                                }
                                bl3 = false;
                            }
                            if (bl3 && functionDescriptor.getValueParameters().size() == 1) {
                                if (!OperatorChecks.INSTANCE.getSingleValueParameter($receiver)) return false;
                                if (!OperatorChecks.INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                                return true;
                            }
                            if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getPLUS(), name)) break block29;
                            if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getMINUS(), name)) break block29;
                            if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getUNARY_PLUS(), name)) break block29;
                            if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getUNARY_MINUS(), name)) break block29;
                            if (!Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getNOT(), name)) break block30;
                        }
                        bl2 = OperatorChecks.INSTANCE.getNoValueParameters($receiver);
                        return bl2;
                    }
                    if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getINC(), name)) break block31;
                    if (!Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getDEC(), name)) break block32;
                }
                if ((receiverParameterDescriptor = $receiver.getDispatchReceiverParameter()) == null) {
                    receiverParameterDescriptor = $receiver.getExtensionReceiverParameter();
                }
                receiver = receiverParameterDescriptor;
                if (!OperatorChecks.INSTANCE.isMemberOrExtension($receiver)) return false;
                if (receiver == null) return false;
                KotlinType kotlinType = $receiver.getReturnType();
                if (kotlinType == null) return false;
                KotlinType $receiver4 = kotlinType;
                KotlinType it4 = $receiver4;
                KotlinType kotlinType2 = receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "receiver.type");
                boolean bl5 = TypeUtilsKt.isSubtypeOf(it4, kotlinType2);
                if (!bl5) return false;
                return true;
            }
            receiver = OperatorNameConventions.INSTANCE.getASSIGNMENT_OPERATIONS$kotlin_core();
            for (Object element : $receiver2) {
                it = (Name)element;
                if (!Intrinsics.areEqual(it, name)) continue;
                bl = true;
                break block28;
            }
            bl = false;
        }
        if (bl) {
            if (!OperatorChecks.INSTANCE.getReturnsUnit($receiver)) return false;
            if (!OperatorChecks.INSTANCE.getSingleValueParameter($receiver)) return false;
            if (!OperatorChecks.INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
            return true;
        }
        if (!StringsKt.matches(name.asString(), OperatorNameConventions.INSTANCE.getCOMPONENT_REGEX())) return false;
        bl2 = OperatorChecks.INSTANCE.getNoValueParameters($receiver);
        return bl2;
    }

    private final boolean isKProperty(ValueParameterDescriptor $receiver) {
        boolean bl;
        KotlinType kotlinType = ReflectionTypes.Companion.INSTANCE.createKPropertyStarType(DescriptorUtilsKt.getModule($receiver));
        if (kotlinType != null) {
            KotlinType kotlinType2 = TypeUtilsKt.makeNotNullable($receiver.getType());
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "type.makeNotNullable()");
            bl = TypeUtilsKt.isSubtypeOf(kotlinType, kotlinType2);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isMember(FunctionDescriptor $receiver) {
        return $receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    private final boolean isMemberOrExtension(FunctionDescriptor $receiver) {
        return DescriptorUtilsKt.isExtension($receiver) || $receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    private final boolean getNoValueParameters(FunctionDescriptor $receiver) {
        return $receiver.getValueParameters().isEmpty();
    }

    private final boolean getSingleValueParameter(FunctionDescriptor $receiver) {
        return $receiver.getValueParameters().size() == 1;
    }

    private final boolean getReturnsBoolean(FunctionDescriptor $receiver) {
        boolean bl;
        KotlinType kotlinType = $receiver.getReturnType();
        if (kotlinType != null) {
            KotlinType $receiver2 = kotlinType;
            KotlinType it = $receiver2;
            bl = KotlinBuiltIns.isBoolean(it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean getReturnsInt(FunctionDescriptor $receiver) {
        boolean bl;
        KotlinType kotlinType = $receiver.getReturnType();
        if (kotlinType != null) {
            KotlinType $receiver2 = kotlinType;
            KotlinType it = $receiver2;
            bl = Intrinsics.areEqual(DescriptorUtilsKt.getBuiltIns($receiver).getIntType(), it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean getReturnsUnit(FunctionDescriptor $receiver) {
        boolean bl;
        KotlinType kotlinType = $receiver.getReturnType();
        if (kotlinType != null) {
            KotlinType $receiver2 = kotlinType;
            KotlinType it = $receiver2;
            bl = Intrinsics.areEqual(DescriptorUtilsKt.getBuiltIns($receiver).getUnitType(), it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean getNoDefaultsAndVarargs(FunctionDescriptor $receiver) {
        boolean bl;
        block1: {
            Iterable $receiver2 = $receiver.getValueParameters();
            for (Object element : $receiver2) {
                ValueParameterDescriptor it = (ValueParameterDescriptor)element;
                if (!DescriptorUtilsKt.hasDefaultValue(it) && it.getVarargElementType() == null) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    static {
        new OperatorChecks();
    }

    private OperatorChecks() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

