/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.CompilerOutputParser;
import org.jetbrains.kotlin.compilerRunner.CompilerRunnerUtil;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.rmi.CompileService;
import org.jetbrains.kotlin.rmi.CompilerId;
import org.jetbrains.kotlin.rmi.DaemonJVMOptions;
import org.jetbrains.kotlin.rmi.DaemonOptions;
import org.jetbrains.kotlin.rmi.DaemonParamsKt;
import org.jetbrains.kotlin.rmi.DummyProfiler;
import org.jetbrains.kotlin.rmi.PerfCounters;
import org.jetbrains.kotlin.rmi.Profiler;
import org.jetbrains.kotlin.rmi.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.rmi.kotlinr.CompilationServices;
import org.jetbrains.kotlin.rmi.kotlinr.DaemonReportCategory;
import org.jetbrains.kotlin.rmi.kotlinr.DaemonReportMessage;
import org.jetbrains.kotlin.rmi.kotlinr.DaemonReportingTargets;
import org.jetbrains.kotlin.rmi.kotlinr.KotlinCompilerClient;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\r\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q!\u0001\u0003\u0002\u000b\u0005Aq!B\u0001\u0005\u0004\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0010\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\u000f)\u0011\u0001c\u0003\u0006\u0001\u0015\t\u0001\u0012C\u0003\u0002\t\u0007!1-\u0001\u0007\u00013\u0005A\n!HA\"E\u0005\u001eA!A)\u0004\u0003!\tQ%\u0004\u0003\u0002\u0011\u000fiA!\u0003\u0002\n\u0003a%\u0001\u0004B\r\u0006\u0011\u0015i1!C\u0001\u0005\u0004a-Q%\u0003\u0003\u0002\u0011\u0019i\u0011\u0001\u0007\u0002\u001a\t!5QB\u0001G\u00011\u0003);\u0003B\u0001\t\u000f5\tAuB\t\u0005\t\u0001Ay!F\u0001\u0019\u0011e\u0019\u0001\u0012C\u0007\u00021!I2\u0001C\u0005\u000e\u0003\u0011>\u0011kA\u0001\t\u0014\u0015\"B!\u0001\u0005\u000b\u001b\u0005A*\"G\u0002\t\u00175\t\u0001tC\r\u0004\u00111i\u0011\u0001'\u0007\u001a\u0007!iQ\"\u0001M\u000e3\rAa\"D\u0001\u0019\u0005\u0015BA!\u0001E\u000f\u001b\u0005A*\"G\u0002\t\u00175\t\u0001tC\u0013\u0015\t\u0005Aq\"D\u0001\u0019\u0016e\u0019\u0001rD\u0007\u00021\tI2\u0001\u0003\t\u000e\u0003a\u0005\u0012d\u0001\u0005\f\u001b\u0005A:\"G\u0002\t#5\t\u00014E\u0013\u001d\t\u0005A!#D\u0001\u0019\u0016e\u0019\u0001RE\u0007\u00021\tI2\u0001C\n\u000e\u0003aA\u0011d\u0001E\u0014\u001b\u0005A\"!G\u0002\t\u00175\t\u0001tC\r\u0004\u00111i\u0011\u0001'\u0007\u001a\u0007!!R\"\u0001M\u0015K5BQ#D\u0001\u0019\u0016e\u0019\u00012F\u0007\u00021!I2\u0001\u0003\f\u000e\u0003a5\u0012d\u0001\u0005\u0018\u001b\u0005Az#G\u0002\t\u00175\t\u0001tC\r\u0004\u0011Qi\u0011\u0001'\u000b\u001a\u0007!aQ\"\u0001M\r3\u0019A\u0001$\u0004\u0003\n\u0005%\t\u0001$\u0007M\u00193\u0019A\u0019$\u0004\u0003\n\u0005%\t\u0001D\u0001\r\u00053\rA!$D\u0001\u00193\u0015z\u0002RG\u0007\u00021+I2\u0001c\u000b\u000e\u0003aA\u0011d\u0001\u0005\u001c\u001b\u0005A:$G\u0002\t/5\t\u0001tF\r\u0004\u0011-i\u0011\u0001g\u0006\u001a\u0007!!R\"\u0001M\u00153\rAA$D\u0001\u00193e\u0019\u0001\u0002D\u0007\u000213)#\u0004B\u0001\t:5\t\u0001TC\r\u0004\u0011ui\u0011\u0001G\r\u001a\r!AR\u0002B\u0005\u0003\u0013\u0005A\u0012\u0004'\r\u001a\r!mR\u0002B\u0005\u0003\u0013\u0005A\"\u0001\u0007\u0003\u001a\u0007!qR\"\u0001M\u0017K1!\u0011\u0001#\u0010\u000e\u0003aU\u0011d\u0001\u0005\u001d\u001b\u0005A\u0012$G\u0002\t=5\t\u0001tGS\u001e\t\u0005Aq$D\u0001\u0019@e\u0019\u0001RE\u0007\u00021\tIb\u0001\u0003\u0011\u000e\t%\u0011\u0011\"\u0001\r\u00031\u0003J2\u0001\u0003\u000b\u000e\u0003a%\u0012d\u0001\u0005\f\u001b\u0005A:\"G\u0002\t\u00195\t\u0001\u0014D)\u0004\u0003!\t\u0013f\u0002\u0003B\u0011!\rQ\"\u0001\r\u0003#\u000e\tQ\u0001AU\b\t\u0005C\u0015\u0001#\u0002\u000e\u0003a\u0011\u0011kA\u0001\u0006\u0001%>A!\u0011%\u0002\u0011\ri\u0011\u0001\u0007\u0002R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner;", "", "()V", "INTERNAL_ERROR", "", "K2JS_COMPILER", "K2JVM_COMPILER", "collectFieldsToCopy", "", "Ljava/lang/reflect/Field;", "clazz", "Ljava/lang/Class;", "getReturnCodeFromObject", "rc", "mergeBeans", "T", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "from", "to", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "processCompilerOutput", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "collector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "stream", "Ljava/io/ByteArrayOutputStream;", "exitCode", "reportInternalCompilerError", "reportTotalAndThreadPerf", "message", "daemonOptions", "Lorg/jetbrains/kotlin/rmi/DaemonOptions;", "profiler", "Lorg/jetbrains/kotlin/rmi/Profiler;", "runCompiler", "compilerClassName", "arguments", "additionalArguments", "environment", "Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;", "runK2JsCompiler", "commonArguments", "k2jsArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "compilerSettings", "Lorg/jetbrains/kotlin/config/CompilerSettings;", "sourceFiles", "", "Ljava/io/File;", "libraryFiles", "outputFile", "runK2JvmCompiler", "k2jvmArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "moduleFile", "setupK2JsArguments", "_outputFile", "_libraryFiles", "settings", "setupK2JvmArguments", "tryCompileWithDaemon", "", "argsArray", "", "(Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;)Z", "DaemonConnection", "getDaemonConnection"}, moduleName="jps-plugin")
public final class KotlinCompilerRunner {
    private static final String K2JVM_COMPILER = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
    private static final String K2JS_COMPILER = "org.jetbrains.kotlin.cli.js.K2JSCompiler";
    private static final String INTERNAL_ERROR;
    public static final KotlinCompilerRunner INSTANCE;
    public static final KotlinCompilerRunner INSTANCE$;

    public final void runK2JvmCompiler(@NotNull CommonCompilerArguments commonArguments, @NotNull K2JVMCompilerArguments k2jvmArguments, @NotNull CompilerSettings compilerSettings, @NotNull MessageCollector messageCollector, @NotNull CompilerEnvironment environment, @NotNull File moduleFile, @NotNull OutputItemsCollector collector) {
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull((Object)k2jvmArguments, (String)"k2jvmArguments");
        Intrinsics.checkParameterIsNotNull((Object)compilerSettings, (String)"compilerSettings");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)moduleFile, (String)"moduleFile");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        K2JVMCompilerArguments arguments = (K2JVMCompilerArguments)this.mergeBeans(commonArguments, (CommonCompilerArguments)k2jvmArguments);
        this.setupK2JvmArguments(moduleFile, arguments);
        this.runCompiler(K2JVM_COMPILER, arguments, compilerSettings.getAdditionalArguments(), messageCollector, collector, environment);
    }

    public final void runK2JsCompiler(@NotNull CommonCompilerArguments commonArguments, @NotNull K2JSCompilerArguments k2jsArguments, @NotNull CompilerSettings compilerSettings, @NotNull MessageCollector messageCollector, @NotNull CompilerEnvironment environment, @NotNull OutputItemsCollector collector, @NotNull Collection<? extends File> sourceFiles, @NotNull List<? extends String> libraryFiles, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull((Object)k2jsArguments, (String)"k2jsArguments");
        Intrinsics.checkParameterIsNotNull((Object)compilerSettings, (String)"compilerSettings");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull(libraryFiles, (String)"libraryFiles");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        K2JSCompilerArguments arguments = (K2JSCompilerArguments)this.mergeBeans(commonArguments, (CommonCompilerArguments)k2jsArguments);
        this.setupK2JsArguments(outputFile, sourceFiles, libraryFiles, arguments);
        this.runCompiler(K2JS_COMPILER, arguments, compilerSettings.getAdditionalArguments(), messageCollector, collector, environment);
    }

    private final void processCompilerOutput(MessageCollector messageCollector, OutputItemsCollector collector, ByteArrayOutputStream stream, String exitCode) {
        BufferedReader reader = new BufferedReader(new StringReader(stream.toString()));
        CompilerOutputParser.parseCompilerMessagesFromReader(messageCollector, reader, collector);
        if (Intrinsics.areEqual((Object)INTERNAL_ERROR, (Object)exitCode)) {
            this.reportInternalCompilerError(messageCollector);
        }
    }

    private final void reportInternalCompilerError(MessageCollector messageCollector) {
        messageCollector.report(CompilerMessageSeverity.ERROR, "Compiler terminated with internal error", CompilerMessageLocation.Companion.INSTANCE.getNO_LOCATION());
    }

    /*
     * WARNING - void declaration
     */
    private final void runCompiler(String compilerClassName, CommonCompilerArguments arguments, String additionalArguments, MessageCollector messageCollector, OutputItemsCollector collector, CompilerEnvironment environment) {
        try {
            void $receiver;
            messageCollector.report(CompilerMessageSeverity.INFO, "Using kotlin-home = " + environment.getKotlinPaths().getHomePath(), CompilerMessageLocation.Companion.INSTANCE.getNO_LOCATION());
            List<String> argumentsList = ArgumentUtils.convertArgumentsToStringList(arguments);
            argumentsList.addAll(StringsKt.split$default((String)additionalArguments, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6));
            Collection collection = argumentsList;
            void v0 = $receiver;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection = (Collection)v0;
            String[] stringArray = thisCollection.toArray(new String[thisCollection.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] argsArray = (String[])((Object[])stringArray);
            if (!this.tryCompileWithDaemon(compilerClassName, argsArray, environment, messageCollector, collector)) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(stream);
                Object rc = CompilerRunnerUtil.invokeExecMethod(compilerClassName, argsArray, environment, messageCollector, out);
                this.processCompilerOutput(messageCollector, collector, stream, this.getReturnCodeFromObject(rc));
            }
        }
        catch (Throwable e) {
            MessageCollectorUtil.reportException(messageCollector, e);
            this.reportInternalCompilerError(messageCollector);
        }
    }

    private final boolean tryCompileWithDaemon(String compilerClassName, String[] argsArray, CompilerEnvironment environment, MessageCollector messageCollector, OutputItemsCollector collector) {
        if (DaemonParamsKt.isDaemonEnabled()) {
            DaemonConnection connection;
            DaemonConnection daemonConnection = connection = getDaemonConnection.INSTANCE.invoke(environment, messageCollector);
            if ((daemonConnection != null ? daemonConnection.getDaemon() : null) != null) {
                CompileService.TargetPlatform targetPlatform;
                ByteArrayOutputStream compilerOut = new ByteArrayOutputStream();
                ByteArrayOutputStream daemonOut = new ByteArrayOutputStream();
                CompilationServices services = new CompilationServices(environment.getServices().get(IncrementalCompilationComponents.class), environment.getServices().get(CompilationCanceledStatus.class));
                String string = compilerClassName;
                if (Intrinsics.areEqual((Object)string, (Object)K2JVM_COMPILER)) {
                    targetPlatform = CompileService.TargetPlatform.JVM;
                } else if (Intrinsics.areEqual((Object)string, (Object)K2JS_COMPILER)) {
                    targetPlatform = CompileService.TargetPlatform.JS;
                } else {
                    throw (Throwable)new IllegalArgumentException("Unknown compiler type " + compilerClassName);
                }
                CompileService.TargetPlatform targetPlatform2 = targetPlatform;
                DaemonConnection daemonConnection2 = connection;
                if (daemonConnection2 == null) {
                    Intrinsics.throwNpe();
                }
                CompileService compileService = daemonConnection2.getDaemon();
                if (compileService == null) {
                    Intrinsics.throwNpe();
                }
                int res = KotlinCompilerClient.incrementalCompile$default(KotlinCompilerClient.INSTANCE, compileService, targetPlatform2, argsArray, services, compilerOut, daemonOut, null, 64);
                this.processCompilerOutput(messageCollector, collector, compilerOut, String.valueOf(res));
                TextStreamsKt.forEachLine((Reader)new BufferedReader(new StringReader(daemonOut.toString())), (Function1)((Function1)new Function1<String, Unit>(messageCollector){
                    final /* synthetic */ MessageCollector $messageCollector;

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$messageCollector.report(CompilerMessageSeverity.INFO, it, CompilerMessageLocation.Companion.INSTANCE.getNO_LOCATION());
                    }
                    {
                        this.$messageCollector = messageCollector;
                        super(1);
                    }
                }));
                return true;
            }
        }
        return false;
    }

    private final void reportTotalAndThreadPerf(String message, DaemonOptions daemonOptions, MessageCollector messageCollector, Profiler profiler) {
        if (daemonOptions.getReportPerf()) {
            reportTotalAndThreadPerf.1 ms$ = reportTotalAndThreadPerf.1.INSTANCE;
            PerfCounters counters = profiler.getTotalCounters();
            messageCollector.report(CompilerMessageSeverity.INFO, "PERF: " + message + " " + ms$.invoke(counters.getTime()) + " ms, thread " + ms$.invoke(counters.getThreadTime()), CompilerMessageLocation.Companion.INSTANCE.getNO_LOCATION());
        }
    }

    private final String getReturnCodeFromObject(Object rc) {
        if (rc == null) {
            return INTERNAL_ERROR;
        }
        if (Intrinsics.areEqual((Object)ExitCode.class.getName(), (Object)rc.getClass().getName())) {
            return rc.toString();
        }
        throw (Throwable)new IllegalStateException("Unexpected return: " + rc);
    }

    private final <T extends CommonCompilerArguments> T mergeBeans(CommonCompilerArguments from, T to) {
        CommonCompilerArguments copy = (CommonCompilerArguments)XmlSerializerUtil.createCopy(to);
        List<Field> fromFields = this.collectFieldsToCopy(from.getClass());
        for (Field fromField : fromFields) {
            Field toField = copy.getClass().getField(fromField.getName());
            toField.set(copy, fromField.get(from));
        }
        CommonCompilerArguments commonCompilerArguments = copy;
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCompilerArguments, (String)"copy");
        return (T)commonCompilerArguments;
    }

    private final List<Field> collectFieldsToCopy(Class<?> clazz) {
        ArrayList<Field> fromFields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] fieldArray = currentClass.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                fromFields.add(field);
            }
        }
        return fromFields;
    }

    private final void setupK2JvmArguments(File moduleFile, K2JVMCompilerArguments settings) {
        K2JVMCompilerArguments $receiver = settings;
        $receiver.module = moduleFile.getAbsolutePath();
        $receiver.noStdlib = true;
        $receiver.noJdk = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupK2JsArguments(File _outputFile, Collection<? extends File> sourceFiles, List<? extends String> _libraryFiles, K2JSCompilerArguments settings) {
        Object[] objectArray;
        void destination;
        void $receiver;
        Collection $receiver2;
        K2JSCompilerArguments $receiver3 = settings;
        $receiver3.noStdlib = true;
        Iterable iterable = sourceFiles;
        K2JSCompilerArguments k2JSCompilerArguments = $receiver3;
        void var8_8 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            File file = (File)item;
            objectArray = destination;
            String string = it.getPath();
            objectArray.add(string);
        }
        k2JSCompilerArguments.freeArgs = objectArray = (Object[])destination;
        $receiver3.outputFile = _outputFile.getPath();
        $receiver3.metaInfo = true;
        $receiver2 = _libraryFiles;
        k2JSCompilerArguments = $receiver3;
        Collection collection2 = $receiver2;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection = collection2;
        String[] stringArray = thisCollection.toArray(new String[thisCollection.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = stringArray;
        k2JSCompilerArguments.libraryFiles = (String[])objectArray;
    }

    static {
        new KotlinCompilerRunner();
    }

    private KotlinCompilerRunner() {
        INSTANCE = this;
        INSTANCE$ = this;
        K2JVM_COMPILER = K2JVM_COMPILER;
        K2JS_COMPILER = K2JS_COMPILER;
        INTERNAL_ERROR = ExitCode.INTERNAL_ERROR.toString();
    }

    public static final /* synthetic */ void access$reportTotalAndThreadPerf(KotlinCompilerRunner $this, @NotNull String message, @NotNull DaemonOptions daemonOptions, @NotNull MessageCollector messageCollector, @NotNull Profiler profiler) {
        $this.reportTotalAndThreadPerf(message, daemonOptions, messageCollector, profiler);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA1\u0001\u0003\u0001\u0019\u0001I\u0012\u0001'\u0001\"\u0010%!\u0001\"A\u0007\u0003\u0019\u0003A\u001a!U\u0002\u0002\u0011\tI3\u0002B\"\t\u0011\u0005i!\u0001$\u0001\u0019\u0004E\u001bA!\u0002\u0001\u000e\u0005\u0011\u0015\u0001b\u0001"}, strings={"Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner$DaemonConnection;", "", "daemon", "Lorg/jetbrains/kotlin/rmi/CompileService;", "(Lorg/jetbrains/kotlin/rmi/CompileService;)V", "getDaemon", "()Lorg/jetbrains/kotlin/rmi/CompileService;"}, moduleName="jps-plugin")
    public static final class DaemonConnection {
        @Nullable
        private final CompileService daemon;

        @Nullable
        public final CompileService getDaemon() {
            return this.daemon;
        }

        public DaemonConnection(@Nullable CompileService daemon) {
            this.daemon = daemon;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tA\u0001Y\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K7!9\t\u0002E\u0003\u001b\ta\t\u0001\u0007\u0002\u001a\u0007!\u0019Q\"\u0001M\u00043\rAA!D\u0001\u0019\n%RA1\u0011\u000f\t\u00045\u0011A\u0012\u0001\r\u00039\u0005\u0001\u0013!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner$getDaemonConnection;", "", "()V", "connection", "Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner$DaemonConnection;", "invoke", "environment", "Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;"}, moduleName="jps-plugin")
    public static final class getDaemonConnection {
        private static volatile DaemonConnection connection;
        public static final getDaemonConnection INSTANCE;
        public static final getDaemonConnection INSTANCE$;

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final synchronized DaemonConnection invoke(@NotNull CompilerEnvironment environment, @NotNull MessageCollector messageCollector) {
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
                Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
                if (getDaemonConnection.connection != null) break block3;
                libPath = CompilerRunnerUtil.getLibPath(environment.getKotlinPaths(), messageCollector);
                compilerId = CompilerId.Companion.INSTANCE.makeCompilerId(new File[]{new File(libPath, "kotlin-compiler.jar")});
                daemonOptions = DaemonParamsKt.configureDaemonOptions();
                daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions(true, new String[0]);
                daemonJVMOptions.getJvmParams().add("Dkotlin.environment.keepalive");
                daemonReportMessages = new ArrayList<E>();
                profiler = daemonOptions.getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                profiler.withMeasure(null, (Function0)new Function0<Unit>(compilerId, daemonJVMOptions, daemonOptions, daemonReportMessages){
                    final /* synthetic */ CompilerId $compilerId;
                    final /* synthetic */ DaemonJVMOptions $daemonJVMOptions;
                    final /* synthetic */ DaemonOptions $daemonOptions;
                    final /* synthetic */ ArrayList $daemonReportMessages;

                    public final void invoke() {
                        getDaemonConnection.access$setConnection$p(getDaemonConnection.INSTANCE, new DaemonConnection(KotlinCompilerClient.connectToCompileService(this.$compilerId, this.$daemonJVMOptions, this.$daemonOptions, new DaemonReportingTargets(null, this.$daemonReportMessages), true, true)));
                    }
                    {
                        this.$compilerId = compilerId;
                        this.$daemonJVMOptions = daemonJVMOptions;
                        this.$daemonOptions = daemonOptions;
                        this.$daemonReportMessages = arrayList;
                        super(0);
                    }
                });
                for (DaemonReportMessage msg : daemonReportMessages) {
                    v0 = new StringBuilder();
                    if (!Intrinsics.areEqual((Object)msg.getCategory(), (Object)DaemonReportCategory.EXCEPTION)) ** GOTO lbl-1000
                    v1 = getDaemonConnection.connection;
                    if ((v1 != null ? v1.getDaemon() : null) == null) {
                        v2 = "Falling  back to compilation without daemon due to error: ";
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = "";
                    }
                    messageCollector.report(CompilerMessageSeverity.INFO, v0.append(v2).append(msg.getMessage()).toString(), CompilerMessageLocation.Companion.INSTANCE.getNO_LOCATION());
                }
                KotlinCompilerRunner.access$reportTotalAndThreadPerf(KotlinCompilerRunner.INSTANCE, "Daemon connect", daemonOptions, messageCollector, profiler);
            }
            return getDaemonConnection.connection;
        }

        static {
            new getDaemonConnection();
        }

        private getDaemonConnection() {
            INSTANCE = this;
            INSTANCE$ = this;
        }

        @Nullable
        public static final /* synthetic */ DaemonConnection access$getConnection$p(getDaemonConnection $this) {
            getDaemonConnection getDaemonConnection2 = $this;
            return connection;
        }

        public static final /* synthetic */ void access$setConnection$p(getDaemonConnection $this, @Nullable DaemonConnection daemonConnection) {
            getDaemonConnection getDaemonConnection2 = $this;
            connection = daemonConnection;
        }
    }
}

