/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import java.io.File;
import kotlin.StringsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.load.java.JvmAbi;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tAaA\u0003\u0002\u0011\u0005)\u0001!B\u0001\t\f\u0015\tA!\u0001\u0007\u0001!\u001dI\u0012\u0001'\u0001\u001e\u0002\u001d\tk!C\u0002\t\u00035\t\u00014A)\u0004\u0003!\u0011Qe\u0001E\u0005\u001b\u0005AR!J\u0002\t\f5\t\u0001DB\u0013\u0004\u0011\u001bi\u0011\u0001G\u0003*\u000f\u0011\t\u0005\u0002#\u0002\u000e\u0003a\r\u0011kA\u0001\u0006\u0001%RAq\u0011\u0005\t\u00075\t\u00014\u0001\u000f$#\u000e\u0019QB\u0001C\u0004\u0011\u0011\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/CacheFormatVersion;", "", "targetDataRoot", "Ljava/io/File;", "(Ljava/io/File;)V", "file", "formatVersionFile", "getFormatVersionFile", "()Ljava/io/File;", "clean", "", "isIncompatible", "", "saveIfNeeded", "Companion"}, moduleName="jps-plugin")
public final class CacheFormatVersion {
    private static final int INCREMENTAL_CACHE_OWN_VERSION = 7;
    private static final int CACHE_FORMAT_VERSION;
    private static final String FORMAT_VERSION_FILE_PATH = "kotlin/format-version.txt";
    private final File file;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.jps.incremental.CacheFormatVersion$Companion.INSTANCE;
        INCREMENTAL_CACHE_OWN_VERSION = 7;
        CACHE_FORMAT_VERSION = org.jetbrains.kotlin.jps.incremental.CacheFormatVersion$Companion.INSTANCE.getINCREMENTAL_CACHE_OWN_VERSION() * 1000000 + JvmAbi.VERSION.getMajor() * 1000 + JvmAbi.VERSION.getMinor();
        FORMAT_VERSION_FILE_PATH = IncrementalCacheImplKt.getCACHE_DIRECTORY_NAME() + "/format-version.txt";
    }

    public final boolean isIncompatible() {
        if (!this.file.exists()) {
            return false;
        }
        if (!IncrementalCompilation.isEnabled()) {
            return true;
        }
        int versionNumber = StringsKt.toInt((String)FilesKt.readText$default((File)this.file, null, (int)1));
        if (versionNumber != org.jetbrains.kotlin.jps.incremental.CacheFormatVersion$Companion.INSTANCE.getCACHE_FORMAT_VERSION()) {
            KotlinBuilder.Companion.INSTANCE.getLOG().info("Incompatible incremental cache version, expected " + org.jetbrains.kotlin.jps.incremental.CacheFormatVersion$Companion.INSTANCE.getCACHE_FORMAT_VERSION() + ", actual " + versionNumber);
            return true;
        }
        return false;
    }

    public final void saveIfNeeded() {
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        FilesKt.writeText$default((File)this.file, (String)String.valueOf(org.jetbrains.kotlin.jps.incremental.CacheFormatVersion$Companion.INSTANCE.getCACHE_FORMAT_VERSION()), null, (int)2);
    }

    public final void clean() {
        this.file.delete();
    }

    @NotNull
    public final File getFormatVersionFile() {
        return this.file;
    }

    public CacheFormatVersion(@NotNull File targetDataRoot) {
        Intrinsics.checkParameterIsNotNull((Object)targetDataRoot, (String)"targetDataRoot");
        this.file = new File(targetDataRoot, org.jetbrains.kotlin.jps.incremental.CacheFormatVersion$Companion.INSTANCE.getFORMAT_VERSION_FILE_PATH());
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!!Q!\u0001C\u0002\u000b\u0005Aq!B\u0001\u0005\u0005\u0011\u0019\u001d\u0001\u0004\u0001\u001a\u0003a\u0005\u0011u\u0001\u0003\u0002#\u000e\t\u0001\"A\u0015\f\t\u0005C\u00012A\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\"\u0002\t\u0007%^A!\u0011%\u0002\u0011\u000fi\u0011\u0001\u0007\u0003R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011%\u0001\"BU\f\t\u0005C\u0015\u0001c\u0003\u000e\u0003a\u0011\u0011kA\u0003\u0006\u00031\u0005QB\u0001\u0003\u0007\u0011\r\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/CacheFormatVersion$Companion;", "", "()V", "CACHE_FORMAT_VERSION", "", "getCACHE_FORMAT_VERSION", "()I", "FORMAT_VERSION_FILE_PATH", "", "getFORMAT_VERSION_FILE_PATH", "()Ljava/lang/String;", "INCREMENTAL_CACHE_OWN_VERSION", "getINCREMENTAL_CACHE_OWN_VERSION"}, moduleName="jps-plugin")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final int getINCREMENTAL_CACHE_OWN_VERSION() {
            return INCREMENTAL_CACHE_OWN_VERSION;
        }

        private final int getCACHE_FORMAT_VERSION() {
            return CACHE_FORMAT_VERSION;
        }

        private final String getFORMAT_VERSION_FILE_PATH() {
            return FORMAT_VERSION_FILE_PATH;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

