/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.ast;

import java.util.ArrayList;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.CompositeASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000e\u0015\tAAA\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\u0002B\u0003\u0002\t\u0005!1\u0002\u0004\u0001\u0011\u0013e\t\u0001\u0014AO\u0001\u0013\u00056\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u0011\t)s\u0002B\u0006\t\b5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003\u001a\r!-Q\u0002B\u0005\u0003\u0013\u0005Aj\u0001\u0007\u0004&'\u0011Y\u0001bB\u0007\u0005\u0013\tI\u0011\u0001'\u0004\u0019\re\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001c\u0004\u000e\u0003aA\u0011d\u0001E\t\u001b\u0005A\u0002\"\u000b\u0006\u0005\u0005\"A\u0011!D\u0001\u0019\u0004E\u001bA!\u0002\u0001\u000e\u0005\u0011\u0015\u0001b\u0001"}, strings={"Lorg/intellij/markdown/ast/ASTNodeBuilder;", "", "text", "", "(Ljava/lang/CharSequence;)V", "getText", "()Ljava/lang/CharSequence;", "createCompositeNode", "Lorg/intellij/markdown/ast/CompositeASTNode;", "type", "Lorg/intellij/markdown/IElementType;", "children", "", "Lorg/intellij/markdown/ast/ASTNode;", "createLeafNodes", "startOffset", "", "endOffset", "Companion"}, moduleName="intellij-markdown")
public class ASTNodeBuilder {
    @NotNull
    private final CharSequence text;
    public static final Companion Companion = org.intellij.markdown.ast.ASTNodeBuilder$Companion.INSTANCE;

    @NotNull
    public List<ASTNode> createLeafNodes(@NotNull IElementType type, int startOffset, int endOffset) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.Companion.INSTANCE.getWHITE_SPACE())) {
            int nextEol;
            ArrayList<LeafASTNode> result = new ArrayList<LeafASTNode>();
            int lastEol = startOffset;
            while (lastEol < endOffset && (nextEol = org.intellij.markdown.ast.ASTNodeBuilder$Companion.INSTANCE.indexOfSubSeq(this.text, lastEol, endOffset, '\n')) != -1) {
                if (nextEol > lastEol) {
                    result.add(new LeafASTNode(MarkdownTokenTypes.Companion.INSTANCE.getWHITE_SPACE(), lastEol, nextEol));
                }
                result.add(new LeafASTNode(MarkdownTokenTypes.Companion.INSTANCE.getEOL(), nextEol, nextEol + 1));
                lastEol = nextEol + 1;
            }
            if (endOffset > lastEol) {
                result.add(new LeafASTNode(MarkdownTokenTypes.Companion.INSTANCE.getWHITE_SPACE(), lastEol, endOffset));
            }
            return result;
        }
        return CollectionsKt.listOf((Object)new LeafASTNode(type, startOffset, endOffset));
    }

    @NotNull
    public CompositeASTNode createCompositeNode(@NotNull IElementType type, @NotNull List<? extends ASTNode> children) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull(children, (String)"children");
        IElementType iElementType = type;
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.INSTANCE.getUNORDERED_LIST()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.INSTANCE.getORDERED_LIST())) {
            return new ListCompositeNode(type, children);
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.INSTANCE.getLIST_ITEM())) {
            return new ListItemCompositeNode(children);
        }
        return new CompositeASTNode(type, children);
    }

    @NotNull
    protected final CharSequence getText() {
        return this.text;
    }

    public ASTNodeBuilder(@NotNull CharSequence text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!!Q\u0001A\u0003\u0002\u0011\u001b)\u0011\u0001b\u0001\u0006\u0003!1Aaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002KMA\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a\u0011\u0011d\u0001\u0005\u0005\u001b\u0005A\"!G\u0002\t\n5\t\u0001$\u0002"}, strings={"Lorg/intellij/markdown/ast/ASTNodeBuilder$Companion;", "", "()V", "indexOfSubSeq", "", "s", "", "from", "to", "c", ""}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        /*
         * WARNING - void declaration
         */
        public final int indexOfSubSeq(@NotNull CharSequence s, int from, int to, char c) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            int n = from;
            int n2 = to - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    if (s.charAt((int)i) == c) {
                        return (int)i;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            return -1;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

