/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\tA!A\u0003\u0002\u0011A)\u0001!B\u0001\r\u0003\u0015\tAQ\u0001\u0007\u00013\u0005A\n!(A\u0007C\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005%RA!\u0011\u0005\t\u00065!\u0011BA\u0005\u00021\u0007A2!U\u0002\u0002\u000b\u0001I3\u0002B\"\t\u0011\u000fi!\u0001$\u0001\u0019\tE\u001bA!\u0002\u0001\u000e\u0005\u0011%\u0001\"B\u0015\u000b\t\rC\u0001\"A\u0007\u00021\u0007\t6\u0001B\u0003\u0001\u001b\t!Y\u0001\u0003\u0004"}, strings={"Lorg/intellij/markdown/parser/LookaheadText;", "", "text", "", "(Ljava/lang/String;)V", "lines", "", "startPosition", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "getStartPosition", "()Lorg/intellij/markdown/parser/LookaheadText$Position;", "getText", "()Ljava/lang/String;", "Position"}, moduleName="intellij-markdown")
public final class LookaheadText {
    private final List<? extends String> lines;
    @Nullable
    private final Position startPosition;
    @NotNull
    private final String text;

    @Nullable
    public final Position getStartPosition() {
        return this.startPosition;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public LookaheadText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
        this.lines = StringsKt.split$default((String)this.text, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6);
        this.startPosition = StringsKt.isNotEmpty((String)this.text) ? Position.nextPosition$default(new Position(0, -1, -1), 0, 1) : (Position)null;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\t\u0015\tAAA\u0003\u0002\u0011\u0019)\u0011\u0001b\u0001\u0006\u0003!9Q!\u0001C\u0002\u000b\u0005Ai!B\u0001\u0005\u0018\u0011\u0019%\u0001\u0004\u0001\u001a\u0003a\u0005\u0011\u0005\u0006\u0003\u0001\u0013\u0013A\u0011!D\u0001\u0019\u0004A\u001b\t!#\u0003\t\u00055\t\u00014\u0001)\u0004\u0003%%\u0001RA\u0007\u00021\u0007\u000161A)\u0004\u0003!\u0019QU\u0002E\u0012\u001b\ta\t\u0001g\u0001R\u0007\u0005A9\"\n\u0003\t%5\u0011A\u0012\u0001\r\u0001K%A)#\u0004\u0002\r\u0002a\u0001\u0011\u0004\u0002\u0003\u0002\u0011Mi\u0011\u0001g\u0001&\t\u0011Y\u0001rE\u0007\u00021\u0019I#\u0002B\"\t\u0011\u000fi\u0011\u0001\u0007\u0003\u001dGE\u001b1!\u0004\u0002\u0005\n!)\u0011F\u0003\u0003D\u0011!-Q\"\u0001\r\u00079\r\n6aA\u0007\u0003\t\u001bAq!\u000b\u0006\u0005\u0007\"Ay!D\u0001\u0019\u0011q\u0019\u0013kA\u0002\u000e\u0005\u0011E\u0001\"C\u0015\b\t\u0005C\u0001RA\u0007\u00021\u0007\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\ti\u0011\u0001g\u0001R\u0007\u0005)\u0001!K\u0006\u0005\u0007\"A\u0019\"\u0004\u0002\r\u0002a1AdI)\u0004\u00075\u0011AA\u0003\u0005\bS-!1\t\u0003E\u000b\u001b\ta\t\u0001g\u0001\u001dGE\u001b1!\u0004\u0002\u0005\u0017!]\u0011F\u0003\u0003D\u0011!aQ\"\u0001M\u00029\r\n6aA\u0007\u0003\t3AQ\"\u000b\u0006\u0005\u0007\"AY\"D\u0001\u0019\u0004q\u0019\u0013kA\u0002\u000e\u0005\u0011q\u0001\"D\u0015\u000b\t\rC\u0001RD\u0007\u00021\u0007a2%U\u0002\u0004\u001b\t!q\u0002C\u0007*\u0017\u0011\u0019\u0005\u0002c\b\u000e\u00051\u0005\u0001D\u0002\u000f$#\u000e\u0019QB\u0001\u0003\u0011\u0011\u001dI#\u0002B\"\t\u0011Ci\u0011\u0001\u0007\u0005\u001dGE\u001b1!\u0004\u0002\u0005#!I\u0001"}, strings={"Lorg/intellij/markdown/parser/LookaheadText$Position;", "", "lineN", "", "localPos", "globalPos", "(Lorg/intellij/markdown/parser/LookaheadText;III)V", "char", "", "getChar", "()C", "currentLine", "", "getCurrentLine", "()Ljava/lang/String;", "currentLineFromPosition", "", "getCurrentLineFromPosition", "()Ljava/lang/CharSequence;", "nextLine", "getNextLine", "nextLineOffset", "getNextLineOffset", "()Ljava/lang/Integer;", "nextLineOrEofOffset", "getNextLineOrEofOffset", "()I", "offset", "getOffset", "offsetInCurrentLine", "getOffsetInCurrentLine", "prevLine", "getPrevLine", "textFromPosition", "getTextFromPosition", "charsToNonWhitespace", "nextLinePosition", "nextPosition", "delta", "toString"}, moduleName="intellij-markdown")
    public final class Position {
        private final int lineN;
        private final int localPos;
        private final int globalPos;

        @NotNull
        public String toString() {
            return "Position: '" + (this.localPos == -1 ? "\\n" + this.getCurrentLine() : StringsKt.substring((String)this.getCurrentLine(), (int)this.localPos)) + "'";
        }

        public final int getOffset() {
            return this.globalPos;
        }

        public final int getOffsetInCurrentLine() {
            return this.localPos;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Integer getNextLineOffset() {
            void $receiver;
            Collection collection = LookaheadText.this.lines;
            int n = this.lineN + 1;
            int n2 = $receiver.size();
            return n < n2 ? Integer.valueOf(this.globalPos + (CollectionsKt.length((CharSequence)this.getCurrentLine()) - this.localPos)) : (Integer)null;
        }

        public final int getNextLineOrEofOffset() {
            return this.globalPos + (CollectionsKt.length((CharSequence)this.getCurrentLine()) - this.localPos);
        }

        @NotNull
        public final CharSequence getTextFromPosition() {
            return LookaheadText.this.getText().subSequence(this.globalPos, CollectionsKt.length((CharSequence)LookaheadText.this.getText()));
        }

        @NotNull
        public final String getCurrentLine() {
            return LookaheadText.this.lines.get(this.lineN);
        }

        @NotNull
        public final CharSequence getCurrentLineFromPosition() {
            return this.getCurrentLine().subSequence(this.getOffsetInCurrentLine(), CollectionsKt.length((CharSequence)this.getCurrentLine()));
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String getNextLine() {
            void $receiver;
            Collection collection = LookaheadText.this.lines;
            int n = this.lineN + 1;
            int n2 = $receiver.size();
            return n < n2 ? LookaheadText.this.lines.get(this.lineN + 1) : (String)null;
        }

        @Nullable
        public final String getPrevLine() {
            return this.lineN > 0 ? LookaheadText.this.lines.get(this.lineN - 1) : (String)null;
        }

        public final char getChar() {
            return CollectionsKt.charAt((CharSequence)LookaheadText.this.getText(), (int)this.globalPos);
        }

        @Nullable
        public final Position nextPosition(int delta) {
            int remaining = delta;
            Position currentPosition = this;
            while (currentPosition.localPos + remaining >= CollectionsKt.length((CharSequence)currentPosition.getCurrentLine())) {
                Integer nextLine = currentPosition.getNextLineOffset();
                if (nextLine == null) {
                    return null;
                }
                int payload = CollectionsKt.length((CharSequence)currentPosition.getCurrentLine()) - currentPosition.localPos;
                currentPosition = new Position(currentPosition.lineN + 1, -1, currentPosition.globalPos + payload);
                remaining -= payload;
            }
            return new Position(currentPosition.lineN, currentPosition.localPos + remaining, currentPosition.globalPos + remaining);
        }

        @Nullable
        public static /* synthetic */ Position nextPosition$default(Position position, int n, int n2) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return position.nextPosition(n);
        }

        @Nullable
        public final Position nextLinePosition() {
            Integer n = this.getNextLineOffset();
            if (n == null) {
                return null;
            }
            int nextLine = ((Number)n).intValue();
            return this.nextPosition(nextLine - this.getOffset());
        }

        @Nullable
        public final Integer charsToNonWhitespace() {
            String line = this.getCurrentLine();
            for (int offset = this.localPos; offset < CollectionsKt.length((CharSequence)line); ++offset) {
                char c;
                if (offset < 0 || (c = line.charAt(offset)) == ' ' || c == '\t') continue;
                return offset - this.localPos;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public Position(int lineN, int localPos, int globalPos) {
            void $receiver;
            this.lineN = lineN;
            this.localPos = localPos;
            this.globalPos = globalPos;
            Collection collection = LookaheadText.this.lines;
            int n = this.lineN;
            int n2 = $receiver.size();
            PreconditionsKt.assert((n < n2 ? 1 : 0) != 0);
            PreconditionsKt.assert((this.localPos >= -1 && this.localPos < CollectionsKt.length((CharSequence)LookaheadText.this.lines.get(this.lineN)) ? 1 : 0) != 0);
        }
    }
}

