/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.Range;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.MyBuilder;
import org.intellij.markdown.parser.MyRawBuilder;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.sequentialparsers.LexerBasedTokensCache;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\u0001Q!\u0001E\u0007\u000b\u0001)\u0011\u0001\u0003\u0003\u0006\u0003\u0011\tA\u0002A\r\u00021\u0003i\n1CQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&\u000f!\u0015Q\"\u0001\r\u00043\rA9!D\u0001\u0019\t\u0015\u0002\u0002\u0012B\u0007\u00021\rI2\u0001C\u0003\u000e\u0003a-\u0011d\u0001E\u0004\u001b\u0005AB!\u0007\u0003\u0005\u0003!1Q\"\u0001M\u0007KMAq!D\u0001\u0019\u0007e\u0019\u0001\"B\u0007\u00021\u0017I2\u0001c\u0002\u000e\u0003a=\u0011d\u0001\u0005\t\u001b\u0005A\n\"G\u0002\t\u00135\t\u0001\u0014C\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001"}, strings={"Lorg/intellij/markdown/parser/MarkdownParser;", "", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "(Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;)V", "buildMarkdownTreeFromString", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "parse", "root", "Lorg/intellij/markdown/IElementType;", "parseInlines", "", "parseInline", "", "textStart", "", "textEnd", "InlineExpandingASTNodeBuilder"}, moduleName="intellij-markdown")
public final class MarkdownParser {
    private final MarkdownFlavourDescriptor flavour;

    @NotNull
    public final ASTNode buildMarkdownTreeFromString(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.parse(MarkdownElementTypes.Companion.INSTANCE.getMARKDOWN_FILE(), text, true);
    }

    @NotNull
    public final ASTNode parse(@NotNull IElementType root, @NotNull String text, boolean parseInlines) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        ProductionHolder productionHolder = new ProductionHolder();
        MarkerProcessor<?> markerProcessor = this.flavour.getMarkerProcessorFactory().createMarkerProcessor(productionHolder);
        ProductionHolder.Marker rootMarker = productionHolder.mark();
        LookaheadText textHolder = new LookaheadText(text);
        LookaheadText.Position pos = textHolder.getStartPosition();
        while (pos != null) {
            productionHolder.updatePosition(pos.getOffset());
            pos = markerProcessor.processPosition(pos);
        }
        productionHolder.updatePosition(CollectionsKt.length((CharSequence)text));
        markerProcessor.flushMarkers();
        rootMarker.done(root);
        ASTNodeBuilder nodeBuilder = parseInlines ? (ASTNodeBuilder)new InlineExpandingASTNodeBuilder(text) : new ASTNodeBuilder(text);
        MyRawBuilder builder = new MyRawBuilder(nodeBuilder);
        return builder.buildTree(productionHolder.getProduction());
    }

    @NotNull
    public static /* synthetic */ ASTNode parse$default(MarkdownParser markdownParser, IElementType iElementType, String string, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return markdownParser.parse(iElementType, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ASTNode parseInline(@NotNull IElementType root, @NotNull CharSequence text, int textStart, int textEnd) {
        void $receiver;
        IntRange intRange;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        MarkdownLexer lexer = this.flavour.createInlinesLexer();
        lexer.start(text, textStart, textEnd);
        LexerBasedTokensCache tokensCache = new LexerBasedTokensCache(lexer);
        Collection collection = tokensCache.getFilteredTokens();
        int n = 0;
        IntRange intRange2 = intRange;
        IntRange intRange3 = intRange;
        int n2 = $receiver.size();
        intRange2(n, n2);
        IntRange wholeRange = intRange3;
        Collection<SequentialParser.Node> nodes = this.flavour.getSequentialParserManager().runParsingSequence(tokensCache, SequentialParserUtil.Companion.INSTANCE.filterBlockquotes(tokensCache, (Range<Integer>)((Range)wholeRange)));
        return new MyBuilder(new ASTNodeBuilder(text), tokensCache).buildTree(CollectionsKt.plus(nodes, (Iterable)CollectionsKt.listOf((Object)new SequentialParser.Node((Range<Integer>)((Range)wholeRange), root))));
    }

    public MarkdownParser(@NotNull MarkdownFlavourDescriptor flavour) {
        Intrinsics.checkParameterIsNotNull((Object)flavour, (String)"flavour");
        this.flavour = flavour;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000e\u0015\tA!A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AA!\u0002\u0001\u0005\u0003\na\u0001!G\u0001\u0019\u0002\u0005B\u0011\u0012\u0002\u0005\u0002\u001b\u0005A\u001a\u0001UB\u0001#\u000e\t\u0001BA\u0013\u0014\t-A)!\u0004\u0003\n\u0005%\t\u0001t\u0001\r\u00043\rAA!D\u0001\u0019\ne\u0019\u0001\"B\u0007\u00021\u0017I2\u0001\u0003\u0004\u000e\u0003a-\u0001"}, strings={"Lorg/intellij/markdown/parser/MarkdownParser$InlineExpandingASTNodeBuilder;", "Lorg/intellij/markdown/ast/ASTNodeBuilder;", "text", "", "(Lorg/intellij/markdown/parser/MarkdownParser;Ljava/lang/CharSequence;)V", "createLeafNodes", "", "Lorg/intellij/markdown/ast/ASTNode;", "type", "Lorg/intellij/markdown/IElementType;", "startOffset", "", "endOffset"}, moduleName="intellij-markdown")
    private final class InlineExpandingASTNodeBuilder
    extends ASTNodeBuilder {
        @Override
        @NotNull
        public List<ASTNode> createLeafNodes(@NotNull IElementType type, int startOffset, int endOffset) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            IElementType iElementType = type;
            return Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.INSTANCE.getPARAGRAPH()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.INSTANCE.getATX_CONTENT()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.INSTANCE.getSETEXT_CONTENT()) ? CollectionsKt.listOf((Object)MarkdownParser.this.parseInline(type, this.getText(), startOffset, endOffset)) : super.createLeafNodes(type, startOffset, endOffset);
        }

        public InlineExpandingASTNodeBuilder(CharSequence text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            super(text);
        }
    }
}

