/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.ParagraphMarkerBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"i\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\t\u0001\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001c\u0003\u0006\u0001\u0015\t\u0001\u0012E\u0003\u0002\t\u0005)\u0011\u0001\u0003\u0003\u0006\u0003\u0011)Q!\u0001\u0005\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0004\tMa\u0001!\u0006\u0003\u0005\u0001!\u0005Q#\u0001\r\u00023\u0005A\u001a!(A\u001cC+I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011b\u0001\u0005\u0004\u001b\u0005A:!U\u0002\u0002\u0011\u0011)s\u0001\u0003\t\u000e\u0003a\u0005\u0012d\u0001\u0005\u0012\u001b\u0005AZ!\n\t\u0005\u0003!\rR\"\u0001M\u00113\rA!#D\u0001\u0019\u0017e\u0019\u0001RE\u0007\u00021\u0017I2\u0001C\n\u000e\u0003a\u001dR\u0005\u0003\u0003\u0002\u0011Qi\u0011\u0001G\u0006\u001a\u0007!%R\"\u0001\r\tK1!\u0011\u0001C\u000b\u000e\u0003a\u0005\u0012d\u0001\u0005\u0013\u001b\u0005A2\"G\u0002\t,5\t\u0001DF\u0013\u0010\t-Ai#\u0004\u0003\n\u0005%\t\u00014\u0002\r\u00063\rAI#D\u0001\u0019\u0011e\u0019\u0001BA\u0007\u00021\u000b)3\u0001C\f\u000e\u0003a\u0005RE\u0003\u0003\u0013\u0011_iq!C\u0003\n\t%\u0011\u0011\"\u0001\u000f\u00011aAR!\n\t\u0005%!ER\"\u0001M\u00113\rAI#D\u0001\u0019\u0011e\u0019\u0001\"G\u0007\u00021\u000fI2\u0001\u0003\u0002\u000e\u0003a\u0015Q\u0005\u0003\u0003\u0002\u0011gi\u0011\u0001'\u0005\u001a\u0007!%R\"\u0001\r\tK!A!$\u0004\u0002\r\u0002aA\u0011d\u0001E\u0015\u001b\u0005A\u0002\"\n\u0003\u0005\u0003!UR\"\u0001M\u0011K!!!\u0003C\u000e\u000e\u0003a\u0005\u0012d\u0001E\u0015\u001b\u0005A\u0002\"K\u0007\u0005\u0005\"AI!\u0004\u0003\n\u0005%\t\u00014\u0002\r\u0006#\u000e!Q\u0001A\u0007\u0003\t\u0019Ai!\u000b\t\u0005\u0003\"Aq!\u0004\u0006\n\u0005%\t\u0001\u0004C\u0005\u0003\u0013\u0005A:!\u0003\u0002\n\u0003aE\u0001tB)\u0004\u0003\u0015\u0001\u0011&\u0004\u0003C\u0011!IQ\u0002B\u0005\u0003\u0013\u0005AZ\u0001g\u0005R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0015!5\u0011f\u0002\u0003B9!UQ\"\u0001\r\f#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001BA\u0007\u00021\u000b\t6!A\u0003\u0001S)!!\t\u0003\u0005\u0004\u001b\u0005A:!U\u0002\u0005\u000b\u0001i!\u0001b\u0006\t\u0019%JAA\u0015\u0005\t\u001a5\tA\u0004A)\u0004\u00075\u0011A!\u0004E\u000eS5!!\t\b\u0005\u000f\u001b\u0005A:!U\u0002\b\u000b\u0001i!\u0001\"\b\t\u0019E\u0011Aa\u0004E\u0010"}, strings={"Lorg/intellij/markdown/parser/MarkerProcessor;", "T", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "startConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "(Lorg/intellij/markdown/parser/ProductionHolder;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)V", "NO_BLOCKS", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "getNO_BLOCKS", "()Ljava/util/List;", "interruptsParagraph", "Lkotlin/Function2;", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "", "markersStack", "", "getMarkersStack", "nextInterestingPosForExistingMarkers", "", "getStartConstraints", "()Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "stateInfo", "getStateInfo", "()Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "topBlockConstraints", "getTopBlockConstraints", "setTopBlockConstraints", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)V", "addNewMarkerBlock", "", "newMarkerBlock", "applyProcessingResult", "index", "markerBlock", "processingResult", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "calculateNextPosForExistingMarkers", "pos", "closeChildren", "childrenAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "createNewMarkerBlocks", "flushMarkers", "getMarkerBlockProviders", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "populateConstraintsTokens", "constraints", "processMarkers", "processPosition", "relaxTopConstraints", "updateStateInfo", "StateInfo"}, moduleName="intellij-markdown")
public abstract class MarkerProcessor<T extends StateInfo> {
    @NotNull
    private final List<? extends MarkerBlock> NO_BLOCKS;
    @NotNull
    private final List<MarkerBlock> markersStack;
    @NotNull
    private MarkdownConstraints topBlockConstraints;
    private int nextInterestingPosForExistingMarkers;
    private final Function2<? super LookaheadText.Position, ? super MarkdownConstraints, ? extends Boolean> interruptsParagraph;
    private final ProductionHolder productionHolder;
    @NotNull
    private final MarkdownConstraints startConstraints;

    @NotNull
    protected final List<MarkerBlock> getNO_BLOCKS() {
        return this.NO_BLOCKS;
    }

    @NotNull
    protected final List<MarkerBlock> getMarkersStack() {
        return this.markersStack;
    }

    @NotNull
    protected final MarkdownConstraints getTopBlockConstraints() {
        return this.topBlockConstraints;
    }

    protected final void setTopBlockConstraints(@NotNull MarkdownConstraints markdownConstraints) {
        Intrinsics.checkParameterIsNotNull((Object)markdownConstraints, (String)"<set-?>");
        this.topBlockConstraints = markdownConstraints;
    }

    @NotNull
    protected abstract T getStateInfo();

    @NotNull
    protected abstract List<MarkerBlockProvider<T>> getMarkerBlockProviders();

    protected abstract void updateStateInfo(@NotNull LookaheadText.Position var1);

    protected abstract void populateConstraintsTokens(@NotNull LookaheadText.Position var1, @NotNull MarkdownConstraints var2, @NotNull ProductionHolder var3);

    @NotNull
    public List<MarkerBlock> createNewMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        PreconditionsKt.assert((boolean)MarkerBlockProvider.Companion.INSTANCE.isStartOfLineWithConstraints(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints()));
        for (MarkerBlockProvider<T> provider : this.getMarkerBlockProviders()) {
            List<MarkerBlock> list = provider.createMarkerBlocks(pos, productionHolder, this.getStateInfo());
            if (!CollectionsKt.isNotEmpty((Collection)list)) continue;
            return list;
        }
        if (pos.getOffsetInCurrentLine() >= ((StateInfo)this.getStateInfo()).getNextConstraints().getCharsEaten(pos.getCurrentLine()) && pos.charsToNonWhitespace() != null) {
            return CollectionsKt.listOf((Object)new ParagraphMarkerBlock(((StateInfo)this.getStateInfo()).getCurrentConstraints(), productionHolder.mark(), this.interruptsParagraph));
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public final LookaheadText.Position processPosition(@NotNull LookaheadText.Position pos) {
        int delta;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        this.updateStateInfo(pos);
        boolean shouldRecalcNextPos = false;
        if (pos.getOffset() >= this.nextInterestingPosForExistingMarkers) {
            this.processMarkers(pos);
            shouldRecalcNextPos = true;
        }
        if (MarkerBlockProvider.Companion.INSTANCE.isStartOfLineWithConstraints(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints())) {
            MarkerBlock markerBlock = (MarkerBlock)CollectionsKt.lastOrNull(this.markersStack);
            if (Intrinsics.areEqual((Object)(markerBlock != null ? Boolean.valueOf(markerBlock.allowsSubBlocks()) : null), (Object)false) ^ true) {
                List<MarkerBlock> newMarkerBlocks = this.createNewMarkerBlocks(pos, this.productionHolder);
                for (MarkerBlock newMarkerBlock : newMarkerBlocks) {
                    this.addNewMarkerBlock(newMarkerBlock);
                    shouldRecalcNextPos = true;
                }
            }
        }
        if (shouldRecalcNextPos) {
            this.nextInterestingPosForExistingMarkers = this.calculateNextPosForExistingMarkers(pos);
        }
        if ((pos.getOffsetInCurrentLine() == -1 || MarkerBlockProvider.Companion.INSTANCE.isStartOfLineWithConstraints(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints())) && (delta = ((StateInfo)this.getStateInfo()).getNextConstraints().getCharsEaten(pos.getCurrentLine()) - pos.getOffsetInCurrentLine()) > 0) {
            if (pos.getOffsetInCurrentLine() != -1 && ((StateInfo)this.getStateInfo()).getNextConstraints().getIndent() <= this.topBlockConstraints.getIndent()) {
                this.populateConstraintsTokens(pos, ((StateInfo)this.getStateInfo()).getNextConstraints(), this.productionHolder);
            }
            return pos.nextPosition(delta);
        }
        return pos.nextPosition(this.nextInterestingPosForExistingMarkers - pos.getOffset());
    }

    private final int calculateNextPosForExistingMarkers(LookaheadText.Position pos) {
        MarkerBlock markerBlock = (MarkerBlock)CollectionsKt.lastOrNull(this.markersStack);
        int result = markerBlock != null ? markerBlock.getNextInterestingOffset(pos) : pos.getNextLineOrEofOffset();
        return result == -1 ? Integer.MAX_VALUE : result;
    }

    public final void addNewMarkerBlock(@NotNull MarkerBlock newMarkerBlock) {
        Intrinsics.checkParameterIsNotNull((Object)newMarkerBlock, (String)"newMarkerBlock");
        this.markersStack.add(newMarkerBlock);
        this.relaxTopConstraints();
    }

    public final void flushMarkers() {
        this.closeChildren(-1, MarkerBlock.ClosingAction.DEFAULT);
    }

    private final boolean processMarkers(LookaheadText.Position pos) {
        Collection $receiver = this.markersStack;
        int index = $receiver.size();
        while (index > 0) {
            MarkerBlock markerBlock;
            MarkerBlock.ProcessingResult processingResult;
            $receiver = this.markersStack;
            int n = --index;
            int n2 = $receiver.size();
            if (n >= n2 || Intrinsics.areEqual((Object)(processingResult = (markerBlock = this.markersStack.get(index)).processToken(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints())), (Object)MarkerBlock.ProcessingResult.Companion.INSTANCE.getPASS())) continue;
            this.applyProcessingResult(index, markerBlock, processingResult);
            if (!Intrinsics.areEqual((Object)((Object)processingResult.getEventAction()), (Object)((Object)MarkerBlock.EventAction.CANCEL))) continue;
            return true;
        }
        return false;
    }

    private final void applyProcessingResult(int index, MarkerBlock markerBlock, MarkerBlock.ProcessingResult processingResult) {
        this.closeChildren(index, processingResult.getChildrenAction());
        if (markerBlock.acceptAction(processingResult.getSelfAction())) {
            CollectionsKt.remove(this.markersStack, (int)index);
            this.relaxTopConstraints();
        }
    }

    private final void closeChildren(int index, MarkerBlock.ClosingAction childrenAction) {
        if (Intrinsics.areEqual((Object)((Object)childrenAction), (Object)((Object)MarkerBlock.ClosingAction.NOTHING)) ^ true) {
            Collection collection = this.markersStack;
            for (int latterIndex = $receiver.size() - 1; latterIndex > index; --latterIndex) {
                boolean result = this.markersStack.get(latterIndex).acceptAction(childrenAction);
                if (PreconditionsKt.getASSERTIONS_ENABLED() && !result) {
                    String message = "If closing action is not NOTHING, marker should be gone";
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                CollectionsKt.remove(this.markersStack, (int)latterIndex);
            }
            this.relaxTopConstraints();
        }
    }

    private final void relaxTopConstraints() {
        this.topBlockConstraints = this.markersStack.isEmpty() ? this.startConstraints : ((MarkerBlock)CollectionsKt.last(this.markersStack)).getBlockConstraints();
    }

    @NotNull
    protected final MarkdownConstraints getStartConstraints() {
        return this.startConstraints;
    }

    public MarkerProcessor(@NotNull ProductionHolder productionHolder, @NotNull MarkdownConstraints startConstraints) {
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)startConstraints, (String)"startConstraints");
        this.productionHolder = productionHolder;
        this.startConstraints = startConstraints;
        this.NO_BLOCKS = CollectionsKt.emptyList();
        this.markersStack = new ArrayList();
        this.topBlockConstraints = this.startConstraints;
        this.nextInterestingPosForExistingMarkers = -1;
        this.interruptsParagraph = (Function2)new Function2<LookaheadText.Position, MarkdownConstraints, Boolean>(this){
            final /* synthetic */ MarkerProcessor this$0;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull LookaheadText.Position position, @NotNull MarkdownConstraints constraints) {
                void var3_3;
                Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
                Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
                boolean result = false;
                for (MarkerBlockProvider<T> provider : this.this$0.getMarkerBlockProviders()) {
                    if (!provider.interruptsParagraph(position, constraints)) continue;
                    result = true;
                    break;
                }
                return (boolean)var3_3;
            }
            {
                this.this$0 = markerProcessor;
                super(2);
            }
        };
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0003\u0011!Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\f\u0015\tA!A\u0003\u0002\u0011\u0011!1\u0002\u0004\u0001\u001a\u0003a\u0005\u00115E\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\u0007!\u0011Q\"\u0001M\u0002\u0013\u0019A)!\u0004\u0003\n\u0005%\t\u0001t\u0001\r\u0004#\u000e\t\u0001\u0002BS\n\t-#\u00012C\u0007\u00021)IB\u0001#\u0006\u000e\u00051\u0005\u0001\u0014A\u0013\u0005\t-A1\"D\u0001\u0019\u0018%RAa\u0011\u0005\t\u00035\t\u00014A)\u0004\t\u0015\u0001QB\u0001C\u0005\u0011\u0015I3\u0002B\"\t\u0011\u0017i!\u0001$\u0001\u0019\bq\u0019\u0013kA\u0002\u000e\u0005\u00111\u0001RB\u0015\u000b\t\u0005C\u0001RA\u0007\u0005\u0013\tI\u0011\u0001g\u0002\u0019\u0007E\u001b\u0011!\u0002\u0001*\u0015\u0011\u0019\u0005\u0002\u0003\u0002\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0002\u0005\u0006S-!1\t\u0003E\b\u001b\ta\t\u0001\u0007\u0005\u001dGE\u001b1!\u0004\u0002\u0005\u0012!I\u0001"}, strings={"Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "", "currentConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "nextConstraints", "markersStack", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Ljava/util/List;)V", "getCurrentConstraints", "()Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "lastBlock", "getLastBlock", "()Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "getNextConstraints", "paragraphBlock", "Lorg/intellij/markdown/parser/markerblocks/impl/ParagraphMarkerBlock;", "getParagraphBlock", "()Lorg/intellij/markdown/parser/markerblocks/impl/ParagraphMarkerBlock;", "equals", "", "other", "hashCode", ""}, moduleName="intellij-markdown")
    public static class StateInfo {
        @NotNull
        private final MarkdownConstraints currentConstraints;
        @NotNull
        private final MarkdownConstraints nextConstraints;
        private final List<? extends MarkerBlock> markersStack;

        @Nullable
        public final ParagraphMarkerBlock getParagraphBlock() {
            Object v0;
            block1: {
                Iterable $receiver = this.markersStack;
                for (Object element : $receiver) {
                    MarkerBlock block = (MarkerBlock)element;
                    if (!(block instanceof ParagraphMarkerBlock)) continue;
                    v0 = element;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final MarkerBlock getLastBlock() {
            return (MarkerBlock)CollectionsKt.lastOrNull(this.markersStack);
        }

        public boolean equals(@Nullable Object other) {
            Object object = other;
            if (!(object instanceof StateInfo)) {
                object = null;
            }
            StateInfo stateInfo = (StateInfo)object;
            if (stateInfo == null) {
                return false;
            }
            StateInfo otherStateInfo = stateInfo;
            return Intrinsics.areEqual((Object)this.currentConstraints, (Object)otherStateInfo.currentConstraints) && Intrinsics.areEqual((Object)this.nextConstraints, (Object)otherStateInfo.nextConstraints) && Intrinsics.areEqual(this.markersStack, otherStateInfo.markersStack);
        }

        public int hashCode() {
            int result = this.currentConstraints.hashCode();
            result = result * 37 + this.nextConstraints.hashCode();
            result = result * 37 + ((Object)this.markersStack).hashCode();
            return result;
        }

        @NotNull
        public final MarkdownConstraints getCurrentConstraints() {
            return this.currentConstraints;
        }

        @NotNull
        public final MarkdownConstraints getNextConstraints() {
            return this.nextConstraints;
        }

        public StateInfo(@NotNull MarkdownConstraints currentConstraints, @NotNull MarkdownConstraints nextConstraints, @NotNull List<? extends MarkerBlock> markersStack) {
            Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
            Intrinsics.checkParameterIsNotNull((Object)nextConstraints, (String)"nextConstraints");
            Intrinsics.checkParameterIsNotNull(markersStack, (String)"markersStack");
            this.currentConstraints = currentConstraints;
            this.nextConstraints = nextConstraints;
            this.markersStack = markersStack;
        }
    }
}

