/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.Pair;
import kotlin.Range;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.CodeFenceMarkerBlock;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"G\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001C\u0004\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\u0003\u0006\u00011\u0001\u0001cC\r\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u0002u\u00051\")\u0002R\u0007\u0005A\u0019!J\n\u0005\u0017!\u0011Q\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00053\rAI!D\u0001\u0019\u000be\u0019\u00012B\u0007\u00021\u0005)c\u0003B\u0001\t\r5\t\u0001TB\r\u0004\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\u0013!9QbB\u0005\u0003\u0013\u0005A\u0002\"\u0003\u0002\n\u0003aA\u0001tB\r\u0004\u0011\u0013i\u0011\u0001G\u0003&'\u0011\t\u0001\u0012C\u0007\t\u0013\tI\u0011\u0001\u0007\u0005\n\u0005%\t\u0001\u0004\u0003G\u00011\u001fI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001\u0005\n\u001b\u0005A\u001a\"\n\u0007\u0005\u0017!QQ\"\u0001M\u000b3\rA9!D\u0001\u0019\te\u0019\u0001\"C\u0007\u00021'\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/CodeFenceProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "createNodesForFenceStart", "", "fenceAndInfo", "Lkotlin/Pair;", "", "getFenceStartAndInfo", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "interruptsParagraph", "", "Companion"}, moduleName="intellij-markdown")
public final class CodeFenceProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Regex REGEX;
    public static final Companion Companion;

    static {
        Companion = org.intellij.markdown.parser.markerblocks.providers.CodeFenceProvider$Companion.INSTANCE;
        REGEX = new Regex("^ {0,3}(~~~+|```+)([^`]*)$");
    }

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        Pair<String, String> fenceAndInfo = this.getFenceStartAndInfo(pos, stateInfo.getCurrentConstraints());
        if (fenceAndInfo != null) {
            this.createNodesForFenceStart(pos, fenceAndInfo, productionHolder);
            return CollectionsKt.listOf((Object)new CodeFenceMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, (String)fenceAndInfo.getFirst()));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return this.getFenceStartAndInfo(pos, constraints) != null;
    }

    private final void createNodesForFenceStart(LookaheadText.Position pos, Pair<? extends String, ? extends String> fenceAndInfo, ProductionHolder productionHolder) {
        int infoStartPosition = pos.getNextLineOrEofOffset() - CollectionsKt.length((CharSequence)((CharSequence)fenceAndInfo.getSecond()));
        productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node((Range<Integer>)((Range)new IntRange(pos.getOffset(), infoStartPosition)), MarkdownTokenTypes.Companion.INSTANCE.getCODE_FENCE_START())));
        if (CollectionsKt.length((CharSequence)((CharSequence)fenceAndInfo.getSecond())) > 0) {
            productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node((Range<Integer>)((Range)new IntRange(infoStartPosition, pos.getNextLineOrEofOffset())), MarkdownTokenTypes.Companion.INSTANCE.getFENCE_LANG())));
        }
    }

    private final Pair<String, String> getFenceStartAndInfo(LookaheadText.Position pos, MarkdownConstraints constraints) {
        if (!MarkerBlockProvider.Companion.INSTANCE.isStartOfLineWithConstraints(pos, constraints)) {
            return null;
        }
        MatchResult matchResult = Regex.match$default((Regex)org.intellij.markdown.parser.markerblocks.providers.CodeFenceProvider$Companion.INSTANCE.getREGEX(), (CharSequence)pos.getCurrentLineFromPosition(), (int)0, (int)2);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        MatchGroup matchGroup = matchResult2.getGroups().get(1);
        String string = matchGroup != null ? matchGroup.getValue() : null;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        MatchGroup matchGroup2 = matchResult2.getGroups().get(2);
        String string2 = matchGroup2 != null ? matchGroup2.getValue() : null;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        return new Pair((Object)string, (Object)string2);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!K\u0006\u0005\u0007\"A\u0019!D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011AQ\u0001\u0005\u0004"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/CodeFenceProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

