/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Regex;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.HorizontalRuleMarkerBlock;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\r\u0001AE\u0011\u0004B\u0005\u0003\u0013\u0005A\u0012\u0001'\u0001\u001e\u0002#\t+!U\u0002\u0002\u0011\u0007)3\u0003B\u0006\t\u00055!\u0011BA\u0005\u00021\rA*!G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!-Q\"\u0001\r\u0002K1!1\u0002\u0003\u0004\u000e\u0003a5\u0011d\u0001E\u0004\u001b\u0005AB!G\u0002\t\u000f5\t\u0001tB\u0013\f\u0011!i\u0011\u0001'\u0004\u001a\u0007!\u001dQ\"\u0001\r\u00053\rAq!D\u0001\u0019\u0010\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/HorizontalRuleProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "Companion"}, moduleName="intellij-markdown")
public final class HorizontalRuleProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Regex REGEX;
    public static final Companion Companion;

    static {
        Companion = org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider$Companion.INSTANCE;
        Companion $receiver = org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider$Companion.INSTANCE;
        Companion $receiver2 = $receiver;
        ArrayList<String> variants = new ArrayList<String>();
        String[] stringArray = new String[]{"-", "_", "\\*"};
        for (int i = 0; i < stringArray.length; ++i) {
            String c = stringArray[i];
            variants.add("(" + c + " *){3,}");
        }
        REGEX = new Regex("^ {0,3}(" + StringsKt.join$default((Iterable)variants, (String)"|", null, null, (int)0, null, (int)30) + ")$");
    }

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        if (this.matches(pos, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.listOf((Object)new HorizontalRuleMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark()));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return this.matches(pos, constraints);
    }

    public final boolean matches(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        if (!MarkerBlockProvider.Companion.INSTANCE.isStartOfLineWithConstraints(pos, constraints)) {
            return false;
        }
        return org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider$Companion.INSTANCE.isHorizontalRule(pos.getCurrentLine(), pos.getOffsetInCurrentLine());
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005AY!\u0002\u0001\u0006\u0003!5Q\u0001A\u0003\u0002\u0011\u0011!19\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u0017!\u001dQ\"\u0001\r\u00053\rAI!D\u0001\u0019\u000be\u0019\u00012B\u0007\u00021\u0019I3\u0002B\"\t\u0011\u0007i\u0011\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011\u0015\u0001b\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/HorizontalRuleProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;", "isHorizontalRule", "", "line", "", "offset", ""}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isHorizontalRule(@NotNull CharSequence line, int offset) {
            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
            Character hrChar = null;
            int startSpace = 0;
            int charCount = 1;
            int n = offset;
            int n2 = CollectionsKt.length((CharSequence)line) - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    char c = line.charAt((int)i);
                    if (hrChar == null) {
                        if (c == '*' || c == '-' || c == '_') {
                            hrChar = Character.valueOf(c);
                        } else {
                            if (startSpace >= 3) return false;
                            if (c != ' ') return false;
                            ++startSpace;
                        }
                    } else if (Intrinsics.areEqual((Object)Character.valueOf(c), (Object)hrChar)) {
                        ++charCount;
                    } else if (c != ' ' && c != '\t') {
                        return false;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (charCount < 3) return false;
            return true;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

