/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.Range;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.LinkReferenceDefinitionMarkerBlock;
import org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0001\u0001\u0004\u0001\u0011\u0011e!\u0011BA\u0005\u00021\u0005A\n!(\u0001\tC\u000b\t6!\u0001E\u0002KM!1\u0002\u0003\u0002\u000e\t%\u0011\u0011\"\u0001\r\u00041\u000bI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001$A\u0013\r\t-Aa!D\u0001\u0019\u000ee\u0019\u0001rA\u0007\u00021\u0011I2\u0001C\u0004\u000e\u0003a=\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "Companion"}, moduleName="intellij-markdown")
public final class LinkReferenceDefinitionProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final String WHSP = "[ \\t]*";
    @NotNull
    public static final Function1<? super String, ? extends String> NOT_CHARS;
    @NotNull
    public static final String LINK_LABEL;
    @NotNull
    public static final String NONCONTROL = "(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])";
    @NotNull
    public static final String LINK_DESTINATION = "(?:<(?:\\\\[<>]|[^<>])*>|(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*\\((?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*\\)(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*|(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])+)";
    @NotNull
    public static final String LINK_TITLE;
    @NotNull
    public static final String NO_MORE_ONE_NEWLINE = "[ \\t]*(?:\\n[ \\t]*)?";
    @NotNull
    public static final Regex LINK_DEFINITION_REGEX;
    public static final Companion Companion;

    static {
        Companion = org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE;
        WHSP = WHSP;
        NOT_CHARS = Companion.NOT_CHARS.1.INSTANCE;
        LINK_LABEL = "\\" + "[" + (String)org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getNOT_CHARS().invoke((Object)"\\[\\]") + "\\" + "]";
        NONCONTROL = NONCONTROL;
        LINK_DESTINATION = "(?:<(?:" + "\\" + "\\" + "[<>]|[^<>])*>|" + org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getNONCONTROL() + "*" + "\\" + "(" + org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getNONCONTROL() + "*" + "\\" + ")" + org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getNONCONTROL() + "*|" + org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getNONCONTROL() + "+)";
        LINK_TITLE = "(?:" + "\"" + (String)org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getNOT_CHARS().invoke((Object)"\"") + "\"" + "|'" + (String)org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getNOT_CHARS().invoke((Object)"'") + "'|" + "\\" + "(" + (String)org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getNOT_CHARS().invoke((Object)"\\)") + "\\" + "))";
        NO_MORE_ONE_NEWLINE = NO_MORE_ONE_NEWLINE;
        LINK_DEFINITION_REGEX = new Regex("^ {0,3}(" + org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getLINK_LABEL() + "):" + (org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getNO_MORE_ONE_NEWLINE() + "(" + org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getLINK_DESTINATION() + ")") + ("(?:" + org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getNO_MORE_ONE_NEWLINE() + "(" + org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getLINK_TITLE() + ")" + org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getWHSP() + "(?:" + "\\" + "n|" + "$" + "))?"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        void furthestOffset;
        int matchLength;
        LookaheadText.Position endPosition;
        MatchGroup $receiver;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        if (!MarkerBlockProvider.Companion.INSTANCE.isStartOfLineWithConstraints(pos, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.emptyList();
        }
        MatchResult matchResult = Regex.match$default((Regex)org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.getLINK_DEFINITION_REGEX(), (CharSequence)pos.getTextFromPosition(), (int)0, (int)2);
        if (matchResult == null) {
            return CollectionsKt.emptyList();
        }
        MatchResult matchResult2 = matchResult;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        int n = 1;
        Collection collection = (Collection)matchResult2.getGroups();
        int n2 = $receiver.size() - 1;
        if (n <= n2) {
            while (true) {
                Unit unit;
                void i;
                if (matchResult2.getGroups().get((int)i) != null) {
                    IElementType iElementType;
                    MatchGroup group = $receiver;
                    Range range = (Range)org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.addToRangeAndWiden(group.getRange(), pos.getOffset());
                    switch (i) {
                        case 1: {
                            iElementType = MarkdownElementTypes.Companion.INSTANCE.getLINK_LABEL();
                            break;
                        }
                        case 2: {
                            iElementType = MarkdownElementTypes.Companion.INSTANCE.getLINK_DESTINATION();
                            break;
                        }
                        case 3: {
                            iElementType = MarkdownElementTypes.Companion.INSTANCE.getLINK_TITLE();
                            break;
                        }
                        default: {
                            throw (Throwable)((Object)new AssertionError((Object)"There are no more than three groups in this regex"));
                        }
                    }
                    productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node((Range<Integer>)range, iElementType)));
                    furthestOffset.element = ((Number)group.getRange().getEnd()).intValue();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (i == n2) break;
                ++i;
            }
        }
        if ((endPosition = pos.nextPosition(matchLength = furthestOffset.element - ((Number)matchResult2.getRange().getStart()).intValue() + 1)) != null && !org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE.isEndOfLine(endPosition)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new LinkReferenceDefinitionMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark(), pos.getOffset() + matchLength));
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return false;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"=\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005Aq!B\u0001\u0005\n\u0015\tA\"A\u0003\u0002\t\u000f)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0005\u000b\u0001)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"\u0001\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)3\u0002#\u0007\u000e\u0003ai\u0011d\u0001E\u000e\u001b\u0005AR\"G\u0002\t\u001d5\t\u0001TD\u0013\b\u0011=i\u0011\u0001g\b\u001a\u0007!\u0001R\"\u0001M\u0011S-!1\t\u0003E\u0002\u001b\u0005A\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0006!\u0019\u0011v\u0003\u0003D\u0011\u0006A9!D\u0001\u0019\tE\u001bQ!B\u0001\r\u00025\u0011A\u0011\u0002\u0005\u0006S-!1\t\u0003E\u0006\u001b\u0005AB!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\r!)\u0011f\u0003\u0003D\u0011!5Q\"\u0001\r\u0005#\u000e)Q!\u0001G\u0001\u001b\t!q\u0001C\u0003*\u0018\u0011\u0019\u0005*\u0001E\b\u001b\u0005AB!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0011!)\u0011&\u0005\u0003D\u0011!EQbB\u0005\u0003\u0013\u0005AB!\u0003\u0002\n\u0003a!\u0001$C)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t'A!\"k\u0006\u0005\u0007\"\u000b\u0001RC\u0007\u00021\u0011\t6!B\u0003\u0002\u0019\u0003i!\u0001B\u0006\t\u000b%^Aa\u0011%\u0002\u0011/i\u0011\u0001\u0007\u0003R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011a\u0001\"\u0002"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider$Companion;", "", "()V", "LINK_DEFINITION_REGEX", "Lkotlin/text/Regex;", "getLINK_DEFINITION_REGEX", "()Lkotlin/text/Regex;", "LINK_DESTINATION", "", "getLINK_DESTINATION", "()Ljava/lang/String;", "LINK_LABEL", "getLINK_LABEL", "LINK_TITLE", "getLINK_TITLE", "NONCONTROL", "getNONCONTROL", "NOT_CHARS", "Lkotlin/Function1;", "getNOT_CHARS", "()Lkotlin/jvm/functions/Function1;", "NO_MORE_ONE_NEWLINE", "getNO_MORE_ONE_NEWLINE", "WHSP", "getWHSP", "addToRangeAndWiden", "Lkotlin/IntRange;", "range", "t", "", "isEndOfLine", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getWHSP() {
            return WHSP;
        }

        @NotNull
        public final Function1<String, String> getNOT_CHARS() {
            return NOT_CHARS;
        }

        @NotNull
        public final String getLINK_LABEL() {
            return LINK_LABEL;
        }

        @NotNull
        public final String getNONCONTROL() {
            return NONCONTROL;
        }

        @NotNull
        public final String getLINK_DESTINATION() {
            return LINK_DESTINATION;
        }

        @NotNull
        public final String getLINK_TITLE() {
            return LINK_TITLE;
        }

        @NotNull
        public final String getNO_MORE_ONE_NEWLINE() {
            return NO_MORE_ONE_NEWLINE;
        }

        @NotNull
        public final Regex getLINK_DEFINITION_REGEX() {
            return LINK_DEFINITION_REGEX;
        }

        @NotNull
        public final IntRange addToRangeAndWiden(@NotNull IntRange range, int t) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            return new IntRange(((Number)range.getStart()).intValue() + t, ((Number)range.getEnd()).intValue() + t + 1);
        }

        public final boolean isEndOfLine(@NotNull LookaheadText.Position pos) {
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            return pos.getOffsetInCurrentLine() == -1 || pos.charsToNonWhitespace() == null;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

